/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.config.ComboBoxSpecifier;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.SpecifierPanel;

public abstract class OptionConfigKey<T>
extends ConfigKey<T> {
    private final T[] options_;
    private final boolean useRadio_;

    public OptionConfigKey(ConfigMeta meta, Class<T> clazz, T[] options, T dflt, boolean useRadio) {
        super(meta, clazz, dflt);
        this.options_ = options;
        this.useRadio_ = useRadio;
    }

    public OptionConfigKey(ConfigMeta meta, Class<T> clazz, T[] options, T dflt) {
        this(meta, clazz, options, dflt, false);
    }

    public OptionConfigKey(ConfigMeta meta, Class<T> clazz, T[] options) {
        this(meta, clazz, options, options[0]);
    }

    @Override
    public String valueToString(T value) {
        if (value == null) {
            return null;
        }
        String name = value.toString();
        return name.toLowerCase().replaceAll(" ", "_");
    }

    public abstract String getXmlDescription(T var1);

    @Override
    public T stringToValue(String txt) throws ConfigException {
        if (txt == null || txt.trim().length() == 0) {
            return null;
        }
        for (int i = 0; i < this.options_.length; ++i) {
            T option = this.options_[i];
            if (!txt.equalsIgnoreCase(this.valueToString(option))) continue;
            return option;
        }
        StringBuffer sbuf = new StringBuffer().append("Unknown value \"").append(txt).append("\"").append(" should be ");
        for (int i = 0; i < this.options_.length; ++i) {
            if (i > 0) {
                sbuf.append(", ");
            }
            sbuf.append(this.valueToString(this.options_[i]));
        }
        throw new ConfigException(this, sbuf.toString());
    }

    public T[] getOptions() {
        return this.options_;
    }

    @Override
    public Specifier<T> createSpecifier() {
        if (this.useRadio_) {
            return new RadioButtonSpecifier();
        }
        ComboBoxSpecifier spec = new ComboBoxSpecifier<T>(this.options_){

            @Override
            public String stringify(T value) {
                return OptionConfigKey.this.valueToString(value);
            }
        };
        spec.setSpecifiedValue(this.getDefaultValue());
        return spec;
    }

    public OptionConfigKey<T> setOptionUsage() {
        int point;
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < this.options_.length; ++i) {
            if (sbuf.length() > 0) {
                sbuf.append("|");
            }
            sbuf.append(this.valueToString(this.options_[i]));
        }
        if (sbuf.length() > 50 && (point = sbuf.indexOf("|", 20)) > 0) {
            sbuf.replace(point + 1, sbuf.length(), "...");
        }
        this.getMeta().setStringUsage(sbuf.toString());
        return this;
    }

    public OptionConfigKey<T> addOptionsXml() {
        ConfigMeta meta = this.getMeta();
        meta.setXmlDescription(new StringBuffer().append(meta.getXmlDescription()).append(this.getOptionsXml()).toString());
        return this;
    }

    public String getOptionsXml() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<p>The available options are:\n").append("<ul>\n");
        for (T option : this.getOptions()) {
            String name = this.valueToString(option);
            String description = this.getXmlDescription(option);
            sbuf.append("<li><code>").append(name).append("</code>");
            if (description != null) {
                sbuf.append(": ").append(description);
            }
            sbuf.append("</li>").append("\n");
        }
        sbuf.append("</ul>\n").append("</p>\n");
        return sbuf.toString();
    }

    private class RadioButtonSpecifier
    extends SpecifierPanel<T> {
        private final JRadioButton[] buttons_;

        RadioButtonSpecifier() {
            super(false);
            ButtonGroup grp = new ButtonGroup();
            this.buttons_ = new JRadioButton[OptionConfigKey.this.options_.length];
            for (int i = 0; i < OptionConfigKey.this.options_.length; ++i) {
                JRadioButton butt;
                Object opt = OptionConfigKey.this.options_[i];
                this.buttons_[i] = butt = new JRadioButton(OptionConfigKey.this.valueToString(opt));
                grp.add(butt);
                if (opt != null && opt.equals(OptionConfigKey.this.getDefaultValue())) {
                    butt.setSelected(true);
                }
                butt.addActionListener(this.getActionForwarder());
            }
        }

        @Override
        public JComponent createComponent() {
            Box box = new Box(0){

                @Override
                public void setEnabled(boolean enabled) {
                    super.setEnabled(enabled);
                    for (int ib = 0; ib < RadioButtonSpecifier.this.buttons_.length; ++ib) {
                        RadioButtonSpecifier.this.buttons_[ib].setEnabled(enabled);
                    }
                }
            };
            for (int i = 0; i < this.buttons_.length; ++i) {
                if (i > 0) {
                    box.add(Box.createHorizontalStrut(10));
                }
                box.add(this.buttons_[i]);
            }
            return box;
        }

        @Override
        public T getSpecifiedValue() {
            for (int i = 0; i < this.buttons_.length; ++i) {
                if (!this.buttons_[i].isSelected()) continue;
                return OptionConfigKey.this.options_[i];
            }
            return null;
        }

        @Override
        public void setSpecifiedValue(T value) {
            for (int i = 0; i < OptionConfigKey.this.options_.length; ++i) {
                if (OptionConfigKey.this.options_[i] != value) continue;
                this.buttons_[i].setSelected(true);
                this.fireAction();
                return;
            }
        }

        @Override
        public void submitReport(ReportMap report) {
        }
    }
}

