/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.ttools.plot2.ParsedFunctionCall;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.ScaleType;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.SpecifierPanel;
import uk.ac.starlink.util.gui.ComboBoxBumper;

public class ScaleConfigKey
extends ConfigKey<Scale> {
    public ScaleConfigKey(ConfigMeta meta) {
        super(meta, Scale.class, Scale.LINEAR);
    }

    @Override
    public String valueToString(Scale scale) {
        int np;
        ScaleType type = scale.getScaleType();
        ScaleType.Param[] params = type.getParams();
        String typeName = type.getName();
        double[] paramValues = scale.getParamValues();
        for (np = paramValues.length; np > 0 && paramValues[np - 1] == params[np - 1].getDefault(); --np) {
        }
        if (np > 0) {
            double[] values = new double[np];
            System.arraycopy(paramValues, 0, values, 0, np);
            return new ParsedFunctionCall(typeName, values).toString();
        }
        return typeName;
    }

    @Override
    public Scale stringToValue(String txt) throws ConfigException {
        ParsedFunctionCall pfc = ParsedFunctionCall.fromString(txt);
        if (pfc != null) {
            String typeName = pfc.getFunctionName();
            double[] args = pfc.getArguments();
            ScaleType type = ScaleType.fromName(typeName);
            if (type != null) {
                if (args != null && args.length > type.getParams().length) {
                    throw new ConfigException(this, "Too many arguments for scale type " + type.getName());
                }
                try {
                    return type.createScale(args == null ? new double[]{} : args);
                }
                catch (IllegalArgumentException e) {
                    throw new ConfigException(this, "Bad scale arguments: " + txt, e);
                }
            }
            throw new ConfigException(this, "Unknown scale type: " + typeName);
        }
        throw new ConfigException(this, "Unparseable scale: " + txt);
    }

    @Override
    public Specifier<Scale> createSpecifier() {
        return new ScaleSpecifier();
    }

    private static class ParamSpinnerModel
    extends SpinnerNumberModel {
        private final ScaleType.Param param_;
        private double value_;

        ParamSpinnerModel(ScaleType.Param param) {
            this.param_ = param;
            this.value_ = param.getDefault();
        }

        @Override
        public void setValue(Object value) {
            if (value instanceof Number) {
                this.value_ = ((Number)value).doubleValue();
                this.fireStateChanged();
            }
        }

        @Override
        public Object getValue() {
            return this.value_;
        }

        @Override
        public Object getNextValue() {
            return this.param_.nextUp(this.value_);
        }

        @Override
        public Object getPreviousValue() {
            return this.param_.nextDown(this.value_);
        }
    }

    private static class ArgNumberEditor
    extends JSpinner.NumberEditor {
        private final double dflt_;
        private final boolean requirePositive_;

        public ArgNumberEditor(JSpinner spinner, double dflt, boolean requirePositive) {
            super(spinner);
            this.dflt_ = dflt;
            this.requirePositive_ = requirePositive;
            final JFormattedTextField field = this.getTextField();
            final JFormattedTextField.AbstractFormatter formatter = new JFormattedTextField.AbstractFormatter(){

                @Override
                public Object stringToValue(String txt) throws ParseException {
                    try {
                        return Double.valueOf(txt);
                    }
                    catch (NumberFormatException e) {
                        throw (ParseException)new ParseException("Not a number", 0).initCause(e);
                    }
                }

                @Override
                public String valueToString(Object value) throws ParseException {
                    if (value instanceof Number) {
                        double d = ((Number)value).doubleValue();
                        if (requirePositive_ && d <= 0.0) {
                            throw new ParseException("Non-positive", 0);
                        }
                        return d == (double)((int)d) ? Integer.toString((int)d) : Double.toString(d);
                    }
                    throw new ParseException("Not a number", 0);
                }
            };
            field.setFormatterFactory(new JFormattedTextField.AbstractFormatterFactory(){

                @Override
                public JFormattedTextField.AbstractFormatter getFormatter(JFormattedTextField tf) {
                    return formatter;
                }
            });
            field.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent evt) {
                    this.checkValue();
                }

                @Override
                public void focusLost(FocusEvent evt) {
                    this.checkValue();
                }

                private void checkValue() {
                    Object val = field.getValue();
                    if (!(val instanceof Number) || requirePositive_ && !(((Number)val).doubleValue() > 0.0)) {
                        field.setValue(dflt_);
                    }
                }
            });
        }
    }

    private static class ArgField
    extends JSpinner {
        private final ScaleType.Param param_;

        ArgField(ScaleType.Param param) {
            super(new ParamSpinnerModel(param));
            this.param_ = param;
            this.setToolTipText(param.getDescription());
            this.setValue(param.getDefault());
            boolean requirePositive = true;
            this.setEditor(new ArgNumberEditor(this, param.getDefault(), requirePositive));
        }

        public double readValue() {
            Object obj = this.getValue();
            return obj instanceof Number ? ((Number)obj).doubleValue() : this.param_.getDefault();
        }

        public void writeValue(double d) {
            this.setValue(d);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension size = super.getPreferredSize();
            return new Dimension(Math.max(size.width, 64), size.height);
        }
    }

    private static class ScaleSpecifier
    extends SpecifierPanel<Scale> {
        private final JComboBox<ScaleType> typeBox_ = new JComboBox<ScaleType>(ScaleType.getInstances());
        private final JComponent fieldContainer_ = Box.createHorizontalBox();
        private final Map<ScaleType, ArgField[]> fieldsMap_ = new HashMap<ScaleType, ArgField[]>();

        ScaleSpecifier() {
            super(false);
            ActionListener forwarder = this.getActionForwarder();
            this.typeBox_.addActionListener(forwarder);
        }

        @Override
        protected JComponent createComponent() {
            ComboBoxBumper bumper = new ComboBoxBumper(this.typeBox_);
            Box box = Box.createHorizontalBox();
            box.add(this.typeBox_);
            box.add(Box.createHorizontalStrut(2));
            box.add((Component)bumper);
            box.add(this.fieldContainer_);
            box.addPropertyChangeListener("enabled", evt -> {
                boolean isEnabled = box.isEnabled();
                this.typeBox_.setEnabled(isEnabled);
                bumper.setEnabled(isEnabled);
                for (ArgField[] fields : this.fieldsMap_.values()) {
                    for (ArgField field : fields) {
                        field.setEnabled(isEnabled);
                    }
                }
            });
            this.typeBox_.addActionListener(evt -> {
                Object typeObj = this.typeBox_.getSelectedItem();
                if (typeObj instanceof ScaleType) {
                    this.updateSelector((ScaleType)typeObj);
                }
            });
            return box;
        }

        @Override
        public Scale getSpecifiedValue() {
            ScaleType type = this.typeBox_.getItemAt(this.typeBox_.getSelectedIndex());
            double[] args = Arrays.stream((Object[])this.fieldsMap_.get(type)).mapToDouble(ArgField::readValue).toArray();
            return type.createScale(args);
        }

        @Override
        public void setSpecifiedValue(Scale scale) {
            ScaleType type = scale.getScaleType();
            double[] args = scale.getParamValues();
            this.typeBox_.setSelectedItem(type);
            this.updateSelector(type);
            ArgField[] afields = this.fieldsMap_.get(type);
            for (int ia = 0; ia < afields.length; ++ia) {
                afields[ia].writeValue(args[ia]);
            }
        }

        @Override
        public void submitReport(ReportMap report) {
        }

        private void updateSelector(ScaleType type) {
            assert (this.typeBox_.getSelectedItem() == type);
            assert (SwingUtilities.isEventDispatchThread());
            this.fieldContainer_.removeAll();
            if (!this.fieldsMap_.containsKey(type)) {
                ScaleType.Param[] params = type.getParams();
                ArgField[] afields = new ArgField[params.length];
                ChangeListener listener = evt -> this.getActionForwarder().actionPerformed(new ActionEvent(this, 0, "x"));
                for (int ip = 0; ip < params.length; ++ip) {
                    ArgField afield = new ArgField(params[ip]);
                    afield.addChangeListener(listener);
                    afields[ip] = afield;
                }
                this.fieldsMap_.put(type, afields);
            }
            for (ArgField afield : this.fieldsMap_.get(type)) {
                this.fieldContainer_.add(Box.createHorizontalStrut(5));
                this.fieldContainer_.add(new JLabel(afield.param_.getName() + ":"));
                this.fieldContainer_.add(afield);
            }
            this.fieldContainer_.revalidate();
        }
    }
}

