/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.SpecifierPanel;

public class ToggleSpecifier<T>
extends SpecifierPanel<T> {
    private final Specifier<T> base_;
    private final T toggleValue_;
    private final JCheckBox checkBox_;

    public ToggleSpecifier(Specifier<T> base, T toggleValue, String label) {
        super(true);
        this.base_ = base;
        this.toggleValue_ = toggleValue;
        this.checkBox_ = new JCheckBox(label);
    }

    @Override
    protected JComponent createComponent() {
        final JComponent baseComponent = this.base_.getComponent();
        this.checkBox_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                baseComponent.setEnabled(!ToggleSpecifier.this.checkBox_.isSelected());
            }
        });
        ActionListener forwarder = this.getActionForwarder();
        this.checkBox_.addActionListener(forwarder);
        this.base_.addActionListener(forwarder);
        Box line = Box.createHorizontalBox();
        line.add(baseComponent);
        line.add(Box.createHorizontalStrut(10));
        line.add(this.checkBox_);
        return line;
    }

    @Override
    public T getSpecifiedValue() {
        return this.checkBox_.isSelected() ? this.toggleValue_ : this.base_.getSpecifiedValue();
    }

    @Override
    public void setSpecifiedValue(T value) {
        boolean isTog = PlotUtil.equals(value, this.toggleValue_);
        this.checkBox_.setSelected(isTog);
        this.base_.getComponent().setEnabled(!isTog);
        if (!isTog) {
            this.base_.setSpecifiedValue(value);
        }
        this.fireAction();
    }

    @Override
    public void submitReport(ReportMap report) {
        this.base_.submitReport(report);
    }
}

