/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.config;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.config.RangeSliderUtil;
import uk.ac.starlink.ttools.plot2.config.SpecifierPanel;

public class UnitRangeSpecifier
extends SpecifierPanel<Subrange> {
    private static final int NSTEP = 1000;
    private final JSlider slider_ = RangeSliderUtil.createRangeSlider(0, 1000);
    private final JButton resetButton_;
    private final JTextField loField_;
    private final JTextField hiField_;
    private final JRadioButton sliderButton_;
    private final JRadioButton txtButton_;

    public UnitRangeSpecifier(final Subrange reset) {
        super(true);
        this.setSliderRange(reset);
        AbstractAction resetAct = new AbstractAction(null, ResourceIcon.ZERO){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnitRangeSpecifier.this.setSliderRange(reset);
            }
        };
        resetAct.putValue("ShortDescription", "Reset slider to default (" + reset + ")");
        this.resetButton_ = new JButton(resetAct);
        this.resetButton_.setMargin(new Insets(0, 0, 0, 0));
        JTextField[] fields = new JTextField[2];
        for (int i = 0; i < 2; ++i) {
            fields[i] = new JTextField(4){

                @Override
                public Dimension getMinimumSize() {
                    return this.getPreferredSize();
                }
            };
        }
        this.loField_ = fields[0];
        this.hiField_ = fields[1];
        this.sliderButton_ = new JRadioButton();
        this.txtButton_ = new JRadioButton();
        ButtonGroup bgrp = new ButtonGroup();
        bgrp.add(this.sliderButton_);
        bgrp.add(this.txtButton_);
        this.sliderButton_.setSelected(true);
    }

    @Override
    public JComponent createComponent() {
        JPanel sliderHolder = new JPanel(){

            @Override
            public Dimension getMinimumSize() {
                Dimension s = super.getMinimumSize();
                return new Dimension(Math.max(s.width, 128), s.height);
            }
        };
        sliderHolder.setLayout(new BoxLayout(sliderHolder, 0));
        sliderHolder.add(this.slider_);
        Box line = Box.createHorizontalBox();
        line.add(this.sliderButton_);
        line.add(sliderHolder);
        line.add(Box.createHorizontalStrut(5));
        line.add(this.txtButton_);
        line.add(this.loField_);
        line.add(Box.createHorizontalStrut(2));
        line.add(this.hiField_);
        line.add(Box.createHorizontalStrut(5));
        line.add(this.resetButton_);
        final ChangeListener changeForwarder = this.getChangeForwarder();
        final ActionListener actionForwarder = this.getActionForwarder();
        this.slider_.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                UnitRangeSpecifier.this.updateInputState();
                changeForwarder.stateChanged(evt);
            }
        });
        this.loField_.addActionListener(actionForwarder);
        this.hiField_.addActionListener(actionForwarder);
        ActionListener radioListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                UnitRangeSpecifier.this.updateInputState();
                actionForwarder.actionPerformed(evt);
            }
        };
        this.sliderButton_.addActionListener(radioListener);
        this.txtButton_.addActionListener(radioListener);
        this.txtButton_.addActionListener(radioListener);
        this.updateInputState();
        return line;
    }

    @Override
    public Subrange getSpecifiedValue() {
        Subrange range;
        if (!this.isSliderActive() && (range = this.getTextValue()) != null) {
            return range;
        }
        return this.getSliderValue();
    }

    @Override
    public void setSpecifiedValue(Subrange range) {
        if (range != null) {
            if (this.isSliderActive()) {
                this.setSliderRange(range);
            } else {
                this.setTextRange(range);
            }
        }
    }

    @Override
    public void submitReport(ReportMap report) {
    }

    public boolean isSliderActive() {
        return this.sliderButton_.isSelected();
    }

    public void setSliderActive(boolean isActive) {
        this.sliderButton_.setSelected(isActive);
    }

    private void updateInputState() {
        boolean sliderActive = this.isSliderActive();
        this.slider_.setEnabled(sliderActive);
        this.resetButton_.setEnabled(sliderActive);
        this.loField_.setEnabled(!sliderActive);
        this.hiField_.setEnabled(!sliderActive);
        Subrange value = this.getSpecifiedValue();
        if (sliderActive) {
            this.setTextRange(value);
        } else {
            this.setSliderRange(value);
        }
    }

    private Subrange getSliderValue() {
        int[] range = RangeSliderUtil.getSliderRange(this.slider_);
        return new Subrange(this.scale(range[0]), this.scale(range[1]));
    }

    private Subrange getTextValue() {
        double lo = this.unformatFraction(this.loField_.getText());
        double hi = this.unformatFraction(this.hiField_.getText());
        if (Double.isNaN(hi)) {
            hi = lo;
        }
        if (!(lo >= 0.0) || !(lo <= 1.0)) {
            lo = 0.0;
            this.loField_.setText(this.formatFraction(lo));
        }
        if (!(hi >= lo) || !(hi <= 1.0)) {
            hi = 1.0;
            this.hiField_.setText(lo == hi ? null : this.formatFraction(hi));
        }
        return new Subrange(lo, hi);
    }

    private void setSliderRange(Subrange range) {
        RangeSliderUtil.setSliderRange(this.slider_, this.unscale(range.getLow()), this.unscale(range.getHigh()));
    }

    private void setTextRange(Subrange range) {
        double lo = range.getLow();
        double hi = range.getHigh();
        this.loField_.setText(this.formatFraction(lo));
        this.hiField_.setText(lo == hi ? null : this.formatFraction(hi));
    }

    private double scale(int ivalue) {
        return (double)ivalue * 1.0 / 1000.0;
    }

    private int unscale(double dvalue) {
        return (int)Math.round(dvalue * 1000.0);
    }

    private String formatFraction(double value) {
        if (value == 0.0) {
            return "0";
        }
        if (value == 1.0) {
            return "1";
        }
        return String.format("%1$5.3f", value);
    }

    private double unformatFraction(String txt) {
        try {
            return Double.parseDouble(txt);
        }
        catch (RuntimeException e) {
            return Double.NaN;
        }
    }
}

