/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BooleanSupplier;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.data.WrapperTuple;

public class AbortTupleSequence
extends WrapperTuple
implements TupleSequence {
    private final TupleSequence base_;
    private final BooleanSupplier abortCondition_;
    private final int checkPeriod_;
    private final AtomicBoolean aborted_;
    private final BooleanSupplier checkCondition_;
    private int count_;

    public AbortTupleSequence(TupleSequence base, BooleanSupplier abortCondition) {
        this(base, abortCondition, 1);
    }

    public AbortTupleSequence(TupleSequence base, BooleanSupplier abortCondition, int checkPeriod) {
        this(base, abortCondition, checkPeriod, new AtomicBoolean(false));
    }

    private AbortTupleSequence(TupleSequence base, BooleanSupplier abortCondition, int checkPeriod, AtomicBoolean aborted) {
        super(base);
        this.base_ = base;
        this.abortCondition_ = abortCondition;
        this.checkPeriod_ = checkPeriod;
        this.aborted_ = aborted;
        this.checkCondition_ = checkPeriod <= 1 ? abortCondition : () -> this.count_++ % this.checkPeriod_ == 0 && this.abortCondition_.getAsBoolean();
    }

    @Override
    public boolean next() {
        return this.checkRunning() && this.base_.next();
    }

    public AbortTupleSequence split() {
        TupleSequence baseSplit = (TupleSequence)this.base_.split();
        if (baseSplit != null) {
            return this.checkRunning() ? new AbortTupleSequence(baseSplit, this.abortCondition_, this.checkPeriod_, this.aborted_) : new AbortTupleSequence(PlotUtil.EMPTY_TUPLE_SEQUENCE, () -> true, 0, new AtomicBoolean(true));
        }
        return null;
    }

    public long splittableSize() {
        return this.base_.splittableSize();
    }

    public boolean isAborted() {
        return this.aborted_.get();
    }

    private boolean checkRunning() {
        if (this.aborted_.get()) {
            return false;
        }
        if (this.checkCondition_.getAsBoolean()) {
            this.aborted_.set(true);
            return false;
        }
        return true;
    }
}

