/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.util.function.Function;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.Area;
import uk.ac.starlink.ttools.AreaDomain;
import uk.ac.starlink.ttools.AreaMapper;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.Input;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.StorageType;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.geom.PlaneDataGeom;
import uk.ac.starlink.ttools.plot2.geom.SkyDataGeom;
import uk.ac.starlink.ttools.plot2.geom.SphereDataGeom;

public abstract class AreaCoord<DG extends DataGeom>
implements Coord {
    private final Input input_;
    private final boolean isRequired_;
    private final int nDataDim_;
    private final boolean allowPoint_;
    private static final InputMeta META = new InputMeta("area", "Area");
    public static final AreaCoord<PlaneDataGeom> PLANE_COORD;
    public static final AreaCoord<SkyDataGeom> SKY_COORD;
    public static final AreaCoord<SphereDataGeom> SPHERE_COORD;
    private static final double[] NO_AREA;

    private AreaCoord(InputMeta meta, boolean isRequired, int nDataDim) {
        this.input_ = new Input(meta, AreaDomain.INSTANCE);
        this.isRequired_ = isRequired;
        this.nDataDim_ = nDataDim;
        this.allowPoint_ = true;
    }

    protected abstract void writeDataPos(Area var1, double[] var2);

    public abstract DG getAreaDataGeom(DG var1);

    @Override
    public Input[] getInputs() {
        return new Input[]{this.input_};
    }

    @Override
    public StorageType getStorageType() {
        return StorageType.DOUBLE_ARRAY;
    }

    @Override
    public boolean isRequired() {
        return this.isRequired_;
    }

    public Function<Object[], double[]> inputStorage(ValueInfo[] infos, DomainMapper[] dms) {
        if (dms[0] instanceof AreaMapper) {
            AreaMapper mapper = (AreaMapper)dms[0];
            Class clazz = infos[0].getContentClass();
            Function<Object, Area> areaFunc = mapper.areaFunction(clazz);
            return areaFunc == null ? values -> NO_AREA : values -> this.areaStorage((Area)areaFunc.apply(values[0]));
        }
        assert (false) : dms[0];
        return null;
    }

    public Area readAreaCoord(Tuple tuple, int icol) {
        double[] array = (double[])tuple.getObjectValue(icol);
        int na = array.length;
        if (na == 0) {
            return null;
        }
        assert (array.length > this.nDataDim_ && array[this.nDataDim_] == (double)((int)array[this.nDataDim_]));
        Area.Type type = Area.Type.fromInt((int)array[this.nDataDim_]);
        assert (type != null);
        if (type != null) {
            int nd = na - this.nDataDim_ - 1;
            double[] areaData = new double[nd];
            System.arraycopy(array, this.nDataDim_ + 1, areaData, 0, nd);
            return new Area(type, areaData);
        }
        return null;
    }

    private double[] areaStorage(Area area) {
        if (area == null) {
            return NO_AREA;
        }
        double[] areaData = area.getDataArray();
        int nd = areaData.length;
        double[] storage = new double[this.nDataDim_ + 1 + nd];
        this.writeDataPos(area, storage);
        storage[this.nDataDim_] = area.getType().ordinal();
        System.arraycopy(areaData, 0, storage, this.nDataDim_ + 1, nd);
        return storage;
    }

    public static AreaCoord<PlaneDataGeom> createPlaneCoord(InputMeta meta, boolean isRequired) {
        return new AreaCoord<PlaneDataGeom>(meta, isRequired, 2){
            private final PlaneDataGeom geom_ = new AreaPlaneDataGeom(this);

            @Override
            protected void writeDataPos(Area area, double[] dpos) {
                area.writePlaneCoords2(dpos);
            }

            @Override
            public PlaneDataGeom getAreaDataGeom(PlaneDataGeom baseGeom) {
                return this.geom_;
            }
        };
    }

    public static AreaCoord<SkyDataGeom> createSkyCoord(InputMeta meta, boolean isRequired) {
        return new AreaCoord<SkyDataGeom>(meta, isRequired, 3){

            @Override
            protected void writeDataPos(Area area, double[] dpos) {
                area.writeSkyCoords3(dpos);
            }

            @Override
            public SkyDataGeom getAreaDataGeom(SkyDataGeom baseGeom) {
                return new AreaSkyDataGeom(this, baseGeom);
            }
        };
    }

    public static AreaCoord<SphereDataGeom> createSphereCoord(InputMeta meta, boolean isRequired) {
        return new AreaCoord<SphereDataGeom>(meta, isRequired, 3){
            private final SphereDataGeom geom_ = new AreaSphereDataGeom(this);

            @Override
            protected void writeDataPos(Area area, double[] dpos) {
                area.writeSkyCoords3(dpos);
            }

            @Override
            public SphereDataGeom getAreaDataGeom(SphereDataGeom baseGeom) {
                return this.geom_;
            }
        };
    }

    static {
        META.setShortDescription("Specifies a 2D plot region");
        META.setXmlDescription(new String[]{"<p>Expression giving the geometry of a 2D region on the plot.", "It may be a string- or array-valued expression,", "and its interpretation depends on the value of the corresponding", "<code>" + META.getShortName() + "type</code> parameter.", "</p>"});
        PLANE_COORD = AreaCoord.createPlaneCoord(META, true);
        SKY_COORD = AreaCoord.createSkyCoord(META, true);
        SPHERE_COORD = AreaCoord.createSphereCoord(META, true);
        NO_AREA = new double[0];
    }

    private static class AreaSphereDataGeom
    extends SphereDataGeom {
        private final AreaCoord<SphereDataGeom> areaCoord_;

        AreaSphereDataGeom(AreaCoord<SphereDataGeom> areaCoord) {
            this.areaCoord_ = areaCoord;
        }

        @Override
        public Coord[] getPosCoords() {
            return new Coord[]{this.areaCoord_};
        }

        @Override
        public boolean readDataPos(Tuple tuple, int ic, double[] dpos) {
            double[] array = (double[])tuple.getObjectValue(ic);
            if (array.length == 0) {
                return false;
            }
            double r = tuple.getDoubleValue(ic + 1);
            if (Double.isNaN(r)) {
                dpos[0] = array[0];
                dpos[1] = array[1];
                dpos[2] = array[2];
            } else {
                dpos[0] = r * array[0];
                dpos[1] = r * array[1];
                dpos[2] = r * array[2];
            }
            return true;
        }

        public int hashCode() {
            return this.areaCoord_.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof AreaSphereDataGeom) {
                AreaSphereDataGeom other = (AreaSphereDataGeom)o;
                return this.areaCoord_.equals(other.areaCoord_);
            }
            return false;
        }
    }

    private static class AreaSkyDataGeom
    extends SkyDataGeom {
        final AreaCoord<SkyDataGeom> areaCoord_;
        final SkyDataGeom baseGeom_;

        AreaSkyDataGeom(AreaCoord<SkyDataGeom> areaCoord, SkyDataGeom baseGeom) {
            super(baseGeom.getVariantName(), baseGeom.getViewSystem());
            this.areaCoord_ = areaCoord;
            this.baseGeom_ = baseGeom;
        }

        @Override
        public Coord[] getPosCoords() {
            return new Coord[]{this.areaCoord_};
        }

        @Override
        public boolean readDataPos(Tuple tuple, int ic, double[] dpos) {
            double[] array = (double[])tuple.getObjectValue(ic);
            if (array.length == 0) {
                return false;
            }
            dpos[0] = array[0];
            dpos[1] = array[1];
            dpos[2] = array[2];
            this.baseGeom_.rotate(dpos);
            return true;
        }

        @Override
        public void rotate(double[] dpos) {
            this.baseGeom_.rotate(dpos);
        }

        @Override
        public void unrotate(double[] dpos) {
            this.baseGeom_.unrotate(dpos);
        }

        @Override
        public int hashCode() {
            int code = 442023;
            code = 23 * code + this.areaCoord_.hashCode();
            code = 23 * code + this.baseGeom_.hashCode();
            return code;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof AreaSkyDataGeom) {
                AreaSkyDataGeom other = (AreaSkyDataGeom)o;
                return this.areaCoord_.equals(other.areaCoord_) && this.baseGeom_.equals(other.baseGeom_);
            }
            return false;
        }
    }

    private static class AreaPlaneDataGeom
    extends PlaneDataGeom {
        private final AreaCoord<PlaneDataGeom> areaCoord_;

        AreaPlaneDataGeom(AreaCoord<PlaneDataGeom> areaCoord) {
            this.areaCoord_ = areaCoord;
        }

        @Override
        public Coord[] getPosCoords() {
            return new Coord[]{this.areaCoord_};
        }

        @Override
        public boolean readDataPos(Tuple tuple, int ic, double[] dpos) {
            double[] array = (double[])tuple.getObjectValue(ic);
            if (array.length == 0) {
                return false;
            }
            dpos[0] = array[0];
            dpos[1] = array[1];
            return true;
        }

        public int hashCode() {
            return this.areaCoord_.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof AreaPlaneDataGeom) {
                AreaPlaneDataGeom other = (AreaPlaneDataGeom)o;
                return this.areaCoord_.equals(other.areaCoord_);
            }
            return false;
        }
    }
}

