/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.util.function.Function;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.SimpleDomain;
import uk.ac.starlink.ttools.plot2.data.SingleCoord;
import uk.ac.starlink.ttools.plot2.data.StorageType;
import uk.ac.starlink.ttools.plot2.data.Tuple;

public class BooleanCoord
extends SingleCoord {
    private static final SimpleDomain<Boolean> BOOLEAN_DOMAIN = new SimpleDomain<Boolean>(Boolean.class, "Boolean", "boolean", "Boolean value");

    public BooleanCoord(InputMeta meta, boolean isRequired) {
        super(meta, isRequired, BOOLEAN_DOMAIN, StorageType.BOOLEAN);
    }

    public Function<Object[], Boolean> inputStorage(ValueInfo[] infos, DomainMapper[] dms) {
        return userValues -> {
            Object c = userValues[0];
            return c instanceof Boolean ? (Boolean)c : Boolean.FALSE;
        };
    }

    public boolean readBooleanCoord(Tuple tuple, int icol) {
        return tuple.getBooleanValue(icol);
    }
}

