/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.util.function.Supplier;
import uk.ac.starlink.ttools.plot2.data.CachedReader;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;

public class CachedTupleSequence
implements TupleSequence {
    private final Supplier<CachedReader> maskSupplier_;
    private final Supplier<CachedReader[]> colsSupplier_;
    private final CachedReader maskRdr_;
    private final CachedReader[] colRdrs_;
    private long irow_;
    private long nrow_;
    private static final CachedReader TRUE_READER = new TrueReader();

    public CachedTupleSequence(Supplier<CachedReader> maskSupplier, Supplier<CachedReader[]> colsSupplier, long nrow) {
        this(maskSupplier, colsSupplier, -1L, nrow);
    }

    private CachedTupleSequence(Supplier<CachedReader> maskSupplier, Supplier<CachedReader[]> colsSupplier, long irow, long nrow) {
        this.maskSupplier_ = maskSupplier;
        this.colsSupplier_ = colsSupplier;
        this.irow_ = irow;
        this.nrow_ = nrow;
        CachedReader maskRdr = maskSupplier == null ? null : maskSupplier.get();
        this.maskRdr_ = maskRdr == null ? TRUE_READER : maskRdr;
        this.colRdrs_ = colsSupplier.get();
    }

    @Override
    public boolean next() {
        while (++this.irow_ < this.nrow_) {
            if (!this.maskRdr_.getBooleanValue(this.irow_)) continue;
            return true;
        }
        return false;
    }

    public TupleSequence split() {
        if (this.nrow_ - this.irow_ > 2L) {
            long mid = (this.irow_ + this.nrow_) / 2L;
            CachedTupleSequence split = new CachedTupleSequence(this.maskSupplier_, this.colsSupplier_, this.irow_, mid);
            this.irow_ = mid - 1L;
            return split;
        }
        return null;
    }

    public long splittableSize() {
        return this.nrow_ - this.irow_;
    }

    @Override
    public long getRowIndex() {
        return this.irow_;
    }

    @Override
    public Object getObjectValue(int icol) {
        return this.colRdrs_[icol].getObjectValue(this.irow_);
    }

    @Override
    public double getDoubleValue(int icol) {
        return this.colRdrs_[icol].getDoubleValue(this.irow_);
    }

    @Override
    public int getIntValue(int icol) {
        return this.colRdrs_[icol].getIntValue(this.irow_);
    }

    @Override
    public long getLongValue(int icol) {
        return this.colRdrs_[icol].getLongValue(this.irow_);
    }

    @Override
    public boolean getBooleanValue(int icol) {
        return this.colRdrs_[icol].getBooleanValue(this.irow_);
    }

    private static class TrueReader
    implements CachedReader {
        private TrueReader() {
        }

        @Override
        public boolean getBooleanValue(long ix) {
            return true;
        }

        @Override
        public double getDoubleValue(long ix) {
            return -1.0;
        }

        @Override
        public int getIntValue(long ix) {
            return -1;
        }

        @Override
        public long getLongValue(long ix) {
            return -1L;
        }

        @Override
        public Object getObjectValue(long ix) {
            return null;
        }
    }
}

