/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.storage.ByteStoreAccess;
import uk.ac.starlink.table.storage.Codec;
import uk.ac.starlink.table.storage.FileByteStore;
import uk.ac.starlink.table.storage.NioByteStoreAccess;
import uk.ac.starlink.ttools.plot2.data.CachedColumn;
import uk.ac.starlink.ttools.plot2.data.CachedReader;
import uk.ac.starlink.ttools.plot2.data.MoveFileByteStore;
import uk.ac.starlink.ttools.plot2.data.StorageType;
import uk.ac.starlink.util.DataBufferedOutputStream;

public abstract class ColumnStorage {
    private static final Map<StorageType, ColumnStorage> map_ = ColumnStorage.createTypedMap();
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.data");

    public abstract CachedColumn createColumn(Supplier<ByteStore> var1);

    public abstract File[] getFileNames(File var1);

    public abstract CachedColumn createDiskColumn(File[] var1) throws IOException;

    public abstract CachedReader createDiskReader(File[] var1) throws IOException;

    public abstract long getDiskRowCount(File[] var1);

    public static ColumnStorage getStorage(StorageType type) {
        return map_.get((Object)type);
    }

    private static Map<StorageType, ColumnStorage> createTypedMap() {
        EnumMap<StorageType, ColumnStorage> map = new EnumMap<StorageType, ColumnStorage>(StorageType.class);
        map.put(StorageType.DOUBLE, new FixedStorage(() -> Codec.DOUBLE));
        map.put(StorageType.FLOAT, new FixedStorage(() -> Codec.FLOAT));
        map.put(StorageType.LONG, new FixedStorage(() -> Codec.LONG));
        map.put(StorageType.INT, new FixedStorage(() -> Codec.INT));
        map.put(StorageType.SHORT, new FixedStorage(() -> Codec.SHORT));
        map.put(StorageType.BYTE, new FixedStorage(() -> Codec.BYTE));
        map.put(StorageType.DOUBLE3, new FixedStorage(Double3Codec::new));
        map.put(StorageType.FLOAT3, new FixedStorage(Float3Codec::new));
        map.put(StorageType.INT3, new FixedStorage(Int3Codec::new));
        map.put(StorageType.BOOLEAN, new BooleanStorage());
        map.put(StorageType.DOUBLE_ARRAY, new IndexedStorage(Codec.DOUBLE_ARRAY));
        map.put(StorageType.FLOAT_ARRAY, new IndexedStorage(Codec.FLOAT_ARRAY));
        map.put(StorageType.STRING, new IndexedStorage(Codec.STRING));
        assert (map.size() == StorageType.values().length);
        return map;
    }

    private static ByteStoreAccess createCopyAccess(ByteBuffer[] bufs) {
        return NioByteStoreAccess.createAccess((ByteBuffer[])NioByteStoreAccess.copyBuffers((ByteBuffer[])bufs));
    }

    private static ByteStoreAccess createAccess(File file) throws IOException {
        return NioByteStoreAccess.createAccess((ByteBuffer[])FileByteStore.toByteBuffers((File)file));
    }

    private static class IndexedStorage
    extends ColumnStorage {
        final Codec arrayCodec_;

        IndexedStorage(Codec arrayCodec) {
            this.arrayCodec_ = arrayCodec;
        }

        @Override
        public CachedColumn createColumn(Supplier<ByteStore> bsSupplier) {
            return this.createIndexedColumn(bsSupplier.get(), bsSupplier.get());
        }

        @Override
        public File[] getFileNames(File baseFile) {
            return new File[]{new File(baseFile + ".dat"), new File(baseFile + ".idx")};
        }

        @Override
        public CachedColumn createDiskColumn(File[] files) throws IOException {
            return this.createIndexedColumn(new MoveFileByteStore(files[0]), new MoveFileByteStore(files[1]));
        }

        @Override
        public CachedReader createDiskReader(File[] files) throws IOException {
            return this.createIndexedReader(ColumnStorage.createAccess(files[0]), ColumnStorage.createAccess(files[1]));
        }

        @Override
        public long getDiskRowCount(File[] files) {
            long leng = files[1].length();
            return leng > 0L ? leng / 8L : -1L;
        }

        CachedColumn createIndexedColumn(final ByteStore dataStore, final ByteStore indexStore) {
            final DataBufferedOutputStream dataOut = new DataBufferedOutputStream(dataStore.getOutputStream());
            final DataBufferedOutputStream indexOut = new DataBufferedOutputStream(indexStore.getOutputStream());
            return new CachedColumn(){
                long index_;
                long nrow_;
                ByteBuffer[] dataBufs_;
                ByteBuffer[] indexBufs_;

                @Override
                public void add(Object value) throws IOException {
                    indexOut.writeLong(this.index_);
                    this.index_ += (long)arrayCodec_.encode(value, (DataOutput)dataOut);
                    ++this.nrow_;
                }

                @Override
                public long getRowCount() {
                    return this.nrow_;
                }

                @Override
                public void endAdd() throws IOException {
                    indexOut.close();
                    dataOut.close();
                    this.dataBufs_ = dataStore.toByteBuffers();
                    this.indexBufs_ = indexStore.toByteBuffers();
                }

                @Override
                public CachedReader createReader() {
                    return this.createIndexedReader(ColumnStorage.createCopyAccess(this.dataBufs_), ColumnStorage.createCopyAccess(this.indexBufs_));
                }
            };
        }

        CachedReader createIndexedReader(final ByteStoreAccess dataAccess, final ByteStoreAccess indexAccess) {
            return new ErrorLogReader(){
                long nextIx_;

                @Override
                Object objectValue(long ix) throws IOException {
                    if (ix != this.nextIx_) {
                        indexAccess.seek(ix * 8L);
                        long ioff = indexAccess.readLong();
                        dataAccess.seek(ioff);
                    }
                    this.nextIx_ = ix + 1L;
                    return arrayCodec_.decodeObject(dataAccess);
                }

                @Override
                int intValue(long ix) throws IOException {
                    this.objectValue(ix);
                    return 0;
                }

                @Override
                long longValue(long ix) throws IOException {
                    this.objectValue(ix);
                    return 0L;
                }

                @Override
                double doubleValue(long ix) throws IOException {
                    this.objectValue(ix);
                    return Double.NaN;
                }

                @Override
                boolean booleanValue(long ix) throws IOException {
                    this.objectValue(ix);
                    return false;
                }
            };
        }
    }

    private static class BooleanStorage
    extends SingleStorage {
        private BooleanStorage() {
        }

        @Override
        public long getDiskRowCount(File[] files) {
            long leng = files[0].length();
            return leng > 0L ? leng * 8L + 7L : -1L;
        }

        @Override
        CachedColumn createSingleColumn(ByteStore byteStore) {
            return new StreamColumn(byteStore){
                int iflags_;
                int ipos_;

                @Override
                void doAdd(Object value) throws IOException {
                    if (Boolean.TRUE.equals(value)) {
                        this.iflags_ |= 1 << this.ipos_;
                    }
                    if (++this.ipos_ == 8) {
                        this.out_.write(this.iflags_);
                        this.ipos_ = 0;
                        this.iflags_ = 0;
                    }
                }

                @Override
                public void endAdd() throws IOException {
                    if (this.ipos_ > 0) {
                        this.out_.write(this.iflags_);
                    }
                    super.endAdd();
                }

                @Override
                public CachedReader createReader(ByteStoreAccess access) {
                    return this.createSingleReader(access);
                }
            };
        }

        @Override
        CachedReader createSingleReader(final ByteStoreAccess access) {
            return new ErrorLogReader(){
                long ioffLast_;
                int bytLast_;
                {
                    this.ioffLast_ = -1L;
                }

                @Override
                boolean booleanValue(long ix) throws IOException {
                    long ioff = ix / 8L;
                    if (ioff != this.ioffLast_) {
                        this.ioffLast_ = ioff;
                        access.seek(ioff);
                        this.bytLast_ = access.readByte();
                    }
                    return (this.bytLast_ & 1 << (int)ix % 8) != 0;
                }

                @Override
                int intValue(long ix) throws IOException {
                    return this.booleanValue(ix) ? 1 : 0;
                }

                @Override
                long longValue(long ix) throws IOException {
                    return this.booleanValue(ix) ? 1L : 0L;
                }

                @Override
                double doubleValue(long ix) throws IOException {
                    return this.booleanValue(ix) ? 1.0 : 0.0;
                }

                @Override
                Object objectValue(long ix) throws IOException {
                    return this.booleanValue(ix);
                }
            };
        }
    }

    private static class FixedStorage
    extends SingleStorage {
        private final Supplier<Codec> codecSupplier_;
        private final int itemSize_;

        FixedStorage(Supplier<Codec> codecSupplier) {
            this.codecSupplier_ = codecSupplier;
            this.itemSize_ = codecSupplier.get().getItemSize();
        }

        @Override
        public long getDiskRowCount(File[] files) {
            long leng = files[0].length();
            return leng > 0L ? leng / (long)this.itemSize_ : -1L;
        }

        @Override
        CachedColumn createSingleColumn(ByteStore byteStore) {
            final Codec encoder = this.codecSupplier_.get();
            return new StreamColumn(byteStore){

                @Override
                public void doAdd(Object value) throws IOException {
                    encoder.encode(value, (DataOutput)this.out_);
                }

                @Override
                CachedReader createReader(ByteStoreAccess access) {
                    return this.createSingleReader(access);
                }
            };
        }

        @Override
        CachedReader createSingleReader(final ByteStoreAccess access) {
            final Codec decoder = this.codecSupplier_.get();
            final int nbyte = decoder.getItemSize();
            return new ErrorLogReader(){

                @Override
                int intValue(long ix) throws IOException {
                    access.seek(ix * (long)nbyte);
                    return decoder.decodeInt(access);
                }

                @Override
                long longValue(long ix) throws IOException {
                    access.seek(ix * (long)nbyte);
                    return decoder.decodeLong(access);
                }

                @Override
                double doubleValue(long ix) throws IOException {
                    access.seek(ix * (long)nbyte);
                    return decoder.decodeDouble(access);
                }

                @Override
                boolean booleanValue(long ix) throws IOException {
                    access.seek(ix * (long)nbyte);
                    return decoder.decodeBoolean(access);
                }

                @Override
                Object objectValue(long ix) throws IOException {
                    access.seek(ix * (long)nbyte);
                    return decoder.decodeObject(access);
                }
            };
        }
    }

    private static abstract class SingleStorage
    extends ColumnStorage {
        private SingleStorage() {
        }

        abstract CachedColumn createSingleColumn(ByteStore var1);

        abstract CachedReader createSingleReader(ByteStoreAccess var1);

        @Override
        public CachedColumn createColumn(Supplier<ByteStore> bsSupplier) {
            return this.createSingleColumn(bsSupplier.get());
        }

        @Override
        public File[] getFileNames(File baseFile) {
            return new File[]{new File(baseFile + ".dat")};
        }

        @Override
        public CachedColumn createDiskColumn(File[] files) throws IOException {
            return this.createSingleColumn(new MoveFileByteStore(files[0]));
        }

        @Override
        public CachedReader createDiskReader(File[] files) throws IOException {
            return this.createSingleReader(ColumnStorage.createAccess(files[0]));
        }
    }

    private static abstract class StreamColumn
    implements CachedColumn {
        final ByteStore store_;
        final DataBufferedOutputStream out_;
        long nrow_;
        ByteBuffer[] bufs_;

        StreamColumn(ByteStore store) {
            this.store_ = store;
            this.out_ = new DataBufferedOutputStream(store.getOutputStream());
        }

        abstract void doAdd(Object var1) throws IOException;

        abstract CachedReader createReader(ByteStoreAccess var1);

        @Override
        public void add(Object value) throws IOException {
            this.doAdd(value);
            ++this.nrow_;
        }

        @Override
        public long getRowCount() {
            return this.nrow_;
        }

        @Override
        public void endAdd() throws IOException {
            this.out_.close();
            this.bufs_ = this.store_.toByteBuffers();
        }

        @Override
        public CachedReader createReader() {
            ByteStoreAccess access = ColumnStorage.createCopyAccess(this.bufs_);
            return this.createReader(access);
        }
    }

    private static abstract class ErrorLogReader
    implements CachedReader {
        boolean errorLogged_;

        private ErrorLogReader() {
        }

        abstract int intValue(long var1) throws IOException;

        abstract long longValue(long var1) throws IOException;

        abstract double doubleValue(long var1) throws IOException;

        abstract boolean booleanValue(long var1) throws IOException;

        abstract Object objectValue(long var1) throws IOException;

        @Override
        public int getIntValue(long ix) {
            try {
                return this.intValue(ix);
            }
            catch (IOException e) {
                this.logError(e);
                return 0;
            }
        }

        @Override
        public long getLongValue(long ix) {
            try {
                return this.longValue(ix);
            }
            catch (IOException e) {
                this.logError(e);
                return 0L;
            }
        }

        @Override
        public double getDoubleValue(long ix) {
            try {
                return this.doubleValue(ix);
            }
            catch (IOException e) {
                this.logError(e);
                return Double.NaN;
            }
        }

        @Override
        public boolean getBooleanValue(long ix) {
            try {
                return this.booleanValue(ix);
            }
            catch (IOException e) {
                this.logError(e);
                return false;
            }
        }

        @Override
        public Object getObjectValue(long ix) {
            try {
                return this.objectValue(ix);
            }
            catch (IOException e) {
                this.logError(e);
                return null;
            }
        }

        private void logError(IOException e) {
            if (!this.errorLogged_) {
                logger_.log(Level.WARNING, "Read error", e);
                this.errorLogged_ = true;
            }
        }
    }

    private static class Int3Codec
    extends FixedObjectCodec {
        int[] vec3_ = new int[3];

        Int3Codec() {
            super(12);
        }

        public int encode(Object value, DataOutput out) throws IOException {
            int[] array = (int[])value;
            out.writeInt(array[0]);
            out.writeInt(array[1]);
            out.writeInt(array[2]);
            return 12;
        }

        public Object decodeObject(ByteStoreAccess in) throws IOException {
            this.vec3_[0] = in.readInt();
            this.vec3_[1] = in.readInt();
            this.vec3_[2] = in.readInt();
            return this.vec3_;
        }
    }

    private static class Float3Codec
    extends FixedObjectCodec {
        float[] vec3_ = new float[3];

        Float3Codec() {
            super(12);
        }

        public int encode(Object value, DataOutput out) throws IOException {
            float[] array = (float[])value;
            out.writeFloat(array[0]);
            out.writeFloat(array[1]);
            out.writeFloat(array[2]);
            return 12;
        }

        public Object decodeObject(ByteStoreAccess in) throws IOException {
            this.vec3_[0] = in.readFloat();
            this.vec3_[1] = in.readFloat();
            this.vec3_[2] = in.readFloat();
            return this.vec3_;
        }
    }

    private static class Double3Codec
    extends FixedObjectCodec {
        double[] vec3_ = new double[3];

        Double3Codec() {
            super(24);
        }

        public int encode(Object value, DataOutput out) throws IOException {
            double[] array = (double[])value;
            out.writeDouble(array[0]);
            out.writeDouble(array[1]);
            out.writeDouble(array[2]);
            return 24;
        }

        public Object decodeObject(ByteStoreAccess in) throws IOException {
            this.vec3_[0] = in.readDouble();
            this.vec3_[1] = in.readDouble();
            this.vec3_[2] = in.readDouble();
            return this.vec3_;
        }
    }

    private static abstract class FixedObjectCodec
    extends Codec {
        final int itemSize_;

        FixedObjectCodec(int itemSize) {
            this.itemSize_ = itemSize;
        }

        public int decodeInt(ByteStoreAccess in) throws IOException {
            in.skip(this.itemSize_);
            return 0;
        }

        public long decodeLong(ByteStoreAccess in) throws IOException {
            in.skip(this.itemSize_);
            return 0L;
        }

        public double decodeDouble(ByteStoreAccess in) throws IOException {
            in.skip(this.itemSize_);
            return Double.NaN;
        }

        public boolean decodeBoolean(ByteStoreAccess in) throws IOException {
            in.skip(this.itemSize_);
            return false;
        }

        public int getItemSize() {
            return this.itemSize_;
        }
    }
}

