/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.logging.Logger;
import uk.ac.starlink.table.ByteStore;
import uk.ac.starlink.table.storage.FileByteStore;
import uk.ac.starlink.ttools.plot2.data.DiskCache;

public class MoveFileByteStore
implements ByteStore {
    private final File destFile_;
    private final OutputStream out_;
    private File workFile_;
    private long length_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.data");

    public MoveFileByteStore(File file) throws IOException {
        this.destFile_ = file;
        this.workFile_ = DiskCache.toWorkFilename(file);
        this.out_ = new FileOutputStream(this.workFile_){

            @Override
            public void write(int b) throws IOException {
                super.write(b);
                MoveFileByteStore.this.length_++;
            }

            @Override
            public void write(byte[] b) throws IOException {
                super.write(b);
                MoveFileByteStore.this.length_ = MoveFileByteStore.this.length_ + (long)b.length;
            }

            @Override
            public void write(byte[] b, int off, int len) throws IOException {
                super.write(b, off, len);
                MoveFileByteStore.this.length_ = MoveFileByteStore.this.length_ + (long)len;
            }
        };
    }

    public OutputStream getOutputStream() {
        return this.out_;
    }

    public long getLength() {
        return this.length_;
    }

    public void copy(OutputStream out) throws IOException {
        this.moveFile();
        FileByteStore.copy((File)this.destFile_, (OutputStream)out);
    }

    public ByteBuffer[] toByteBuffers() throws IOException {
        this.moveFile();
        return FileByteStore.toByteBuffers((File)this.destFile_);
    }

    private void moveFile() throws IOException {
        this.out_.flush();
        if (this.workFile_ != null) {
            if (!this.workFile_.renameTo(this.destFile_)) {
                throw new IOException("File move failed");
            }
            this.workFile_ = null;
        }
    }

    public void close() {
        File file = this.workFile_ == null ? this.workFile_ : this.destFile_;
        try {
            this.out_.close();
        }
        catch (IOException e) {
            logger_.warning("close error: " + e);
        }
        if (file.delete()) {
            logger_.info("Deleting temporary file: " + file);
        } else if (file.exists()) {
            logger_.warning("Failed to delete temporary file " + file);
        } else {
            logger_.info("Temporary file got deleted before close");
        }
    }
}

