/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import uk.ac.starlink.table.RowCollector;
import uk.ac.starlink.table.RowData;
import uk.ac.starlink.table.RowRunner;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.plot2.Slow;
import uk.ac.starlink.ttools.plot2.data.CachedColumn;
import uk.ac.starlink.ttools.plot2.data.CachedColumnFactory;
import uk.ac.starlink.ttools.plot2.data.CachedReader;
import uk.ac.starlink.ttools.plot2.data.CoordSpec;
import uk.ac.starlink.ttools.plot2.data.MaskSpec;
import uk.ac.starlink.ttools.plot2.data.StorageType;

public class TableCachedData {
    private final long nrow_;
    private final List<Supplier<CachedReader>> maskCols_;
    private final List<Supplier<CachedReader>> coordCols_;

    public TableCachedData(long nrow, List<Supplier<CachedReader>> maskCols, List<Supplier<CachedReader>> coordCols) {
        this.nrow_ = nrow;
        this.maskCols_ = maskCols;
        this.coordCols_ = coordCols;
    }

    public long getRowCount() {
        return this.nrow_;
    }

    public List<Supplier<CachedReader>> getMaskColumns() {
        return this.maskCols_;
    }

    public List<Supplier<CachedReader>> getCoordColumns() {
        return this.coordCols_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Slow
    public static TableCachedData readDataSeq(StarTable table, MaskSpec[] maskSpecs, CoordSpec[] coordSpecs, CachedColumnFactory colFact) throws IOException, InterruptedException {
        int ic;
        int im;
        int nm = maskSpecs.length;
        int nc = coordSpecs.length;
        long leng = table.getRowCount();
        CachedColumn[] maskCols = new CachedColumn[nm];
        CachedColumn[] coordCols = new CachedColumn[nc];
        MaskSpec.Reader[] maskRdrs = new MaskSpec.Reader[nm];
        CoordSpec.Reader[] coordRdrs = new CoordSpec.Reader[nc];
        RowSequence rseq = table.getRowSequence();
        for (int im2 = 0; im2 < nm; ++im2) {
            maskRdrs[im2] = maskSpecs[im2].flagReader((RowData)rseq);
            maskCols[im2] = colFact.createColumn(StorageType.BOOLEAN, leng);
        }
        for (int ic2 = 0; ic2 < nc; ++ic2) {
            coordRdrs[ic2] = coordSpecs[ic2].valueReader((RowData)rseq);
            coordCols[ic2] = colFact.createColumn(coordSpecs[ic2].getStorageType(), leng);
        }
        long nr = 0L;
        try {
            long irow = 0L;
            while (rseq.next()) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                for (im = 0; im < nm; ++im) {
                    boolean include = maskRdrs[im].readFlag(irow);
                    maskCols[im].add(include);
                }
                for (ic = 0; ic < nc; ++ic) {
                    Object value = coordRdrs[ic].readValue(irow);
                    coordCols[ic].add(value);
                }
                ++nr;
                ++irow;
            }
        }
        finally {
            rseq.close();
        }
        ArrayList<Supplier<CachedReader>> maskDatas = new ArrayList<Supplier<CachedReader>>();
        ArrayList<Supplier<CachedReader>> coordDatas = new ArrayList<Supplier<CachedReader>>();
        for (im = 0; im < nm; ++im) {
            maskCols[im].endAdd();
            maskDatas.add(maskCols[im]::createReader);
        }
        for (ic = 0; ic < nc; ++ic) {
            coordCols[ic].endAdd();
            coordDatas.add(coordCols[ic]::createReader);
        }
        return new TableCachedData(nr, maskDatas, coordDatas);
    }

    @Slow
    public static TableCachedData readDataPar(StarTable table, final MaskSpec[] maskSpecs, final CoordSpec[] coordSpecs, final CachedColumnFactory colFact, RowRunner rowRunner) throws IOException {
        final int nm = maskSpecs.length;
        final int nc = coordSpecs.length;
        RowCollector<List<TableCachedData>> collector = new RowCollector<List<TableCachedData>>(){

            public List<TableCachedData> createAccumulator() {
                return new ArrayList<TableCachedData>();
            }

            public List<TableCachedData> combine(List<TableCachedData> tcds1, List<TableCachedData> tcds2) {
                tcds1.addAll(tcds2);
                return tcds1;
            }

            public void accumulateRows(RowSplittable rseq, List<TableCachedData> tcds) throws IOException {
                int ic;
                int im;
                long leng = rseq.splittableSize();
                CachedColumn[] maskCols = new CachedColumn[nm];
                CachedColumn[] coordCols = new CachedColumn[nc];
                MaskSpec.Reader[] maskRdrs = new MaskSpec.Reader[nm];
                CoordSpec.Reader[] coordRdrs = new CoordSpec.Reader[nc];
                for (int im2 = 0; im2 < nm; ++im2) {
                    maskRdrs[im2] = maskSpecs[im2].flagReader((RowData)rseq);
                    maskCols[im2] = colFact.createColumn(StorageType.BOOLEAN, leng);
                }
                for (int ic2 = 0; ic2 < nc; ++ic2) {
                    coordRdrs[ic2] = coordSpecs[ic2].valueReader((RowData)rseq);
                    coordCols[ic2] = colFact.createColumn(coordSpecs[ic2].getStorageType(), leng);
                }
                long nr = 0L;
                LongSupplier rowIndex = rseq.rowIndex();
                while (rseq.next()) {
                    long irow = rowIndex == null ? -1L : rowIndex.getAsLong();
                    for (im = 0; im < nm; ++im) {
                        boolean include = maskRdrs[im].readFlag(irow);
                        maskCols[im].add(include);
                    }
                    for (ic = 0; ic < nc; ++ic) {
                        Object value = coordRdrs[ic].readValue(irow);
                        coordCols[ic].add(value);
                    }
                    ++nr;
                }
                ArrayList<Supplier<CachedReader>> maskDatas = new ArrayList<Supplier<CachedReader>>();
                ArrayList<Supplier<CachedReader>> coordDatas = new ArrayList<Supplier<CachedReader>>();
                for (im = 0; im < nm; ++im) {
                    maskCols[im].endAdd();
                    maskDatas.add(maskCols[im]::createReader);
                }
                for (ic = 0; ic < nc; ++ic) {
                    coordCols[ic].endAdd();
                    coordDatas.add(coordCols[ic]::createReader);
                }
                tcds.add(new TableCachedData(nr, maskDatas, coordDatas));
            }
        };
        List tcds = (List)rowRunner.collect((RowCollector)collector, table);
        return tcds.size() > 1 ? TableCachedData.toMulti(tcds) : (TableCachedData)tcds.get(0);
    }

    private static TableCachedData toMulti(List<TableCachedData> tcds) {
        List subCols;
        TableCachedData tcd0 = tcds.get(0);
        int nm = tcd0.getMaskColumns().size();
        int nc = tcd0.getCoordColumns().size();
        long[] nrows = new long[tcds.size()];
        int isub = 0;
        long nrow = 0L;
        for (TableCachedData tcd2 : tcds) {
            long nr = tcd2.getRowCount();
            nrows[isub++] = nr;
            nrow += nr;
        }
        ArrayList<Supplier<CachedReader>> multiMaskCols = new ArrayList<Supplier<CachedReader>>();
        ArrayList<Supplier<CachedReader>> multiCoordCols = new ArrayList<Supplier<CachedReader>>();
        int im = 0;
        while (im < nm) {
            int im0 = im++;
            subCols = tcds.stream().map(tcd -> tcd.getMaskColumns().get(im0)).collect(Collectors.toList());
            multiMaskCols.add(() -> new MultiCachedReader(subCols, nrows));
        }
        int ic = 0;
        while (ic < nc) {
            int ic0 = ic++;
            subCols = tcds.stream().map(tcd -> tcd.getCoordColumns().get(ic0)).collect(Collectors.toList());
            multiCoordCols.add(() -> new MultiCachedReader(subCols, nrows));
        }
        return new TableCachedData(nrow, multiMaskCols, multiCoordCols);
    }

    private static class MultiCachedReader
    implements CachedReader {
        final List<Supplier<CachedReader>> subCols_;
        final long[] nrows_;
        final CachedReader[] subRdrs_;
        long ixlo_;
        long ixhi_;
        long jx_;
        CachedReader rdr_;

        MultiCachedReader(List<Supplier<CachedReader>> subCols, long[] nrows) {
            this.subCols_ = subCols;
            this.nrows_ = nrows;
            this.subRdrs_ = new CachedReader[this.nrows_.length];
            this.ixlo_ = -1L;
            this.ixhi_ = -1L;
        }

        private void update(long ix) {
            if (ix < this.ixlo_ || ix >= this.ixhi_) {
                long ixhi = 0L;
                for (int isub = 0; isub < this.nrows_.length; ++isub) {
                    long ixlo = ixhi;
                    if (ix < ixlo || ix >= (ixhi += this.nrows_[isub])) continue;
                    this.ixlo_ = ixlo;
                    this.ixhi_ = ixhi;
                    this.jx_ = ix - ixlo;
                    if (this.subRdrs_[isub] == null) {
                        this.subRdrs_[isub] = this.subCols_.get(isub).get();
                    }
                    this.rdr_ = this.subRdrs_[isub];
                    return;
                }
                throw new IllegalArgumentException("Index out of range: " + ix + " > " + ixhi);
            }
            this.jx_ = ix - this.ixlo_;
        }

        @Override
        public boolean getBooleanValue(long ix) {
            this.update(ix);
            return this.rdr_.getBooleanValue(this.jx_);
        }

        @Override
        public int getIntValue(long ix) {
            this.update(ix);
            return this.rdr_.getIntValue(this.jx_);
        }

        @Override
        public long getLongValue(long ix) {
            this.update(ix);
            return this.rdr_.getLongValue(this.jx_);
        }

        @Override
        public double getDoubleValue(long ix) {
            this.update(ix);
            return this.rdr_.getDoubleValue(this.jx_);
        }

        @Override
        public Object getObjectValue(long ix) {
            this.update(ix);
            return this.rdr_.getObjectValue(this.jx_);
        }
    }
}

