/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.data;

import java.io.IOException;
import uk.ac.starlink.table.DomainMapper;
import uk.ac.starlink.table.RowAccess;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.RowSplittable;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.WrapperStarTable;
import uk.ac.starlink.ttools.plot2.data.AbstractDataSpec;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.DataStoreFactory;
import uk.ac.starlink.ttools.plot2.data.TupleRunner;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.data.UserDataReader;

public abstract class WrapperDataStoreFactory
implements DataStoreFactory {
    private final DataStoreFactory baseFact_;

    protected WrapperDataStoreFactory(DataStoreFactory baseFact) {
        this.baseFact_ = baseFact;
    }

    @Override
    public DataStore readDataStore(DataSpec[] dataSpecs, DataStore prevStore) throws IOException, InterruptedException {
        int nspec = dataSpecs.length;
        DataSpec[] wrapDataSpecs = new DataSpec[nspec];
        for (int i = 0; i < nspec; ++i) {
            wrapDataSpecs[i] = new WrapperDataSpec(dataSpecs[i]);
            assert (wrapDataSpecs[i].equals(new WrapperDataSpec(dataSpecs[i])));
        }
        DataStore basePrevStore = prevStore instanceof WrapperDataStore ? ((WrapperDataStore)prevStore).baseStore_ : prevStore;
        DataStore baseStore = this.baseFact_.readDataStore(wrapDataSpecs, basePrevStore);
        return new WrapperDataStore(baseStore);
    }

    protected abstract RowSequence createRowSequence(StarTable var1) throws IOException;

    protected abstract RowAccess createRowAccess(StarTable var1) throws IOException;

    protected abstract RowSplittable createRowSplittable(StarTable var1) throws IOException;

    private class WrapperDataSpec
    extends AbstractDataSpec {
        private final DataSpec baseSpec_;
        private final StarTable table_;

        public WrapperDataSpec(DataSpec baseSpec) {
            this.baseSpec_ = baseSpec;
            final StarTable baseSourceTable = baseSpec.getSourceTable();
            this.table_ = new WrapperStarTable(baseSourceTable){

                public RowSequence getRowSequence() throws IOException {
                    return WrapperDataStoreFactory.this.createRowSequence(baseSourceTable);
                }

                public RowAccess getRowAccess() throws IOException {
                    return WrapperDataStoreFactory.this.createRowAccess(baseSourceTable);
                }

                public RowSplittable getRowSplittable() throws IOException {
                    return WrapperDataStoreFactory.this.createRowSplittable(baseSourceTable);
                }

                public int hashCode() {
                    return baseSourceTable.hashCode();
                }

                public boolean equals(Object o) {
                    return o instanceof WrapperStarTable && ((WrapperStarTable)o).getBaseTable().equals(this.getBaseTable());
                }
            };
        }

        @Override
        public StarTable getSourceTable() {
            return this.table_;
        }

        @Override
        public int getCoordCount() {
            return this.baseSpec_.getCoordCount();
        }

        @Override
        public String getMaskId() {
            return this.baseSpec_.getMaskId();
        }

        @Override
        public String getCoordId(int icoord) {
            return this.baseSpec_.getCoordId(icoord);
        }

        @Override
        public Coord getCoord(int icoord) {
            return this.baseSpec_.getCoord(icoord);
        }

        @Override
        public ValueInfo[] getUserCoordInfos(int icoord) {
            return this.baseSpec_.getUserCoordInfos(icoord);
        }

        @Override
        public DomainMapper[] getUserCoordMappers(int icoord) {
            return this.baseSpec_.getUserCoordMappers(icoord);
        }

        @Override
        public UserDataReader createUserDataReader() {
            return this.baseSpec_.createUserDataReader();
        }

        @Override
        public boolean isMaskTrue() {
            return this.baseSpec_.isMaskTrue();
        }

        @Override
        public boolean isCoordBlank(int icoord) {
            return this.baseSpec_.isCoordBlank(icoord);
        }
    }

    private class WrapperDataStore
    implements DataStore {
        final DataStore baseStore_;

        WrapperDataStore(DataStore baseStore) {
            this.baseStore_ = baseStore;
        }

        @Override
        public TupleSequence getTupleSequence(DataSpec spec) {
            return this.baseStore_.getTupleSequence(new WrapperDataSpec(spec));
        }

        @Override
        public boolean hasData(DataSpec spec) {
            return this.baseStore_.hasData(new WrapperDataSpec(spec));
        }

        @Override
        public TupleRunner getTupleRunner() {
            return this.baseStore_.getTupleRunner();
        }
    }
}

