/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.Tuple;

public class CubeDataGeom
implements DataGeom {
    public static final FloatingCoord X_COORD = CubeDataGeom.posCoord("X");
    public static final FloatingCoord Y_COORD = CubeDataGeom.posCoord("Y");
    public static final FloatingCoord Z_COORD = CubeDataGeom.posCoord("Z");
    public static CubeDataGeom INSTANCE = new CubeDataGeom();

    private CubeDataGeom() {
    }

    @Override
    public int getDataDimCount() {
        return 3;
    }

    @Override
    public String getVariantName() {
        return "Components";
    }

    @Override
    public Coord[] getPosCoords() {
        return new Coord[]{X_COORD, Y_COORD, Z_COORD};
    }

    @Override
    public boolean readDataPos(Tuple tuple, int ic, double[] dpos) {
        double x = X_COORD.readDoubleCoord(tuple, ic++);
        double y = Y_COORD.readDoubleCoord(tuple, ic++);
        double z = Z_COORD.readDoubleCoord(tuple, ic++);
        if (Double.isNaN(x) || Double.isNaN(y) || Double.isNaN(z)) {
            return false;
        }
        dpos[0] = x;
        dpos[1] = y;
        dpos[2] = z;
        return true;
    }

    private static FloatingCoord posCoord(String axName) {
        InputMeta meta = new InputMeta(axName.toLowerCase(), axName.toUpperCase());
        meta.setShortDescription(axName + " coordinate");
        return FloatingCoord.createCoord(meta, true);
    }
}

