/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import skyview.geometry.Deprojecter;
import skyview.geometry.Projecter;
import skyview.geometry.Transformer;
import skyview.geometry.projecter.Ait;
import skyview.geometry.projecter.Arc;
import skyview.geometry.projecter.Car;
import skyview.geometry.projecter.Stg;
import skyview.geometry.projecter.Tan;
import uk.ac.starlink.ttools.plot.Matrices;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.geom.SkyAspect;
import uk.ac.starlink.ttools.plot2.geom.SkyFov;
import uk.ac.starlink.ttools.plot2.geom.SkySurface;
import uk.ac.starlink.ttools.plot2.geom.SkyviewProjection;

public abstract class FixedSkyviewProjection
extends SkyviewProjection {
    public static final FixedSkyviewProjection AIT = FixedSkyviewProjection.createProjection((Projecter)new Ait(), "Aitoff", "Hammer-Aitoff projection with lon=0 at center", FixedRotation.UNIT);
    public static final FixedSkyviewProjection AIT0 = FixedSkyviewProjection.createProjection((Projecter)new Ait(), "Aitoff0", "Hammer-Aitoff projection with lon=180 at center", FixedRotation.LON_PI);
    public static final FixedSkyviewProjection CAR1 = FixedSkyviewProjection.createProjection(new Car1(), "Car", "Plate Carree projection (lon/lat on Cartesian axes) with lon=0 at center", FixedRotation.UNIT);
    public static final FixedSkyviewProjection CAR0 = FixedSkyviewProjection.createProjection(new Car1(), "Car0", "Plate Carree Projection (lon/lat on Cartesian axes) with lon=180 at center", FixedRotation.LON_PI);
    public static final FixedSkyviewProjection TAN = FixedSkyviewProjection.createSimpleProjection((Projecter)new Tan());
    private static final FixedSkyviewProjection ARC = FixedSkyviewProjection.createSimpleProjection((Projecter)new Arc());
    private static final FixedSkyviewProjection STG = FixedSkyviewProjection.createSimpleProjection((Projecter)new Stg());

    protected FixedSkyviewProjection(Projecter projecter, Shape shape, String name, String description) {
        super(projecter, shape, name, description);
    }

    protected abstract double[] getFixedRotation(boolean var1);

    @Override
    public double[] cursorRotate(double[] rotmat, Point2D.Double pos0, Point2D.Double pos1) {
        return null;
    }

    @Override
    public double[] projRotate(double[] rotmat, Point2D.Double pos0, Point2D.Double pos1) {
        return null;
    }

    @Override
    public boolean useRanges(boolean reflect, double[] r3, double radiusRad) {
        return false;
    }

    @Override
    public SkyAspect createAspect(boolean reflect, double[] r3, double radiusRad, Range[] ranges) {
        double yoff;
        double xoff;
        double zoom;
        double[] rotmat = this.getFixedRotation(reflect);
        double[] rr3 = r3 == null ? null : Matrices.mvMult(rotmat, r3);
        Point2D.Double dpos = new Point2D.Double();
        if (rr3 != null && this.project(rr3[0], rr3[1], rr3[2], dpos)) {
            zoom = Math.PI / radiusRad;
            xoff = -dpos.x * zoom;
            yoff = dpos.y * zoom;
        } else {
            zoom = 1.0;
            xoff = 0.0;
            yoff = 0.0;
        }
        return new SkyAspect(rotmat, zoom, xoff, yoff);
    }

    @Override
    public SkyFov getFov(SkySurface surf) {
        if (surf.getZoom() == 1.0 && surf.getOffsetX() == 0.0 && surf.getOffsetY() == 0.0) {
            return null;
        }
        Rectangle bounds = surf.getPlotBounds();
        int npix = Math.max(bounds.width, bounds.height);
        Point2D.Double gpos = new Point2D.Double(bounds.x + bounds.width / 2, bounds.y + bounds.height / 2);
        double[] r3 = surf.graphicsToData(gpos, null);
        if (r3 != null) {
            double[] lonLat = surf.getRoundedLonLatDegrees(r3);
            double rdeg = 180.0 / surf.getZoom();
            double radiusDeg = PlotUtil.roundNumber(rdeg, rdeg / (double)(10 * npix));
            return new SkyFov(lonLat[0], lonLat[1], radiusDeg);
        }
        return null;
    }

    private static FixedSkyviewProjection createSimpleProjection(Projecter projecter) {
        return new FixedSkyviewProjection(projecter, FixedSkyviewProjection.getShape(projecter), projecter.getName(), projecter.getDescription()){

            @Override
            public boolean isContinuous() {
                return true;
            }

            @Override
            public boolean isContinuousLine(double[] r3a, double[] r3b) {
                return true;
            }

            @Override
            public double[] getFixedRotation(boolean reflect) {
                return SkyAspect.unitMatrix(reflect);
            }
        };
    }

    private static FixedSkyviewProjection createProjection(Projecter projecter, String name, String descrip, final FixedRotation rotation) {
        return new FixedSkyviewProjection(projecter, FixedSkyviewProjection.getShape(projecter), name, descrip){

            @Override
            public boolean isContinuous() {
                return false;
            }

            @Override
            public boolean isContinuousLine(double[] r3a, double[] r3b) {
                return rotation.isContinuousLine(r3a, r3b);
            }

            @Override
            public double[] getFixedRotation(boolean reflect) {
                return rotation.getMatrix(reflect);
            }
        };
    }

    private static Shape getShape(Projecter projecter) {
        double S2 = Math.sqrt(2.0);
        double PI = Math.PI;
        Class<?> clazz = projecter.getClass();
        if (clazz.equals(Ait.class)) {
            return new Ellipse2D.Double(-2.0 * S2, -S2, 4.0 * S2, 2.0 * S2);
        }
        if (clazz.equals(Arc.class)) {
            return new Ellipse2D.Double(-Math.PI, -Math.PI, Math.PI * 2, Math.PI * 2);
        }
        if (clazz.equals(Car1.class)) {
            return new Rectangle2D.Double(-Math.PI, -1.5707963267948966, Math.PI * 2, Math.PI);
        }
        if (clazz.equals(Stg.class)) {
            return new Ellipse2D.Double(-2.0, -2.0, 4.0, 4.0);
        }
        if (clazz.equals(Tan.class)) {
            return null;
        }
        throw new IllegalArgumentException("Don't know shape for projection");
    }

    private static class Car1
    extends Projecter {
        final Car base_ = new Car();

        Car1() {
        }

        public String getName() {
            return this.base_.getName();
        }

        public String getDescription() {
            return this.base_.getDescription();
        }

        public Deprojecter inverse() {
            return this.base_.inverse();
        }

        public double getXTiling() {
            return 0.0;
        }

        public double getYTiling() {
            return 0.0;
        }

        public boolean isInverse(Transformer t) {
            return this.base_.isInverse(t);
        }

        public void transform(double[] sphere, double[] plane) {
            this.base_.transform(sphere, plane);
        }

        public boolean allValid() {
            return false;
        }

        public boolean validPosition(double[] pos) {
            double x = pos[0];
            double y = pos[1];
            return x >= -Math.PI && x <= Math.PI && y >= -1.5707963267948966 && y <= 1.5707963267948966;
        }
    }

    private static abstract class FixedRotation {
        public static final FixedRotation UNIT = new FixedRotation(){

            @Override
            public double[] getMatrix(boolean reflect) {
                double[] dArray;
                if (reflect) {
                    double[] dArray2 = new double[9];
                    dArray2[0] = 1.0;
                    dArray2[1] = 0.0;
                    dArray2[2] = 0.0;
                    dArray2[3] = 0.0;
                    dArray2[4] = -1.0;
                    dArray2[5] = 0.0;
                    dArray2[6] = 0.0;
                    dArray2[7] = 0.0;
                    dArray = dArray2;
                    dArray2[8] = 1.0;
                } else {
                    double[] dArray3 = new double[9];
                    dArray3[0] = 1.0;
                    dArray3[1] = 0.0;
                    dArray3[2] = 0.0;
                    dArray3[3] = 0.0;
                    dArray3[4] = 1.0;
                    dArray3[5] = 0.0;
                    dArray3[6] = 0.0;
                    dArray3[7] = 0.0;
                    dArray = dArray3;
                    dArray3[8] = 1.0;
                }
                return dArray;
            }

            @Override
            public boolean isContinuousLine(double[] r3a, double[] r3b) {
                return r3a[1] * r3b[1] >= 0.0 || r3a[0] >= 0.0 && r3b[0] >= 0.0;
            }
        };
        public static final FixedRotation LON_PI = new FixedRotation(){

            @Override
            public double[] getMatrix(boolean reflect) {
                double[] dArray;
                if (reflect) {
                    double[] dArray2 = new double[9];
                    dArray2[0] = -1.0;
                    dArray2[1] = 0.0;
                    dArray2[2] = 0.0;
                    dArray2[3] = 0.0;
                    dArray2[4] = 1.0;
                    dArray2[5] = 0.0;
                    dArray2[6] = 0.0;
                    dArray2[7] = 0.0;
                    dArray = dArray2;
                    dArray2[8] = 1.0;
                } else {
                    double[] dArray3 = new double[9];
                    dArray3[0] = -1.0;
                    dArray3[1] = 0.0;
                    dArray3[2] = 0.0;
                    dArray3[3] = 0.0;
                    dArray3[4] = -1.0;
                    dArray3[5] = 0.0;
                    dArray3[6] = 0.0;
                    dArray3[7] = 0.0;
                    dArray = dArray3;
                    dArray3[8] = 1.0;
                }
                return dArray;
            }

            @Override
            public boolean isContinuousLine(double[] r3a, double[] r3b) {
                return r3a[1] * r3b[1] >= 0.0 || r3a[0] <= 0.0 && r3b[0] <= 0.0;
            }
        };

        private FixedRotation() {
        }

        abstract double[] getMatrix(boolean var1);

        abstract boolean isContinuousLine(double[] var1, double[] var2);
    }
}

