/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Supplier;
import uk.ac.starlink.ttools.plot2.CoordSequence;
import uk.ac.starlink.ttools.plot2.Decoration;
import uk.ac.starlink.ttools.plot2.Gesture;
import uk.ac.starlink.ttools.plot2.NavAction;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.geom.BandDecoration;
import uk.ac.starlink.ttools.plot2.geom.NavDecorations;
import uk.ac.starlink.ttools.plot2.geom.SkyAspect;
import uk.ac.starlink.ttools.plot2.geom.SkySurface;

public class SkyNavigator
implements Navigator<SkyAspect> {
    private final double zoomFactor_;

    public SkyNavigator(double zoomFactor) {
        this.zoomFactor_ = zoomFactor;
    }

    @Override
    public NavAction<SkyAspect> drag(Surface surface, Point pos, int ibutt, Point origin) {
        SkySurface ssurf = (SkySurface)surface;
        Rectangle bounds = surface.getPlotBounds();
        if (ibutt == 3) {
            double fact = PlotUtil.toZoom(this.zoomFactor_, origin, pos, null);
            SkyAspect aspect = ssurf.zoom(origin, fact);
            Decoration dec = NavDecorations.createDragDecoration(origin, fact, fact, true, true, bounds);
            return new NavAction<SkyAspect>(aspect, dec);
        }
        if (ibutt == 2) {
            Point isoPos = SkyNavigator.toIsoPos(origin, pos, bounds);
            BandDecoration dec = NavDecorations.createBandDecoration(origin, isoPos, true, true, bounds);
            return new NavAction<Object>(null, dec);
        }
        SkyAspect aspect = ssurf.pan(origin, pos);
        return new NavAction<SkyAspect>(aspect, null);
    }

    @Override
    public NavAction<SkyAspect> endDrag(Surface surface, Point pos, int ibutt, Point origin) {
        if (ibutt == 2) {
            SkySurface ssurf = (SkySurface)surface;
            Rectangle bounds = surface.getPlotBounds();
            Point isoPos = SkyNavigator.toIsoPos(origin, pos, bounds);
            BandDecoration dec = NavDecorations.createBandDecoration(origin, isoPos, true, true, bounds);
            if (dec != null) {
                Rectangle target = dec.getTargetRectangle();
                Point cp = new Point(target.x + target.width / 2, target.y + target.height / 2);
                double xf = (double)bounds.width * 1.0 / (double)target.width;
                double yf = (double)bounds.height * 1.0 / (double)target.height;
                double fact = 0.5 * (xf + yf);
                SkyAspect aspect = ssurf.reframe(cp, fact);
                return new NavAction<SkyAspect>(aspect, null);
            }
            return null;
        }
        return null;
    }

    @Override
    public NavAction<SkyAspect> wheel(Surface surface, Point pos, int wheelrot) {
        SkySurface ssurf = (SkySurface)surface;
        double fact = PlotUtil.toZoom(this.zoomFactor_, wheelrot);
        SkyAspect aspect = ssurf.zoom(pos, fact);
        Decoration dec = NavDecorations.createWheelDecoration(pos, fact, fact, true, true, surface.getPlotBounds());
        return new NavAction<SkyAspect>(aspect, dec);
    }

    @Override
    public NavAction<SkyAspect> click(Surface surface, Point pos, int ibutt, Supplier<CoordSequence> dposSupplier) {
        return null;
    }

    @Override
    public Map<Gesture, String> getNavOptions(Surface surface, Point pos) {
        LinkedHashMap<Gesture, String> map = new LinkedHashMap<Gesture, String>();
        map.put(Gesture.DRAG_1, "Pan");
        map.put(Gesture.DRAG_3, "Zoom");
        map.put(Gesture.DRAG_2, "Frame");
        map.put(Gesture.WHEEL, "Zoom");
        return map;
    }

    public static ConfigKey<?>[] getConfigKeys() {
        return new ConfigKey[]{StyleKeys.ZOOM_FACTOR};
    }

    public static SkyNavigator createNavigator(ConfigMap navConfig) {
        double zoom = navConfig.get(StyleKeys.ZOOM_FACTOR);
        return new SkyNavigator(zoom);
    }

    private static Point toIsoPos(Point origin, Point point, Rectangle plotBounds) {
        int w = plotBounds.width;
        int h = plotBounds.height;
        int dx = point.x - origin.x;
        int dy = point.y - origin.y;
        int sx = dx >= 0 ? 1 : -1;
        int sy = dy >= 0 ? 1 : -1;
        double fx = (double)dx * 1.0 / (double)plotBounds.width;
        double fy = (double)dy * 1.0 / (double)plotBounds.height;
        double f = Math.abs(fx) >= Math.abs(fy) ? Math.abs(fx) : Math.abs(fy);
        return new Point((int)Math.round((double)origin.x + f * (double)sx * (double)w), (int)Math.round((double)origin.y + f * (double)sy * (double)h));
    }
}

