/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Scale;

public class SphereAngleRange {
    private final double phiLo_;
    private final double phiHi_;
    private final double thetaLo_;
    private final double thetaHi_;

    public SphereAngleRange(double phiLo, double phiHi, double thetaLo, double thetaHi) {
        this.phiLo_ = phiLo;
        this.phiHi_ = phiHi;
        this.thetaLo_ = thetaLo;
        this.thetaHi_ = thetaHi;
    }

    public double[] getPhiLimits() {
        return new double[]{this.phiLo_, this.phiHi_};
    }

    public double[] getThetaLimits() {
        return new double[]{this.thetaLo_, this.thetaHi_};
    }

    public static SphereAngleRange calculateRange(double[] dlos, double[] dhis) {
        double[] phiRange = null;
        double[] thetaRange = null;
        if (SphereAngleRange.zeroNearCenter(dlos[0], dhis[0]) && SphereAngleRange.zeroNearCenter(dlos[1], dhis[1])) {
            phiRange = new double[]{-Math.PI, Math.PI};
        }
        if (SphereAngleRange.zeroNearCenter(dlos[2], dhis[2])) {
            thetaRange = new double[]{-1.5707963267948966, 1.5707963267948966};
        }
        if (phiRange == null || thetaRange == null) {
            double[] dc = new double[]{SphereAngleRange.frac(dlos[0], dhis[0], 0.5), SphereAngleRange.frac(dlos[1], dhis[1], 0.5), SphereAngleRange.frac(dlos[2], dhis[2], 0.5)};
            double phiCent = Math.atan2(dc[1], dc[0]);
            boolean phiFlip = Math.abs(phiCent) > 1.5707963267948966;
            double thetaLo = 1.5707963267948966;
            double thetaHi = -1.5707963267948966;
            double phiLo = Math.PI * 2;
            double phiHi = -Math.PI;
            int nsamp = 3;
            double dn1 = 1.0 / ((double)nsamp - 1.0);
            for (int ix = 0; ix < nsamp; ++ix) {
                double dx = SphereAngleRange.frac(dlos[0], dhis[0], (double)ix * dn1);
                for (int iy = 0; iy < nsamp; ++iy) {
                    double dy = SphereAngleRange.frac(dlos[1], dhis[1], (double)iy * dn1);
                    for (int iz = 0; iz < nsamp; ++iz) {
                        double dz = SphereAngleRange.frac(dlos[2], dhis[2], (double)iz * dn1);
                        double r = Math.sqrt(dx * dx + dy * dy + dz * dz);
                        double phi = Math.atan2(dy, dx);
                        if (phiFlip && phi < 0.0) {
                            phi += Math.PI * 2;
                        }
                        double theta = Math.acos(dz / r);
                        thetaLo = Math.min(thetaLo, theta);
                        thetaHi = Math.min(thetaHi, theta);
                        phiLo = Math.min(phiLo, phi);
                        phiHi = Math.max(phiHi, phi);
                    }
                }
            }
            if (phiRange == null) {
                phiRange = new double[]{phiLo, phiHi};
            }
            if (thetaRange == null) {
                thetaRange = new double[]{thetaLo, thetaHi};
            }
        }
        return new SphereAngleRange((double)phiRange[0], phiRange[1], thetaRange[0], thetaRange[1]);
    }

    private static boolean zeroNearCenter(double dlo, double dhi) {
        double zf = PlotUtil.unscaleValue(dlo, dhi, 0.0, Scale.LINEAR);
        return zf > 0.25 && zf < 0.75;
    }

    private static double frac(double dlo, double dhi, double f) {
        return dlo + (dhi - dlo) * f;
    }
}

