/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Iterator;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;

public class SphereNet {
    private final CubeSurface surf_;
    private final int gsize_;
    private final double[] dlos_;
    private final double[] dhis_;

    public SphereNet(CubeSurface surf) {
        this.surf_ = surf;
        Rectangle bounds = this.surf_.getPlotBounds();
        this.gsize_ = Math.max(bounds.width, bounds.height);
        double[] xlims = surf.getDataLimits(0);
        double[] ylims = surf.getDataLimits(1);
        double[] zlims = surf.getDataLimits(2);
        this.dlos_ = new double[]{xlims[0], ylims[0], zlims[0]};
        this.dhis_ = new double[]{xlims[1], ylims[1], zlims[1]};
    }

    public double getDefaultRadius() {
        if (this.containsOrigin()) {
            double r = Double.POSITIVE_INFINITY;
            for (int i = 0; i < 3; ++i) {
                r = Math.min(r, Math.abs(this.dlos_[i]));
                r = Math.min(r, Math.abs(this.dhis_[i]));
            }
            return r;
        }
        double r = 0.0;
        for (int i = 0; i < 3; ++i) {
            r = Math.max(r, Math.abs(this.dlos_[i]));
            r = Math.max(r, Math.abs(this.dhis_[i]));
        }
        return r;
    }

    public Line3d[] getLongitudeLines(double dRadius, int nLon) {
        double dsize = 1.0 / this.unitNorm(2);
        double[][][] grid = new double[nLon][][];
        int np = this.getQuadrantPointCount(dsize, dRadius);
        for (int il = 0; il < nLon; ++il) {
            grid[il] = new double[np * 4 + 1][];
        }
        double dTheta = 1.5707963267948966 / (double)np;
        double dPhi = Math.PI / (double)nLon;
        double[] cosPhis = new double[nLon];
        double[] sinPhis = new double[nLon];
        for (int iLon = 0; iLon < nLon; ++iLon) {
            double phi = (double)iLon * dPhi;
            cosPhis[iLon] = Math.cos(phi);
            sinPhis[iLon] = Math.sin(phi);
        }
        for (int ip = 0; ip <= np; ++ip) {
            double theta = (double)ip * dTheta;
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            for (int il = 0; il < nLon; ++il) {
                double x = dRadius * (cosTheta * cosPhis[il]);
                double y = dRadius * (cosTheta * sinPhis[il]);
                double z = dRadius * sinTheta;
                int ip0 = 0 * np + ip;
                int ip1 = 2 * np - ip - 1;
                int ip2 = 2 * np + ip;
                int ip3 = 4 * np - ip - 1;
                grid[il][ip0] = new double[]{x, y, z};
                grid[il][ip1] = new double[]{-x, -y, z};
                grid[il][ip2] = new double[]{-x, -y, -z};
                grid[il][ip3] = new double[]{x, y, -z};
            }
        }
        return SphereNet.toLines(grid);
    }

    public Line3d[] getLatitudeLines(double dRadius, int nLat) {
        double dsize = 1.0 / Math.min(this.unitNorm(0), this.unitNorm(1));
        double[][][] grid = new double[1 + nLat * 2][][];
        double dTheta = 1.5707963267948966 / (double)(nLat + 1);
        for (int iLat = 0; iLat < nLat; ++iLat) {
            double theta = (double)(iLat + 1) * dTheta;
            double cosTheta = Math.cos(theta);
            double sinTheta = Math.sin(theta);
            double r = dRadius * sinTheta;
            int np = this.getQuadrantPointCount(dsize, r * cosTheta);
            double dPhi = 1.5707963267948966 / (double)np;
            for (int iup = 0; iup < 2; ++iup) {
                int il = 1 + iLat * 2 + iup;
                grid[il] = new double[np * 4 + 1][];
            }
            for (int ip = 0; ip < np; ++ip) {
                double phi = (double)ip * dPhi;
                double x = r * Math.cos(phi);
                double y = r * Math.sin(phi);
                int ip0 = 0 * np + ip;
                int ip1 = 2 * np - ip - 1;
                int ip2 = 2 * np + ip;
                int ip3 = 4 * np - ip - 1;
                for (int iup = 0; iup < 2; ++iup) {
                    int il = 1 + iLat * 2 + iup;
                    double z = iup == 0 ? dRadius * cosTheta : -dRadius * cosTheta;
                    grid[il][ip0] = new double[]{x, y, z};
                    grid[il][ip1] = new double[]{-x, y, z};
                    grid[il][ip2] = new double[]{-x, -y, z};
                    grid[il][ip3] = new double[]{x, -y, z};
                }
            }
        }
        int np = this.getQuadrantPointCount(dsize, dRadius);
        double dPhi = 1.5707963267948966 / (double)np;
        double[][] equator = new double[np * 4 + 1][];
        for (int ip = 0; ip < np; ++ip) {
            double phi = (double)ip * dPhi;
            double x = dRadius * Math.cos(phi);
            double y = dRadius * Math.sin(phi);
            int ip0 = 0 * np + ip;
            int ip1 = 2 * np - ip - 1;
            int ip2 = 2 * np + ip;
            int ip3 = 4 * np - ip - 1;
            equator[ip0] = new double[]{x, y, 0.0};
            equator[ip1] = new double[]{-x, y, 0.0};
            equator[ip2] = new double[]{-x, -y, 0.0};
            equator[ip3] = new double[]{x, -y, 0.0};
        }
        grid[0] = equator;
        return SphereNet.toLines(grid);
    }

    private boolean containsOrigin() {
        for (int i = 0; i < 3; ++i) {
            if (!(this.dlos_[i] >= 0.0) && !(this.dhis_[i] <= 0.0)) continue;
            return false;
        }
        return true;
    }

    private int getQuadrantPointCount(double dataUnitSize, double dataRadius) {
        double dPixel = dataUnitSize / (double)this.gsize_;
        double tol = 0.5 * dPixel;
        double dnp = 1.5707963267948966 * Math.sqrt(dataRadius / tol);
        return Math.min(400, (int)Math.ceil(dnp));
    }

    private static Line3d[] toLines(double[][][] grid) {
        for (int il = 0; il < grid.length; ++il) {
            double[][] line = grid[il];
            assert (line[line.length - 1] == null);
            line[line.length - 1] = line[0];
        }
        Line3d[] lines = new Line3d[grid.length];
        for (int il = 0; il < lines.length; ++il) {
            lines[il] = new Line3d(grid[il]);
        }
        return lines;
    }

    private double unitNorm(int idim) {
        double[] dp0 = new double[3];
        double[] dp1 = new double[3];
        dp1[idim] = 1.0;
        return Math.abs(this.surf_.normalise(dp1, idim) - this.surf_.normalise(dp0, idim));
    }

    public static class Line3d
    implements Iterable<double[]> {
        final double[][] points_;

        Line3d(double[][] points) {
            this.points_ = points;
        }

        @Override
        public Iterator<double[]> iterator() {
            return Arrays.asList(this.points_).iterator();
        }
    }
}

