/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.function.Supplier;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.Gang;
import uk.ac.starlink.ttools.plot2.Ganger;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.PlotPlacement;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ShadeAxis;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.Surround;
import uk.ac.starlink.ttools.plot2.Trimming;
import uk.ac.starlink.ttools.plot2.ZoneContent;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.IntegerConfigKey;

public abstract class StackGanger<P, A>
implements Ganger<P, A> {
    private final String[] zoneNames_;
    private final int nz_;
    private final boolean isUp_;
    private final Padding padding_;
    private final int zoneGap_;
    public static final ConfigKey<Integer> ZONEGAP_KEY = StackGanger.createZoneGapKey();
    private static final int PAD = 2;

    protected StackGanger(String[] zoneNames, boolean isUp, Padding padding, int zoneGap) {
        String[] stringArray;
        if (zoneNames == null || zoneNames.length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "";
        } else {
            stringArray = new LinkedHashSet<String>(Arrays.asList(zoneNames)).toArray(new String[0]);
        }
        this.zoneNames_ = stringArray;
        this.nz_ = this.zoneNames_.length;
        this.isUp_ = isUp;
        this.padding_ = padding;
        this.zoneGap_ = zoneGap;
    }

    public abstract double[] getXLimits(A var1);

    public abstract A fixXLimits(A var1, double var2, double var4);

    @Override
    public int getZoneCount() {
        return this.nz_;
    }

    public String[] getZoneNames() {
        return this.zoneNames_;
    }

    @Override
    public Gang createGang(Rectangle[] zonePlotBounds) {
        return new StackGang(zonePlotBounds);
    }

    @Override
    public Gang createGang(final Rectangle gangExtBox, final SurfaceFactory<P, A> surfFact, ZoneContent<P, A>[] contents, Trimming[] trimmings, ShadeAxis[] shadeAxes, boolean withScroll) {
        final ZoneContent<P, A> zc0 = contents.length > 0 ? contents[0] : null;
        Supplier<Captioner> capSupplier = zc0 == null ? () -> null : new Supplier<Captioner>(){
            private Captioner captioner_;

            @Override
            public Captioner get() {
                if (this.captioner_ == null) {
                    this.captioner_ = surfFact.createSurface(gangExtBox, zc0.getProfile(), zc0.getAspect()).getCaptioner();
                }
                return this.captioner_;
            }
        };
        Surround decSurround = Surround.fromInsets(new Insets(0, 0, 0, 0));
        for (int iz = 0; iz < this.nz_; ++iz) {
            Surround surround = PlotPlacement.calculateApproxDecorationSurround(gangExtBox, trimmings[iz], shadeAxes[iz], capSupplier);
            decSurround = decSurround.union(surround);
        }
        Rectangle decBox = PlotUtil.subtractInsets(gangExtBox, decSurround.toInsets());
        Surround axisSurround = this.calculateAxisSurround(decBox, surfFact, contents, withScroll);
        Surround gangSurround = decSurround.union(axisSurround);
        Insets gangInsets = Padding.padInsets(this.padding_, gangSurround.toInsets());
        return this.createGang(PlotUtil.subtractInsets(gangExtBox, gangInsets));
    }

    @Override
    public Gang createApproxGang(Rectangle extBounds) {
        int h = extBounds.height / this.nz_;
        Rectangle[] boxes = new Rectangle[this.nz_];
        for (int iz = 0; iz < this.nz_; ++iz) {
            boxes[iz] = new Rectangle(extBounds.x, extBounds.y + h * (this.isUp_ ? this.nz_ - 1 - iz : iz), extBounds.width, h);
        }
        return new StackGang(boxes);
    }

    @Override
    public A[] adjustAspects(A[] aspects, int index) {
        double[] xlimits;
        if (index >= 0) {
            xlimits = this.getXLimits(aspects[index]);
        } else {
            double[] dArray;
            double min = Double.POSITIVE_INFINITY;
            double max = Double.NEGATIVE_INFINITY;
            for (A aspect : aspects) {
                double[] lims = this.getXLimits(aspect);
                min = Math.min(min, lims[0]);
                max = Math.max(max, lims[1]);
            }
            if (min < max) {
                double[] dArray2 = new double[2];
                dArray2[0] = min;
                dArray = dArray2;
                dArray2[1] = max;
            } else {
                dArray = xlimits = null;
            }
        }
        if (xlimits != null) {
            Object[] newAspects = (Object[])aspects.clone();
            for (int iz = 0; iz < aspects.length; ++iz) {
                newAspects[iz] = this.fixXLimits(aspects[iz], xlimits[0], xlimits[1]);
            }
            return newAspects;
        }
        return aspects;
    }

    @Override
    public P[] adjustProfiles(P[] profiles) {
        return profiles;
    }

    private StackGang createGang(Rectangle gangInBox) {
        int zh = (gangInBox.height + this.zoneGap_) / this.nz_;
        int cw = gangInBox.width;
        int xoff = gangInBox.x;
        int yoff = gangInBox.y;
        Rectangle[] boxes = new Rectangle[this.nz_];
        for (int iz = 0; iz < this.nz_; ++iz) {
            int rx = xoff;
            int ry = yoff + (this.isUp_ ? this.nz_ - 1 - iz : iz) * zh;
            int rw = cw;
            int rh = zh - this.zoneGap_;
            boxes[iz] = new Rectangle(rx, ry, rw, rh);
        }
        return new StackGang(boxes);
    }

    private Surround calculateAxisSurround(Rectangle gangExtBox, SurfaceFactory<P, A> surfFact, ZoneContent<P, A>[] zoneContents, boolean withScroll) {
        Surround surround = Surround.fromInsets(new Insets(2, 2, 2, 2));
        int cw0 = gangExtBox.width;
        int ch0 = gangExtBox.height / this.nz_;
        Padding zonePadding = null;
        for (int iz = 0; iz < this.nz_; ++iz) {
            ZoneContent<P, A> content = zoneContents[iz];
            Rectangle zoneExtBox = new Rectangle(0, 0, cw0, ch0);
            Surround zoneSurround = PlotPlacement.createPlacement(zoneExtBox, zonePadding, surfFact, content.getProfile(), content.getAspect(), withScroll, null, null).getSurface().getSurround(withScroll);
            surround = surround.union(zoneSurround);
        }
        return surround;
    }

    private static ConfigKey<Integer> createZoneGapKey() {
        ConfigMeta meta = new ConfigMeta("cellgap", "Cell Gap");
        meta.setShortDescription("Vertical gap between plots");
        meta.setXmlDescription(new String[]{"<p>Gives the number of pixels between individual members", "in the stack of plots.", "</p>"});
        return IntegerConfigKey.createSpinnerKey(meta, 4, 0, 32);
    }

    private static class StackGang
    implements Gang {
        private final Rectangle[] zoneBoxes_;

        StackGang(Rectangle[] zoneBoxes) {
            this.zoneBoxes_ = zoneBoxes;
        }

        @Override
        public int getZoneCount() {
            return this.zoneBoxes_.length;
        }

        @Override
        public Rectangle getZonePlotBounds(int iz) {
            return new Rectangle(this.zoneBoxes_[iz]);
        }

        @Override
        public int getNavigationZoneIndex(Point pos) {
            int y = pos.y;
            int minDist = Integer.MAX_VALUE;
            int izClosest = -1;
            for (int iz = 0; iz < this.zoneBoxes_.length; ++iz) {
                Rectangle box = this.zoneBoxes_[iz];
                int ylo = box.y;
                int yhi = box.y + box.height;
                if (y >= ylo && y < yhi) {
                    return iz;
                }
                int ydist = Math.min(Math.abs(y - ylo), Math.abs(y - yhi));
                if (ydist >= minDist) continue;
                minDist = ydist;
                izClosest = iz;
            }
            return izClosest;
        }
    }
}

