/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import uk.ac.starlink.ttools.func.Times;
import uk.ac.starlink.ttools.plot2.BasicTicker;
import uk.ac.starlink.ttools.plot2.Caption;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.PrefixTicker;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Ticker;
import uk.ac.starlink.ttools.plot2.geom.DateTickLevel;

@Equality
public abstract class TimeFormat {
    private final String name_;
    private final String description_;
    public static final TimeFormat ISO8601;
    public static final TimeFormat DECIMAL_YEAR;
    private static final NumericTimeFormat decimalYear_;
    public static final TimeFormat MJD;
    public static final TimeFormat UNIX_SECONDS;
    private static final TimeZone UTC;
    private static final TimeFormat[] KNOWN_FORMATS;

    protected TimeFormat(String name, String description) {
        this.name_ = name;
        this.description_ = description;
    }

    public abstract String formatTime(double var1, double var3);

    public abstract double parseTime(String var1);

    public abstract Ticker getTicker();

    public String getFormatName() {
        return this.name_;
    }

    public String getFormatDescription() {
        return this.description_;
    }

    public String toString() {
        return this.name_;
    }

    public static TimeFormat[] getKnownFormats() {
        return (TimeFormat[])KNOWN_FORMATS.clone();
    }

    public static double unixSecondsToDecimalYear(double unixSec) {
        double absUnixSec = Math.abs(unixSec);
        if (absUnixSec < 1.0E10 && absUnixSec > 0.1) {
            GregorianCalendar cal = new GregorianCalendar(UTC, Locale.UK);
            cal.setTimeInMillis((long)(unixSec * 1000.0));
            int year = cal.get(1);
            cal.clear();
            cal.set(year, 0, 1);
            long millis0 = cal.getTimeInMillis();
            ((Calendar)cal).add(1, 1);
            long millis1 = cal.getTimeInMillis();
            long millisInYear = millis1 - millis0;
            assert ((double)millisInYear > 3.1527359999999992E10 && (double)millisInYear < 3.1631040000000008E10);
            double milliOfYear = unixSec * 1000.0 - (double)millis0;
            double yearFraction = milliOfYear / (double)millisInYear;
            assert (yearFraction >= 0.0 && yearFraction <= 1.0) : yearFraction;
            return (double)year + yearFraction;
        }
        return 1970.0 + unixSec / 3.15576E7;
    }

    public static double decimalYearToUnixSeconds(double decYear) {
        int year = (int)decYear;
        double yearFraction = decYear - (double)year;
        GregorianCalendar cal = new GregorianCalendar(UTC, Locale.UK);
        cal.clear();
        cal.set(year, 0, 1);
        long millis0 = cal.getTimeInMillis();
        ((Calendar)cal).add(1, 1);
        long millis1 = cal.getTimeInMillis();
        long millisInYear = millis1 - millis0;
        double milliOfYear = yearFraction * (double)millisInYear;
        double unixMillis = (double)millis0 + milliOfYear;
        return unixMillis / 1000.0;
    }

    private static Caption createTimeCaption(String iso8601Text) {
        return Caption.createCaption(iso8601Text, txt -> txt.replaceAll("([:-])", "\\\\text{$1}"));
    }

    static {
        UTC = TimeZone.getTimeZone("UTC");
        TimeFormat[] timeFormatArray = new TimeFormat[4];
        timeFormatArray[0] = ISO8601 = new Iso8601TimeFormat('T', UTC, Locale.UK);
        decimalYear_ = new NumericTimeFormat("Year", "Decimal year"){

            @Override
            public double fromUnixSeconds(double unixSec) {
                return 1.unixSecondsToDecimalYear(unixSec);
            }

            @Override
            public double toUnixSeconds(double value) {
                return 1.decimalYearToUnixSeconds(value);
            }
        };
        DECIMAL_YEAR = decimalYear_;
        timeFormatArray[1] = decimalYear_;
        timeFormatArray[2] = MJD = new NumericTimeFormat("MJD", "Modified Julian Date"){

            @Override
            public double fromUnixSeconds(double unixSec) {
                return Times.decYearToMjd(2.unixSecondsToDecimalYear(unixSec));
            }

            @Override
            public double toUnixSeconds(double value) {
                return 2.decimalYearToUnixSeconds(Times.mjdToDecYear(value));
            }
        };
        timeFormatArray[3] = UNIX_SECONDS = new NumericTimeFormat("Unix", "Seconds since midnight of 1 Jan 1970"){

            @Override
            public double fromUnixSeconds(double unixSec) {
                return unixSec;
            }

            @Override
            public double toUnixSeconds(double value) {
                return value;
            }
        };
        KNOWN_FORMATS = timeFormatArray;
    }

    private static class DateLevelSet {
        final DateTickLevel[] levels_;
        final DateTickLevel secondsLevel_;
        private final long maxTickSeconds_;

        public DateLevelSet(char dateSep) {
            this.levels_ = DateTickLevel.createLevels(dateSep);
            long maxTickSeconds = -1L;
            DateTickLevel secondsLevel = null;
            for (DateTickLevel level : this.levels_) {
                long majorSecs = level.getMajorTickSeconds();
                maxTickSeconds = Math.max(majorSecs, maxTickSeconds);
                if (majorSecs != 1L) continue;
                secondsLevel = level;
            }
            assert (secondsLevel != null);
            assert (maxTickSeconds > 0L);
            this.maxTickSeconds_ = maxTickSeconds;
            this.secondsLevel_ = secondsLevel;
        }

        public int getLevelIndex(double secPrecision) {
            if (secPrecision > (double)this.maxTickSeconds_) {
                return -1;
            }
            for (int i = 0; i < this.levels_.length; ++i) {
                DateTickLevel level = this.levels_[i];
                if (!(secPrecision >= (double)level.getMajorTickSeconds())) continue;
                return i;
            }
            return this.levels_.length;
        }

        public DateTickLevel getLevel(double secPrecision) {
            int ilevel = Math.min(Math.max(this.getLevelIndex(secPrecision), 0), this.levels_.length - 1);
            return this.levels_[ilevel];
        }
    }

    private static abstract class PrefixRuleAdapter
    implements PrefixTicker.Rule {
        private final BasicTicker.Rule basicRule_;

        public PrefixRuleAdapter(BasicTicker.Rule basicRule) {
            this.basicRule_ = basicRule;
        }

        @Override
        public long floorIndex(double value) {
            return this.basicRule_.floorIndex(value);
        }

        @Override
        public double[] getMinors(long index) {
            return this.basicRule_.getMinors(index);
        }

        @Override
        public double indexToValue(long index) {
            return this.basicRule_.indexToValue(index);
        }

        @Override
        public Caption indexToLabel(long index) {
            return this.basicRule_.indexToLabel(index);
        }
    }

    private static class DateRule
    implements PrefixTicker.Rule {
        private final DateTickLevel level_;
        private final TimeZone tz_;
        private final Locale locale_;
        private final DateFormat prefixFormat_;
        private final DateFormat suffixFormat_;
        private final GregorianCalendar calendar_;

        public DateRule(DateTickLevel level, TimeZone tz, Locale locale) {
            this.level_ = level;
            this.tz_ = tz;
            this.locale_ = locale;
            GregorianCalendar cal = new GregorianCalendar(tz, locale);
            this.prefixFormat_ = new SimpleDateFormat(level.getPrefixPattern());
            this.prefixFormat_.setTimeZone(tz);
            this.prefixFormat_.setCalendar(cal);
            this.suffixFormat_ = new SimpleDateFormat(level.getSuffixPattern());
            this.suffixFormat_.setTimeZone(tz);
            this.suffixFormat_.setCalendar(cal);
            this.calendar_ = new GregorianCalendar(tz, locale);
            this.calendar_.clear();
        }

        @Override
        public Caption indexToLabel(long index) {
            return TimeFormat.createTimeCaption(this.formatUnixSeconds(this.indexToValue(index), true, true));
        }

        @Override
        public Caption indexToSuffix(long index) {
            return TimeFormat.createTimeCaption(this.formatUnixSeconds(this.indexToValue(index), false, true));
        }

        @Override
        public Caption indexToPrefix(long index) {
            return TimeFormat.createTimeCaption(this.formatUnixSeconds(this.indexToValue(index), true, false));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long floorIndex(double value) {
            long index;
            double unixSec = value;
            long lsec = (long)Math.floor(unixSec);
            GregorianCalendar gregorianCalendar = this.calendar_;
            synchronized (gregorianCalendar) {
                this.calendar_.clear();
                this.calendar_.setTimeInMillis(lsec * 1000L);
                index = this.level_.calendarFloorIndex(this.calendar_);
            }
            return index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double indexToValue(long index) {
            long unixMillis;
            GregorianCalendar gregorianCalendar = this.calendar_;
            synchronized (gregorianCalendar) {
                this.level_.setCalendarToIndex(index, this.calendar_);
                unixMillis = this.calendar_.getTimeInMillis();
            }
            return (double)unixMillis * 0.001;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public double[] getMinors(long index) {
            long[] offs;
            double baseUnixSec;
            GregorianCalendar gregorianCalendar = this.calendar_;
            synchronized (gregorianCalendar) {
                this.level_.setCalendarToIndex(index, this.calendar_);
                baseUnixSec = (double)this.calendar_.getTimeInMillis() * 0.001;
                offs = this.level_.getMinorSecondOffsets(this.calendar_);
            }
            int nm = offs.length;
            double[] minors = new double[nm];
            for (int im = 0; im < nm; ++im) {
                minors[im] = baseUnixSec + (double)offs[im];
            }
            return minors;
        }

        synchronized String formatUnixSeconds(double unixSec, boolean prefix, boolean suffix) {
            long lunixSec = (long)Math.floor(unixSec);
            Date date = new Date(lunixSec * 1000L);
            StringBuffer sbuf = new StringBuffer();
            if (prefix) {
                sbuf.append(this.prefixFormat_.format(date));
            }
            if (suffix) {
                sbuf.append(this.suffixFormat_.format(date));
            }
            return sbuf.toString();
        }
    }

    private static class Iso8601Ticker
    extends PrefixTicker {
        private final DateLevelSet levelSet_;
        private final TimeZone tz_;
        private final Locale locale_;

        Iso8601Ticker(DateLevelSet levelSet, TimeZone tz, Locale locale) {
            super(Scale.LINEAR);
            this.levelSet_ = levelSet;
            this.tz_ = tz;
            this.locale_ = locale;
        }

        @Override
        public PrefixTicker.Rule createRule(double dlo, double dhi, double approxMajorCount, int adjust) {
            double secGap = (dhi - dlo) / approxMajorCount;
            int ilevel = this.levelSet_.getLevelIndex(secGap);
            if (ilevel < 0) {
                final BasicTicker.Rule yearRule = decimalYear_.ticker_.createRule(dlo, dhi, approxMajorCount, adjust);
                return new PrefixRuleAdapter(yearRule){

                    @Override
                    public Caption indexToPrefix(long index) {
                        return null;
                    }

                    @Override
                    public Caption indexToSuffix(long index) {
                        return TimeFormat.createTimeCaption(yearRule.indexToLabel(index).toText());
                    }
                };
            }
            if (ilevel < this.levelSet_.levels_.length) {
                ilevel = Math.max(0, Math.min(this.levelSet_.levels_.length - 1, ilevel + adjust));
                return new DateRule(this.levelSet_.levels_[ilevel], this.tz_, this.locale_);
            }
            final BasicTicker.Rule secondRule = BasicTicker.LINEAR.createRule(dlo, dhi, approxMajorCount, adjust);
            final DateRule secondDateRule = new DateRule(this.levelSet_.secondsLevel_, this.tz_, this.locale_);
            final double secPerIndex = secondRule.indexToValue(1L) - secondRule.indexToValue(0L);
            final long indexPerSec = Math.round(1.0 / secPerIndex);
            return new PrefixRuleAdapter(secondRule){

                @Override
                public Caption indexToSuffix(long index) {
                    long minFloorIndex = this.getMinuteFloorIndex(index);
                    int addSecIndex = (int)(index - minFloorIndex);
                    String txt = secondRule.indexToLabel(addSecIndex).toText();
                    double labelValue = Double.parseDouble(txt);
                    assert (labelValue >= 0.0 && labelValue < 60.0) : txt;
                    if (labelValue >= 0.0 && labelValue < 10.0) {
                        txt = "0" + txt;
                    }
                    return TimeFormat.createTimeCaption(txt);
                }

                @Override
                public Caption indexToPrefix(long index) {
                    double minFloorSec = (double)this.getMinuteFloorIndex(index) * secPerIndex;
                    String txt = secondDateRule.formatUnixSeconds(minFloorSec, true, false);
                    return TimeFormat.createTimeCaption(txt);
                }

                private long getMinuteFloorIndex(long index) {
                    long indexPerMin = 60L * indexPerSec;
                    long whole = index / indexPerMin;
                    long part = index % indexPerMin;
                    if (part < 0L) {
                        part += indexPerMin;
                        --whole;
                    }
                    return whole * indexPerMin;
                }
            };
        }
    }

    private static class Iso8601TimeFormat
    extends TimeFormat {
        private final DateLevelSet levelSet_;
        private final Ticker ticker_;
        private final TimeZone tz_;
        private final Locale locale_;

        Iso8601TimeFormat(char dateSep, TimeZone tz, Locale locale) {
            super("ISO-8601", "ISO 8601 date, of the form yyyy-mm-dd" + dateSep + "hh:mm:ss.s");
            this.levelSet_ = new DateLevelSet(dateSep);
            this.ticker_ = new Iso8601Ticker(this.levelSet_, tz, locale);
            this.tz_ = tz;
            this.locale_ = locale;
        }

        @Override
        public String formatTime(double unixSec, double secPrec) {
            DateTickLevel level = this.levelSet_.getLevel(secPrec);
            String txt = new DateRule(level, this.tz_, this.locale_).formatUnixSeconds(unixSec, true, true);
            if (secPrec <= 0.1) {
                int nSecDp = (int)Math.round(Math.max(0.0, -Math.log10(secPrec)));
                long scale = Math.round(Math.pow(10.0, nSecDp));
                double fracSec = unixSec - Math.floor(unixSec);
                assert (fracSec >= 0.0 && fracSec < 1.0);
                long digits1 = Math.round((double)scale * (1.0 + fracSec));
                String digits = Long.toString(digits1).substring(1);
                return new StringBuffer().append(txt).append('.').append(digits).toString();
            }
            return txt;
        }

        @Override
        public double parseTime(String timeStr) {
            double mjd;
            try {
                mjd = Times.isoToMjd(timeStr);
            }
            catch (NumberFormatException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw (NumberFormatException)new NumberFormatException().initCause(e);
            }
            return (double)Times.mjdToUnixMillis(mjd) * 0.001;
        }

        @Override
        public Ticker getTicker() {
            return this.ticker_;
        }
    }

    private static abstract class NumericTimeFormat
    extends TimeFormat {
        private final BasicTicker ticker_ = new BasicTicker(Scale.LINEAR){

            @Override
            public BasicTicker.Rule createRule(double dlo, double dhi, double approxMajorCount, int adjust) {
                final BasicTicker.Rule rule = LINEAR.createRule(this.fromUnixSeconds(dlo), this.fromUnixSeconds(dhi), approxMajorCount, adjust);
                return new BasicTicker.Rule(){

                    @Override
                    public long floorIndex(double value) {
                        return rule.floorIndex(this.fromUnixSeconds(value));
                    }

                    @Override
                    public double[] getMinors(long index) {
                        double[] minors = rule.getMinors(index);
                        for (int i = 0; i < minors.length; ++i) {
                            minors[i] = this.toUnixSeconds(minors[i]);
                        }
                        return minors;
                    }

                    @Override
                    public double indexToValue(long index) {
                        return this.toUnixSeconds(rule.indexToValue(index));
                    }

                    @Override
                    public Caption indexToLabel(long index) {
                        return rule.indexToLabel(index);
                    }
                };
            }
        };

        protected NumericTimeFormat(String name, String description) {
            super(name, description);
        }

        public abstract double fromUnixSeconds(double var1);

        public abstract double toUnixSeconds(double var1);

        @Override
        public String formatTime(double unixSec, double secPrecision) {
            double val = this.fromUnixSeconds(unixSec);
            double prec = this.fromUnixSeconds(unixSec + secPrecision) - val;
            int ndp = (int)Math.round(Math.max(0.0, -Math.log10(prec)));
            double aval = Math.abs(val);
            int nsf = Math.max(0, (int)Math.round(-Math.log10(prec / aval)));
            if (ndp <= -3) {
                return PlotUtil.formatNumber(val, "0.#0", nsf - 1);
            }
            if (ndp <= 0) {
                return Long.toString(Math.round(val));
            }
            return PlotUtil.formatNumber(val, "0.0", ndp);
        }

        @Override
        public double parseTime(String timeStr) {
            return this.toUnixSeconds(Double.parseDouble(timeStr));
        }

        @Override
        public Ticker getTicker() {
            return this.ticker_;
        }
    }
}

