/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import uk.ac.starlink.ttools.plot2.GangContext;
import uk.ac.starlink.ttools.plot2.Ganger;
import uk.ac.starlink.ttools.plot2.GangerFactory;
import uk.ac.starlink.ttools.plot2.Padding;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.geom.SideFlags;
import uk.ac.starlink.ttools.plot2.geom.StackGanger;
import uk.ac.starlink.ttools.plot2.geom.TimeAspect;
import uk.ac.starlink.ttools.plot2.geom.TimeSurfaceFactory;

public class TimeStackGanger
extends StackGanger<TimeSurfaceFactory.Profile, TimeAspect> {
    private static final boolean UP = false;
    public static final GangerFactory<TimeSurfaceFactory.Profile, TimeAspect> FACTORY = new GangerFactory<TimeSurfaceFactory.Profile, TimeAspect>(){

        @Override
        public boolean hasIndependentZones() {
            return true;
        }

        @Override
        public ConfigKey<?>[] getGangerKeys() {
            return new ConfigKey[]{StackGanger.ZONEGAP_KEY};
        }

        @Override
        public Ganger<TimeSurfaceFactory.Profile, TimeAspect> createGanger(Padding padding, ConfigMap config, GangContext context) {
            int zoneGap = config.get(StackGanger.ZONEGAP_KEY);
            return new TimeStackGanger(context.getRequestedZoneNames(), padding, zoneGap);
        }
    };

    public TimeStackGanger(String[] zoneNames, Padding padding, int zoneGap) {
        super(zoneNames, false, padding, zoneGap);
    }

    @Override
    public boolean isTrimmingGlobal() {
        return false;
    }

    @Override
    public boolean isShadingGlobal() {
        return false;
    }

    @Override
    public double[] getXLimits(TimeAspect aspect) {
        return new double[]{aspect.getTMin(), aspect.getTMax()};
    }

    @Override
    public TimeAspect fixXLimits(TimeAspect aspect, double xmin, double xmax) {
        return new TimeAspect(new double[]{xmin, xmax}, new double[]{aspect.getYMin(), aspect.getYMax()});
    }

    public TimeSurfaceFactory.Profile[] adjustProfiles(TimeSurfaceFactory.Profile[] profiles) {
        profiles = (TimeSurfaceFactory.Profile[])profiles.clone();
        for (int i = 0; i < profiles.length; ++i) {
            boolean left = true;
            boolean right = true;
            boolean top = i == 0;
            boolean bottom = i == profiles.length - 1;
            SideFlags annotateFlags = new SideFlags(bottom, left, top, right);
            profiles[i] = profiles[i].fixAnnotation(annotateFlags);
        }
        return profiles;
    }
}

