/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Supplier;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.BasicTicker;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.CoordSequence;
import uk.ac.starlink.ttools.plot2.Orientation;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.Surround;
import uk.ac.starlink.ttools.plot2.Tick;
import uk.ac.starlink.ttools.plot2.TickRun;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.geom.AxisAnnotation;
import uk.ac.starlink.ttools.plot2.geom.OrientationPolicy;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.geom.PlaneAxisAnnotation;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurface;
import uk.ac.starlink.ttools.plot2.geom.SideFlags;
import uk.ac.starlink.ttools.plot2.geom.SlaveTicker;
import uk.ac.starlink.ttools.plot2.geom.TimeAspect;
import uk.ac.starlink.ttools.plot2.geom.TimeFormat;
import uk.ac.starlink.ttools.plot2.geom.TimeSurfaceFactory;

public class TimeSurface
implements Surface,
PlanarSurface {
    private final int gxlo_;
    private final int gxhi_;
    private final int gylo_;
    private final int gyhi_;
    private final double dtlo_;
    private final double dthi_;
    private final double dylo_;
    private final double dyhi_;
    private final Scale yscale_;
    private final boolean yflip_;
    private final Tick[] tticks_;
    private final Tick[] yticks_;
    private final Orientation torient_;
    private final Orientation yorient_;
    private final String tlabel_;
    private final String ylabel_;
    private final Tick[] t2ticks_;
    private final Tick[] y2ticks_;
    private final Orientation t2orient_;
    private final Orientation y2orient_;
    private final String t2label_;
    private final String y2label_;
    private final Captioner captioner_;
    private final Color gridcolor_;
    private final TimeFormat tformat_;
    private final SideFlags annotateflags_;
    private final Axis tAxis_;
    private final Axis yAxis_;
    private static final boolean INVERT_Y = true;

    public TimeSurface(int gxlo, int gxhi, int gylo, int gyhi, double dtlo, double dthi, double dylo, double dyhi, Scale yscale, boolean yflip, Tick[] tticks, Tick[] yticks, Orientation torient, Orientation yorient, String tlabel, String ylabel, Tick[] t2ticks, Tick[] y2ticks, Orientation t2orient, Orientation y2orient, String t2label, String y2label, Captioner captioner, Color gridcolor, TimeFormat tformat, SideFlags annotateflags) {
        this.gxlo_ = gxlo;
        this.gxhi_ = gxhi;
        this.gylo_ = gylo;
        this.gyhi_ = gyhi;
        this.dtlo_ = dtlo;
        this.dthi_ = dthi;
        this.dylo_ = dylo;
        this.dyhi_ = dyhi;
        this.yscale_ = yscale;
        this.yflip_ = yflip;
        this.tticks_ = tticks;
        this.yticks_ = yticks;
        this.torient_ = torient;
        this.yorient_ = yorient;
        this.tlabel_ = tlabel;
        this.ylabel_ = ylabel;
        this.t2ticks_ = t2ticks;
        this.y2ticks_ = y2ticks;
        this.t2orient_ = t2orient;
        this.y2orient_ = y2orient;
        this.t2label_ = t2label;
        this.y2label_ = y2label;
        this.captioner_ = captioner;
        this.gridcolor_ = gridcolor;
        this.tformat_ = tformat;
        this.annotateflags_ = annotateflags;
        this.tAxis_ = new Axis(this.gxlo_, this.gxhi_, this.dtlo_, this.dthi_, Scale.TIME, false);
        this.yAxis_ = new Axis(this.gylo_, this.gyhi_, this.dylo_, this.dyhi_, this.yscale_, this.yflip_ ^ true);
        assert (this.equals(this));
    }

    @Override
    public Rectangle getPlotBounds() {
        return new Rectangle(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
    }

    @Override
    public Surround getSurround(boolean withScroll) {
        return this.createAxisAnnotation().getSurround(withScroll);
    }

    @Override
    public int getDataDimCount() {
        return 2;
    }

    @Override
    public boolean dataToGraphics(double[] dpos, boolean visibleOnly, Point2D.Double gp) {
        double gx = this.tAxis_.dataToGraphics(dpos[0]);
        double gy = this.yAxis_.dataToGraphics(dpos[1]);
        if (!visibleOnly || gx >= (double)this.gxlo_ && gx < (double)this.gxhi_ && gy >= (double)this.gylo_ && gy < (double)this.gyhi_) {
            gp.x = gx;
            gp.y = gy;
            return true;
        }
        return false;
    }

    @Override
    public boolean dataToGraphicsOffset(double[] dpos0, Point2D.Double gpos0, double[] dpos1, boolean visibleOnly, Point2D.Double gpos1) {
        return this.dataToGraphics(dpos1, visibleOnly, gpos1);
    }

    @Override
    public double[] graphicsToData(Point2D gp, Supplier<CoordSequence> dposSupplier) {
        return new double[]{this.tAxis_.graphicsToData(gp.getX()), this.yAxis_.graphicsToData(gp.getY())};
    }

    @Override
    public boolean isContinuousLine(double[] dpos0, double[] dpos1) {
        return true;
    }

    @Override
    public String formatPosition(double[] dpos) {
        double timePixelSize = (this.dthi_ - this.dtlo_) / (double)(this.gxhi_ - this.gxlo_);
        return this.tformat_.formatTime(dpos[0], timePixelSize) + ", " + PlaneSurface.formatPosition(this.yAxis_, dpos[1]);
    }

    @Override
    public void paintBackground(Graphics g) {
        Color color0 = g.getColor();
        g.setColor(Color.WHITE);
        g.fillRect(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
        g.setColor(color0);
    }

    @Override
    public void paintForeground(Graphics g) {
        Color color0 = g.getColor();
        if (this.gridcolor_ != null) {
            Graphics gGrid = PlotUtil.createLineGraphics(g, this.gridcolor_);
            for (Tick tick : this.tticks_) {
                if (tick.getLabel() == null) continue;
                int gx = (int)this.tAxis_.dataToGraphics(tick.getValue());
                gGrid.drawLine(gx, this.gylo_, gx, this.gyhi_);
            }
            for (Tick tick : this.yticks_) {
                if (tick.getLabel() == null) continue;
                int gy = (int)this.yAxis_.dataToGraphics(tick.getValue());
                gGrid.drawLine(this.gxlo_, gy, this.gxhi_, gy);
            }
        }
        g.setColor(Color.BLACK);
        this.createAxisAnnotation().drawLabels(g);
        g.drawRect(this.gxlo_, this.gylo_, this.gxhi_ - this.gxlo_, this.gyhi_ - this.gylo_);
        g.setColor(color0);
    }

    @Override
    public Captioner getCaptioner() {
        return this.captioner_;
    }

    @Override
    public Scale[] getScales() {
        return new Scale[]{Scale.TIME, this.yscale_};
    }

    @Override
    public boolean[] getFlipFlags() {
        return new boolean[]{false, this.yflip_};
    }

    @Override
    public boolean[] getTimeFlags() {
        return new boolean[]{true, false};
    }

    @Override
    public double[][] getDataLimits() {
        return new double[][]{{this.dtlo_, this.dthi_}, {this.dylo_, this.dyhi_}};
    }

    @Override
    public Axis[] getAxes() {
        return new Axis[]{this.tAxis_, this.yAxis_};
    }

    ConfigMap getAspectConfig() {
        ConfigMap config = new ConfigMap();
        double timeEpsilon = 0.1 * (this.dthi_ - this.dtlo_) / (double)(this.gxhi_ - this.gxlo_);
        TimeFormat tfmt = this.dthi_ - this.dtlo_ > 3.1536E7 ? TimeFormat.DECIMAL_YEAR : TimeFormat.ISO8601;
        config.put(TimeSurfaceFactory.TMIN_KEY, TimeSurface.roundTime(this.dtlo_, tfmt, timeEpsilon));
        config.put(TimeSurfaceFactory.TMAX_KEY, TimeSurface.roundTime(this.dthi_, tfmt, timeEpsilon));
        config.putAll(PlotUtil.configLimits(TimeSurfaceFactory.YMIN_KEY, TimeSurfaceFactory.YMAX_KEY, this.dylo_, this.dyhi_, this.gyhi_ - this.gylo_));
        return config;
    }

    TimeAspect zoom(Point2D pos, double tZoom, double yZoom) {
        return new TimeAspect(this.tAxis_.dataZoom(this.tAxis_.graphicsToData(pos.getX()), tZoom), this.yAxis_.dataZoom(this.yAxis_.graphicsToData(pos.getY()), yZoom));
    }

    TimeAspect pan(Point2D pos0, Point2D pos1, boolean tFlag, boolean yFlag) {
        if (tFlag || yFlag) {
            double[] dArray;
            double[] dArray2;
            if (tFlag) {
                dArray2 = this.tAxis_.dataPan(this.tAxis_.graphicsToData(pos0.getX()), this.tAxis_.graphicsToData(pos1.getX()));
            } else {
                double[] dArray3 = new double[2];
                dArray3[0] = this.dtlo_;
                dArray2 = dArray3;
                dArray3[1] = this.dthi_;
            }
            if (yFlag) {
                dArray = this.yAxis_.dataPan(this.yAxis_.graphicsToData(pos0.getY()), this.yAxis_.graphicsToData(pos1.getY()));
            } else {
                double[] dArray4 = new double[2];
                dArray4[0] = this.dylo_;
                dArray = dArray4;
                dArray4[1] = this.dyhi_;
            }
            return new TimeAspect(dArray2, dArray);
        }
        return null;
    }

    TimeAspect center(double[] dpos, boolean tFlag, boolean yFlag) {
        Point2D.Double gp = new Point2D.Double();
        return this.dataToGraphics(dpos, false, gp) && PlotUtil.isPointFinite(gp) ? this.pan(gp, new Point2D.Double((double)(this.gxlo_ + this.gxhi_) * 0.5, (double)(this.gylo_ + this.gyhi_) * 0.5), tFlag, yFlag) : null;
    }

    TimeAspect reframe(Rectangle frame) {
        Point gp1 = new Point(frame.x, frame.y);
        Point gp2 = new Point(frame.x + frame.width, frame.y + frame.height);
        double[] dpos1 = this.graphicsToData(gp1, null);
        double[] dpos2 = this.graphicsToData(gp2, null);
        return new TimeAspect(PlotUtil.orderPair(dpos1[0], dpos2[0]), PlotUtil.orderPair(dpos1[1], dpos2[1]));
    }

    private AxisAnnotation createAxisAnnotation() {
        return new PlaneAxisAnnotation(this.gxlo_, this.gxhi_, this.gylo_, this.gyhi_, this.tAxis_, this.yAxis_, this.tticks_, this.yticks_, this.torient_, this.yorient_, this.tlabel_, this.ylabel_, this.t2ticks_, this.y2ticks_, this.t2orient_, this.y2orient_, this.t2label_, this.y2label_, this.captioner_, this.annotateflags_);
    }

    public int hashCode() {
        int code = 943;
        code = 23 * code + this.gxlo_;
        code = 23 * code + this.gxhi_;
        code = 23 * code + this.gylo_;
        code = 23 * code + this.gyhi_;
        code = 23 * code + Float.floatToIntBits((float)this.dtlo_);
        code = 23 * code + Float.floatToIntBits((float)this.dthi_);
        code = 23 * code + Float.floatToIntBits((float)this.dylo_);
        code = 23 * code + Float.floatToIntBits((float)this.dyhi_);
        code = 23 * code + this.yscale_.hashCode();
        code = 23 * code + (this.yflip_ ? 5 : 7);
        code = 23 * code + Arrays.hashCode(this.tticks_);
        code = 23 * code + Arrays.hashCode(this.yticks_);
        code = 23 * code + PlotUtil.hashCode(this.torient_);
        code = 23 * code + PlotUtil.hashCode(this.yorient_);
        code = 23 * code + PlotUtil.hashCode(this.tlabel_);
        code = 23 * code + PlotUtil.hashCode(this.ylabel_);
        code = 23 * code + Arrays.hashCode(this.t2ticks_);
        code = 23 * code + Arrays.hashCode(this.y2ticks_);
        code = 23 * code + PlotUtil.hashCode(this.t2orient_);
        code = 23 * code + PlotUtil.hashCode(this.y2orient_);
        code = 23 * code + PlotUtil.hashCode(this.t2label_);
        code = 23 * code + PlotUtil.hashCode(this.y2label_);
        code = 23 * code + this.captioner_.hashCode();
        code = 23 * code + PlotUtil.hashCode(this.gridcolor_);
        code = 23 * code + this.tformat_.hashCode();
        code = 23 * code + this.annotateflags_.hashCode();
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof TimeSurface) {
            TimeSurface other = (TimeSurface)o;
            return this.gxlo_ == other.gxlo_ && this.gxhi_ == other.gxhi_ && this.gylo_ == other.gylo_ && this.gyhi_ == other.gyhi_ && this.dtlo_ == other.dtlo_ && this.dthi_ == other.dthi_ && this.dylo_ == other.dylo_ && this.dyhi_ == other.dyhi_ && this.yscale_.equals(other.yscale_) && this.yflip_ == other.yflip_ && Arrays.equals(this.tticks_, other.tticks_) && Arrays.equals(this.yticks_, other.yticks_) && PlotUtil.equals(this.torient_, other.torient_) && PlotUtil.equals(this.yorient_, other.yorient_) && PlotUtil.equals(this.tlabel_, this.tlabel_) && PlotUtil.equals(this.ylabel_, other.ylabel_) && Arrays.equals(this.t2ticks_, other.t2ticks_) && Arrays.equals(this.y2ticks_, other.y2ticks_) && PlotUtil.equals(this.t2orient_, other.t2orient_) && PlotUtil.equals(this.y2orient_, other.y2orient_) && PlotUtil.equals(this.t2label_, other.t2label_) && PlotUtil.equals(this.y2label_, other.y2label_) && this.captioner_.equals(other.captioner_) && PlotUtil.equals(this.gridcolor_, other.gridcolor_) && this.tformat_.equals(other.tformat_) && this.annotateflags_.equals(other.annotateflags_);
        }
        return false;
    }

    private static double roundTime(double tval, TimeFormat tfmt, double tepsilon) {
        try {
            return tfmt.parseTime(tfmt.formatTime(tval, tepsilon));
        }
        catch (RuntimeException e) {
            return tval;
        }
    }

    public static TimeSurface createSurface(Rectangle plotBounds, TimeAspect aspect, Scale yscale, boolean yflip, String tlabel, String ylabel, DoubleUnaryOperator t2func, DoubleUnaryOperator y2func, String t2label, String y2label, Captioner captioner, Color gridcolor, TimeFormat tformat, double tcrowd, double ycrowd, OrientationPolicy orientpolicy, boolean minor, boolean shadow, SideFlags annotateflags) {
        TickRun t2tickRun;
        int gxlo = plotBounds.x;
        int gxhi = plotBounds.x + plotBounds.width;
        int gylo = plotBounds.y;
        int gyhi = plotBounds.y + plotBounds.height;
        double dtlo = aspect.getTMin();
        double dthi = aspect.getTMax();
        double dylo = aspect.getYMin();
        double dyhi = aspect.getYMax();
        TickRun ttickRun = tformat.getTicker().getTicks(aspect.getTMin(), aspect.getTMax(), minor, captioner, orientpolicy.getOrientationsX(), plotBounds.width, tcrowd);
        TickRun ytickRun = yscale.getTicker().getTicks(dylo, dyhi, minor, captioner, orientpolicy.getOrientationsY(), plotBounds.height, ycrowd);
        Tick[] tticks = ttickRun.getTicks();
        Tick[] yticks = ytickRun.getTicks();
        Orientation torient = ttickRun.getOrientation();
        Orientation yorient = ytickRun.getOrientation();
        Axis tAxis = new Axis(gxlo, gxhi, dtlo, dthi, Scale.TIME, false);
        Axis yAxis = new Axis(gylo, gyhi, dylo, dyhi, yscale, yflip ^ true);
        TickRun tickRun = t2func == null ? (shadow ? new TickRun(PlotUtil.getShadowTicks(tticks), Orientation.ANTI_X) : null) : (t2tickRun = new SlaveTicker(tAxis, t2func, BasicTicker.LINEAR).getTicks(aspect.getTMin(), aspect.getTMax(), minor, captioner, orientpolicy.getOrientationsX2(), plotBounds.width, tcrowd));
        TickRun y2tickRun = y2func == null ? (shadow ? new TickRun(PlotUtil.getShadowTicks(yticks), Orientation.ANTI_Y) : null) : SlaveTicker.createTicker(yAxis, y2func).getTicks(dylo, dyhi, minor, captioner, orientpolicy.getOrientationsY2(), plotBounds.height, ycrowd);
        Tick[] t2ticks = t2tickRun == null ? null : t2tickRun.getTicks();
        Tick[] y2ticks = y2tickRun == null ? null : y2tickRun.getTicks();
        Orientation t2orient = t2tickRun == null ? null : t2tickRun.getOrientation();
        Orientation y2orient = y2tickRun == null ? null : y2tickRun.getOrientation();
        return new TimeSurface(gxlo, gxhi, gylo, gyhi, dtlo, dthi, dylo, dyhi, yscale, yflip, tticks, yticks, torient, yorient, tlabel, ylabel, t2ticks, y2ticks, t2orient, y2orient, t2label, y2label, captioner, gridcolor, tformat, annotateflags);
    }
}

