/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import gnu.jel.CompilationException;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.DoubleUnaryOperator;
import java.util.stream.Collectors;
import uk.ac.starlink.ttools.jel.JELFunction;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.Captioner;
import uk.ac.starlink.ttools.plot2.LabelledLine;
import uk.ac.starlink.ttools.plot2.Navigator;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotMetric;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.SurfaceFactory;
import uk.ac.starlink.ttools.plot2.config.BooleanConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigException;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.StringConfigKey;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.config.SubrangeConfigKey;
import uk.ac.starlink.ttools.plot2.config.TextFieldSpecifier;
import uk.ac.starlink.ttools.plot2.config.TimeConfigKey;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.geom.LabelUnit;
import uk.ac.starlink.ttools.plot2.geom.OrientationPolicy;
import uk.ac.starlink.ttools.plot2.geom.PlaneSurfaceFactory;
import uk.ac.starlink.ttools.plot2.geom.SideFlags;
import uk.ac.starlink.ttools.plot2.geom.TimeAspect;
import uk.ac.starlink.ttools.plot2.geom.TimeFormat;
import uk.ac.starlink.ttools.plot2.geom.TimeJELFunction;
import uk.ac.starlink.ttools.plot2.geom.TimeNavigator;
import uk.ac.starlink.ttools.plot2.geom.TimeSurface;

public class TimeSurfaceFactory
implements SurfaceFactory<Profile, TimeAspect> {
    public static final ConfigKey<Double> TMIN_KEY = new TimeConfigKey(new ConfigMeta("tmin", "Time Minimum").setShortDescription("Lower limit on time axis").setXmlDescription(new String[]{"<p>Minimum value of the time coordinate plotted.", "This sets the value before any subranging is applied.", "If not supplied, the value is determined from the plotted", "data.", "</p>", TimeConfigKey.FORMAT_XML}));
    public static final ConfigKey<Double> TMAX_KEY = new TimeConfigKey(new ConfigMeta("tmax", "Time Maximum").setShortDescription("Upper limit on time axis").setXmlDescription(new String[]{"<p>Maximum value of the time coordinate plotted.", "This sets the value before any subranging is applied.", "If not supplied, the value is determined from the plotted", "data.", "</p>", TimeConfigKey.FORMAT_XML}));
    public static final ConfigKey<Subrange> TSUBRANGE_KEY = new SubrangeConfigKey(SubrangeConfigKey.createAxisSubMeta("t", "Time"), new Subrange(), -0.1, 1.1);
    public static final ConfigKey<Double> YMIN_KEY = PlaneSurfaceFactory.YMIN_KEY;
    public static final ConfigKey<Double> YMAX_KEY = PlaneSurfaceFactory.YMAX_KEY;
    public static final ConfigKey<Subrange> YSUBRANGE_KEY = PlaneSurfaceFactory.YSUBRANGE_KEY;
    public static final ConfigKey<Scale> YSCALE_KEY = PlaneSurfaceFactory.YSCALE_KEY;
    public static final ConfigKey<Boolean> YLOG_KEY = PlaneSurfaceFactory.YLOG_KEY;
    public static final ConfigKey<Boolean> YFLIP_KEY = PlaneSurfaceFactory.YFLIP_KEY;
    public static final ConfigKey<String> TLABEL_KEY = new StringConfigKey(new ConfigMeta("tlabel", "Time Label").setStringUsage("<text>").setShortDescription("Label for Time axis").setXmlDescription(new String[]{"<p>Gives a label to be used for annotating the Time axis.", "If not supplied no label will be drawn.", "</p>"}), null);
    public static final ConfigKey<String> YLABEL_KEY = PlaneSurfaceFactory.YLABEL_KEY;
    public static final ConfigKey<TimeJELFunction> T2FUNC_KEY = TimeSurfaceFactory.createSecondaryTimeAxisFunctionKey();
    public static final ConfigKey<JELFunction> Y2FUNC_KEY = PlaneSurfaceFactory.createSecondaryAxisFunctionKey("Y");
    public static final ConfigKey<String> T2LABEL_KEY = PlaneSurfaceFactory.createSecondaryAxisLabelKey("Time");
    public static final ConfigKey<String> Y2LABEL_KEY = PlaneSurfaceFactory.createSecondaryAxisLabelKey("Y");
    public static final ConfigKey<Boolean> GRID_KEY = new BooleanConfigKey(new ConfigMeta("grid", "Draw Grid").setShortDescription("Draw grid lines?").setXmlDescription(new String[]{"<p>If true, grid lines are drawn on the plot", "at positions determined by the major tick marks.", "If false, they are absent.", "</p>"}), false);
    public static final ConfigKey<Double> TCROWD_KEY = PlaneSurfaceFactory.createAxisCrowdKey("Time");
    public static final ConfigKey<Double> YCROWD_KEY = PlaneSurfaceFactory.YCROWD_KEY;
    public static final ConfigKey<OrientationPolicy> ORIENTATIONS_KEY = PlaneSurfaceFactory.ORIENTATIONS_KEY_PLANE;
    public static final ConfigKey<TimeFormat> TFORMAT_KEY = TimeSurfaceFactory.createTimeFormatKey();
    private static final double DFLT_TIME_RANGE_SEC = 6.31152E7;
    private static final PlotMetric plotMetric_ = new TimePlotMetric();

    @Override
    public Surface createSurface(Rectangle plotBounds, Profile profile, TimeAspect aspect) {
        Profile p = profile;
        return TimeSurface.createSurface(plotBounds, aspect, p.yscale_, p.yflip_, p.tlabel_, p.ylabel_, p.t2func_, p.y2func_, p.t2label_, p.y2label_, p.captioner_, p.gridcolor_, p.tformat_, p.tcrowd_, p.ycrowd_, p.orientpolicy_, p.minor_, p.shadow_, p.annotateflags_);
    }

    @Override
    public ConfigKey<?>[] getProfileKeys() {
        ArrayList list = new ArrayList();
        list.addAll(Arrays.asList(YSCALE_KEY, YLOG_KEY, YFLIP_KEY, TLABEL_KEY, YLABEL_KEY, T2FUNC_KEY, Y2FUNC_KEY, T2LABEL_KEY, Y2LABEL_KEY, GRID_KEY, TCROWD_KEY, YCROWD_KEY, ORIENTATIONS_KEY, TFORMAT_KEY, StyleKeys.MINOR_TICKS, StyleKeys.SHADOW_TICKS));
        list.addAll(Arrays.asList(StyleKeys.GRIDCOLOR_KEYSET.getKeys()));
        list.addAll(Arrays.asList(StyleKeys.CAPTIONER.getKeys()));
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public Profile createProfile(ConfigMap config) {
        Scale yscale = PlaneSurfaceFactory.getScale(YSCALE_KEY, YLOG_KEY, config);
        boolean yflip = config.get(YFLIP_KEY);
        String tlabel = config.get(TLABEL_KEY);
        String ylabel = config.get(YLABEL_KEY);
        DoubleUnaryOperator t2func = config.get(T2FUNC_KEY);
        DoubleUnaryOperator y2func = config.get(Y2FUNC_KEY);
        String t2label = config.get(T2LABEL_KEY);
        String y2label = config.get(Y2LABEL_KEY);
        Color gridcolor = config.get(GRID_KEY) != false ? StyleKeys.GRIDCOLOR_KEYSET.createValue(config) : null;
        double tcrowd = config.get(TCROWD_KEY);
        double ycrowd = config.get(YCROWD_KEY);
        OrientationPolicy orientpolicy = config.get(ORIENTATIONS_KEY);
        TimeFormat tformat = config.get(TFORMAT_KEY);
        boolean minor = config.get(StyleKeys.MINOR_TICKS);
        boolean shadow = config.get(StyleKeys.SHADOW_TICKS);
        Captioner captioner = StyleKeys.CAPTIONER.createValue(config);
        SideFlags annotateflags = SideFlags.ALL;
        return new Profile(yscale, yflip, tlabel, ylabel, t2func, y2func, t2label, y2label, captioner, gridcolor, tcrowd, ycrowd, orientpolicy, tformat, minor, shadow, annotateflags);
    }

    @Override
    public ConfigKey<?>[] getAspectKeys() {
        return new ConfigKey[]{TMIN_KEY, TMAX_KEY, TSUBRANGE_KEY, YMIN_KEY, YMAX_KEY, YSUBRANGE_KEY};
    }

    @Override
    public boolean useRanges(Profile profile, ConfigMap config) {
        return TimeSurfaceFactory.createUnrangedAspect(profile, config) == null;
    }

    @Override
    public TimeAspect createAspect(Profile profile, ConfigMap config, Range[] ranges) {
        double thi1;
        double tlo1;
        TimeAspect unrangedAspect = TimeSurfaceFactory.createUnrangedAspect(profile, config);
        if (unrangedAspect != null) {
            return unrangedAspect;
        }
        Range trange = ranges == null ? new Range() : ranges[0];
        trange = new Range(trange);
        trange.limit(config.get(TMIN_KEY), config.get(TMAX_KEY));
        double[] tr0 = trange.getBounds();
        double tlo0 = tr0[0];
        double thi0 = tr0[1];
        double nowUnixSec = (double)System.currentTimeMillis() * 0.001;
        if (tlo0 < thi0) {
            tlo1 = tlo0;
            thi1 = thi0;
        } else if (PlotUtil.isFinite(tlo0) && !PlotUtil.isFinite(thi0)) {
            tlo1 = tlo0;
            thi1 = nowUnixSec > tlo0 ? nowUnixSec : tlo0 + 6.31152E7;
        } else if (!PlotUtil.isFinite(tlo0) && PlotUtil.isFinite(thi0)) {
            tlo1 = nowUnixSec < thi0 ? nowUnixSec : thi0 - 6.31152E7;
            thi1 = thi0;
        } else {
            tlo1 = nowUnixSec - 6.31152E7;
            thi1 = nowUnixSec;
        }
        double[] tlimits = PlotUtil.scaleRange(tlo1, thi1, config.get(TSUBRANGE_KEY), Scale.TIME);
        Range yrange = ranges == null ? new Range() : ranges[1];
        double[] ylimits = PlaneSurfaceFactory.getLimits(config, YMIN_KEY, YMAX_KEY, YSUBRANGE_KEY, profile.yscale_, yrange);
        return new TimeAspect(tlimits, ylimits);
    }

    @Override
    public ConfigMap getAspectConfig(Surface surf) {
        return surf instanceof TimeSurface ? ((TimeSurface)surf).getAspectConfig() : new ConfigMap();
    }

    @Override
    public Range[] readRanges(Profile profile, PlotLayer[] layers, DataStore dataStore) {
        Range[] ranges = new Range[]{new Range(), new Range()};
        Scale[] scales = new Scale[]{Scale.TIME, profile.getYScale()};
        PlotUtil.extendCoordinateRanges(layers, ranges, scales, true, dataStore);
        return ranges;
    }

    @Override
    public ConfigKey<?>[] getNavigatorKeys() {
        return TimeNavigator.getConfigKeys();
    }

    @Override
    public Navigator<TimeAspect> createNavigator(ConfigMap navConfig) {
        return TimeNavigator.createNavigator(navConfig);
    }

    @Override
    public PlotMetric getPlotMetric() {
        return plotMetric_;
    }

    private static TimeAspect createUnrangedAspect(Profile profile, ConfigMap config) {
        double[] tlimits = PlaneSurfaceFactory.getLimits(config, TMIN_KEY, TMAX_KEY, TSUBRANGE_KEY, Scale.LINEAR, null);
        double[] ylimits = PlaneSurfaceFactory.getLimits(config, YMIN_KEY, YMAX_KEY, YSUBRANGE_KEY, profile.yscale_, null);
        return tlimits == null || ylimits == null ? null : new TimeAspect(tlimits, ylimits);
    }

    private static ConfigKey<TimeFormat> createTimeFormatKey() {
        TimeFormat[] formats = TimeFormat.getKnownFormats();
        ConfigMeta meta = new ConfigMeta("tformat", "Time Format");
        meta.setShortDescription("Time display format");
        meta.setXmlDescription(new String[]{"<p>Selects the way in which time values are represented", "when using them to label the time axis.", "</p>"});
        OptionConfigKey<TimeFormat> key = new OptionConfigKey<TimeFormat>(meta, TimeFormat.class, formats){
            private final double unixSec = 1.33161342E9;
            private final double secPrecision = 14400.0;

            @Override
            public String valueToString(TimeFormat format) {
                return format == null ? null : format.getFormatName().toLowerCase();
            }

            @Override
            public String getXmlDescription(TimeFormat format) {
                return format.getFormatDescription() + " (e.g. \"" + format.formatTime(1.33161342E9, 14400.0) + "\")";
            }
        };
        key.setOptionUsage();
        key.addOptionsXml();
        return key;
    }

    private static ConfigKey<TimeJELFunction> createSecondaryTimeAxisFunctionKey() {
        final TimeJELFunction.TimeQuantity[] tqs = TimeJELFunction.getTimeQuantities();
        ConfigMeta meta = new ConfigMeta("t2func", "Secondary Time Axis Value");
        meta.setStringUsage("<time-expr>");
        meta.setShortDescription("Function of time value from primary axis");
        meta.setXmlDescription(new String[]{"<p>Defines a secondary time axis in terms of the primary one.", "If a secondary axis is defined in this way,", "then the axis opposite the primary one,", "i.e. the one on the top edge of the plot,", "will be annotated with the appropriate tickmarks.", "</p>", "<p>The value of this parameter is an", "<ref id='jel'>algebraic expression</ref>", "giving the numeric value to be displayed on the secondary axis", "corresponding to a given time value on the primary axis.", "The expression may be given in terms of one of the following", "variables:", "<ul>", Arrays.stream(tqs).map(tq -> "<li><code>" + tq.getName() + "</code>: " + tq.getDescription() + "</li>\n").collect(Collectors.joining()), "</ul>", "</p>", "<p>In most cases, the value of this parameter will simply be", "one of those variable names, for instance,", "\"<code>mjd</code>\" to annotate the secondary axis", "in Modified Julian Date.", "However you can apply operations to these values in the usual way", "if required, for instance to provide a differently offset", "date scale.", "</p>", "<p>The function supplied should be monotonic", "and reasonably well-behaved,", "otherwise the secondary axis annotation may not work well.", "Tick marks will always be applied on a linear scale.", "Currently there is no way to annotate the secondary axis", "with ISO-8601 dates or other non-numeric labels.", "</p>"});
        return new ConfigKey<TimeJELFunction>(meta, TimeJELFunction.class, null){

            @Override
            public TimeJELFunction stringToValue(String fexpr) throws ConfigException {
                if (fexpr == null || fexpr.trim().length() == 0) {
                    return null;
                }
                try {
                    return new TimeJELFunction(fexpr);
                }
                catch (CompilationException e) {
                    StringBuffer sbuf = new StringBuffer().append("Expresssion \"").append(fexpr).append("\" is not a function of ");
                    int nq = tqs.length;
                    for (int iq = 0; iq < nq; ++iq) {
                        sbuf.append(tqs[iq].getName());
                        if (iq < nq - 1) {
                            sbuf.append(", ");
                        }
                        if (iq != nq - 2) continue;
                        sbuf.append("or ");
                    }
                    sbuf.append(": ").append(e.getMessage());
                    throw new ConfigException(this, sbuf.toString());
                }
            }

            @Override
            public String valueToString(TimeJELFunction func) {
                return func == null ? null : func.getExpression();
            }

            @Override
            public Specifier<TimeJELFunction> createSpecifier() {
                return new TextFieldSpecifier<Object>(this, null);
            }
        };
    }

    public static class Profile {
        private final Scale yscale_;
        private final boolean yflip_;
        private final String tlabel_;
        private final String ylabel_;
        private final DoubleUnaryOperator t2func_;
        private final DoubleUnaryOperator y2func_;
        private final String t2label_;
        private final String y2label_;
        private final Captioner captioner_;
        private final Color gridcolor_;
        private final double tcrowd_;
        private final double ycrowd_;
        private final OrientationPolicy orientpolicy_;
        private final TimeFormat tformat_;
        private final boolean minor_;
        private final boolean shadow_;
        private final SideFlags annotateflags_;

        public Profile(Scale yscale, boolean yflip, String tlabel, String ylabel, DoubleUnaryOperator t2func, DoubleUnaryOperator y2func, String t2label, String y2label, Captioner captioner, Color gridcolor, double tcrowd, double ycrowd, OrientationPolicy orientpolicy, TimeFormat tformat, boolean minor, boolean shadow, SideFlags annotateflags) {
            this.yscale_ = yscale;
            this.yflip_ = yflip;
            this.tlabel_ = tlabel;
            this.ylabel_ = ylabel;
            this.t2func_ = t2func;
            this.y2func_ = y2func;
            this.t2label_ = t2label;
            this.y2label_ = y2label;
            this.captioner_ = captioner;
            this.gridcolor_ = gridcolor;
            this.tcrowd_ = tcrowd;
            this.ycrowd_ = ycrowd;
            this.orientpolicy_ = orientpolicy;
            this.tformat_ = tformat;
            this.minor_ = minor;
            this.shadow_ = shadow;
            this.annotateflags_ = annotateflags;
        }

        public Scale getYScale() {
            return this.yscale_;
        }

        public Profile fixAnnotation(SideFlags annotateflags) {
            return new Profile(this.yscale_, this.yflip_, this.tlabel_, this.ylabel_, this.t2func_, this.y2func_, this.t2label_, this.y2label_, this.captioner_, this.gridcolor_, this.tcrowd_, this.ycrowd_, this.orientpolicy_, this.tformat_, this.minor_, this.shadow_, annotateflags);
        }
    }

    private static class TimePlotMetric
    implements PlotMetric {
        private static final LabelUnit[] SEC_UNITS = new LabelUnit[]{new LabelUnit("\u03bcsec", 1.0E-6), new LabelUnit("millisec", 0.001), new LabelUnit("sec", 1.0), new LabelUnit("min", 60.0), new LabelUnit("hour", 3600.0), new LabelUnit("day", 86400.0), new LabelUnit("year", 3.15576E7)};

        private TimePlotMetric() {
        }

        @Override
        public LabelledLine[] getMeasures(Surface surf, Point2D gp0, Point2D gp1) {
            if (!(surf instanceof TimeSurface)) {
                return new LabelledLine[0];
            }
            Axis[] axes = ((TimeSurface)surf).getAxes();
            Axis tAxis = axes[0];
            Axis yAxis = axes[1];
            double gx0 = gp0.getX();
            double gy0 = gp0.getY();
            double gx1 = gp1.getX();
            double gy1 = gp1.getY();
            double dt0 = tAxis.graphicsToData(gx0);
            double dy0 = yAxis.graphicsToData(gy0);
            double dt1 = tAxis.graphicsToData(gx1);
            double dy1 = yAxis.graphicsToData(gy1);
            double et = Math.max(Math.abs(tAxis.graphicsToData(gx0 + 1.0) - dt0), Math.abs(tAxis.graphicsToData(gx1 + 1.0) - dt1));
            double ey = Math.max(Math.abs(yAxis.graphicsToData(gy0 + 1.0) - dy0), Math.abs(yAxis.graphicsToData(gy1 + 1.0) - dy1));
            double dt01 = Math.abs(dt1 - dt0);
            String tLabel = LabelUnit.formatValue(dt01, et, SEC_UNITS);
            String yLabel = PlotUtil.formatNumber(Math.abs(dy1 - dy0), ey);
            Point2D.Double gp01 = new Point2D.Double(gx1, gy0);
            return new LabelledLine[]{new LabelledLine(gp0, gp01, tLabel), new LabelledLine(gp01, gp1, yLabel)};
        }
    }
}

