/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.geom;

import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.PerUnitConfigKey;
import uk.ac.starlink.ttools.plot2.layer.Unit;

public class TimeUnit
extends Unit {
    public static final TimeUnit MICRO = new TimeUnit("microsec", "microsecond", "us", 1.0E-6, "microsecond (1e-6 seconds)");
    public static final TimeUnit MILLI = new TimeUnit("millisec", "millisecond", "ms", 0.001, "millisecond (1e-3 seconds)");
    public static final TimeUnit SECOND = new TimeUnit("second", "second", "s", 1.0, "second");
    public static final TimeUnit MINUTE = new TimeUnit("minute", "minute", "min", 60.0, "minute (60 seconds)");
    public static final TimeUnit HOUR = new TimeUnit("hour", "hour", "h", 3600.0, "hour (3600 seconds)");
    public static final TimeUnit DAY = new TimeUnit("day", "day", "d", 86400.0, "day (24 * 3600 seconds)");
    public static final TimeUnit WEEK = new TimeUnit("week", "week", "7d", 604800.0, "week (7 days)");
    public static final TimeUnit MONTH = new TimeUnit("month", "month", "30.4375d", 2565000.0, "month (1/12 Julian year, 30.4375 days)");
    public static final TimeUnit QUARTER = new TimeUnit("quarter", "quarter", "0.25a", 7889400.0, "quarter (0.25 Julian year, 91.3125 days)");
    public static final TimeUnit YEAR = new TimeUnit("year", "year", "a", 3.15576E7, "Julian year (365.25 days)");
    private static final TimeUnit[] VALUES = new TimeUnit[]{MICRO, MILLI, SECOND, MINUTE, HOUR, DAY, WEEK, MONTH, QUARTER, YEAR};

    public TimeUnit(String label, String textName, String symbol, double extentInSeconds, String description) {
        super(label, textName, symbol, extentInSeconds, description);
    }

    public double getExtentInSeconds() {
        return this.getExtent();
    }

    public static TimeUnit[] getKnownValues() {
        return (TimeUnit[])VALUES.clone();
    }

    public static PerUnitConfigKey<Unit> createHistogramConfigKey() {
        ConfigMeta meta = new ConfigMeta("perunit", "Per Unit");
        meta.setShortDescription("Time unit for densities");
        meta.setXmlDescription(new String[]{"<p>Defines the amount of time used to scale values.", "If the combination mode is density-like", "this parameter controls what amount of time", "sums or counts are divided by to produce density values.", "For unscaled combination modes like sum or mean,", "it has no effect.", "</p>"});
        return new PerUnitConfigKey(meta, Unit.class, (Unit[])VALUES, (Unit)SECOND);
    }
}

