/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import uk.ac.starlink.ttools.plot2.layer.ArrayBinList;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.HashBinList;

public class AdaptiveBinList
implements BinList {
    private final int size_;
    private final Combiner combiner_;
    private final int binThresh_;
    private int isub_;
    private HashBinList hlist_;
    private BinList base_;

    public AdaptiveBinList(int size, Combiner combiner, int factThresh) {
        this.size_ = size;
        this.combiner_ = combiner;
        this.hlist_ = new HashBinList(size, combiner);
        this.base_ = this.hlist_;
        this.binThresh_ = size / factThresh;
    }

    @Override
    public Combiner getCombiner() {
        return this.combiner_;
    }

    @Override
    public long getSize() {
        return this.size_;
    }

    @Override
    public void submitToBin(long index, double datum) {
        if (this.hlist_ != null && ++this.isub_ % 1024 == 0 && this.hlist_.getMap().size() > this.binThresh_) {
            ArrayBinList alist = ArrayBinList.fromHashBinList(this.hlist_);
            this.hlist_ = null;
            if (alist != null) {
                this.base_ = alist;
            }
        }
        this.base_.submitToBin(index, datum);
    }

    @Override
    public Combiner.Container getBinContainer(long index) {
        return this.base_.getBinContainer(index);
    }

    @Override
    public BinList.Result getResult() {
        return this.base_.getResult();
    }

    public BinList getBaseBinList() {
        return this.base_;
    }

    public boolean isHash() {
        return this.hlist_ != null;
    }
}

