/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public enum AngleUnit {
    RADIAN("radian", "radians", Math.PI / 180, new String[]{"rad", "radian", "radians"}),
    DEGREE("degree", "degrees", 1.0, new String[]{"deg"}),
    MINUTE("minute", "arcminutes", 0.016666666666666666, new String[]{"min", "minutes", "mins"}),
    ARCSEC("arcsec", "arcseconds", 2.777777777777778E-4, new String[]{"as", "arcsecs", "arcsecond", "arcseconds"}),
    MAS("mas", "milli-arcseconds", 2.7777777777777776E-7, new String[]{"milliarcsec", "milliarcsecond", "milliarcseconds"}),
    UAS("uas", "micro-arcseconds", 2.7777777777777777E-10, new String[]{"microarcsec", "microarcsecond", "microarcseconds"});

    private final String name_;
    private final String fullName_;
    private final double valueInDegrees_;
    private final Collection<String> allnames_;

    private AngleUnit(String name, String fullName, double valueInDegrees, String[] otherNames) {
        this.name_ = name;
        this.fullName_ = fullName;
        this.valueInDegrees_ = valueInDegrees;
        HashSet<String> allnames = new HashSet<String>();
        allnames.add(name);
        allnames.add(fullName);
        for (String n2 : otherNames) {
            allnames.add(n2.toLowerCase());
        }
        this.allnames_ = Collections.unmodifiableSet(allnames);
    }

    public double getValueInDegrees() {
        return this.valueInDegrees_;
    }

    public String getName() {
        return this.name_;
    }

    public String getFullName() {
        return this.fullName_;
    }

    public String toString() {
        return this.name_;
    }

    public static AngleUnit getNamedUnit(String name) {
        if (name != null) {
            for (AngleUnit u : AngleUnit.values()) {
                if (!u.allnames_.contains(name.toLowerCase())) continue;
                return u;
            }
        }
        return null;
    }
}

