/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.layer.AdaptiveBinList;
import uk.ac.starlink.ttools.plot2.layer.ArrayBinList;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.HashBinList;
import uk.ac.starlink.util.SplitCollector;

public abstract class BinListCollector
implements SplitCollector<TupleSequence, BinList> {
    private final Combiner combiner_;
    private final long nbin_;

    public BinListCollector(Combiner combiner, long nbin) {
        this.combiner_ = combiner;
        this.nbin_ = nbin;
    }

    public BinList createAccumulator() {
        return BinListCollector.createDefaultBinList(this.combiner_, this.nbin_);
    }

    public BinList combine(BinList binList1, BinList binList2) {
        return BinListCollector.mergeBinLists(binList1, binList2);
    }

    public static BinList createDefaultBinList(Combiner combiner, long size) {
        ArrayBinList binList;
        if ((double)size < 1000000.0 && (binList = combiner.createArrayBinList((int)size)) != null) {
            return binList;
        }
        if (size < Integer.MAX_VALUE) {
            return new AdaptiveBinList((int)size, combiner, 8);
        }
        return new HashBinList(size, combiner);
    }

    public static BinList mergeBinLists(BinList binList1, BinList binList2) {
        BinList bl2;
        BinList bl1 = binList1 instanceof AdaptiveBinList ? ((AdaptiveBinList)binList1).getBaseBinList() : binList1;
        BinList binList = bl2 = binList2 instanceof AdaptiveBinList ? ((AdaptiveBinList)binList2).getBaseBinList() : binList2;
        if (bl1 instanceof ArrayBinList && bl2 instanceof ArrayBinList) {
            ((ArrayBinList)bl1).addBins((ArrayBinList)bl2);
            return bl1;
        }
        if (bl1 instanceof HashBinList) {
            ((HashBinList)bl1).addBins(bl2);
            return bl1;
        }
        if (bl2 instanceof HashBinList) {
            ((HashBinList)bl2).addBins(bl1);
            return bl2;
        }
        HashBinList bl = new HashBinList(bl1.getSize(), bl1.getCombiner());
        bl.addBins(bl1);
        bl.addBins(bl2);
        return bl;
    }
}

