/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingArrayCoord;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotter;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.BinListCollector;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.util.SplitCollector;

public abstract class CombineArrayPlotter<S extends CombineArrayStyle>
extends AbstractPlotter<S> {
    private static final FloatingArrayCoord XS_COORD = FloatingArrayCoord.X;
    private static final FloatingArrayCoord YS_COORD = FloatingArrayCoord.Y;
    private static final int IC_XS = 0;
    private static final int IC_YS = 1;
    public static final ConfigKey<Combiner> XCOMBINER_KEY = CombineArrayPlotter.createCombinerKey(false);
    public static final ConfigKey<Combiner> YCOMBINER_KEY = CombineArrayPlotter.createCombinerKey(true);
    public static final ReportKey<double[]> XS_REPKEY = ReportKey.createUnprintableKey(new ReportMeta("xs", "X Values"), double[].class);
    public static final ReportKey<double[]> YS_REPKEY = ReportKey.createUnprintableKey(new ReportMeta("ys", "Y Values"), double[].class);

    protected CombineArrayPlotter(String name, Icon icon) {
        super(name, icon, CoordGroup.createNoBasicCoordGroup(new Coord[]{XS_COORD, YS_COORD}, 0, new boolean[]{true, true}), true);
    }

    @Override
    public PlotLayer createLayer(final DataGeom geom, final DataSpec dataSpec, final CombineArrayStyle style) {
        boolean hasY;
        boolean hasX = !dataSpec.isCoordBlank(0);
        boolean bl = hasY = !dataSpec.isCoordBlank(1);
        if (!hasX && !hasY) {
            return null;
        }
        return new AbstractPlotLayer(this, geom, dataSpec, style, style.getLayerOpt()){

            @Override
            public Drawing createDrawing(Surface surface, Map<AuxScale, Span> auxSpans, PaperType paperType) {
                return new CombineArrayDrawing((PlanarSurface)surface, geom, dataSpec, style, paperType);
            }

            @Override
            public void extendCoordinateRanges(Range[] ranges, Scale[] scales, DataStore dataStore) {
                super.extendCoordinateRanges(ranges, scales, dataStore);
                XYData xyData = CombineArrayPlotter.collectXYData(style, dataSpec, dataStore);
                int np = xyData.nbin_;
                if (np > 0) {
                    Range xRange = ranges[0];
                    Range yRange = ranges[1];
                    BinList.Result xResult = xyData.xBins_.getResult();
                    BinList.Result yResult = xyData.yBins_.getResult();
                    for (int ip = 0; ip < np; ++ip) {
                        xRange.submit(xResult.getBinValue(ip));
                        yRange.submit(yResult.getBinValue(ip));
                    }
                }
            }
        };
    }

    @Override
    public Object getRangeStyleKey(S style) {
        return Arrays.asList(((CombineArrayStyle)style).getCombinerX(), ((CombineArrayStyle)style).getCombinerY());
    }

    private static ConfigKey<Combiner> createCombinerKey(boolean isY) {
        char axischar = isY ? (char)'y' : 'x';
        char axisChar = Character.toUpperCase(axischar);
        ConfigMeta meta = new ConfigMeta(axischar + "combine", axisChar + " Combine");
        meta.setShortDescription(axisChar + " axis combination mode");
        meta.setXmlDescription(PlotUtil.concatLines(new String[]{"<p>Defines how corresponding array elements on the " + axisChar, "axis are combined together to produce the plotted value.", "</p>"}));
        Combiner[] options = new Combiner[]{Combiner.MEAN, Combiner.MEDIAN, Combiner.MIN, Combiner.MAX, Combiner.Q01, Combiner.Q1, Combiner.Q3, Combiner.Q99, Combiner.SAMPLE_STDEV, Combiner.SUM, Combiner.COUNT};
        return new OptionConfigKey<Combiner>(meta, Combiner.class, options, Combiner.MEAN){

            @Override
            public String getXmlDescription(Combiner combiner) {
                return combiner.getDescription();
            }
        }.setOptionUsage().addOptionsXml();
    }

    private static BinList createSequenceBinList(int nbin) {
        BinList binlist = BinListCollector.createDefaultBinList(Combiner.MAX, nbin);
        for (int i = 0; i < nbin; ++i) {
            binlist.submitToBin(i, i);
        }
        return binlist;
    }

    private static XYData collectXYData(CombineArrayStyle style, DataSpec dataSpec, DataStore dataStore) {
        boolean xBlank = dataSpec.isCoordBlank(0);
        boolean yBlank = dataSpec.isCoordBlank(1);
        if (xBlank && yBlank) {
            assert (false);
            XYData xyData = new XYData();
            xyData.nbin_ = -1;
            return xyData;
        }
        Combiner combinerX = xBlank ? null : style.getCombinerX();
        Combiner combinerY = yBlank ? null : style.getCombinerY();
        XYData xyData = PlotUtil.tupleCollect(new XYCollector(combinerX, combinerY), dataSpec, dataStore);
        int nbin = xyData.nbin_;
        if (nbin > 0) {
            if (xBlank) {
                xyData.xBins_ = CombineArrayPlotter.createSequenceBinList(nbin);
            }
            if (yBlank) {
                xyData.yBins_ = CombineArrayPlotter.createSequenceBinList(nbin);
            }
        }
        return xyData;
    }

    static String getXYCombineComment() {
        return String.join((CharSequence)"\n", "<p>Note that because the X and Y arrays must be of a fixed size", "for all rows, and because combination is performed in both", "X and Y directions,", "this is typically only suitable for plotting combined spectra", "if they all share a common horizontal axis,", "e.g. are all sampled into the same wavelength bins.", "To visually combine spectra with non-uniform sampling,", "the <ref id='layer-arrayquantile'>arrayquantile</ref> plotter", "may be more useful.", "</p>", "");
    }

    private static class CombineArrayPlan {
        final DataSpec dataSpec_;
        final Combiner xCombiner_;
        final Combiner yCombiner_;
        final double[] dxs_;
        final double[] dys_;

        CombineArrayPlan(DataSpec dataSpec, Combiner xCombiner, Combiner yCombiner, double[] dxs, double[] dys) {
            this.dataSpec_ = dataSpec;
            this.xCombiner_ = xCombiner;
            this.yCombiner_ = yCombiner;
            this.dxs_ = dxs;
            this.dys_ = dys;
        }

        boolean matches(DataSpec dataSpec, Combiner xCombiner, Combiner yCombiner) {
            return this.dataSpec_.equals(dataSpec) && this.xCombiner_.equals(xCombiner) && this.yCombiner_.equals(yCombiner);
        }

        public Point2D.Double[] getPoints(Surface surface) {
            int np;
            int n = np = this.dxs_ == null ? 0 : this.dxs_.length;
            if (np > 0) {
                ArrayList<Point2D.Double> list = new ArrayList<Point2D.Double>(np);
                for (int ip = 0; ip < np; ++ip) {
                    double[] dpos = new double[]{this.dxs_[ip], this.dys_[ip]};
                    Point2D.Double gp = new Point2D.Double();
                    if (!surface.dataToGraphics(dpos, false, gp) || !PlotUtil.isPointReal(gp)) continue;
                    list.add(gp);
                }
                return list.toArray(new Point2D.Double[0]);
            }
            return null;
        }
    }

    private static class XYData {
        int nbin_;
        BinList xBins_;
        BinList yBins_;

        private XYData() {
        }
    }

    private static class XYCollector
    implements SplitCollector<TupleSequence, XYData> {
        final Combiner xCombiner_;
        final Combiner yCombiner_;
        final boolean hasX_;
        final boolean hasY_;

        XYCollector(Combiner xCombiner, Combiner yCombiner) {
            this.xCombiner_ = xCombiner;
            this.yCombiner_ = yCombiner;
            this.hasX_ = xCombiner != null;
            this.hasY_ = yCombiner != null;
        }

        public XYData createAccumulator() {
            return new XYData();
        }

        public void accumulate(TupleSequence tseq, XYData xyData) {
            if (xyData.nbin_ < 0) {
                return;
            }
            while (tseq.next()) {
                int npx = XS_COORD.getArrayCoordLength(tseq, 0);
                int npy = YS_COORD.getArrayCoordLength(tseq, 1);
                if (npx <= 0 && this.hasX_ || npy <= 0 && this.hasY_) continue;
                if (npx == npy || !this.hasX_ || !this.hasY_) {
                    int np;
                    int n = np = this.hasX_ ? npx : npy;
                    if (xyData.nbin_ == 0) {
                        this.initBinCount(xyData, np);
                    }
                    if (xyData.nbin_ != np) {
                        this.initBinCount(xyData, -1);
                        return;
                    }
                    if (this.hasX_) {
                        XYCollector.submitArray(XS_COORD.readArrayCoord(tseq, 0), npx, xyData.xBins_);
                    }
                    if (!this.hasY_) continue;
                    XYCollector.submitArray(YS_COORD.readArrayCoord(tseq, 1), npy, xyData.yBins_);
                    continue;
                }
                this.initBinCount(xyData, -1);
                return;
            }
        }

        public XYData combine(XYData xydata1, XYData xydata2) {
            int nbin1 = xydata1.nbin_;
            int nbin2 = xydata2.nbin_;
            if (nbin1 < 0) {
                return xydata1;
            }
            if (nbin2 < 0) {
                return xydata2;
            }
            if (nbin1 == 0) {
                return xydata2;
            }
            if (nbin2 == 0) {
                return xydata1;
            }
            if (nbin1 != nbin2) {
                this.initBinCount(xydata1, -1);
                return xydata1;
            }
            if (this.hasX_) {
                xydata1.xBins_ = BinListCollector.mergeBinLists(xydata1.xBins_, xydata2.xBins_);
            }
            if (this.hasY_) {
                xydata1.yBins_ = BinListCollector.mergeBinLists(xydata1.yBins_, xydata2.yBins_);
            }
            return xydata1;
        }

        private void initBinCount(XYData xyData, int nbin) {
            xyData.nbin_ = nbin;
            if (nbin > 0) {
                if (this.hasX_) {
                    xyData.xBins_ = BinListCollector.createDefaultBinList(this.xCombiner_, nbin);
                }
                if (this.hasY_) {
                    xyData.yBins_ = BinListCollector.createDefaultBinList(this.yCombiner_, nbin);
                }
            } else {
                xyData.xBins_ = null;
                xyData.yBins_ = null;
            }
        }

        private static void submitArray(double[] samples, int np, BinList binList) {
            for (int ip = 0; ip < np; ++ip) {
                double d = samples[ip];
                if (Double.isNaN(d)) continue;
                binList.submitToBin(ip, d);
            }
        }
    }

    private static class CombineArrayDrawing
    implements Drawing {
        final PlanarSurface surface_;
        final DataGeom geom_;
        final DataSpec dataSpec_;
        final CombineArrayStyle style_;
        final PaperType paperType_;

        CombineArrayDrawing(PlanarSurface surface, DataGeom geom, DataSpec dataSpec, CombineArrayStyle style, PaperType paperType) {
            this.surface_ = surface;
            this.geom_ = geom;
            this.dataSpec_ = dataSpec;
            this.style_ = style;
            this.paperType_ = paperType;
        }

        @Override
        public CombineArrayPlan calculatePlan(Object[] knownPlans, DataStore dataStore) {
            double[] dys;
            double[] dxs;
            Combiner xCombiner = this.style_.getCombinerX();
            Combiner yCombiner = this.style_.getCombinerY();
            for (Object knownPlan : knownPlans) {
                if (!(knownPlan instanceof CombineArrayPlan) || !((CombineArrayPlan)knownPlan).matches(this.dataSpec_, xCombiner, yCombiner)) continue;
                return (CombineArrayPlan)knownPlan;
            }
            XYData xyData = CombineArrayPlotter.collectXYData(this.style_, this.dataSpec_, dataStore);
            int nbin = xyData.nbin_;
            if (nbin > 0) {
                BinList.Result xResult = xyData.xBins_.getResult();
                BinList.Result yResult = xyData.yBins_.getResult();
                dxs = new double[nbin];
                dys = new double[nbin];
                for (int ib = 0; ib < nbin; ++ib) {
                    dxs[ib] = xResult.getBinValue(ib);
                    dys[ib] = yResult.getBinValue(ib);
                }
            } else {
                dxs = null;
                dys = null;
            }
            return new CombineArrayPlan(this.dataSpec_, xCombiner, yCombiner, dxs, dys);
        }

        @Override
        public void paintData(Object plan, Paper paper, DataStore dataStore) {
            Point2D.Double[] points = ((CombineArrayPlan)plan).getPoints(this.surface_);
            if (points != null) {
                this.style_.paintPoints(this.surface_, this.paperType_, paper, points);
            }
        }

        @Override
        public ReportMap getReport(Object plan) {
            ReportMap report = new ReportMap();
            if (plan instanceof CombineArrayPlan) {
                CombineArrayPlan cplan = (CombineArrayPlan)plan;
                if (cplan.dxs_ != null) {
                    report.put(XS_REPKEY, cplan.dxs_);
                    report.put(YS_REPKEY, cplan.dys_);
                }
            }
            return report;
        }
    }

    public static abstract class CombineArrayStyle
    implements Style {
        private final Combiner xCombiner_;
        private final Combiner yCombiner_;
        private final LayerOpt layerOpt_;

        protected CombineArrayStyle(Combiner xCombiner, Combiner yCombiner, LayerOpt layerOpt) {
            this.xCombiner_ = xCombiner;
            this.yCombiner_ = yCombiner;
            this.layerOpt_ = layerOpt;
        }

        public Combiner getCombinerX() {
            return this.xCombiner_;
        }

        public Combiner getCombinerY() {
            return this.yCombiner_;
        }

        public LayerOpt getLayerOpt() {
            return this.layerOpt_;
        }

        public abstract void paintPoints(PlanarSurface var1, PaperType var2, Paper var3, Point2D.Double[] var4);

        public int hashCode() {
            int code = 232357;
            code = 23 * code + this.xCombiner_.hashCode();
            code = 23 * code + this.yCombiner_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof CombineArrayStyle) {
                CombineArrayStyle other = (CombineArrayStyle)o;
                return this.xCombiner_.equals(other.xCombiner_) && this.yCombiner_.equals(other.yCombiner_);
            }
            return false;
        }
    }
}

