/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.DoubleConfigKey;
import uk.ac.starlink.ttools.plot2.config.IntegerConfigKey;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.SliderSpecifier;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotter;
import uk.ac.starlink.ttools.plot2.layer.ArrayBinList;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.ContourStyle;
import uk.ac.starlink.ttools.plot2.layer.Gridder;
import uk.ac.starlink.ttools.plot2.layer.LevelMode;
import uk.ac.starlink.ttools.plot2.layer.NumberArray;
import uk.ac.starlink.ttools.plot2.layer.ShapeMode;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.util.SplitCollector;

public class ContourPlotter
extends AbstractPlotter<ContourStyle> {
    private static final FloatingCoord WEIGHT_COORD = FloatingCoord.WEIGHT_COORD;
    public static final ConfigKey<Integer> NLEVEL_KEY = IntegerConfigKey.createSpinnerKey(new ConfigMeta("nlevel", "Level Count").setShortDescription("Maximum number of contours").setXmlDescription(new String[]{"<p>Number of countour lines drawn.", "In fact, this is an upper limit;", "if there is not enough variation in the plot's density,", "then fewer contour lines will be drawn.", "</p>"}), 5, 1, 999);
    public static final ConfigKey<Integer> SMOOTH_KEY = IntegerConfigKey.createSpinnerKey(new ConfigMeta("smooth", "Smoothing").setStringUsage("<pixels>").setShortDescription("Smoothing kernel size in pixels").setXmlDescription(new String[]{"<p>The linear size of the smoothing kernel applied to the", "density before performing the contour determination.", "If set too low the contours will be too crinkly,", "and if too high they will lose definition.", "Smoothing currently uses an approximately Gaussian kernel", "for extensive combination modes (count, sum)", "or a circular top hat for intensive modes (weighted mean).", "</p>"}), 5, 1, 100);
    public static final ConfigKey<Integer> THICKNESS_KEY = StyleKeys.createThicknessKey(1);
    public static final ConfigKey<Double> OFFSET_KEY = DoubleConfigKey.createSliderKey(new ConfigMeta("zero", "Zero Point").setShortDescription("Level of first contour").setXmlDescription(new String[]{"<p>Determines the level at which the first contour", "(and hence all the others, which are separated from it", "by a fixed amount) are drawn.", "</p>"}), 1.0, 0.0, 2.0, false, false, SliderSpecifier.TextOption.ENTER_ECHO);
    public static final ConfigKey<Combiner> COMBINER_KEY = new OptionConfigKey<Combiner>(new ConfigMeta("combine", "Combine").setShortDescription("Weight combination mode").setXmlDescription(new String[]{"<p>Defines the way that the weight values are combined", "when generating the value grid for which the contours", "will be plotted.", "If a weighting is supplied, the most useful values are", "<code>" + Combiner.MEAN + "</code> which traces the", "mean values of a quantity and", "<code>" + Combiner.SUM + "</code> which traces the", "weighted sum.", "Other values such as", "<code>" + Combiner.MEDIAN + "</code>", "are of dubious validity because of the way that the", "smoothing is done.", "</p>", "<p>This value is ignored if the weighting coordinate", "<code>" + WEIGHT_COORD.getInput().getMeta().getShortName() + "</code>", "is not set.", "</p>"}), Combiner.class, new Combiner[]{Combiner.SUM, Combiner.MEAN, Combiner.MEDIAN, Combiner.SAMPLE_STDEV, Combiner.MIN, Combiner.MAX, Combiner.COUNT}, Combiner.SUM){

        @Override
        public String getXmlDescription(Combiner combiner) {
            return combiner.getDescription();
        }
    }.setOptionUsage().addOptionsXml();
    public static final ReportKey<double[]> LEVELS_REPKEY = new LevelsReportKey();
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2");
    private final FloatingCoord weightCoord_;

    public ContourPlotter(boolean hasWeight) {
        this(hasWeight ? WEIGHT_COORD : null);
    }

    private ContourPlotter(FloatingCoord weightCoord) {
        Coord[] coordArray;
        if (weightCoord == null) {
            coordArray = new Coord[]{};
        } else {
            Coord[] coordArray2 = new Coord[1];
            coordArray = coordArray2;
            coordArray2[0] = weightCoord;
        }
        super("Contour", ResourceIcon.PLOT_CONTOUR, 1, coordArray);
        this.weightCoord_ = weightCoord;
    }

    @Override
    public String getPlotterDescription() {
        String weightPara = this.weightCoord_ == null ? "" : PlotUtil.concatLines(new String[]{"<p>A weighting may optionally be applied to the quantity", "being contoured.", "To do this, provide a non-blank value for the", "<code>" + this.weightCoord_.getInput().getMeta().getShortName() + "</code>", "coordinate, and use the", "<code>" + COMBINER_KEY.getMeta().getShortName() + "</code>", "parameter to define how the weights are combined", "(<code>" + Combiner.SUM + "</code>,", "<code>" + Combiner.MEAN + "</code>, etc).", "</p>"});
        return PlotUtil.concatLines(new String[]{"<p>Plots position density contours.", "This provides another way", "(alongside the", ShapeMode.modeRef(ShapeMode.AUTO) + ",", ShapeMode.modeRef(ShapeMode.DENSITY), "and", ShapeMode.modeRef(ShapeMode.WEIGHTED), "shading modes)", "to visualise the characteristics of overdense regions", "in a crowded plot.", "It's not very useful if you just have a few points.", "</p>", weightPara, "<p>The contours are currently drawn as pixels rather than lines", "so they don't look very beautiful in exported vector", "output formats (PDF, PostScript).", "This may be improved in the future.", "</p>"});
    }

    @Override
    public boolean hasReports() {
        return true;
    }

    @Override
    public ConfigKey<?>[] getStyleKeys() {
        ArrayList<ConfigKey<Object>> keys = new ArrayList<ConfigKey<Object>>();
        keys.add(StyleKeys.COLOR);
        if (this.weightCoord_ != null) {
            keys.add(COMBINER_KEY);
        }
        keys.add(NLEVEL_KEY);
        keys.add(SMOOTH_KEY);
        keys.add(THICKNESS_KEY);
        keys.add(StyleKeys.LEVEL_MODE);
        keys.add(OFFSET_KEY);
        return keys.toArray(new ConfigKey[0]);
    }

    @Override
    public ContourStyle createStyle(ConfigMap config) {
        Color color = config.get(StyleKeys.COLOR);
        int nlevel = config.get(NLEVEL_KEY);
        double offset = config.get(OFFSET_KEY);
        int nsmooth = config.get(SMOOTH_KEY);
        int thickness = config.get(THICKNESS_KEY);
        LevelMode levMode = config.get(StyleKeys.LEVEL_MODE);
        Combiner combiner = this.weightCoord_ == null ? Combiner.COUNT : config.get(COMBINER_KEY);
        return new ContourStyle(color, nlevel, offset, nsmooth, thickness, levMode, combiner);
    }

    @Override
    public PlotLayer createLayer(final DataGeom geom, final DataSpec dataSpec, final ContourStyle style) {
        LayerOpt opt = new LayerOpt(style.getColor(), true);
        return new AbstractPlotLayer(this, geom, dataSpec, style, opt){

            @Override
            public Drawing createDrawing(Surface surface, Map<AuxScale, Span> auxSpans, PaperType paperType) {
                if (!paperType.isBitmap()) {
                    logger_.warning("Sorry - contours are ugly in vector plots");
                }
                CoordGroup cgrp = ContourPlotter.this.getCoordGroup();
                int icPos = cgrp.getPosCoordIndex(0, geom);
                int icWeight = ContourPlotter.this.weightCoord_ == null ? -1 : cgrp.getExtraCoordIndex(0, geom);
                return new BitmapContourDrawing(surface, geom, dataSpec, style, icPos, icWeight, paperType);
            }
        };
    }

    private static NumberGrid smoothSum(NumberGrid inGrid, int smooth) {
        Gridder gridder = inGrid.gridder_;
        int nx = gridder.getWidth();
        int ny = gridder.getHeight();
        int npix = gridder.getLength();
        double[] kernel = ContourPlotter.gaussian(smooth, 1.5);
        double[] a1 = new double[npix];
        double[] b1 = new double[npix];
        for (int qx = 0; qx < smooth; ++qx) {
            double k = kernel[qx];
            int px = qx - smooth / 2;
            int ix0 = Math.max(0, px);
            int ix1 = Math.min(nx, nx + px);
            for (int iy = 0; iy < ny; ++iy) {
                for (int ix = ix0; ix < ix1; ++ix) {
                    int index1;
                    int jx = ix - px;
                    double d = inGrid.getValue(gridder.getIndex(jx, iy));
                    if (Double.isNaN(d)) continue;
                    int n = index1 = gridder.getIndex(ix, iy);
                    a1[n] = a1[n] + k * d;
                    int n2 = index1;
                    b1[n2] = b1[n2] + k;
                }
            }
        }
        double[] a2 = new double[npix];
        double[] b2 = new double[npix];
        for (int qy = 0; qy < smooth; ++qy) {
            double k = kernel[qy];
            int py = qy - smooth / 2;
            int iy0 = Math.max(0, py);
            int iy1 = Math.min(ny, ny + py);
            for (int iy = iy0; iy < iy1; ++iy) {
                for (int ix = 0; ix < nx; ++ix) {
                    int jy = iy - py;
                    int index2 = gridder.getIndex(ix, iy);
                    int index1 = gridder.getIndex(ix, jy);
                    int n = index2;
                    a2[n] = a2[n] + k * a1[index1];
                    int n3 = index2;
                    b2[n3] = b2[n3] + k * b1[index1];
                }
            }
        }
        final double[] out = a2;
        double[] mask = b2;
        double sk = 0.0;
        for (int i = 0; i < smooth; ++i) {
            for (int j = 0; j < smooth; ++j) {
                sk += kernel[i] * kernel[j];
            }
        }
        double factor = 1.0 / sk;
        for (int i = 0; i < out.length; ++i) {
            out[i] = mask[i] > 0.0 ? out[i] * factor : Double.NaN;
        }
        return new NumberGrid(gridder){

            @Override
            public double getValue(int i) {
                return out[i];
            }
        };
    }

    private static NumberGrid smoothMean(NumberGrid inGrid, int smooth) {
        Gridder gridder = inGrid.gridder_;
        int nx = gridder.getWidth();
        int ny = gridder.getHeight();
        int npix = gridder.getLength();
        ArrayBinList outBinList = Combiner.MEAN.createArrayBinList(npix);
        double q0 = 0.5 * (double)(smooth - 1);
        double qr = 0.5 * (double)(smooth - 1) + 0.5;
        for (int qx = 0; qx < smooth; ++qx) {
            int px = qx - smooth / 2;
            int ix0 = Math.max(0, px);
            int ix1 = Math.min(nx, nx + px);
            for (int qy = 0; qy < smooth; ++qy) {
                int py = qy - smooth / 2;
                int iy0 = Math.max(0, py);
                int iy1 = Math.min(ny, ny + py);
                double r = Math.hypot((double)qx - q0, (double)qy - q0);
                if (!(r <= qr)) continue;
                for (int iy = iy0; iy < iy1; ++iy) {
                    int jy = iy - py;
                    for (int ix = ix0; ix < ix1; ++ix) {
                        int jx = ix - px;
                        double d = inGrid.getValue(gridder.getIndex(jx, jy));
                        if (Double.isNaN(d)) continue;
                        int ig = gridder.getIndex(ix, iy);
                        outBinList.submitToBin(ig, d);
                    }
                }
            }
        }
        final BinList.Result binResult = outBinList.getResult();
        return new NumberGrid(gridder){

            @Override
            public double getValue(int i) {
                return binResult.getBinValue(i);
            }
        };
    }

    private static double[] gaussian(int nsamp, double nsigma) {
        double[] kernel = new double[nsamp];
        double x0 = 0.5 * (double)(nsamp - 1);
        double sigma = (double)nsamp * 0.5 / nsigma;
        double sum = 0.0;
        for (int i = 0; i < nsamp; ++i) {
            double sample;
            double p = ((double)i - x0) / sigma;
            kernel[i] = sample = Math.exp(-0.5 * p * p);
            sum += sample;
        }
        double norm = 1.0 / sum;
        int i = 0;
        while (i < nsamp) {
            int n = i++;
            kernel[n] = kernel[n] + norm;
        }
        return kernel;
    }

    private static class ContourPlan {
        final Combiner combiner_;
        final Surface surface_;
        final DataSpec dataSpec_;
        final DataGeom geom_;
        final int pad_;
        final NumberGrid rawGrid_;
        final int smooth_;
        final NumberGrid smoothGrid_;

        ContourPlan(Combiner combiner, Surface surface, DataSpec dataSpec, DataGeom geom, int pad, NumberGrid rawGrid, int smooth, NumberGrid smoothGrid) {
            this.combiner_ = combiner;
            this.surface_ = surface;
            this.dataSpec_ = dataSpec;
            this.geom_ = geom;
            this.pad_ = pad;
            this.rawGrid_ = rawGrid;
            this.smooth_ = smooth;
            this.smoothGrid_ = smoothGrid;
        }

        ContourPlan resmooth(int smooth) {
            if (smooth == this.smooth_) {
                return this;
            }
            NumberGrid sgrid = smooth == 1 ? this.rawGrid_ : (this.combiner_.getType().isExtensive() ? ContourPlotter.smoothSum(this.rawGrid_, smooth) : ContourPlotter.smoothMean(this.rawGrid_, smooth));
            return new ContourPlan(this.combiner_, this.surface_, this.dataSpec_, this.geom_, this.pad_, this.rawGrid_, smooth, sgrid);
        }

        public boolean matches(Combiner combiner, Surface surface, DataSpec dataSpec, DataGeom geom, int requiredPad) {
            return combiner.equals(this.combiner_) && surface.equals(this.surface_) && dataSpec.equals(this.dataSpec_) && this.geom_.equals(geom) && this.pad_ >= requiredPad;
        }
    }

    private static abstract class NumberGrid
    implements NumberArray {
        final Gridder gridder_;

        NumberGrid(Gridder gridder) {
            this.gridder_ = gridder;
        }

        public double getValue(int ix, int iy) {
            return this.getValue(this.gridder_.getIndex(ix, iy));
        }

        @Override
        public int getLength() {
            return this.gridder_.getLength();
        }
    }

    private static class Leveller {
        final double[] levels_;

        Leveller(double[] levels) {
            this.levels_ = levels;
        }

        public int getLevel(double value) {
            int ipos = Arrays.binarySearch(this.levels_, value);
            return ipos < 0 ? -(ipos + 1) : ipos;
        }
    }

    private static class LevelsReportKey
    extends ReportKey<double[]> {
        LevelsReportKey() {
            super(new ReportMeta("levels", "Levels"), double[].class, true);
        }

        @Override
        public String toText(double[] values) {
            int nval;
            int n = nval = values == null ? 0 : values.length;
            if (nval == 0) {
                return null;
            }
            if (nval == 1) {
                return Double.toString(values[0]);
            }
            if (LevelsReportKey.allInteger(values)) {
                StringBuffer sbuf = new StringBuffer();
                for (int i = 0; i < nval; ++i) {
                    if (i > 0) {
                        sbuf.append(", ");
                    }
                    sbuf.append(Long.toString((long)values[i]));
                }
                return sbuf.toString();
            }
            StringBuffer sbuf = new StringBuffer();
            for (int i = 0; i < nval; ++i) {
                double d1 = i - 1 >= 0 ? Math.abs(values[i] - values[i - 1]) : Double.POSITIVE_INFINITY;
                double d2 = i + 1 < nval ? Math.abs(values[i + 1] - values[i]) : Double.POSITIVE_INFINITY;
                double diff = Math.min(d1, d2);
                double dp = 0.001 * diff;
                if (i > 0) {
                    sbuf.append(", ");
                }
                sbuf.append(PlotUtil.formatNumber(values[i], dp));
            }
            return sbuf.toString();
        }

        private static boolean allInteger(double[] values) {
            for (double d : values) {
                if ((double)((long)d) == d) continue;
                return false;
            }
            return true;
        }
    }

    private static class BitmapContourDrawing
    implements Drawing {
        private final Surface surface_;
        private final DataGeom geom_;
        private final DataSpec dataSpec_;
        private final ContourStyle style_;
        private final int icPos_;
        private final int icWeight_;
        private final PaperType paperType_;
        private final boolean hasWeight_;

        BitmapContourDrawing(Surface surface, DataGeom geom, DataSpec dataSpec, ContourStyle style, int icPos, int icWeight, PaperType paperType) {
            this.surface_ = surface;
            this.geom_ = geom;
            this.dataSpec_ = dataSpec;
            this.style_ = style;
            this.icPos_ = icPos;
            this.icWeight_ = icWeight;
            this.paperType_ = paperType;
            this.hasWeight_ = this.icWeight_ >= 0 && !this.dataSpec_.isCoordBlank(this.icWeight_);
        }

        @Override
        public ContourPlan calculatePlan(Object[] knownPlans, DataStore dataStore) {
            Combiner combiner = this.style_.getCombiner();
            int smooth = this.style_.getSmoothing();
            int requiredPad = (smooth + 1) / 2;
            for (Object plan : knownPlans) {
                ContourPlan cplan;
                if (!(plan instanceof ContourPlan) || !(cplan = (ContourPlan)plan).matches(combiner, this.surface_, this.dataSpec_, this.geom_, requiredPad)) continue;
                return cplan.smooth_ == smooth ? cplan : cplan.resmooth(smooth);
            }
            int requestedPad = Math.max(16, requiredPad * 2);
            NumberGrid rawGrid = this.readBinGrid(dataStore, requestedPad);
            return new ContourPlan(combiner, this.surface_, this.dataSpec_, this.geom_, requestedPad, rawGrid, 1, rawGrid).resmooth(smooth);
        }

        private NumberGrid readBinGrid(DataStore dataStore, int pad) {
            Rectangle bounds = this.surface_.getPlotBounds();
            final int nx = bounds.width + 2 * pad;
            final int ny = bounds.height + 2 * pad;
            final Gridder gridder = new Gridder(nx, ny);
            final int xoff = bounds.x - pad;
            final int yoff = bounds.y - pad;
            final int nbin = gridder.getLength();
            SplitCollector<TupleSequence, ArrayBinList> collector = new SplitCollector<TupleSequence, ArrayBinList>(){

                public ArrayBinList createAccumulator() {
                    return (hasWeight_ ? style_.getCombiner() : Combiner.COUNT).createArrayBinList(nbin);
                }

                public void accumulate(TupleSequence tseq, ArrayBinList binList) {
                    double[] dpos = new double[surface_.getDataDimCount()];
                    Point2D.Double gp = new Point2D.Double();
                    if (hasWeight_) {
                        while (tseq.next()) {
                            int gy;
                            int gx;
                            double w = WEIGHT_COORD.readDoubleCoord(tseq, icWeight_);
                            if (Double.isNaN(w) || !geom_.readDataPos(tseq, icPos_, dpos) || !surface_.dataToGraphics(dpos, false, gp) || (gx = PlotUtil.ifloor(gp.x) - xoff) < 0 || gx >= nx || (gy = PlotUtil.ifloor(gp.y) - yoff) < 0 || gy >= ny) continue;
                            int ibin = gridder.getIndex(gx, gy);
                            binList.submitToBin(ibin, w);
                        }
                    } else {
                        while (tseq.next()) {
                            int gy;
                            int gx;
                            if (!geom_.readDataPos(tseq, icPos_, dpos) || !surface_.dataToGraphics(dpos, false, gp) || (gx = PlotUtil.ifloor(gp.x) - xoff) < 0 || gx >= nx || (gy = PlotUtil.ifloor(gp.y) - yoff) < 0 || gy >= ny) continue;
                            int ibin = gridder.getIndex(gx, gy);
                            binList.submitToBin(ibin, 1.0);
                        }
                    }
                }

                public ArrayBinList combine(ArrayBinList acc1, ArrayBinList acc2) {
                    acc1.addBins(acc2);
                    return acc1;
                }
            };
            final BinList.Result binResult = PlotUtil.tupleCollect(collector, this.dataSpec_, dataStore).getResult();
            return new NumberGrid(gridder){

                @Override
                public double getValue(int index) {
                    return binResult.getBinValue(index);
                }
            };
        }

        @Override
        public void paintData(final Object plan, Paper paper, DataStore dataStore) {
            this.paperType_.placeDecal(paper, new Decal(){

                @Override
                public void paintDecal(Graphics g) {
                    this.paintContours(g, (ContourPlan)plan);
                }

                @Override
                public boolean isOpaque() {
                    return true;
                }
            });
        }

        @Override
        public ReportMap getReport(Object plan) {
            ReportMap reports = new ReportMap();
            if (plan instanceof ContourPlan) {
                Leveller leveller = this.createLeveller((ContourPlan)plan);
                reports.put(LEVELS_REPKEY, leveller.levels_);
            }
            return reports;
        }

        private Leveller createLeveller(ContourPlan plan) {
            Combiner combiner = this.style_.getCombiner();
            LevelMode lmode = this.style_.getLevelMode();
            NumberGrid grid = plan.smoothGrid_;
            boolean isCounts = plan.smooth_ == 1 && (!this.hasWeight_ || combiner.equals(Combiner.COUNT) || combiner.equals(Combiner.HIT));
            double[] levels = lmode.calculateLevels(grid, this.style_.getLevelCount(), this.style_.getOffset(), isCounts);
            return new Leveller(levels);
        }

        private void paintContours(Graphics g, ContourPlan cplan) {
            int lev1;
            int lev0;
            assert (cplan.smooth_ == this.style_.getSmoothing());
            Color color0 = g.getColor();
            g.setColor(this.style_.getColor());
            Rectangle bounds = this.surface_.getPlotBounds();
            int pad = cplan.pad_;
            int xoff = bounds.x - pad;
            int yoff = bounds.y - pad;
            int nx = bounds.width;
            int ny = bounds.height;
            Gridder gridder = new Gridder(nx + 2 * pad, ny + 2 * pad);
            int leng = gridder.getLength();
            Leveller leveller = this.createLeveller(cplan);
            final NumberGrid smoothGrid = cplan.smoothGrid_;
            assert (gridder.equals(smoothGrid.gridder_));
            NumberGrid plotGrid = new NumberGrid(smoothGrid.gridder_){

                @Override
                public double getValue(int i) {
                    double value = smoothGrid.getValue(i);
                    return Double.isNaN(value) ? -1.7976931348623157E308 : value;
                }
            };
            int lw = this.style_.getThickness();
            int ioff = (lw + 1) / 2;
            int ix0 = Math.max(0, pad - lw);
            int ix1 = Math.min(nx + pad + 2 * lw, gridder.getWidth());
            int iy0 = Math.max(0, pad - lw);
            int iy1 = Math.min(ny + pad + 2 * lw, gridder.getHeight());
            for (int ix = ix0; ix < ix1; ++ix) {
                lev0 = leveller.getLevel(plotGrid.getValue(ix, 0));
                for (int iy = iy0 + 1; iy < iy1; ++iy) {
                    lev1 = leveller.getLevel(plotGrid.getValue(ix, iy));
                    if (lev1 != lev0) {
                        g.fillRect(xoff + ix, yoff + iy - ioff, lw, lw);
                    }
                    lev0 = lev1;
                }
            }
            for (int iy = iy0; iy < iy1; ++iy) {
                lev0 = leveller.getLevel(plotGrid.getValue(0, iy));
                for (int ix = ix0 + 1; ix < ix1; ++ix) {
                    lev1 = leveller.getLevel(plotGrid.getValue(ix, iy));
                    if (lev1 != lev0) {
                        g.fillRect(xoff + ix - ioff, yoff + iy, lw, lw);
                    }
                    lev0 = lev1;
                }
            }
            g.setColor(color0);
        }
    }
}

