/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.LevelMode;

@Equality
public class ContourStyle
implements Style {
    private final Color color_;
    private final int nLevel_;
    private final double offset_;
    private final int nSmooth_;
    private final LevelMode levelMode_;
    private final Combiner combiner_;
    private final int thickness_;

    public ContourStyle(Color color, int nLevel, double offset, int nSmooth, int thickness, LevelMode levelMode, Combiner combiner) {
        this.color_ = color;
        this.nLevel_ = nLevel;
        this.offset_ = offset;
        this.nSmooth_ = nSmooth;
        this.thickness_ = thickness;
        this.levelMode_ = levelMode;
        this.combiner_ = combiner;
    }

    public Color getColor() {
        return this.color_;
    }

    public int getLevelCount() {
        return this.nLevel_;
    }

    public double getOffset() {
        return this.offset_;
    }

    public int getSmoothing() {
        return this.nSmooth_;
    }

    public int getThickness() {
        return this.thickness_;
    }

    public LevelMode getLevelMode() {
        return this.levelMode_;
    }

    public Combiner getCombiner() {
        return this.combiner_;
    }

    @Override
    public Icon getLegendIcon() {
        return new Icon(){
            private static final int width_ = 14;
            private static final int height_ = 12;

            @Override
            public int getIconWidth() {
                return 14;
            }

            @Override
            public int getIconHeight() {
                return 12;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Graphics2D g2 = (Graphics2D)g.create();
                g2.setColor(ContourStyle.this.color_);
                g2.setStroke(new BasicStroke(ContourStyle.this.thickness_));
                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                g2.drawOval(x, y, 14, 12);
                if (ContourStyle.this.thickness_ < 3) {
                    g2.drawOval(x + 2, y + 3, 8, 6);
                }
            }
        };
    }

    public int hashCode() {
        int code = 23037;
        code = code * 23 + this.color_.hashCode();
        code = code * 23 + this.nLevel_;
        code = code * 23 + Float.floatToIntBits((float)this.offset_);
        code = code * 23 + this.nSmooth_;
        code = code * 23 + this.thickness_;
        code = code * 23 + this.levelMode_.hashCode();
        code = code * 23 + this.combiner_.hashCode();
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof ContourStyle) {
            ContourStyle other = (ContourStyle)o;
            return this.color_.equals(other.color_) && this.nLevel_ == other.nLevel_ && this.offset_ == other.offset_ && this.nSmooth_ == other.nSmooth_ && this.thickness_ == other.thickness_ && this.levelMode_.equals(other.levelMode_) && this.combiner_.equals(other.combiner_);
        }
        return false;
    }
}

