/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Ranger;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Scalings;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.DoubleConfigKey;
import uk.ac.starlink.ttools.plot2.config.IntegerConfigKey;
import uk.ac.starlink.ttools.plot2.config.RampKeySet;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.layer.BinSizer;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.Cumulation;
import uk.ac.starlink.ttools.plot2.layer.Kernel1d;
import uk.ac.starlink.ttools.plot2.layer.Kernel1dShape;
import uk.ac.starlink.ttools.plot2.layer.Normalisation;
import uk.ac.starlink.ttools.plot2.layer.Pixel1dPlotter;
import uk.ac.starlink.ttools.plot2.layer.Unit;

public class DensogramPlotter
extends Pixel1dPlotter<DensoStyle> {
    public static final RampKeySet RAMP_KEYSET = new RampKeySet("dense", "Density", StyleKeys.createAuxShaders(), Scaling.LINEAR, true);
    public static final ConfigKey<Integer> EXTENT_KEY = IntegerConfigKey.createSliderKey(new ConfigMeta("size", "Size").setStringUsage("<pixels>").setShortDescription("Height in pixels of the density bar").setXmlDescription(new String[]{"<p>Height of the density bar in pixels.", "</p>"}), 12, 1.0, 100.0, false);
    public static final ConfigKey<Double> POSITION_KEY = DoubleConfigKey.createSliderKey(new ConfigMeta("pos", "Position").setStringUsage("<fraction>").setShortDescription("Location on plot of density bar, in range 0..1").setXmlDescription(new String[]{"<p>Determines where on the plot region the density bar", "appears.", "The value should be in the range 0..1;", "zero corresponds to the bottom of the plot", "and one to the top.", "</p>"}), 0.05, 0.0, 1.0, false);

    public DensogramPlotter(FloatingCoord xCoord, boolean hasWeight) {
        super(xCoord, hasWeight, null, "Densogram", ResourceIcon.FORM_DENSOGRAM);
    }

    @Override
    public String getPlotterDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Represents smoothed density of data values", "along the horizontal axis using a colourmap.", "This is like a", "<ref id='layer-kde'>Kernel Density Estimate</ref>", "(smoothed histogram with bins 1 pixel wide),", "but instead of representing the data extent vertically", "as bars or a line,", "values are represented by a fixed-size pixel-width column", "of a colour from a colour map.", "A smoothing kernel, whose width and shape may be varied,", "is applied to each data point.", "</p>", this.getWeightingDescription(), "<p>This is a rather unconventional way to represent density data,", "and this plotting mode is probably not very useful.", "But hey, nobody's forcing you to use it.", "</p>"});
    }

    @Override
    public ConfigKey<?>[] getStyleKeys() {
        ArrayList list = new ArrayList();
        list.add(StyleKeys.COLOR);
        list.add(SMOOTHSIZER_KEY);
        list.add(StyleKeys.SIDEWAYS);
        list.add(KERNEL_KEY);
        list.addAll(Arrays.asList(RAMP_KEYSET.getKeys()));
        list.add(StyleKeys.CUMULATIVE);
        list.add(EXTENT_KEY);
        list.add(POSITION_KEY);
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public DensoStyle createStyle(ConfigMap config) {
        Color baseColor = config.get(StyleKeys.COLOR);
        RampKeySet.Ramp ramp = RAMP_KEYSET.createValue(config);
        BinSizer sizer = (BinSizer)config.get(SMOOTHSIZER_KEY);
        boolean isY = config.get(StyleKeys.SIDEWAYS);
        Kernel1dShape kernelShape = (Kernel1dShape)config.get(KERNEL_KEY);
        Combiner combiner = Combiner.SUM;
        Cumulation cumul = config.get(StyleKeys.CUMULATIVE);
        int extent = config.get(EXTENT_KEY);
        double position = config.get(POSITION_KEY);
        return new DensoStyle(baseColor, ramp.getShader(), ramp.getScaling(), ramp.getDataClip(), isY, kernelShape, combiner, sizer, cumul, extent, position);
    }

    @Override
    public Object getRangeStyleKey(DensoStyle style) {
        return null;
    }

    @Override
    protected void paintBins(PlanarSurface surface, Pixel1dPlotter.BinArray binArray, DensoStyle style, Graphics2D g) {
        boolean isY = style.isY_;
        Axis xAxis = surface.getAxes()[isY ? 1 : 0];
        Combiner combiner = style.combiner_;
        Kernel1d kernel = DensogramPlotter.createKernel(style.kernelShape_, style.sizer_, xAxis, !combiner.getType().isExtensive());
        double[] bins = DensogramPlotter.getDataBins(binArray, xAxis, kernel, Normalisation.NONE, style.combiner_.getType(), Unit.UNIT, style.cumul_);
        Rectangle bounds = surface.getPlotBounds();
        int gy0 = isY ? bounds.x + (int)((double)(bounds.width - style.extent_) * style.position_) : bounds.y + (int)((double)(bounds.height - style.extent_) * (1.0 - style.position_));
        int ixlo = binArray.getBinIndex(isY ? bounds.y : bounds.x);
        int ixhi = binArray.getBinIndex(isY ? bounds.y + bounds.height : bounds.x + bounds.width);
        int np = ixhi - ixlo;
        Scaling scaling = style.scaling_;
        Ranger ranger = Scalings.createRanger(new Scaling[]{scaling});
        for (int ip = 0; ip < np; ++ip) {
            ranger.submitDatum(bins[ixlo + ip]);
        }
        Span span = ranger.createSpan();
        if (span.getHigh() > span.getLow()) {
            Scaler scaler = span.createScaler(scaling, style.dataclip_);
            float[] baseRgba = style.baseColor_.getRGBComponents(null);
            float[] rgba = new float[4];
            Color color0 = g.getColor();
            boolean isLog = scaler.isLogLike();
            for (int ip = 0; ip < np; ++ip) {
                int ix = ixlo + ip;
                int gx = binArray.getGraphicsCoord(ix);
                double dy = bins[ix];
                if (Double.isNaN(dy)) continue;
                double sy = scaler.scaleValue(dy);
                if (isLog && sy < 0.0) {
                    sy = 0.0;
                }
                System.arraycopy(baseRgba, 0, rgba, 0, 4);
                style.shader_.adjustRgba(rgba, (float)sy);
                Color color = new Color(rgba[0], rgba[1], rgba[2], rgba[3]);
                g.setColor(color);
                if (isY) {
                    g.fillRect(gy0, gx, style.extent_, 1);
                    continue;
                }
                g.fillRect(gx, gy0, 1, style.extent_);
            }
            g.setColor(color0);
        }
    }

    @Override
    protected boolean isY(DensoStyle style) {
        return style.isY_;
    }

    @Override
    protected LayerOpt getLayerOpt(DensoStyle style) {
        return LayerOpt.OPAQUE;
    }

    @Override
    protected int getPixelPadding(DensoStyle style, PlanarSurface surf) {
        boolean isY = style.isY_;
        Kernel1d kernel = DensogramPlotter.createKernel(style.kernelShape_, style.sizer_, surf.getAxes()[isY ? 1 : 0], !style.combiner_.getType().isExtensive());
        return DensogramPlotter.getEffectiveExtent(kernel);
    }

    @Override
    protected Combiner getCombiner(DensoStyle style) {
        return style.combiner_;
    }

    @Override
    protected void extendPixel1dCoordinateRanges(Range[] ranges, Scale[] scales, DensoStyle style, DataSpec dataSpec, DataStore dataStore) {
    }

    @Override
    protected ReportMap getPixel1dReport(Pixel1dPlotter.Pixel1dPlan plan, DensoStyle style, Scale xScale) {
        Axis xAxis = plan.xAxis_;
        BinSizer sizer = style.sizer_;
        double[] dlimits = xAxis.getDataLimits();
        double sSmoothWidth = sizer.getScaleWidth(xAxis.getScale(), dlimits[0], dlimits[1], false);
        ReportMap report = new ReportMap();
        report.put(SMOOTHWIDTH_KEY, sSmoothWidth);
        return report;
    }

    public static class DensoStyle
    implements Style {
        final Color baseColor_;
        final Shader shader_;
        final Scaling scaling_;
        final Subrange dataclip_;
        final boolean isY_;
        final Kernel1dShape kernelShape_;
        final Combiner combiner_;
        final BinSizer sizer_;
        final Cumulation cumul_;
        final int extent_;
        final double position_;

        public DensoStyle(Color baseColor, Shader shader, Scaling scaling, Subrange dataclip, boolean isY, Kernel1dShape kernelShape, Combiner combiner, BinSizer sizer, Cumulation cumul, int extent, double position) {
            this.baseColor_ = baseColor;
            this.shader_ = shader;
            this.scaling_ = scaling;
            this.dataclip_ = dataclip;
            this.isY_ = isY;
            this.kernelShape_ = kernelShape;
            this.combiner_ = combiner;
            this.sizer_ = sizer;
            this.cumul_ = cumul;
            this.extent_ = extent;
            this.position_ = position;
        }

        @Override
        public Icon getLegendIcon() {
            return Shaders.createShaderIcon(this.shader_, true, 10, 8, 1, 2);
        }

        public int hashCode() {
            int code = 3455;
            code = 23 * code + this.baseColor_.hashCode();
            code = 23 * code + this.shader_.hashCode();
            code = 23 * code + this.scaling_.hashCode();
            code = 23 * code + this.dataclip_.hashCode();
            code = 23 * code + (this.isY_ ? 19 : 101);
            code = 23 * code + this.kernelShape_.hashCode();
            code = 23 * code + this.combiner_.hashCode();
            code = 23 * code + this.sizer_.hashCode();
            code = 23 * code + this.cumul_.hashCode();
            code = 23 * code + this.extent_;
            code = 23 * code + Float.floatToIntBits((float)this.position_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof DensoStyle) {
                DensoStyle other = (DensoStyle)o;
                return this.baseColor_.equals(other.baseColor_) && this.shader_.equals(other.shader_) && this.scaling_.equals(other.scaling_) && this.dataclip_.equals(other.dataclip_) && this.isY_ == other.isY_ && this.kernelShape_.equals(other.kernelShape_) && this.combiner_.equals(other.combiner_) && this.sizer_.equals(other.sizer_) && this.cumul_ == other.cumul_ && this.extent_ == other.extent_ && this.position_ == other.position_;
            }
            return false;
        }
    }
}

