/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.MultiPointConfigKey;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.FloatingArrayCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.layer.ArrayShapePlotter;
import uk.ac.starlink.ttools.plot2.layer.MultiPointForm;
import uk.ac.starlink.ttools.plot2.layer.MultiPointScribe;
import uk.ac.starlink.ttools.plot2.layer.MultiPointShape;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.PixOutliner;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapePainter;
import uk.ac.starlink.ttools.plot2.layer.ShapeStyle;
import uk.ac.starlink.ttools.plot2.layer.XYArrayData;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;

public class ErrorArrayForm
implements ShapeForm {
    private final boolean hasX_;
    private final Coord[] extraCoords_;
    private final FloatingArrayCoord xsCoord_;
    private final FloatingArrayCoord ysCoord_;
    private final FloatingArrayCoord xsPosCoord_;
    private final FloatingArrayCoord ysPosCoord_;
    private final FloatingArrayCoord xsNegCoord_;
    private final FloatingArrayCoord ysNegCoord_;
    private final int icXs_;
    private final int icYs_;
    private final int icPxs_;
    private final int icNxs_;
    private final int icPys_;
    private final int icNys_;
    private final MultiPointConfigKey shapeKey_;
    private final ConfigKey<Integer> thickKey_;
    public static final ErrorArrayForm Y = new ErrorArrayForm(false);
    public static final ErrorArrayForm XY = new ErrorArrayForm(true);

    protected ErrorArrayForm(boolean hasX) {
        this.hasX_ = hasX;
        this.xsCoord_ = FloatingArrayCoord.X;
        this.ysCoord_ = FloatingArrayCoord.Y;
        int ic = 0;
        this.icXs_ = ic++;
        this.icYs_ = ic++;
        ArrayList<FloatingArrayCoord> extraCoords = new ArrayList<FloatingArrayCoord>();
        if (hasX) {
            this.xsPosCoord_ = ErrorArrayForm.createErrorsCoord("X", true);
            extraCoords.add(this.xsPosCoord_);
            this.xsNegCoord_ = ErrorArrayForm.createErrorsCoord("X", false);
            extraCoords.add(this.xsNegCoord_);
            this.icPxs_ = ic++;
            this.icNxs_ = ic++;
        } else {
            this.xsPosCoord_ = null;
            this.xsNegCoord_ = null;
            this.icPxs_ = -1;
            this.icNxs_ = -1;
        }
        this.ysPosCoord_ = ErrorArrayForm.createErrorsCoord("Y", true);
        extraCoords.add(this.ysPosCoord_);
        this.ysNegCoord_ = ErrorArrayForm.createErrorsCoord("Y", false);
        extraCoords.add(this.ysNegCoord_);
        this.icPys_ = ic++;
        this.icNys_ = ic++;
        this.extraCoords_ = extraCoords.toArray(new Coord[0]);
        assert (ic == this.extraCoords_.length + 2);
        this.shapeKey_ = hasX ? StyleKeys.ERROR_SHAPE_2D : StyleKeys.ERROR_SHAPE_1D;
        this.thickKey_ = MultiPointForm.createThicknessKey(this.shapeKey_);
    }

    @Override
    public int getBasicPositionCount() {
        return 0;
    }

    @Override
    public String getFormName() {
        return this.hasX_ ? "XYErrors" : "YErrors";
    }

    @Override
    public String getFormDescription() {
        return String.join((CharSequence)"\n", "<p>Plots <em>N</em> error bars in the", this.hasX_ ? "X and Y directions" : "Y direction", "for each input row,", "with the X, Y and error bar extents each supplied", "by <em>N</em>-element array values.", "</p>", "");
    }

    @Override
    public Icon getFormIcon() {
        return this.hasX_ ? ResourceIcon.FORM_ERROR : ResourceIcon.FORM_ERROR1;
    }

    @Override
    public Coord[] getExtraCoords() {
        return (Coord[])this.extraCoords_.clone();
    }

    @Override
    public int getExtraPositionCount() {
        return 0;
    }

    @Override
    public DataGeom adjustGeom(DataGeom geom, DataSpec dataSpec, ShapeStyle style) {
        return geom;
    }

    @Override
    public ConfigKey<?>[] getConfigKeys() {
        return new ConfigKey[]{this.shapeKey_, this.thickKey_};
    }

    @Override
    public Outliner createOutliner(ConfigMap config) {
        MultiPointShape shape = config.get(this.shapeKey_);
        int nthick = config.get(this.thickKey_);
        return new ErrorsOutliner(shape, nthick);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Glyph createErrorGlyph(Surface surface, MultiPointScribe scribe, double[] dpos0, Point2D.Double gpos0, int ip, double[] xsPos, double[] ysPos, double[] xsNeg, double[] ysNeg) {
        double[][] dp1s;
        double dx0 = dpos0[0];
        double dy0 = dpos0[1];
        if (!this.hasX_) {
            double[] yerrs = this.getErrors(ysPos, ysNeg, ip);
            if (yerrs == null) return null;
            dp1s = new double[][]{{dx0, dy0 + yerrs[0]}, {dx0, dy0 - yerrs[1]}};
            return ErrorArrayForm.createErrorGlyph(surface, dpos0, gpos0, dp1s, scribe);
        } else {
            double[] xerrs = this.getErrors(xsPos, xsNeg, ip);
            double[] yerrs = this.getErrors(ysPos, ysNeg, ip);
            if (xerrs != null && yerrs != null) {
                dp1s = new double[][]{{dx0, dy0 + yerrs[0]}, {dx0, dy0 - yerrs[1]}, {dx0 + xerrs[0], dy0}, {dx0 - xerrs[1], dy0}};
                return ErrorArrayForm.createErrorGlyph(surface, dpos0, gpos0, dp1s, scribe);
            } else if (yerrs != null) {
                dp1s = new double[][]{{dx0, dy0 + yerrs[0]}, {dx0, dy0 - yerrs[1]}};
                return ErrorArrayForm.createErrorGlyph(surface, dpos0, gpos0, dp1s, scribe);
            } else {
                if (xerrs == null) return null;
                dp1s = new double[][]{{dx0 + xerrs[0], dy0}, {dx0 - xerrs[1], dy0}};
            }
        }
        return ErrorArrayForm.createErrorGlyph(surface, dpos0, gpos0, dp1s, scribe);
    }

    private static Glyph createErrorGlyph(Surface surface, double[] dpos0, Point2D.Double gpos0, double[][] dp1s, MultiPointScribe scribe) {
        int np = dp1s.length;
        int[] xoffs = new int[np];
        int[] yoffs = new int[np];
        Point2D.Double gpos1 = new Point2D.Double();
        for (int ip = 0; ip < np; ++ip) {
            if (!surface.dataToGraphicsOffset(dpos0, gpos0, dp1s[ip], false, gpos1) || !PlotUtil.isPointReal(gpos1)) {
                return null;
            }
            xoffs[ip] = (int)Math.round(gpos1.x - gpos0.x);
            yoffs[ip] = (int)Math.round(gpos1.y - gpos0.y);
        }
        return scribe.createGlyph(xoffs, yoffs);
    }

    private double[] getErrors(double[] posErrs, double[] negErrs, int ip) {
        double[] dArray;
        double me;
        if (posErrs.length == 0) {
            return null;
        }
        double pErr = posErrs[ip];
        if (Double.isNaN(pErr)) {
            return null;
        }
        double mErr = negErrs.length > 0 ? (Double.isNaN(me = negErrs[ip]) ? pErr : me) : pErr;
        if (pErr > 0.0 || mErr > 0.0) {
            double[] dArray2 = new double[2];
            dArray2[0] = pErr;
            dArray = dArray2;
            dArray2[1] = mErr;
        } else {
            dArray = null;
        }
        return dArray;
    }

    private Function<Tuple, XYArrayData> createXYArrayReader(DataSpec dataSpec) {
        return ArrayShapePlotter.createXYArrayReader(this.xsCoord_, this.ysCoord_, this.icXs_, this.icYs_, dataSpec);
    }

    private static FloatingArrayCoord createErrorsCoord(String axId, boolean isPositive) {
        String axid = axId.toLowerCase();
        InputMeta meta = new InputMeta(axid + (isPositive ? "errhis" : "errlos"), axId + (isPositive ? " Positive" : " Negative") + " Errors");
        meta.setValueUsage("array");
        meta.setShortDescription("Errors in " + axId + " " + (isPositive ? "positive" : "negative") + " direction");
        String xmlDesc = isPositive ? String.join((CharSequence)"\n", "<p>Array of errors in the " + axId + " coordinates", "in the positive direction.", "If no corresponding negative value is supplied,", "then this value is also used in the negative direction,", "i.e. in that case errors are assumed to be symmetric.", "Error exents must be positive; negative array elements", "are ignored.", "</p>", "") : String.join((CharSequence)"\n", "<p>Array of errors in the " + axId + " coordinates", "in the negative direction.", "If left blank, it is assumed to take the same value", "as in the positive direction.", "Error extents must be positive; negative array elements", "are ignored.", "</p>", "");
        meta.setXmlDescription(xmlDesc);
        return FloatingArrayCoord.createCoord(meta, false);
    }

    private class ErrorsOutliner
    extends PixOutliner {
        private final MultiPointScribe scribe_;
        private final Icon icon_;

        ErrorsOutliner(MultiPointShape shape, int nthick) {
            this.scribe_ = shape.createScribe(nthick);
            ErrorMode[] emodes = new ErrorMode[]{ErrorArrayForm.this.hasX_ ? ErrorMode.SYMMETRIC : ErrorMode.NONE, ErrorMode.SYMMETRIC};
            this.icon_ = shape.getLegendIcon(this.scribe_, emodes, 14, 12, 1, 1);
        }

        @Override
        public Icon getLegendIcon() {
            return this.icon_;
        }

        @Override
        public Map<AuxScale, AuxReader> getAuxRangers(DataGeom geom) {
            return new HashMap<AuxScale, AuxReader>();
        }

        @Override
        public boolean canPaint(DataSpec dataSpec) {
            return ErrorArrayForm.this.createXYArrayReader(dataSpec) != null;
        }

        @Override
        public ShapePainter create2DPainter(final Surface surface, DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, final PaperType2D paperType) {
            final Function xyReader = ErrorArrayForm.this.createXYArrayReader(dataSpec);
            return new ShapePainter(){
                final double[] dpos0 = new double[2];
                final Point2D.Double gpos0 = new Point2D.Double();

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    XYArrayData xyData = (XYArrayData)xyReader.apply(tuple);
                    if (xyData != null) {
                        int np = xyData.getLength();
                        double[] xsPos = ErrorArrayForm.this.hasX_ ? ErrorArrayForm.this.xsPosCoord_.readArrayCoord(tuple, ErrorArrayForm.this.icPxs_) : null;
                        double[] ysPos = ErrorArrayForm.this.ysPosCoord_.readArrayCoord(tuple, ErrorArrayForm.this.icPys_);
                        double[] xsNeg = ErrorArrayForm.this.hasX_ ? ErrorArrayForm.this.xsNegCoord_.readArrayCoord(tuple, ErrorArrayForm.this.icNxs_) : null;
                        double[] ysNeg = ErrorArrayForm.this.ysNegCoord_.readArrayCoord(tuple, ErrorArrayForm.this.icNys_);
                        if (xsPos != null && xsPos.length == np || ysPos != null && ysPos.length == np) {
                            for (int ip = 0; ip < np; ++ip) {
                                Glyph glyph;
                                this.dpos0[0] = xyData.getX(ip);
                                this.dpos0[1] = xyData.getY(ip);
                                if (!surface.dataToGraphics(this.dpos0, true, this.gpos0) || (glyph = ErrorArrayForm.this.createErrorGlyph(surface, ErrorsOutliner.this.scribe_, this.dpos0, this.gpos0, ip, xsPos, ysPos, xsNeg, ysNeg)) == null) continue;
                                paperType.placeGlyph(paper, this.gpos0.x, this.gpos0.y, glyph, color);
                            }
                        }
                    }
                }
            };
        }

        @Override
        public ShapePainter create3DPainter(CubeSurface surface, DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, PaperType3D paperType) {
            throw new UnsupportedOperationException("No 3D");
        }

        public int hashCode() {
            int code = 53169;
            code = 23 * code + this.scribe_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof ErrorsOutliner) {
                ErrorsOutliner other = (ErrorsOutliner)o;
                return this.scribe_.equals(other.scribe_);
            }
            return false;
        }
    }
}

