/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Rectangle;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.layer.Pixers;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;

public abstract class GlyphPaper
implements Paper {
    private final Rectangle bounds_;
    private final GlyphPaperType paperType_;

    public GlyphPaper(Rectangle plotBounds) {
        this.bounds_ = new Rectangle(plotBounds);
        this.paperType_ = this.createGlyphPaperType();
    }

    public abstract void glyphPixels(Pixer var1);

    @Override
    public GlyphPaperType getPaperType() {
        return this.paperType_;
    }

    @Override
    public boolean canMerge() {
        return false;
    }

    @Override
    public Paper createSheet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void mergeSheet(Paper other) {
        throw new UnsupportedOperationException();
    }

    private GlyphPaperType createGlyphPaperType() {
        return new GlyphPaperType(){

            @Override
            public void placeGlyph(Paper paper, double dx, double dy, Glyph glyph, Color color) {
                int gx = PlotUtil.ifloor(dx);
                int gy = PlotUtil.ifloor(dy);
                Rectangle cbox = new Rectangle(GlyphPaper.this.bounds_);
                cbox.translate(-gx, -gy);
                Pixer pixer = glyph.createPixer(cbox);
                if (pixer != null) {
                    GlyphPaper.this.glyphPixels(Pixers.translate(pixer, gx, gy));
                }
            }

            @Override
            public void placeGlyph(Paper paper, double dx, double dy, double dz, Glyph glyph, Color color) {
                this.placeGlyph(paper, dx, dy, glyph, color);
            }

            @Override
            public boolean isBitmap() {
                return true;
            }

            @Override
            public void placeDecal(Paper paper, Decal decal) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Icon createDataIcon(Surface surface, Drawing[] drawing, Object[] plans, DataStore dataStore, boolean requireCached) {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static interface GlyphPaperType
    extends PaperType2D,
    PaperType3D {
    }
}

