/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.DoubleConfigKey;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.SliderSpecifier;
import uk.ac.starlink.ttools.plot2.config.Specifier;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.FloatingArrayCoord;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.layer.ArrayShapePlotter;
import uk.ac.starlink.ttools.plot2.layer.FatMarkerShapes;
import uk.ac.starlink.ttools.plot2.layer.MarkForm;
import uk.ac.starlink.ttools.plot2.layer.MarkerShape;
import uk.ac.starlink.ttools.plot2.layer.MarkerStyle;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.PixOutliner;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapePainter;
import uk.ac.starlink.ttools.plot2.layer.ShapeStyle;
import uk.ac.starlink.ttools.plot2.layer.XYArrayData;
import uk.ac.starlink.ttools.plot2.layer.XYArrayPlacement;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;

public class HandleArrayForm
implements ShapeForm {
    private final FloatingArrayCoord xsCoord_ = FloatingArrayCoord.X;
    private final FloatingArrayCoord ysCoord_ = FloatingArrayCoord.Y;
    private final int icXs_;
    private final int icYs_;
    public static final ConfigKey<XYArrayPlacement> PLACEMENT_KEY = HandleArrayForm.createPlacementKey();
    public static final ConfigKey<Double> FRACTION_KEY = HandleArrayForm.createFractionKey();
    public static final ConfigKey<MarkerShape> SHAPE_KEY = HandleArrayForm.createShapeKey();
    public static final ConfigKey<Integer> SIZE_KEY = HandleArrayForm.createSizeKey();
    private static final ReportKey<XYArrayPlacement> REPKEY_PLACEMENT = ReportKey.createObjectKey(new ReportMeta("placement", "Placement"), XYArrayPlacement.class, false);
    private static final HandleArrayForm instance_ = new HandleArrayForm();

    private HandleArrayForm() {
        this.icXs_ = 0;
        this.icYs_ = 1;
    }

    @Override
    public int getBasicPositionCount() {
        return 0;
    }

    @Override
    public Coord[] getExtraCoords() {
        return new Coord[0];
    }

    @Override
    public int getExtraPositionCount() {
        return 1;
    }

    @Override
    public String getFormName() {
        return "Handles";
    }

    @Override
    public Icon getFormIcon() {
        return ResourceIcon.FORM_HANDLES;
    }

    @Override
    public String getFormDescription() {
        return String.join((CharSequence)"\n", "<p>Draws a symbol representing the position of an X/Y array plot.", "Although this may not do a good job of showing the position", "for a whole X/Y array, which is line-like rather than point-like,", "it provides a visible reference position for the plotted row.", "</p>", "<p>This plot type is therefore mostly useful in", "interactive environments like TOPCAT,", "where the plotted marker can be used for activating or identifying", "the corresponding table row.", "</p>", "");
    }

    @Override
    public DataGeom adjustGeom(DataGeom geom, DataSpec dataSpec, ShapeStyle style) {
        HandleOutliner outliner = (HandleOutliner)style.getOutliner();
        XYArrayPlacement placement = outliner.placement_;
        double fraction = outliner.fraction_;
        Function<Tuple, XYArrayData> xyReader = this.createXYArrayReader(dataSpec);
        return xyReader == null ? geom : new XYArrayDataGeom(placement, fraction, xyReader);
    }

    @Override
    public ConfigKey<?>[] getConfigKeys() {
        return new ConfigKey[]{PLACEMENT_KEY, FRACTION_KEY, SIZE_KEY, SHAPE_KEY};
    }

    @Override
    public Outliner createOutliner(ConfigMap config) {
        XYArrayPlacement placement = config.get(PLACEMENT_KEY);
        double fraction = config.get(FRACTION_KEY);
        int size = config.get(SIZE_KEY);
        MarkerShape shape = config.get(SHAPE_KEY);
        return new HandleOutliner(placement, fraction, shape, size);
    }

    private Function<Tuple, XYArrayData> createXYArrayReader(DataSpec dataSpec) {
        return ArrayShapePlotter.createXYArrayReader(this.xsCoord_, this.ysCoord_, this.icXs_, this.icYs_, dataSpec);
    }

    public static HandleArrayForm getInstance() {
        return instance_;
    }

    private static ConfigKey<XYArrayPlacement> createPlacementKey() {
        ConfigMeta meta = new ConfigMeta("placement", "Placement");
        meta.setXmlDescription(new String[]{"<p>Determines where the handle will be positioned", "in relation to the X/Y array values.", "</p>"});
        XYArrayPlacement[] options = new XYArrayPlacement[]{XYArrayPlacement.INDEX, XYArrayPlacement.YMAX, XYArrayPlacement.YMIN, XYArrayPlacement.XMAX, XYArrayPlacement.XMIN, XYArrayPlacement.XYMEAN};
        OptionConfigKey<XYArrayPlacement> key = new OptionConfigKey<XYArrayPlacement>(meta, XYArrayPlacement.class, options){

            @Override
            public String getXmlDescription(XYArrayPlacement placement) {
                return placement.getDescription();
            }
        };
        key.setOptionUsage();
        key.addOptionsXml();
        return key;
    }

    private static ConfigKey<MarkerShape> createShapeKey() {
        ConfigMeta meta = new ConfigMeta("shape", "Shape");
        meta.setShortDescription("Marker shape");
        meta.setXmlDescription(new String[]{"<p>Sets the shape of the marker that is drawn", "to identify the handle position.", "</p>"});
        MarkerShape dfltShape = FatMarkerShapes.FAT_SQUARE;
        return StyleKeys.createMarkerShapeKey(meta, dfltShape);
    }

    private static ConfigKey<Integer> createSizeKey() {
        ConfigMeta meta = new ConfigMeta("size", "Size");
        meta.setStringUsage("<pixels>");
        meta.setShortDescription("Marker size in pixels");
        meta.setXmlDescription(new String[]{"<p>Sets the size of the marker that is drawn", "to identify the handle position.", "The unit is pixels, in most cases the marker", "is approximately twice the size of the supplied value.", "</p>"});
        return StyleKeys.createMarkSizeKey(meta, 4);
    }

    private static ConfigKey<Double> createFractionKey() {
        String fractionName = "fraction";
        String placementName = PLACEMENT_KEY.getMeta().getShortName();
        String indexPlacement = XYArrayPlacement.INDEX.getName().toLowerCase();
        ConfigMeta meta = new ConfigMeta(fractionName, "Fraction");
        meta.setStringUsage("<0..1>");
        meta.setShortDescription("Fractional position (0..1) for use with " + placementName + "=" + indexPlacement);
        meta.setXmlDescription(new String[]{"<p>Provides a numeric value in the range 0..1", "that may influence where the handle is placed.", "Currently, this is only relevant for", "<code>" + placementName + "=" + indexPlacement + "</code>,", "where it indicates how far through the array", "the reference (X,Y) position should be taken", "(0.0 means the first element, 1.0 means the last).", "For other values of", "<code>" + placementName + "</code>", "it is ignored.", "</p>"});
        final double lo = 0.0;
        final double hi = 1.0;
        final double dflt = 0.5;
        final boolean isLog = false;
        return new DoubleConfigKey(meta, dflt){

            @Override
            public Specifier<Double> createSpecifier() {
                return new SliderSpecifier(lo, hi, isLog, dflt){

                    @Override
                    public void submitReport(ReportMap reportMap) {
                        XYArrayPlacement placement = (XYArrayPlacement)reportMap.get(REPKEY_PLACEMENT);
                        boolean isEnabled = placement != null && placement.usesFraction();
                        this.getSlider().setEnabled(isEnabled);
                    }
                };
            }
        };
    }

    @Equality
    private class XYArrayDataGeom
    implements DataGeom {
        private final XYArrayPlacement placement_;
        private final double fraction_;
        private final Function<Tuple, XYArrayData> xyReader_;

        XYArrayDataGeom(XYArrayPlacement placement, double fraction, Function<Tuple, XYArrayData> xyReader) {
            this.placement_ = placement;
            this.fraction_ = fraction;
            this.xyReader_ = xyReader;
        }

        @Override
        public int getDataDimCount() {
            return 2;
        }

        @Override
        public Coord[] getPosCoords() {
            return new Coord[]{HandleArrayForm.this.xsCoord_, HandleArrayForm.this.ysCoord_};
        }

        @Override
        public String getVariantName() {
            return "XYArrayPlacement";
        }

        @Override
        public boolean readDataPos(Tuple tuple, int icol, double[] dpos) {
            XYArrayData xyData = this.xyReader_.apply(tuple);
            return xyData != null && this.placement_.readPosition(xyData, this.fraction_, dpos);
        }

        public int hashCode() {
            int code = 4623423;
            code = 23 * code + this.placement_.hashCode();
            if (this.placement_.usesFraction()) {
                code = 23 * code + Double.hashCode(this.fraction_);
            }
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof XYArrayDataGeom) {
                XYArrayDataGeom other = (XYArrayDataGeom)o;
                return this.placement_.equals(other.placement_) && (!this.placement_.usesFraction() || this.fraction_ == other.fraction_);
            }
            return false;
        }
    }

    private class HandleOutliner
    extends PixOutliner {
        private final XYArrayPlacement placement_;
        private final double fraction_;
        private final MarkerStyle markerStyle_;
        private final Glyph glyph_;
        private final Icon icon_;

        HandleOutliner(XYArrayPlacement placement, double fraction, MarkerShape shape, int size) {
            this.placement_ = placement;
            this.fraction_ = fraction;
            this.markerStyle_ = MarkForm.createMarkStyle(shape, size);
            this.glyph_ = MarkForm.createMarkGlyph(shape, size, true);
            this.icon_ = MarkForm.createLegendIcon(shape, size);
        }

        @Override
        public Icon getLegendIcon() {
            return this.icon_;
        }

        @Override
        public Map<AuxScale, AuxReader> getAuxRangers(DataGeom geom) {
            return new HashMap<AuxScale, AuxReader>();
        }

        @Override
        public boolean canPaint(DataSpec dataSpec) {
            return HandleArrayForm.this.createXYArrayReader(dataSpec) != null;
        }

        @Override
        public ShapePainter create2DPainter(Surface surface, DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, PaperType2D paperType) {
            Point2D.Double gp = new Point2D.Double();
            double[] dpos = new double[2];
            return (tuple, color, paper) -> {
                if (geom.readDataPos(tuple, 0, dpos) && surface.dataToGraphics(dpos, true, gp)) {
                    paperType.placeGlyph(paper, gp.x, gp.y, this.glyph_, color);
                }
            };
        }

        @Override
        public ShapePainter create3DPainter(CubeSurface surf, DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, PaperType3D paperType) {
            throw new UnsupportedOperationException("no 3D");
        }

        @Override
        public ReportMap getReport(Object binPlan) {
            ReportMap map = super.getReport(binPlan);
            if (map == null) {
                map = new ReportMap();
            }
            map.put(REPKEY_PLACEMENT, this.placement_);
            return map;
        }

        public int hashCode() {
            int code = 766025;
            code = 23 * code + this.placement_.hashCode();
            if (this.placement_.usesFraction()) {
                code = 23 * code + Double.hashCode(this.fraction_);
            }
            code = 23 * code + this.markerStyle_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof HandleOutliner) {
                HandleOutliner other = (HandleOutliner)o;
                return this.placement_.equals(other.placement_) && (!this.placement_.usesFraction() || this.fraction_ == other.fraction_) && this.markerStyle_.equals(other.markerStyle_);
            }
            return false;
        }
    }
}

