/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.IteratorRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.BarStyle;
import uk.ac.starlink.ttools.plot.Range;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.Axis;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Scale;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.DoubleConfigKey;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.PerUnitConfigKey;
import uk.ac.starlink.ttools.plot2.config.SliderSpecifier;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.PlanarSurface;
import uk.ac.starlink.ttools.plot2.geom.SliceDataGeom;
import uk.ac.starlink.ttools.plot2.geom.TimeDataGeom;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.BinBag;
import uk.ac.starlink.ttools.plot2.layer.BinSizer;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.Cumulation;
import uk.ac.starlink.ttools.plot2.layer.Normalisation;
import uk.ac.starlink.ttools.plot2.layer.Unit;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.util.SplitCollector;

public class HistogramPlotter
implements Plotter<HistoStyle> {
    private final FloatingCoord xCoord_;
    private final FloatingCoord weightCoord_;
    private final ConfigKey<Unit> unitKey_;
    private final ConfigKey<Combiner> combinerKey_;
    private final ReportKey<Combiner.Type> ctypeRepkey_;
    private final CoordGroup histoCoordGrp_;
    private final int icX_;
    private final int icWeight_;
    private final boolean isTimeX_;
    public static final ReportKey<BinBag> BINS_KEY = ReportKey.createUnprintableKey(new ReportMeta("bins", "Bins"), BinBag.class);
    public static final ReportKey<Double> BINWIDTH_KEY = ReportKey.createDoubleKey(new ReportMeta("binwidth", "Bin Width"), false);
    public static final ReportKey<StarTable> BINTABLE_KEY = ReportKey.createTableKey(new ReportMeta("bins", "Bin data"), true);
    public static final ConfigKey<BinSizer> BINSIZER_KEY = BinSizer.createSizerConfigKey(new ConfigMeta("binsize", "Bin Size").setStringUsage("+<width>|-<count>").setShortDescription("Bin size specification").setXmlDescription(new String[]{"<p>Configures the width of histogram bins.", "If the supplied string is a positive number,", "it is interpreted as a fixed width in the data coordinates", "of the X axis", "(if the X axis is logarithmic, the value is a fixed factor).", "If it is a negative number, then it will be interpreted", "as the approximate number of bins to display across", "the width of the plot", "(though an attempt is made to use only round numbers", "for bin widths).", "</p>", "<p>When setting this value graphically,", "you can use either the slider to adjust the bin count", "or the numeric entry field to fix the bin width.", "</p>"}), BINWIDTH_KEY, 30, false);
    public static final ConfigKey<Integer> THICK_KEY = StyleKeys.createThicknessKey(2);
    public static final ConfigKey<Double> PHASE_KEY = DoubleConfigKey.createSliderKey(new ConfigMeta("phase", "Bin Phase").setShortDescription("Horizontal zero point").setXmlDescription(new String[]{"<p>Controls where the horizontal zero point for binning", "is set.", "For instance if your bin size is 1,", "this value controls whether bin boundaries are at", "0, 1, 2, .. or 0.5, 1.5, 2.5, ... etc.", "</p>", "<p>A value of 0 (or any integer) will result in", "a bin boundary at X=0 (linear X axis)", "or X=1 (logarithmic X axis).", "A fractional value will give a bin boundary at", "that value multiplied by the bin width.", "</p>"}), 0.0, 0.0, 1.0, false, false, SliderSpecifier.TextOption.ENTER_ECHO);
    private static final AffineTransform XY_TRANSFORM = new AffineTransform(0.0f, 1.0f, 1.0f, 0.0f, 0.0f, 0.0f);

    public HistogramPlotter(FloatingCoord xCoord, boolean hasWeight, PerUnitConfigKey<Unit> unitKey) {
        this.xCoord_ = xCoord;
        this.unitKey_ = unitKey;
        ReportKey<Combiner.Type> reportKey = this.ctypeRepkey_ = unitKey == null ? null : unitKey.getCombinerTypeReportKey();
        if (hasWeight) {
            this.weightCoord_ = FloatingCoord.WEIGHT_COORD;
            this.histoCoordGrp_ = CoordGroup.createPartialCoordGroup(new Coord[]{xCoord, this.weightCoord_}, new boolean[]{true, true});
        } else {
            this.weightCoord_ = null;
            this.histoCoordGrp_ = CoordGroup.createPartialCoordGroup(new Coord[]{xCoord}, new boolean[]{true});
        }
        this.combinerKey_ = HistogramPlotter.createCombinerKey(this.weightCoord_, unitKey);
        this.icX_ = this.histoCoordGrp_.getExtraCoordIndex(0, null);
        this.icWeight_ = hasWeight ? this.histoCoordGrp_.getExtraCoordIndex(1, null) : -1;
        this.isTimeX_ = xCoord == TimeDataGeom.T_COORD;
    }

    @Override
    public String getPlotterName() {
        return "Histogram";
    }

    @Override
    public Icon getPlotterIcon() {
        return ResourceIcon.FORM_HISTOGRAM;
    }

    @Override
    public String getPlotterDescription() {
        String weightPara = this.weightCoord_ != null ? PlotUtil.concatLines(new String[]{"<p>Bin heights may optionally be weighted by the", "values of some additional coordinate,", "supplied using the", "<code>" + this.weightCoord_.getInput().getMeta().getShortName() + "</code>", "parameter.", "In this case you can choose how these weights are combined", "in each bin using the", "<code>" + this.combinerKey_.getMeta().getShortName() + "</code>", "parameter.", "</p>"}) : "";
        return PlotUtil.concatLines(new String[]{"<p>Plots a histogram.", "</p>", weightPara, "<p>Various options are provided for configuring how the", "bar heights are calculated,", "but note that not all combinations of the available parameters", "will necessarily lead to meaningful visualisations.", "</p>"});
    }

    @Override
    public CoordGroup getCoordGroup() {
        return this.histoCoordGrp_;
    }

    @Override
    public ConfigKey<?>[] getStyleKeys() {
        ArrayList<ConfigKey> list = new ArrayList<ConfigKey>();
        list.addAll(Arrays.asList(StyleKeys.COLOR, StyleKeys.TRANSPARENCY, BINSIZER_KEY, PHASE_KEY));
        list.add(this.combinerKey_);
        if (this.unitKey_ != null) {
            list.add(this.unitKey_);
        }
        list.addAll(Arrays.asList(StyleKeys.SIDEWAYS, StyleKeys.CUMULATIVE, StyleKeys.NORMALISE, StyleKeys.BAR_FORM, THICK_KEY, StyleKeys.DASH));
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public HistoStyle createStyle(ConfigMap config) {
        Color color = StyleKeys.getAlphaColor(config, StyleKeys.COLOR, StyleKeys.TRANSPARENCY);
        BarStyle.Form barForm = config.get(StyleKeys.BAR_FORM);
        BarStyle.Placement placement = BarStyle.PLACE_OVER;
        Cumulation cumulative = config.get(StyleKeys.CUMULATIVE);
        Normalisation norm = config.get(StyleKeys.NORMALISE);
        Unit unit = this.unitKey_ == null ? Unit.UNIT : config.get(this.unitKey_);
        int thick = config.get(THICK_KEY);
        float[] dash = config.get(StyleKeys.DASH);
        BinSizer sizer = config.get(BINSIZER_KEY);
        double binPhase = config.get(PHASE_KEY);
        Combiner combiner = config.get(this.combinerKey_);
        boolean isY = config.get(StyleKeys.SIDEWAYS);
        return new HistoStyle(color, barForm, placement, cumulative, norm, unit, thick, dash, sizer, binPhase, combiner, isY);
    }

    @Override
    public Object getRangeStyleKey(HistoStyle style) {
        return Arrays.asList(new Object[]{style.combiner_, style.sizer_, style.cumulative_, style.norm_});
    }

    @Override
    public boolean hasReports() {
        return true;
    }

    @Override
    public PlotLayer createLayer(DataGeom geom, final DataSpec dataSpec, final HistoStyle style) {
        if (dataSpec == null || style == null) {
            return null;
        }
        final double binPhase = style.phase_;
        final BinSizer sizer = style.sizer_;
        final Combiner combiner = style.combiner_;
        final Cumulation cumul = style.cumulative_;
        final Normalisation norm = style.norm_;
        final Unit unit = style.unit_;
        final boolean hasWeight = this.weightCoord_ != null && !dataSpec.isCoordBlank(this.icWeight_);
        Color color = style.color_;
        final boolean isOpaque = color.getAlpha() == 255 && style.barForm_.isOpaque();
        LayerOpt layerOpt = new LayerOpt(color, isOpaque);
        final boolean isY = style.isY_;
        SliceDataGeom histoDataGeom = isY ? new SliceDataGeom(new FloatingCoord[]{null, this.xCoord_}, "Y") : new SliceDataGeom(new FloatingCoord[]{this.xCoord_, null}, "X");
        return new AbstractPlotLayer(this, histoDataGeom, dataSpec, style, layerOpt){

            @Override
            public Drawing createDrawing(Surface surface, Map<AuxScale, Span> auxSpans, final PaperType paperType) {
                if (!(surface instanceof PlanarSurface)) {
                    throw new IllegalArgumentException("Not planar surface " + surface);
                }
                final PlanarSurface pSurf = (PlanarSurface)surface;
                Axis xAxis = pSurf.getAxes()[isY ? 1 : 0];
                final Scale xscale = xAxis.getScale();
                double[] xlimits = xAxis.getDataLimits();
                final double xlo = xlimits[0];
                final double xhi = xlimits[1];
                final double binWidth = sizer.getScaleWidth(xscale, xlo, xhi, true);
                boolean iseq = false;
                boolean nseq = true;
                return new Drawing(){

                    @Override
                    public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
                        for (int ip = 0; ip < knownPlans.length; ++ip) {
                            HistoPlan plan;
                            if (!(knownPlans[ip] instanceof HistoPlan) || !(plan = (HistoPlan)knownPlans[ip]).matches(xscale, binWidth, binPhase, combiner, dataSpec)) continue;
                            return plan;
                        }
                        BinBag binBag = HistogramPlotter.this.readBins(xscale, binWidth, binPhase, combiner, xlo, xhi, dataSpec, dataStore);
                        return new HistoPlan(binBag, dataSpec);
                    }

                    @Override
                    public void paintData(Object plan, Paper paper, DataStore dataStore) {
                        HistoPlan hPlan = (HistoPlan)plan;
                        final BinBag binBag = hPlan.binBag_;
                        paperType.placeDecal(paper, new Decal(){

                            @Override
                            public void paintDecal(Graphics g) {
                                HistogramPlotter.this.paintBins(pSurf, binBag, style, 0, 1, g);
                            }

                            @Override
                            public boolean isOpaque() {
                                return isOpaque;
                            }
                        });
                    }

                    @Override
                    public ReportMap getReport(Object plan) {
                        ReportMap report = new ReportMap();
                        if (plan instanceof HistoPlan) {
                            HistoPlan hplan = (HistoPlan)plan;
                            BinBag bbag = hplan.binBag_;
                            report.put(BINS_KEY, bbag);
                            report.put(BINWIDTH_KEY, bbag.getBinWidth());
                            report.put(BINTABLE_KEY, new BinBagTable(hplan, style, hasWeight, xscale, xlo, xhi));
                            if (HistogramPlotter.this.ctypeRepkey_ != null) {
                                report.put(HistogramPlotter.this.ctypeRepkey_, bbag.getCombiner().getType());
                            }
                        }
                        return report;
                    }
                };
            }

            @Override
            public void extendCoordinateRanges(Range[] ranges, Scale[] scales, DataStore dataStore) {
                Range xRange = ranges[isY ? 1 : 0];
                Range yRange = ranges[isY ? 0 : 1];
                Scale xscale = scales[isY ? 1 : 0];
                double[] xlimits = xRange.getFiniteBounds(xscale.isPositiveDefinite());
                double xlo = xlimits[0];
                double xhi = xlimits[1];
                double binWidth = sizer.getScaleWidth(xscale, xlo, xhi, true);
                BinBag binBag = HistogramPlotter.this.readBins(xscale, binWidth, binPhase, combiner, xlo, xhi, dataSpec, dataStore);
                yRange.submit(0.0);
                Iterator<BinBag.Bin> it = binBag.binIterator(cumul, norm, unit, xlimits);
                while (it.hasNext()) {
                    BinBag.Bin bin = it.next();
                    double y = bin.getY();
                    if (y == 0.0) continue;
                    yRange.submit(y);
                    xRange.submit(bin.getXMin());
                    xRange.submit(bin.getXMax());
                }
            }
        };
    }

    public int getWeightCoordIndex() {
        return this.icWeight_;
    }

    private BinBag readBins(final Scale xscale, final double binWidth, final double binPhase, final Combiner combiner, double xlo, double xhi, DataSpec dataSpec, DataStore dataStore) {
        final double point = PlotUtil.scaleValue(xlo, xhi, 0.5, xscale);
        final boolean isUnweighted = this.weightCoord_ == null || dataSpec.isCoordBlank(this.icWeight_);
        SplitCollector<TupleSequence, BinBag> collector = new SplitCollector<TupleSequence, BinBag>(){

            public BinBag createAccumulator() {
                return new BinBag(xscale, binWidth, binPhase, combiner, point);
            }

            public void accumulate(TupleSequence tseq, BinBag binBag) {
                if (isUnweighted) {
                    while (tseq.next()) {
                        double x = HistogramPlotter.this.xCoord_.readDoubleCoord(tseq, HistogramPlotter.this.icX_);
                        binBag.submitToBin(x, 1.0);
                    }
                } else {
                    while (tseq.next()) {
                        double x = HistogramPlotter.this.xCoord_.readDoubleCoord(tseq, HistogramPlotter.this.icX_);
                        double w = HistogramPlotter.this.weightCoord_.readDoubleCoord(tseq, HistogramPlotter.this.icWeight_);
                        if (Double.isNaN(w)) continue;
                        binBag.submitToBin(x, w);
                    }
                }
            }

            public BinBag combine(BinBag bag1, BinBag bag2) {
                if (bag1.getBinCount() > bag2.getBinCount()) {
                    bag1.add(bag2);
                    return bag1;
                }
                bag2.add(bag1);
                return bag2;
            }
        };
        return PlotUtil.tupleCollect(collector, dataSpec, dataStore);
    }

    private void paintBins(PlanarSurface surface, BinBag binBag, HistoStyle style, int iseq, int nseq, Graphics g) {
        Color color0 = g.getColor();
        g.setColor(style.color_);
        BarStyle barStyle = style.barStyle_;
        Cumulation cumul = style.cumulative_;
        Normalisation norm = style.norm_;
        Unit unit = style.unit_;
        boolean isY = style.isY_;
        Axis xAxis = surface.getAxes()[isY ? 1 : 0];
        Axis yAxis = surface.getAxes()[isY ? 0 : 1];
        int xClipMin = xAxis.getGraphicsLimits()[0] - 64;
        int xClipMax = xAxis.getGraphicsLimits()[1] + 64;
        int yClipMin = yAxis.getGraphicsLimits()[0] - 64;
        int yClipMax = yAxis.getGraphicsLimits()[1] + 64;
        double dxMin = xAxis.getDataLimits()[0];
        double dxMax = xAxis.getDataLimits()[1];
        boolean xflip = surface.getFlipFlags()[isY ? 1 : 0];
        boolean yposdef = yAxis.getScale().isPositiveDefinite();
        int lastGx1 = xflip ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        int lastGy1 = 0;
        int commonGy0 = 0;
        Iterator<BinBag.Bin> binIt = binBag.binIterator(cumul, norm, unit, new double[]{dxMin, dxMax});
        while (binIt.hasNext()) {
            BinBag.Bin bin = binIt.next();
            double dxlo = bin.getXMin();
            double dxhi = bin.getXMax();
            double dy = bin.getY();
            if (!(dxlo <= dxMax) || !(dxhi >= dxMin) || !cumul.isCumulative() && dy == 0.0) continue;
            double p0x = xAxis.dataToGraphics(dxlo);
            double p0y = yAxis.dataToGraphics(yposdef ? Double.MIN_VALUE : 0.0);
            double p1x = xAxis.dataToGraphics(dxhi);
            double p1y = yAxis.dataToGraphics(dy);
            if (Double.isNaN(p0x) || Double.isNaN(p0y) || Double.isNaN(p1x) || Double.isNaN(p1y)) continue;
            int gx0 = HistogramPlotter.clip((int)p0x, xClipMin, xClipMax);
            int gx1 = HistogramPlotter.clip((int)p1x, xClipMin, xClipMax);
            int gy0 = HistogramPlotter.clip((int)p0y, yClipMin, yClipMax);
            int gy1 = HistogramPlotter.clip((int)p1y, yClipMin, yClipMax);
            if (lastGx1 != gx0) {
                HistogramPlotter.drawEdge(barStyle, g, isY, lastGx1, lastGy1, gy0, iseq, nseq);
                lastGy1 = gy0;
            }
            HistogramPlotter.drawEdge(barStyle, g, isY, gx0, lastGy1, gy1, iseq, nseq);
            lastGx1 = gx1;
            lastGy1 = gy1;
            commonGy0 = gy0;
            int gxlo = gx0 < gx1 ? gx0 : gx1;
            int gxhi = gx0 < gx1 ? gx1 : gx0;
            HistogramPlotter.drawBar(barStyle, g, isY, gxlo, gxhi, gy0, gy1, iseq, nseq);
        }
        if (!cumul.isCumulative()) {
            HistogramPlotter.drawEdge(barStyle, g, isY, lastGx1, lastGy1, commonGy0, iseq, nseq);
        }
        g.setColor(color0);
    }

    private static int clip(int p, int lo, int hi) {
        return Math.max(Math.min(p, hi), lo);
    }

    private static void drawBar(BarStyle barStyle, Graphics g, boolean isY, int xlo, int xhi, int y0, int y1, int iseq, int nseq) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform trans0 = g2.getTransform();
        if (isY) {
            g2.transform(XY_TRANSFORM);
        }
        if (y0 >= y1) {
            barStyle.drawBar(g, xlo, xhi, y1, y0, iseq, nseq);
        } else {
            g2.translate(0, y0 + y1);
            g2.scale(1.0, -1.0);
            barStyle.drawBar(g, xlo, xhi, y0, y1, iseq, nseq);
        }
        g2.setTransform(trans0);
    }

    private static void drawEdge(BarStyle barStyle, Graphics g, boolean isY, int x, int y0, int y1, int iseq, int nseq) {
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform trans0 = g2.getTransform();
        if (isY) {
            g2.transform(XY_TRANSFORM);
        }
        barStyle.drawEdge(g, x, y0, y1, iseq, nseq);
        g2.setTransform(trans0);
    }

    private static ConfigKey<Combiner> createCombinerKey(FloatingCoord weightCoord, ConfigKey<Unit> unitKey) {
        ConfigMeta meta = new ConfigMeta("combine", "Combine");
        boolean hasWeight = weightCoord != null;
        boolean hasUnit = unitKey != null;
        meta.setShortDescription((hasWeight ? "Weight" : "Value") + " combination mode");
        StringBuffer dbuf = new StringBuffer();
        dbuf.append(PlotUtil.concatLines(new String[]{"<p>Defines how values contributing to the same bin", "are combined together to produce the value assigned to that bin,", "and hence its height."}));
        if (hasWeight) {
            dbuf.append(PlotUtil.concatLines(new String[]{"The combined values are those given by the", "<code>" + weightCoord.getInput().getMeta().getShortName() + "</code> coordinate,", "but if no weight is supplied,", "a weighting of unity is assumed."}));
        }
        dbuf.append("</p>\n");
        if (hasUnit) {
            dbuf.append(PlotUtil.concatLines(new String[]{"<p>For density-like values", "(<code>" + Combiner.DENSITY + "</code>,", "<code>" + Combiner.WEIGHTED_DENSITY + "</code>)", "the scaling is additionally influenced by the", "<code>" + unitKey.getMeta().getShortName() + "</code>", "parameter.", "</p>"}));
        }
        meta.setXmlDescription(dbuf.toString());
        ArrayList<Combiner> optionList = new ArrayList<Combiner>();
        for (Combiner c : Combiner.getKnownCombiners()) {
            if (!hasWeight && Combiner.Type.INTENSIVE.equals((Object)c.getType())) continue;
            optionList.add(c);
        }
        Combiner[] options = optionList.toArray(new Combiner[0]);
        OptionConfigKey<Combiner> key = new OptionConfigKey<Combiner>(meta, Combiner.class, options, Combiner.SUM){

            @Override
            public String getXmlDescription(Combiner combiner) {
                return combiner.getDescription();
            }
        };
        key.setOptionUsage();
        key.addOptionsXml();
        return key;
    }

    private static class HistoPlan {
        final BinBag binBag_;
        final DataSpec dataSpec_;

        HistoPlan(BinBag binBag, DataSpec dataSpec) {
            this.binBag_ = binBag;
            this.dataSpec_ = dataSpec;
        }

        boolean matches(Scale xscale, double binWidth, double binPhase, Combiner combiner, DataSpec dataSpec) {
            return this.binBag_.matches(xscale, binWidth, binPhase, combiner) && this.dataSpec_.equals(dataSpec);
        }
    }

    public static class HistoStyle
    implements Style {
        private final Color color_;
        private final BarStyle.Form barForm_;
        private final BarStyle.Placement placement_;
        private final Cumulation cumulative_;
        private final Normalisation norm_;
        private final Unit unit_;
        private final int thick_;
        private final float[] dash_;
        private final BinSizer sizer_;
        private final double phase_;
        private final Combiner combiner_;
        private final boolean isY_;
        private final BarStyle barStyle_;

        public HistoStyle(Color color, BarStyle.Form barForm, BarStyle.Placement placement, Cumulation cumulative, Normalisation norm, Unit unit, int thick, float[] dash, BinSizer sizer, double phase, Combiner combiner, boolean isY) {
            this.color_ = color;
            this.barForm_ = barForm;
            this.placement_ = placement;
            this.cumulative_ = cumulative;
            this.norm_ = norm;
            this.unit_ = unit;
            this.thick_ = thick;
            this.dash_ = dash;
            this.sizer_ = sizer;
            this.phase_ = phase;
            this.combiner_ = combiner;
            this.isY_ = isY;
            this.barStyle_ = new BarStyle(color, barForm, placement);
            this.barStyle_.setLineWidth(thick);
            this.barStyle_.setDash(dash);
        }

        public BinSizer getBinSizer() {
            return this.sizer_;
        }

        public Cumulation getCumulative() {
            return this.cumulative_;
        }

        public Normalisation getNormalisation() {
            return this.norm_;
        }

        public Unit getUnit() {
            return this.unit_;
        }

        public Combiner getCombiner() {
            return this.combiner_;
        }

        @Override
        public Icon getLegendIcon() {
            return this.barStyle_;
        }

        public int hashCode() {
            int code = 55012;
            code = 23 * code + this.color_.hashCode();
            code = 23 * code + this.barForm_.hashCode();
            code = 23 * code + this.placement_.hashCode();
            code = 23 * code + this.cumulative_.hashCode();
            code = 23 * code + PlotUtil.hashCode(this.norm_);
            code = 23 * code + this.unit_.hashCode();
            code = 23 * code + this.thick_;
            code = 23 * code + Arrays.hashCode(this.dash_);
            code = 23 * code + this.sizer_.hashCode();
            code = 23 * code + Float.floatToIntBits((float)this.phase_);
            code = 23 * code + this.combiner_.hashCode();
            code = 23 * code + (this.isY_ ? 99 : 103);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof HistoStyle) {
                HistoStyle other = (HistoStyle)o;
                return this.color_.equals(other.color_) && this.barForm_.equals(other.barForm_) && this.placement_.equals(other.placement_) && this.cumulative_ == other.cumulative_ && PlotUtil.equals(this.norm_, other.norm_) && this.unit_.equals(other.unit_) && this.thick_ == other.thick_ && Arrays.equals(this.dash_, other.dash_) && this.sizer_.equals(other.sizer_) && this.phase_ == other.phase_ && this.combiner_.equals(other.combiner_) && this.isY_ == other.isY_;
            }
            return false;
        }
    }

    private static class BinBagTable
    extends AbstractStarTable {
        private final BinBag binBag_;
        private final HistoStyle hstyle_;
        private final Scale xscale_;
        private final double xlo_;
        private final double xhi_;
        private final ColumnInfo xmidInfo_;
        private final ColumnInfo xminInfo_;
        private final ColumnInfo xmaxInfo_;
        private final ColumnInfo yInfo_;
        private final ColumnInfo[] colInfos_;

        BinBagTable(HistoPlan hplan, HistoStyle hstyle, boolean hasWeight, Scale xscale, double xlo, double xhi) {
            this.binBag_ = hplan.binBag_;
            this.hstyle_ = hstyle;
            this.xscale_ = xscale;
            this.xlo_ = xlo;
            this.xhi_ = xhi;
            Combiner combiner = hstyle.getCombiner();
            String yName = "Y_" + (hasWeight ? combiner.getName() : "COUNT");
            this.xmidInfo_ = new ColumnInfo("XMID", Double.class, "Bin midpoint");
            this.xminInfo_ = new ColumnInfo("XLOW", Double.class, "Bin lower bound");
            this.xmaxInfo_ = new ColumnInfo("XHIGH", Double.class, "Bin upper bound");
            this.yInfo_ = new ColumnInfo(yName, Double.class, "Bin height");
            this.colInfos_ = new ColumnInfo[]{this.xmidInfo_, this.yInfo_, this.xminInfo_, this.xmaxInfo_};
        }

        public int getColumnCount() {
            return this.colInfos_.length;
        }

        public ColumnInfo getColumnInfo(int icol) {
            return this.colInfos_[icol];
        }

        public long getRowCount() {
            return -1L;
        }

        public RowSequence getRowSequence() {
            final Iterator<BinBag.Bin> binIt = this.binBag_.binIterator(this.hstyle_.getCumulative(), this.hstyle_.getNormalisation(), this.hstyle_.getUnit(), new double[]{this.xlo_, this.xhi_});
            Iterator<Object[]> rowIt = new Iterator<Object[]>(){

                @Override
                public boolean hasNext() {
                    return binIt.hasNext();
                }

                @Override
                public Object[] next() {
                    BinBag.Bin bin = (BinBag.Bin)binIt.next();
                    double xmin = bin.getXMin();
                    double xmax = bin.getXMax();
                    double xmid = PlotUtil.scaleValue(xmin, xmax, 0.5, xscale_);
                    return new Object[]{xmid, bin.getY(), xmin, xmax};
                }

                @Override
                public void remove() {
                    binIt.remove();
                }
            };
            return new IteratorRowSequence((Iterator)rowIt);
        }
    }
}

