/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Ranger;
import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.RampKeySet;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotter;
import uk.ac.starlink.ttools.plot2.layer.AuxColorKit;
import uk.ac.starlink.ttools.plot2.layer.AuxLineStyle;
import uk.ac.starlink.ttools.plot2.layer.ColorKit;
import uk.ac.starlink.ttools.plot2.layer.FixedColorKit;
import uk.ac.starlink.ttools.plot2.layer.LineTracer3D;
import uk.ac.starlink.ttools.plot2.layer.UnplannedDrawing;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;
import uk.ac.starlink.util.SplitCollector;

public class Line3dPlotter
extends AbstractPlotter<AuxLineStyle> {
    private static final FloatingCoord AUX_COORD = FloatingCoord.createCoord(new InputMeta("aux", "Aux").setShortDescription("Auxiliary colour coordinate").setXmlDescription(new String[]{"<p>If supplied, this adjusts the colouring of the line", "along its length according to the value of this coordinate.", "</p>"}), false);
    private static final FloatingCoord SORT_COORD = FloatingCoord.createCoord(new InputMeta("sort", "Sort").setShortDescription("Sorting sequence for plotted lines").setXmlDescription(new String[]{"<p>If supplied, this gives a value to define in what order", "points are joined together.", "If no value is given, the natural order is used,", "i.e. the sequence of rows in the table.", "</p>", "<p>Note that if the required order is in fact the natural", "order of the table, it is better to leave this value blank,", "since sorting is a potentially expensive step.", "</p>"}), false);
    private final boolean reportAuxKeys_ = false;
    private static final AuxScale SCALE = AuxScale.COLOR;
    private static final RampKeySet RAMP_KEYS = StyleKeys.AUX_RAMP;
    private static final boolean IS_OPAQUE = true;
    public static final ConfigKey<Integer> THICK_KEY = StyleKeys.createThicknessKey(1);

    public Line3dPlotter() {
        super("Line3d", ResourceIcon.PLOT_LINE, 1, new Coord[]{AUX_COORD, SORT_COORD});
    }

    @Override
    public String getPlotterDescription() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(PlotUtil.concatLines(new String[]{"<p>Plots a point-to-point line joining", "up the positions of data points in three dimensions.", "There are additional options to pre-sort the points", "by a given quantity before drawing the lines", "(using the <code>" + SORT_COORD.getInput().getMeta().getShortName() + "</code> value),", "and to vary the colour of the line along its length", "(using the <code>" + AUX_COORD.getInput().getMeta().getShortName() + "</code> value)."}));
        sbuf.append(PlotUtil.concatLines(new String[]{"The options for controlling the Aux colour map", "are controlled at the level of the plot itself,", "rather than by per-layer configuration."}));
        sbuf.append("</p>");
        sbuf.append(PlotUtil.concatLines(new String[]{"<p>Note that the line positioning in 3d and the line segment", "aux colouring is somewhat approximate.", "In most cases it is good enough for visual inspection,", "but pixel-level examination may reveal discrepancies.", "</p>"}));
        return sbuf.toString();
    }

    @Override
    public ConfigKey<?>[] getStyleKeys() {
        ArrayList<ConfigKey<Serializable>> list = new ArrayList<ConfigKey<Serializable>>();
        list.add(StyleKeys.COLOR);
        list.add(THICK_KEY);
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public AuxLineStyle createStyle(ConfigMap config) {
        Color color = config.get(StyleKeys.COLOR);
        int thick = config.get(THICK_KEY);
        BasicStroke stroke = new BasicStroke(thick, 1, 1);
        boolean antialias = false;
        RampKeySet.Ramp ramp = RAMP_KEYS.createValue(config);
        Shader shader = ramp.getShader();
        Scaling scaling = ramp.getScaling();
        Subrange dataclip = ramp.getDataClip();
        Color nullColor = config.get(StyleKeys.AUX_NULLCOLOR);
        return new AuxLineStyle(color, stroke, antialias, shader, scaling, dataclip, nullColor);
    }

    @Override
    public PlotLayer createLayer(final DataGeom geom, final DataSpec dataSpec, final AuxLineStyle style) {
        CoordGroup cgrp = this.getCoordGroup();
        final int icPos = cgrp.getPosCoordIndex(0, geom);
        final int icAux = cgrp.getExtraCoordIndex(0, geom);
        final int icSort = cgrp.getExtraCoordIndex(1, geom);
        final boolean hasAux = !dataSpec.isCoordBlank(icAux);
        final boolean hasSort = !dataSpec.isCoordBlank(icSort);
        LayerOpt opt = hasAux ? LayerOpt.OPAQUE : new LayerOpt(style.getColor(), true);
        return new AbstractPlotLayer(this, geom, dataSpec, style, opt){

            @Override
            public Drawing createDrawing(Surface surface, Map<AuxScale, Span> auxSpans, PaperType paperType) {
                final CubeSurface surf = (CubeSurface)surface;
                final PaperType3D ptype = (PaperType3D)paperType;
                final Span auxSpan = auxSpans.get(SCALE);
                return new UnplannedDrawing(){

                    @Override
                    protected void paintData(Paper paper, DataStore dataStore) {
                        this.paintLines3d(style, surf, dataStore, auxSpan, ptype, paper);
                    }
                };
            }

            @Override
            public Map<AuxScale, AuxReader> getAuxRangers() {
                Map<AuxScale, AuxReader> map = super.getAuxRangers();
                if (hasAux) {
                    map.put(SCALE, new AuxReader(){

                        @Override
                        public int getCoordIndex() {
                            return icAux;
                        }

                        @Override
                        public ValueInfo getAxisInfo(DataSpec dataSpec) {
                            ValueInfo[] infos = dataSpec.getUserCoordInfos(icAux);
                            return infos.length == 1 ? infos[0] : null;
                        }

                        @Override
                        public Scaling getScaling() {
                            return style.getScaling();
                        }

                        @Override
                        public void adjustAuxRange(Surface surf, DataSpec dataSpec, DataStore dataStore, Object[] plans, Ranger ranger) {
                            this.rangeAux3d((CubeSurface)surf, dataStore, ranger);
                        }
                    });
                }
                return map;
            }

            private void paintLines3d(AuxLineStyle style2, CubeSurface surf, DataStore dataStore, Span auxSpan, PaperType3D ptype, Paper paper) {
                Supplier<ColorKit> ckitFact;
                Color baseColor = style2.getColor();
                Stroke stroke = style2.getStroke();
                LineTracer3D tracer = LineTracer3D.createTracer(ptype, paper, surf, stroke);
                int ndim = surf.getDataDimCount();
                assert (ndim == 3);
                if (hasAux) {
                    Shader shader = style2.getShader();
                    Scaling scaling = style2.getScaling();
                    Subrange dataclip = style2.getDataClip();
                    Scaler scaler = auxSpan.createScaler(scaling, dataclip);
                    Color nullColor = style2.getNullColor();
                    float scaleAlpha = 1.0f;
                    ckitFact = () -> new AuxColorKit(icAux, shader, scaler, baseColor, nullColor, scaleAlpha);
                } else {
                    ckitFact = () -> new FixedColorKit(baseColor);
                }
                if (!hasSort) {
                    TupleSequence tseq = dataStore.getTupleSequence(dataSpec);
                    ColorKit colorKit = ckitFact.get();
                    double[] dpos = new double[ndim];
                    while (tseq.next()) {
                        if (!geom.readDataPos(tseq, icPos, dpos)) continue;
                        Color color = colorKit.readColor(tseq);
                        tracer.addPoint(dpos, color);
                    }
                } else {
                    List<Vertex> vlist = PlotUtil.tupleCollect(this.sortingVertexCollector(ckitFact), dataSpec, dataStore);
                    double[] dpos = new double[3];
                    for (Vertex v : vlist) {
                        dpos[0] = v.dx_;
                        dpos[1] = v.dy_;
                        dpos[2] = v.dz_;
                        tracer.addPoint(dpos, v.color_);
                    }
                }
            }

            private SplitCollector<TupleSequence, List<Vertex>> sortingVertexCollector(final Supplier<ColorKit> ckitFact) {
                return new SplitCollector<TupleSequence, List<Vertex>>(){

                    public List<Vertex> createAccumulator() {
                        return new ArrayList<Vertex>();
                    }

                    public void accumulate(TupleSequence tseq, List<Vertex> vlist) {
                        ColorKit colorKit = (ColorKit)ckitFact.get();
                        double[] dpos = new double[geom.getDataDimCount()];
                        while (tseq.next()) {
                            Color color;
                            double dsort = tseq.getDoubleValue(icSort);
                            if (!PlotUtil.isFinite(dsort) || !geom.readDataPos(tseq, icPos, dpos) || (color = colorKit.readColor(tseq)) == null) continue;
                            Vertex vertex = new Vertex(dpos[0], dpos[1], dpos[2], color, dsort);
                            vlist.add(vertex);
                        }
                        vlist.sort(null);
                    }

                    public List<Vertex> combine(List<Vertex> vlist1, List<Vertex> vlist2) {
                        vlist1.addAll(vlist2);
                        vlist1.sort(null);
                        return vlist1;
                    }
                };
            }

            private void rangeAux3d(CubeSurface surf, DataStore dataStore, Ranger ranger) {
                int ndim = surf.getDataDimCount();
                BiConsumer<TupleSequence, Ranger> rangeFiller = (tseq, r) -> {
                    double[] dpos = new double[ndim];
                    while (tseq.next()) {
                        if (!geom.readDataPos((Tuple)tseq, icPos, dpos) || !surf.inRange(dpos)) continue;
                        r.submitDatum(tseq.getDoubleValue(icAux));
                    }
                };
                dataStore.getTupleRunner().rangeData(rangeFiller, ranger, dataSpec, dataStore);
            }
        };
    }

    private static class Vertex
    implements Comparable<Vertex> {
        final double dx_;
        final double dy_;
        final double dz_;
        final Color color_;
        final double seq_;

        Vertex(double dx, double dy, double dz, Color color, double seq) {
            this.dx_ = dx;
            this.dy_ = dy;
            this.dz_ = dz;
            this.color_ = color;
            this.seq_ = seq;
        }

        @Override
        public int compareTo(Vertex other) {
            return Double.compare(this.seq_, other.seq_);
        }
    }
}

