/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.FloatingArrayCoord;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.layer.ArrayShapePlotter;
import uk.ac.starlink.ttools.plot2.layer.AxisOpt;
import uk.ac.starlink.ttools.plot2.layer.GraphicsGlyph;
import uk.ac.starlink.ttools.plot2.layer.LineTracer;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.PixOutliner;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapePainter;
import uk.ac.starlink.ttools.plot2.layer.ShapeStyle;
import uk.ac.starlink.ttools.plot2.layer.XYArrayData;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;

public class LineArrayForm
implements ShapeForm {
    private final FloatingArrayCoord xsCoord_ = FloatingArrayCoord.X;
    private final FloatingArrayCoord ysCoord_ = FloatingArrayCoord.Y;
    private final int icXs_;
    private final int icYs_;
    public static final ConfigKey<AxisOpt> SORTAXIS_KEY = LineArrayForm.createSortAxisKey();
    private static final LineArrayForm instance_ = new LineArrayForm();

    private LineArrayForm() {
        this.icXs_ = 0;
        this.icYs_ = 1;
    }

    @Override
    public int getBasicPositionCount() {
        return 0;
    }

    @Override
    public String getFormName() {
        return "Lines";
    }

    @Override
    public Icon getFormIcon() {
        return ResourceIcon.PLOT_LINE;
    }

    @Override
    public String getFormDescription() {
        return String.join((CharSequence)"\n", "<p>Plots an <em>N</em>-segment line for each input row,", "with the X and Y coordinate arrays each supplied by an", "<em>N</em>-element array value.", "</p>", "");
    }

    @Override
    public Coord[] getExtraCoords() {
        return new Coord[0];
    }

    @Override
    public int getExtraPositionCount() {
        return 0;
    }

    @Override
    public DataGeom adjustGeom(DataGeom geom, DataSpec dataSpec, ShapeStyle style) {
        return geom;
    }

    @Override
    public ConfigKey<?>[] getConfigKeys() {
        ArrayList list = new ArrayList();
        list.addAll(Arrays.asList(StyleKeys.getStrokeKeys()));
        list.add(SORTAXIS_KEY);
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public Outliner createOutliner(ConfigMap config) {
        Stroke stroke = StyleKeys.createStroke(config, 1, 1);
        AxisOpt sortaxis = config.get(SORTAXIS_KEY);
        return new LineArrayOutliner(stroke, sortaxis);
    }

    private Function<Tuple, XYArrayData> createXYArrayReader(DataSpec dataSpec) {
        return ArrayShapePlotter.createXYArrayReader(this.xsCoord_, this.ysCoord_, this.icXs_, this.icYs_, dataSpec);
    }

    public static LineArrayForm getInstance() {
        return instance_;
    }

    private static XYArrayData sortXY(final XYArrayData xyData, AxisOpt sortaxis) {
        if (sortaxis == null || xyData == null) {
            return xyData;
        }
        final int n = xyData.getLength();
        final Integer[] indices = new Integer[n];
        for (int i = 0; i < n; ++i) {
            indices[i] = i;
        }
        Comparator<Integer> comparator = Comparator.comparingDouble(index -> sortaxis.getAxisValue(xyData, (int)index));
        Arrays.sort(indices, comparator);
        return new XYArrayData(){

            @Override
            public int getLength() {
                return n;
            }

            @Override
            public double getX(int i) {
                return xyData.getX(indices[i]);
            }

            @Override
            public double getY(int i) {
                return xyData.getY(indices[i]);
            }
        };
    }

    private static ConfigKey<AxisOpt> createSortAxisKey() {
        ConfigMeta meta = new ConfigMeta("sortaxis", "Sort Axis");
        meta.setShortDescription("Sort order for plotted points");
        meta.setStringUsage("[" + AxisOpt.X.toString() + "|" + AxisOpt.Y.toString() + "]");
        meta.setXmlDescription(new String[]{"<p>May be set to", "\"<code>" + AxisOpt.X.toString() + "</code>\" or", "\"<code>" + AxisOpt.Y.toString() + "</code>\"", "to ensure that the points for each line", "are plotted in ascending order", "of the corresponding coordinate.", "This will ensure that the plotted line resembles a", "function of the corresponding coordinate rather than", "a scribble.", "The default (null) value causes the points for each line", "to be joined", "in the sequence in which they appear in the arrays.", "If the points already appear in the arrays sorted", "according to the corresponding coordinate,", "this option has no visible effect,", "though it may slow things down.", "</p>"});
        AxisOpt[] opts = new AxisOpt[]{null, AxisOpt.X, AxisOpt.Y};
        return new OptionConfigKey<AxisOpt>(meta, AxisOpt.class, opts, (AxisOpt)null, true){

            @Override
            public String valueToString(AxisOpt axis) {
                return axis == null ? "None" : axis.toString();
            }

            @Override
            public String getXmlDescription(AxisOpt axis) {
                if (axis == null) {
                    return "No pre-sorting is performed";
                }
                return "Sorting is performed on the " + axis.toString() + " axis";
            }
        };
    }

    private class LineArrayOutliner
    extends PixOutliner {
        private final Stroke stroke_;
        private final AxisOpt sortaxis_;
        private final Icon legendIcon_;

        public LineArrayOutliner(Stroke stroke, AxisOpt sortaxis) {
            this.stroke_ = stroke;
            this.sortaxis_ = sortaxis;
            this.legendIcon_ = new Icon(){
                final int width = 20;
                final int height = 12;

                @Override
                public int getIconWidth() {
                    return 20;
                }

                @Override
                public int getIconHeight() {
                    return 12;
                }

                @Override
                public void paintIcon(Component c, Graphics g, int x, int y) {
                    Graphics2D g2 = (Graphics2D)g;
                    Stroke stroke0 = g2.getStroke();
                    g2.setStroke(LineArrayOutliner.this.stroke_);
                    int y1 = y + 6;
                    g2.drawLine(x, y1, x + 20, y1);
                    g2.setStroke(stroke0);
                }
            };
        }

        @Override
        public Icon getLegendIcon() {
            return this.legendIcon_;
        }

        @Override
        public Map<AuxScale, AuxReader> getAuxRangers(DataGeom geom) {
            return new HashMap<AuxScale, AuxReader>();
        }

        @Override
        public boolean canPaint(DataSpec dataSpec) {
            return LineArrayForm.this.createXYArrayReader(dataSpec) != null;
        }

        @Override
        public ShapePainter create2DPainter(final Surface surface, DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, final PaperType2D paperType) {
            final Rectangle bounds = surface.getPlotBounds();
            final boolean isBitmap = paperType.isBitmap();
            final double[] dpos = new double[2];
            final Point2D.Double gpos = new Point2D.Double();
            final Function xyReader = LineArrayForm.this.createXYArrayReader(dataSpec);
            boolean antialias = false;
            return new ShapePainter(){

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    XYArrayData xyData = LineArrayForm.sortXY((XYArrayData)xyReader.apply(tuple), LineArrayOutliner.this.sortaxis_);
                    if (xyData != null) {
                        int np = xyData.getLength();
                        final double[] gxs = new double[np];
                        final double[] gys = new double[np];
                        int gxlo = bounds.x + bounds.width;
                        int gxhi = bounds.x;
                        int gylo = bounds.y + bounds.height;
                        int gyhi = bounds.y;
                        int jp = 0;
                        for (int ip = 0; ip < np; ++ip) {
                            dpos[0] = xyData.getX(ip);
                            dpos[1] = xyData.getY(ip);
                            if (!surface.dataToGraphics(dpos, false, gpos) || !PlotUtil.isPointReal(gpos)) continue;
                            gxs[jp] = gpos.x;
                            gys[jp] = gpos.y;
                            ++jp;
                            int gx = (int)gpos.x;
                            int gy = (int)gpos.y;
                            gxlo = Math.min(gx, gxlo);
                            gxhi = Math.max(gx, gxhi);
                            gylo = Math.min(gy, gylo);
                            gyhi = Math.max(gy, gyhi);
                        }
                        final int ng = jp;
                        if (gxhi >= gxlo && gyhi >= gylo && jp > 0) {
                            Rectangle gbounds = new Rectangle(gxlo, gylo, gxhi - gxlo + 1, gyhi - gylo + 1);
                            GraphicsGlyph glyph = new GraphicsGlyph(gbounds){

                                @Override
                                public void paintGlyph(Graphics g) {
                                    LineTracer tracer = new LineTracer(g, bounds, LineArrayOutliner.this.stroke_, false, ng, isBitmap);
                                    Color gColor = g.getColor();
                                    for (int ip = 0; ip < ng; ++ip) {
                                        tracer.addVertex(gxs[ip], gys[ip], gColor);
                                    }
                                    tracer.flush();
                                }
                            };
                            paperType.placeGlyph(paper, 0.0, 0.0, glyph, color);
                        }
                    }
                }
            };
        }

        @Override
        public ShapePainter create3DPainter(CubeSurface surf, DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, PaperType3D paperType) {
            throw new UnsupportedOperationException("no 3D");
        }

        public int hashCode() {
            int code = 886301;
            code = 23 * code + this.stroke_.hashCode();
            code = 23 * code + PlotUtil.hashCode((Object)this.sortaxis_);
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof LineArrayOutliner) {
                LineArrayOutliner other = (LineArrayOutliner)o;
                return this.stroke_.equals(other.stroke_) && PlotUtil.equals((Object)this.sortaxis_, (Object)other.sortaxis_);
            }
            return false;
        }
    }
}

