/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Ranger;
import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.RampKeySet;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotter;
import uk.ac.starlink.ttools.plot2.layer.AuxColorKit;
import uk.ac.starlink.ttools.plot2.layer.AuxLineStyle;
import uk.ac.starlink.ttools.plot2.layer.AxisOpt;
import uk.ac.starlink.ttools.plot2.layer.ColorKit;
import uk.ac.starlink.ttools.plot2.layer.FixedColorKit;
import uk.ac.starlink.ttools.plot2.layer.LineTracer;
import uk.ac.starlink.ttools.plot2.layer.UnplannedDrawing;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.util.SplitCollector;

public class LinePlotter
extends AbstractPlotter<LinesStyle> {
    public static final String NOSORT_TXT = "None";
    private static final FloatingCoord AUX_COORD = FloatingCoord.createCoord(new InputMeta("aux", "Aux").setShortDescription("Auxiliary colour coordinate").setXmlDescription(new String[]{"<p>If supplied, this controls the colouring of the line", "along its length according to the value of this coordinate.", "</p>"}), false);
    public static final ConfigKey<AxisOpt> PLANE_SORTAXIS_KEY = new OptionConfigKey<AxisOpt>(new ConfigMeta("sortaxis", "Sort Axis").setShortDescription("Sort order for plotted points").setStringUsage("[" + AxisOpt.X.toString() + "|" + AxisOpt.Y.toString() + "]").setXmlDescription(new String[]{"<p>May be set to", "\"<code>" + AxisOpt.X.toString() + "</code>\" or", "\"<code>" + AxisOpt.Y.toString() + "</code>\"", "to ensure that the points are plotted in ascending order", "of the corresponding coordinate.", "This will ensure that the plotted line resembles a", "function of the corresponding coordinate rather than", "a scribble.", "The default (null) value causes the points to be joined", "in the sequence in which they appear in the table.", "If the points already appear in the table sorted", "according to the corresponding coordinate,", "this option has no visible effect,", "though it may slow things down.", "</p>"}), AxisOpt.class, new AxisOpt[]{null, AxisOpt.X, AxisOpt.Y}, (AxisOpt)null, true){

        @Override
        public String valueToString(AxisOpt axis) {
            return axis == null ? LinePlotter.NOSORT_TXT : axis.toString();
        }

        @Override
        public String getXmlDescription(AxisOpt axis) {
            if (axis == null) {
                return "No pre-sorting is performed";
            }
            return "Sorting is performed on the " + axis.toString() + " axis";
        }
    };
    public static final ConfigKey<AxisOpt> TIME_SORTAXIS_KEY = new OptionConfigKey<AxisOpt>(new ConfigMeta("sortaxis", "Sort Axis").setShortDescription("Sort order for plotted points").setStringUsage("[" + AxisOpt.TIME.toString() + "|" + "None" + "]").setXmlDescription(new String[]{"<p>May be set to", "\"<code>" + AxisOpt.TIME.toString() + "</code>\"", "to ensure that the points are plotted in ascending order", "on the Time axis.", "By default the points are joined in the sequence in which", "they appear in the table;", "that's fine if the rows are already sorted in time order,", "but may result in a scribble if they are not.", "If the points already appear in the table in time order,", "this option has no visible effect,", "but selecting it may slow things down.", "</p>"}), AxisOpt.class, new AxisOpt[]{AxisOpt.TIME, null}, (AxisOpt)null, true){

        @Override
        public String valueToString(AxisOpt axis) {
            return axis == null ? LinePlotter.NOSORT_TXT : axis.toString();
        }

        @Override
        public String getXmlDescription(AxisOpt axis) {
            if (axis == null) {
                return "No pre-sorting is performed";
            }
            return "Sorting is performed on the " + axis.toString() + " axis";
        }
    };
    private final ConfigKey<AxisOpt> sortaxisKey_;
    private final boolean reportAuxKeys_ = false;
    private static final boolean IS_OPAQUE = true;
    private static final AuxScale SCALE = AuxScale.COLOR;
    private static final RampKeySet RAMP_KEYS = StyleKeys.AUX_RAMP;

    public LinePlotter(ConfigKey<AxisOpt> sortaxisKey) {
        super("Line", ResourceIcon.PLOT_LINE, 1, new Coord[]{AUX_COORD});
        this.sortaxisKey_ = sortaxisKey;
    }

    @Override
    public String getPlotterDescription() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(PlotUtil.concatLines(new String[]{"<p>Plots a point-to-point line joining", "up the positions of data points.", "There are additional options to pre-sort the points", "according to their order on the X or Y axis (using the", "<code>" + this.sortaxisKey_.getMeta().getShortName() + "</code>", "value),", "and to vary the colour of the line along its length (using the", "<code>" + AUX_COORD.getInput().getMeta().getShortName() + "</code>", "value).", "</p>"}));
        sbuf.append(PlotUtil.concatLines(new String[]{"<p>The options for controlling the Aux colour map", "are controlled at the level of the plot itself,", "rather than by per-layer configuration.", "</p>"}));
        return sbuf.toString();
    }

    @Override
    public ConfigKey<?>[] getStyleKeys() {
        ArrayList list = new ArrayList();
        list.add(StyleKeys.COLOR);
        list.addAll(Arrays.asList(StyleKeys.getStrokeKeys()));
        list.add(this.sortaxisKey_);
        list.add(StyleKeys.ANTIALIAS);
        list.add(StyleKeys.AUX_NULLCOLOR);
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public LinesStyle createStyle(ConfigMap config) {
        Color color = config.get(StyleKeys.COLOR);
        Stroke stroke = StyleKeys.createStroke(config, 1, 1);
        boolean antialias = config.get(StyleKeys.ANTIALIAS);
        RampKeySet.Ramp ramp = RAMP_KEYS.createValue(config);
        Shader shader = ramp.getShader();
        Scaling scaling = ramp.getScaling();
        Subrange dataclip = ramp.getDataClip();
        Color nullColor = config.get(StyleKeys.AUX_NULLCOLOR);
        AxisOpt sortaxis = config.get(this.sortaxisKey_);
        return new LinesStyle(color, stroke, antialias, shader, scaling, dataclip, nullColor, sortaxis);
    }

    @Override
    public PlotLayer createLayer(final DataGeom geom, final DataSpec dataSpec, final LinesStyle style) {
        if (dataSpec == null || style == null) {
            return null;
        }
        AxisOpt sortaxis = style.sortaxis_;
        CoordGroup cgrp = this.getCoordGroup();
        final int icPos = cgrp.getPosCoordIndex(0, geom);
        final int icAux = cgrp.getExtraCoordIndex(0, geom);
        final boolean hasAux = !dataSpec.isCoordBlank(icAux);
        LayerOpt opt = hasAux ? LayerOpt.OPAQUE : new LayerOpt(style.getColor(), true);
        final boolean isOpaque = opt.isOpaque();
        return new AbstractPlotLayer(this, geom, dataSpec, style, opt){

            @Override
            public Drawing createDrawing(final Surface surface, Map<AuxScale, Span> auxSpans, final PaperType paperType) {
                Supplier<ColorKit> ckitFact;
                Span auxSpan = auxSpans.get(SCALE);
                Color baseColor = style.getColor();
                if (hasAux) {
                    Shader shader = style.getShader();
                    Scaling scaling = style.getScaling();
                    Subrange dataclip = style.getDataClip();
                    Scaler scaler = auxSpan.createScaler(scaling, dataclip);
                    Color nullColor = style.getNullColor();
                    float scaleAlpha = 1.0f;
                    ckitFact = () -> new AuxColorKit(icAux, shader, scaler, baseColor, nullColor, scaleAlpha);
                } else {
                    ckitFact = () -> new FixedColorKit(baseColor);
                }
                return new UnplannedDrawing(){

                    @Override
                    protected void paintData(Paper paper, final DataStore dataStore) {
                        paperType.placeDecal(paper, new Decal(){

                            @Override
                            public void paintDecal(Graphics g) {
                                this.paintLines(surface, dataStore, ckitFact, g, paperType);
                            }

                            @Override
                            public boolean isOpaque() {
                                return isOpaque;
                            }
                        });
                    }
                };
            }

            @Override
            public Map<AuxScale, AuxReader> getAuxRangers() {
                Map<AuxScale, AuxReader> map = super.getAuxRangers();
                if (hasAux) {
                    map.put(SCALE, new AuxReader(){

                        @Override
                        public int getCoordIndex() {
                            return icAux;
                        }

                        @Override
                        public ValueInfo getAxisInfo(DataSpec dataSpec) {
                            ValueInfo[] infos = dataSpec.getUserCoordInfos(icAux);
                            return infos.length == 1 ? infos[0] : null;
                        }

                        @Override
                        public Scaling getScaling() {
                            return style.getScaling();
                        }

                        @Override
                        public void adjustAuxRange(Surface surf, DataSpec dataSpec, DataStore dataStore, Object[] plans, Ranger ranger) {
                            this.rangeAux(surf, dataStore, ranger);
                        }
                    });
                }
                return map;
            }

            private void paintLines(Surface surface, DataStore dataStore, Supplier<ColorKit> ckitFact, Graphics g, PaperType paperType) {
                LineTracer tracer = new LineTracer(g, surface.getPlotBounds(), style.getStroke(), style.getAntialias(), 10240, paperType.isBitmap());
                AxisOpt sortaxis = style.sortaxis_;
                if (sortaxis == null) {
                    TupleSequence tseq = dataStore.getTupleSequence(dataSpec);
                    ColorKit colorKit = ckitFact.get();
                    double[] dpos = new double[surface.getDataDimCount()];
                    Point2D.Double gp = new Point2D.Double();
                    while (tseq.next()) {
                        if (!geom.readDataPos(tseq, icPos, dpos) || !surface.dataToGraphics(dpos, false, gp) || !PlotUtil.isPointReal(gp)) continue;
                        Color color = colorKit.readColor(tseq);
                        tracer.addVertex(gp.x, gp.y, color);
                    }
                } else {
                    SplitCollector<TupleSequence, List<CPoint>> collector = this.sortingPointCollector(ckitFact, sortaxis, surface);
                    List<CPoint> plist = PlotUtil.tupleCollect(collector, dataSpec, dataStore);
                    for (CPoint p : plist) {
                        tracer.addVertex(p.getX(), p.getY(), p.color_);
                    }
                }
                tracer.flush();
            }

            private SplitCollector<TupleSequence, List<CPoint>> sortingPointCollector(final Supplier<ColorKit> ckitFact, AxisOpt sortaxis, final Surface surface) {
                final Comparator<Point2D> comparator = sortaxis.pointComparator();
                final int ndim = surface.getDataDimCount();
                return new SplitCollector<TupleSequence, List<CPoint>>(){

                    public List<CPoint> createAccumulator() {
                        return new ArrayList<CPoint>();
                    }

                    public void accumulate(TupleSequence tseq, List<CPoint> plist) {
                        ColorKit colorKit = (ColorKit)ckitFact.get();
                        double[] dpos = new double[ndim];
                        Point2D.Double gp = new Point2D.Double();
                        while (tseq.next()) {
                            if (!geom.readDataPos(tseq, icPos, dpos) || !surface.dataToGraphics(dpos, false, gp) || !PlotUtil.isPointReal(gp)) continue;
                            Color color = colorKit.readColor(tseq);
                            plist.add(new CPoint(gp.x, gp.y, color));
                        }
                        plist.sort(comparator);
                    }

                    public List<CPoint> combine(List<CPoint> list1, List<CPoint> list2) {
                        list1.addAll(list2);
                        list1.sort(comparator);
                        return list1;
                    }
                };
            }

            private void rangeAux(Surface surf, DataStore dataStore, Ranger ranger) {
                int ndim = surf.getDataDimCount();
                BiConsumer<TupleSequence, Ranger> rangeFiller = (tseq, r) -> {
                    double[] dpos = new double[ndim];
                    Point2D.Double gpos = new Point2D.Double();
                    while (tseq.next()) {
                        if (!geom.readDataPos((Tuple)tseq, icPos, dpos) || !surf.dataToGraphics(dpos, true, gpos)) continue;
                        r.submitDatum(tseq.getDoubleValue(icAux));
                    }
                };
                dataStore.getTupleRunner().rangeData(rangeFiller, ranger, dataSpec, dataStore);
            }
        };
    }

    public static class LinesStyle
    extends AuxLineStyle {
        private final AxisOpt sortaxis_;

        public LinesStyle(Color color, Stroke stroke, boolean antialias, Shader shader, Scaling scaling, Subrange dataclip, Color nullColor, AxisOpt sortaxis) {
            super(color, stroke, antialias, shader, scaling, dataclip, nullColor);
            this.sortaxis_ = sortaxis;
        }

        @Override
        public boolean equals(Object o) {
            if (o instanceof LinesStyle) {
                LinesStyle other = (LinesStyle)o;
                return super.equals(other) && PlotUtil.equals((Object)this.sortaxis_, (Object)other.sortaxis_);
            }
            return false;
        }

        @Override
        public int hashCode() {
            int code = 23;
            code = 23 * code + super.hashCode();
            code = 23 * code + PlotUtil.hashCode((Object)this.sortaxis_);
            return code;
        }
    }

    private static class CPoint
    extends Point2D.Double {
        private final Color color_;

        CPoint(double x, double y, Color color) {
            super(x, y);
            this.color_ = color;
        }
    }
}

