/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import uk.ac.starlink.ttools.plot2.PlotUtil;

public class LineTracer {
    private final int xlo_;
    private final int xhi_;
    private final int ylo_;
    private final int yhi_;
    private final int xmid_;
    private final int ymid_;
    private final double gLimit2_;
    private final Graphics2D g2_;
    private final int nwork_;
    private final double[] xWork_;
    private final double[] yWork_;
    private final VertexStore lastVertex_;
    private int iLine_;
    private Color lastColor_;
    private int lastRegionX_;
    private int lastRegionY_;

    public LineTracer(Graphics g, Rectangle bounds, Stroke stroke, boolean antialias, int nwork, boolean isPixel) {
        this.nwork_ = nwork;
        this.xlo_ = bounds.x;
        this.xhi_ = bounds.x + bounds.width;
        this.ylo_ = bounds.y;
        this.yhi_ = bounds.y + bounds.height;
        this.g2_ = (Graphics2D)g.create();
        this.g2_.clip(bounds);
        this.g2_.setStroke(stroke);
        this.g2_.setRenderingHint(RenderingHints.KEY_ANTIALIASING, antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
        this.xmid_ = (this.xlo_ + this.xhi_) / 2;
        this.ymid_ = (this.ylo_ + this.yhi_) / 2;
        this.gLimit2_ = Math.pow(Math.max(bounds.width, bounds.height) * 100, 2.0);
        this.xWork_ = new double[this.nwork_];
        this.yWork_ = new double[this.nwork_];
        this.lastVertex_ = LineTracer.createVertexStore(isPixel);
    }

    public void addVertex(double dx, double dy, Color color) {
        if (color == null) {
            this.flushPoly();
            this.iLine_ = 0;
        } else if (!this.lastVertex_.equalsVertex(dx, dy)) {
            int regionX = LineTracer.getRegion(dx, this.xlo_, this.xhi_);
            int regionY = LineTracer.getRegion(dy, this.ylo_, this.yhi_);
            if (this.iLine_ == 0) {
                this.addIncludedVertex(dx, dy);
            } else if (regionX * this.lastRegionX_ != 1 && regionY * this.lastRegionY_ != 1) {
                if (color.equals(this.lastColor_)) {
                    this.addIncludedVertex(dx, dy);
                } else {
                    this.flushPoly();
                    assert (this.iLine_ == 1);
                    this.addIncludedVertex(dx, dy);
                    this.flushPair0(this.lastColor_, color);
                }
            } else {
                this.flushPoly();
                this.iLine_ = 0;
                this.addIncludedVertex(dx, dy);
            }
            this.lastVertex_.setVertex(dx, dy);
            this.lastRegionX_ = regionX;
            this.lastRegionY_ = regionY;
            assert (this.iLine_ > 0);
        }
        this.lastColor_ = color;
    }

    public void flush() {
        this.flushPoly();
    }

    private void flushPoly() {
        if (this.iLine_ > 1) {
            assert (this.lastColor_ != null);
            this.g2_.setColor(this.lastColor_);
            Path2D.Double path = new Path2D.Double(1, this.iLine_);
            path.moveTo(this.xWork_[0], this.yWork_[0]);
            for (int ip = 1; ip < this.iLine_; ++ip) {
                path.lineTo(this.xWork_[ip], this.yWork_[ip]);
            }
            this.g2_.draw(path);
            this.xWork_[0] = this.xWork_[this.iLine_ - 1];
            this.yWork_[0] = this.yWork_[this.iLine_ - 1];
            this.iLine_ = 1;
        }
    }

    private void flushPair0(Color color0, Color color1) {
        assert (this.iLine_ == 2);
        double dx0 = this.xWork_[0];
        double dy0 = this.yWork_[0];
        double dx1 = this.xWork_[1];
        double dy1 = this.yWork_[1];
        this.g2_.setPaint(new GradientPaint((float)dx0, (float)dy0, color0, (float)dx1, (float)dy1, color1));
        this.g2_.draw(new Line2D.Double(dx0, dy0, dx1, dy1));
        this.xWork_[0] = dx1;
        this.yWork_[0] = dy1;
        this.iLine_ = 1;
    }

    private void addIncludedVertex(double x, double y) {
        double sy;
        double sx;
        double s2;
        if (this.iLine_ == this.nwork_) {
            this.flush();
            assert (this.iLine_ == 1);
        }
        if ((s2 = (sx = x - (double)this.xmid_) * sx + (sy = y - (double)this.ymid_) + sy) > this.gLimit2_) {
            double theta = Math.atan2(sy, sx);
            double r = Math.sqrt(this.gLimit2_);
            x = (double)this.xmid_ + r * Math.cos(theta);
            y = (double)this.ymid_ + r * Math.sin(theta);
        }
        this.xWork_[this.iLine_] = x;
        this.yWork_[this.iLine_] = y;
        ++this.iLine_;
    }

    private static int getRegion(double point, int lo, int hi) {
        return point >= (double)lo ? (point < (double)hi ? 0 : 1) : -1;
    }

    private static VertexStore createVertexStore(boolean isPixel) {
        if (isPixel) {
            return new VertexStore(){
                private int gx_ = Integer.MIN_VALUE;
                private int gy_ = Integer.MIN_VALUE;

                @Override
                public double getX() {
                    return this.gx_;
                }

                @Override
                public double getY() {
                    return this.gy_;
                }

                @Override
                public void setVertex(double x, double y) {
                    this.gx_ = this.toInt(x);
                    this.gy_ = this.toInt(y);
                }

                @Override
                public boolean equalsVertex(double x, double y) {
                    return this.toInt(x) == this.gx_ && this.toInt(y) == this.gy_;
                }

                private int toInt(double d) {
                    return PlotUtil.ifloor(d);
                }
            };
        }
        return new VertexStore(){
            private double dx_ = Double.NaN;
            private double dy_ = Double.NaN;

            @Override
            public double getX() {
                return this.dx_;
            }

            @Override
            public double getY() {
                return this.dy_;
            }

            @Override
            public void setVertex(double x, double y) {
                this.dx_ = x;
                this.dy_ = y;
            }

            @Override
            public boolean equalsVertex(double x, double y) {
                return x == this.dx_ && y == this.dy_;
            }
        };
    }

    private static interface VertexStore {
        public double getX();

        public double getY();

        public void setVertex(double var1, double var3);

        public boolean equalsVertex(double var1, double var3);
    }
}

