/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.MultiPointConfigKey;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.geom.GPoint3D;
import uk.ac.starlink.ttools.plot2.layer.MultiPointCoordSet;
import uk.ac.starlink.ttools.plot2.layer.MultiPointReader;
import uk.ac.starlink.ttools.plot2.layer.MultiPointScribe;
import uk.ac.starlink.ttools.plot2.layer.MultiPointShape;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.PixOutliner;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapePainter;
import uk.ac.starlink.ttools.plot2.layer.ShapeStyle;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;

public abstract class MultiPointForm
implements ShapeForm {
    private final String name_;
    private final Icon icon_;
    private final String description_;
    private final MultiPointCoordSet extraCoordSet_;
    private final MultiPointConfigKey shapeKey_;
    private final ConfigKey<Double> scaleKey_;
    private final ConfigKey<Integer> thickKey_;
    private final ConfigKey<?>[] otherKeys_;
    public static final int AUTOSCALE_PIXELS = 32;

    public MultiPointForm(String name, Icon icon, String description, MultiPointCoordSet extraCoordSet, MultiPointConfigKey shapeKey, ConfigKey<Double> scaleKey, ConfigKey<?>[] otherKeys) {
        this.name_ = name;
        this.icon_ = icon;
        this.description_ = description;
        this.extraCoordSet_ = extraCoordSet;
        this.shapeKey_ = shapeKey;
        this.scaleKey_ = scaleKey;
        this.thickKey_ = MultiPointForm.createThicknessKey(this.shapeKey_);
        this.otherKeys_ = otherKeys;
    }

    protected abstract MultiPointReader createReader(ConfigMap var1);

    @Override
    public int getBasicPositionCount() {
        return 1;
    }

    @Override
    public String getFormName() {
        return this.name_;
    }

    @Override
    public Icon getFormIcon() {
        return this.icon_;
    }

    @Override
    public String getFormDescription() {
        return this.description_;
    }

    @Override
    public Coord[] getExtraCoords() {
        return this.extraCoordSet_.getCoords();
    }

    @Override
    public int getExtraPositionCount() {
        return 0;
    }

    @Override
    public DataGeom adjustGeom(DataGeom geom, DataSpec dataSpec, ShapeStyle style) {
        return geom;
    }

    @Override
    public ConfigKey<?>[] getConfigKeys() {
        ArrayList list = new ArrayList();
        list.add(this.shapeKey_);
        list.add(this.thickKey_);
        if (this.scaleKey_ != null) {
            list.add(this.scaleKey_);
        }
        list.addAll(Arrays.asList(this.otherKeys_));
        return list.toArray(new ConfigKey[0]);
    }

    @Override
    public Outliner createOutliner(ConfigMap config) {
        MultiPointShape shape = config.get(this.shapeKey_);
        int nthick = config.get(this.thickKey_);
        ErrorMode[] errorModes = this.shapeKey_.getErrorModes();
        double scale = this.scaleKey_ == null ? 1.0 : config.get(this.scaleKey_);
        return new MultiPointOutliner(this.createReader(config), shape, nthick, errorModes, scale);
    }

    public static String getDefaultScalingDescription(String shapename) {
        return String.join((CharSequence)"\n", "<p>In some cases the supplied data values", "give the actual extents in data coordinates", "for the plotted " + shapename + "s", "but sometimes the data is on a different scale", "or in different units to the positional coordinates.", "As a convenience for this case, the plotter can optionally", "scale the magnitudes of all the " + shapename + "s", "to make them a reasonable size on the plot,", "so by default the largest ones are a few tens of pixels long.", "This auto-scaling is turned off by default,", "but it can be activated with the", "<code>" + StyleKeys.AUTOSCALE.getMeta().getShortName() + "</code>", "option.", "Whether autoscaling is on or off, the", "<code>" + StyleKeys.SCALE.getMeta().getShortName() + "</code>", "option can be used to apply a fixed scaling factor.", "</p>");
    }

    public static ConfigKey<Integer> createThicknessKey(MultiPointConfigKey shapeKey) {
        ConfigMeta meta = new ConfigMeta("thick", "Thickness");
        meta.setShortDescription("Line thickness for " + shapeKey.getMeta().getShortDescription());
        meta.setXmlDescription(new String[]{"<p>Controls the line thickness used when drawing shapes.", "Zero, the default value, means a 1-pixel-wide line is used.", "Larger values make drawn lines thicker,", "but note changing this value will not affect all shapes,", "for instance filled rectangles contain no line drawings.", "</p>"});
        return StyleKeys.createPaintThicknessKey(meta, 3);
    }

    public static int getExtrasCoordIndex(DataGeom geom) {
        return geom.getPosCoords().length;
    }

    private static class SizeScale
    extends AuxScale {
        private final MultiPointOutliner outliner_;

        SizeScale(MultiPointOutliner outliner) {
            super("autosize");
            this.outliner_ = outliner;
        }

        public int hashCode() {
            return this.outliner_.hashCode();
        }

        public boolean equals(Object other) {
            return other instanceof SizeScale && this.outliner_.equals(((SizeScale)other).outliner_);
        }
    }

    private static class Offsetter {
        final Surface surface_;
        final int nextra_;
        final double scale_;
        final Point2D.Double gp_;

        Offsetter(Surface surface, int nextra, double scale) {
            this.surface_ = surface;
            this.nextra_ = nextra;
            this.scale_ = scale;
            this.gp_ = new Point2D.Double();
        }

        void calculateOffsets(double[] dpos0, Point2D.Double gpos0, double[][] dposExtras, int[] xoffs, int[] yoffs) {
            double gx0 = gpos0.x;
            double gy0 = gpos0.y;
            for (int ie = 0; ie < this.nextra_; ++ie) {
                int gy;
                int gx;
                if (this.surface_.dataToGraphicsOffset(dpos0, gpos0, dposExtras[ie], false, this.gp_) && PlotUtil.isPointReal(this.gp_)) {
                    gx = (int)Math.round((this.gp_.x - gx0) * this.scale_);
                    gy = (int)Math.round((this.gp_.y - gy0) * this.scale_);
                } else {
                    gx = 0;
                    gy = 0;
                }
                xoffs[ie] = gx;
                yoffs[ie] = gy;
            }
        }
    }

    private static class MultiPointOutliner
    extends PixOutliner {
        private final MultiPointReader reader_;
        private final MultiPointScribe scribe_;
        private final ErrorMode[] modes_;
        private final double scale_;
        private final Icon icon_;
        private final SizeScale sizeScale_;
        private final int nExtra_;

        public MultiPointOutliner(MultiPointReader reader, MultiPointShape shape, int nthick, ErrorMode[] modes, double scale) {
            this.reader_ = reader;
            this.scribe_ = shape.createScribe(nthick);
            this.modes_ = modes;
            this.scale_ = scale;
            this.icon_ = shape.getLegendIcon(this.scribe_, modes, 14, 10, 1, 1);
            this.sizeScale_ = new SizeScale(this);
            this.nExtra_ = reader.getExtraCoordSet().getPointCount();
        }

        @Override
        public Icon getLegendIcon() {
            return this.icon_;
        }

        @Override
        public Map<AuxScale, AuxReader> getAuxRangers(DataGeom geom) {
            HashMap<AuxScale, AuxReader> map = new HashMap<AuxScale, AuxReader>();
            if (this.reader_.isAutoscale()) {
                map.put(this.sizeScale_, this.reader_.createSizeReader(geom));
            }
            return map;
        }

        @Override
        public boolean canPaint(DataSpec dataSpec) {
            return true;
        }

        @Override
        public ShapePainter create2DPainter(final Surface surface, final DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, final PaperType2D paperType) {
            int ndim = surface.getDataDimCount();
            final double[] dpos0 = new double[ndim];
            final double[][] dposExtras = new double[this.nExtra_][ndim];
            final Point2D.Double gpos0 = new Point2D.Double();
            Span sizeSpan = auxSpans.get(this.sizeScale_);
            assert (this.reader_.isAutoscale() == (sizeSpan != null));
            final MultiPointReader.ExtrasReader reader = this.reader_.createExtrasReader(geom, sizeSpan);
            double scale = this.scale_ * this.reader_.getBaseScale(surface, sizeSpan);
            final Offsetter offsetter = new Offsetter(surface, this.nExtra_, scale);
            return new ShapePainter(){

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    if (geom.readDataPos(tuple, 0, dpos0) && surface.dataToGraphics(dpos0, true, gpos0) && reader.readPoints(tuple, dpos0, dposExtras)) {
                        int[] xoffs = new int[nExtra_];
                        int[] yoffs = new int[nExtra_];
                        offsetter.calculateOffsets(dpos0, gpos0, dposExtras, xoffs, yoffs);
                        Glyph glyph = scribe_.createGlyph(xoffs, yoffs);
                        paperType.placeGlyph(paper, gpos0.x, gpos0.y, glyph, color);
                    }
                }
            };
        }

        @Override
        public ShapePainter create3DPainter(final CubeSurface surface, final DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, final PaperType3D paperType) {
            int ndim = surface.getDataDimCount();
            final double[] dpos0 = new double[ndim];
            final double[][] dposExtras = new double[this.nExtra_][ndim];
            final GPoint3D gpos0 = new GPoint3D();
            Span sizeSpan = auxSpans.get(this.sizeScale_);
            assert (this.reader_.isAutoscale() == (sizeSpan != null));
            final MultiPointReader.ExtrasReader reader = this.reader_.createExtrasReader(geom, sizeSpan);
            double scale = this.scale_ * this.reader_.getBaseScale(surface, sizeSpan);
            final Offsetter offsetter = new Offsetter(surface, this.nExtra_, scale);
            return new ShapePainter(){

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    if (geom.readDataPos(tuple, 0, dpos0) && surface.dataToGraphicZ(dpos0, true, gpos0) && reader.readPoints(tuple, dpos0, dposExtras)) {
                        int[] xoffs = new int[nExtra_];
                        int[] yoffs = new int[nExtra_];
                        offsetter.calculateOffsets(dpos0, gpos0, dposExtras, xoffs, yoffs);
                        Glyph glyph = scribe_.createGlyph(xoffs, yoffs);
                        paperType.placeGlyph(paper, gpos0.x, gpos0.y, gpos0.z, glyph, color);
                    }
                }
            };
        }

        public boolean equals(Object o) {
            if (o instanceof MultiPointOutliner) {
                MultiPointOutliner other = (MultiPointOutliner)o;
                return this.reader_.equals(other.reader_) && this.scribe_.equals(other.scribe_) && Arrays.equals(this.modes_, other.modes_) && this.scale_ == other.scale_;
            }
            return false;
        }

        public int hashCode() {
            int code = 3203;
            code = code * 23 + this.reader_.hashCode();
            code = code * 23 + this.scribe_.hashCode();
            code = code * 23 + Arrays.hashCode(this.modes_);
            code = code * 23 + Float.floatToIntBits((float)this.scale_);
            return code;
        }
    }
}

