/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.ErrorMode;
import uk.ac.starlink.ttools.plot.Matrices;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.layer.LineGlyph;
import uk.ac.starlink.ttools.plot2.layer.MultiPointScribe;
import uk.ac.starlink.ttools.plot2.layer.PixelDrawing;
import uk.ac.starlink.ttools.plot2.layer.PixerFactory;
import uk.ac.starlink.ttools.plot2.layer.StrokeKit;

public abstract class MultiPointShape {
    private final String name_;
    private final int iconDim_;
    private final boolean canThick_;
    private Icon icon_;
    public static final MultiPointShape NONE = new Blank("None");
    public static final MultiPointShape DEFAULT = new CappedLine("Lines", true, null);
    public static final MultiPointShape EXAMPLE = new CappedLine("Capped Lines", true, MultiPointShape.barCapper(3));
    private static final int DUMMY_SIZE = 10000;
    private static final int LEGEND_WIDTH = 40;
    private static final int LEGEND_HEIGHT = 16;
    private static final int LEGEND_XPAD = 5;
    private static final int LEGEND_YPAD = 1;
    private static final double SQRT2 = Math.sqrt(2.0);
    private static final MultiPointShape[] OPTIONS_1D = new MultiPointShape[]{NONE, DEFAULT, EXAMPLE, new CappedLine("Caps", false, MultiPointShape.barCapper(3)), new CappedLine("Arrows", true, MultiPointShape.arrowCapper(3))};
    private static final MultiPointShape[] OPTIONS_2D = new MultiPointShape[]{NONE, DEFAULT, EXAMPLE, new CappedLine("Caps", false, MultiPointShape.barCapper(3)), new CappedLine("Arrows", true, MultiPointShape.arrowCapper(3)), new OpenEllipse("Ellipse", false), new OpenEllipse("Crosshair Ellipse", true), new OpenRectangle("Rectangle", false), new OpenRectangle("Crosshair Rectangle", true), new FilledEllipse("Filled Ellipse"), new FilledRectangle("Filled Rectangle")};
    private static final MultiPointShape[] OPTIONS_3D = new MultiPointShape[]{NONE, DEFAULT, EXAMPLE, new CappedLine("Caps", false, MultiPointShape.barCapper(3)), new CappedLine("Arrows", true, MultiPointShape.arrowCapper(3)), new OpenCuboid("Cuboid"), new MultiPlaneShape(new OpenEllipse("Ellipse", false)), new MultiPlaneShape(new OpenEllipse("Crosshair Ellipse", true)), new MultiPlaneShape(new OpenRectangle("Rectangle", false)), new MultiPlaneShape(new OpenRectangle("Crosshair Rectangle", true)), new MultiPlaneShape(new FilledEllipse("Filled Ellipse")), new MultiPlaneShape(new FilledRectangle("Filled Rectangle"))};
    private static final MultiPointShape[] OPTIONS_VECTOR = new MultiPointShape[]{new CappedLine("Small Arrow", true, MultiPointShape.arrowCapper(3)), new CappedLine("Medium Arrow", true, MultiPointShape.arrowCapper(4)), new CappedLine("Large Arrow", true, MultiPointShape.arrowCapper(5)), new Dart("Small Open Dart", false, 2), new Dart("Medium Open Dart", false, 4), new Dart("Large Open Dart", false, 6), new Dart("Small Filled Dart", true, 2), new Dart("Medium Filled Dart", true, 4), new Dart("Large Filled Dart", true, 6), DEFAULT, EXAMPLE};
    private static final MultiPointShape[] OPTIONS_ELLIPSE = new MultiPointShape[]{new OpenEllipse("Ellipse", false), new OpenEllipse("Crosshair Ellipse", true), new FilledEllipse("Filled Ellipse"), new OpenRectangle("Rectangle", false), new OpenRectangle("Crosshair Rectangle", true), new FilledRectangle("Filled Rectangle"), new Triangle("Open Triangle", false), new Triangle("Filled Triangle", true), DEFAULT, EXAMPLE, new CappedLine("Arrows", true, MultiPointShape.arrowCapper(3))};

    protected MultiPointShape(String name, int iconDim, boolean canThick) {
        this.name_ = name;
        this.iconDim_ = iconDim;
        this.canThick_ = canThick;
    }

    public Icon getLegendIcon() {
        if (this.icon_ == null) {
            this.icon_ = new MultiPointIcon(this, this.iconDim_);
        }
        return this.icon_;
    }

    public Icon getLegendIcon(MultiPointScribe scribe, ErrorMode[] modes, int width, int height, int xpad, int ypad) {
        if (this.isPadIcon()) {
            xpad += width / 6;
            ypad += height / 6;
        }
        return new MultiPointIcon(scribe, modes, width, height, xpad, ypad);
    }

    public abstract boolean supportsDimensionality(int var1);

    public abstract MultiPointScribe createScribe(int var1);

    public boolean canThick() {
        return this.canThick_;
    }

    boolean isPadIcon() {
        return false;
    }

    public String getName() {
        return this.name_;
    }

    public String toString() {
        return this.getName();
    }

    public static MultiPointShape[] getOptionsError1d() {
        return (MultiPointShape[])OPTIONS_1D.clone();
    }

    public static MultiPointShape[] getOptionsError2d() {
        return (MultiPointShape[])OPTIONS_2D.clone();
    }

    public static MultiPointShape[] getOptionsError3d() {
        return (MultiPointShape[])OPTIONS_3D.clone();
    }

    public static MultiPointShape[] getOptionsEllipse() {
        return (MultiPointShape[])OPTIONS_ELLIPSE.clone();
    }

    public static MultiPointShape[] getOptionsVector() {
        return (MultiPointShape[])OPTIONS_VECTOR.clone();
    }

    private static Dimension getApproxGraphicsSize(Graphics2D g) {
        Dimension size = g.getDeviceConfiguration().getBounds().getSize();
        return size.width > 1 && size.height > 1 ? size : new Dimension(10000, 10000);
    }

    private static CapperFactory arrowCapper(int capsize) {
        return nthick -> new ArrowCapper(capsize + nthick);
    }

    private static CapperFactory barCapper(int capsize) {
        return boost -> new BarCapper(capsize + boost);
    }

    private static abstract class OblongGlyph
    extends LineGlyph {
        final int[] xoffs_;
        final int[] yoffs_;
        final boolean withLines_;

        OblongGlyph(int[] xoffs, int[] yoffs, boolean withLines) {
            this.xoffs_ = xoffs;
            this.yoffs_ = yoffs;
            this.withLines_ = withLines;
        }

        @Override
        public void paintGlyph(Graphics g, StrokeKit strokeKit) {
            int[] yoffs;
            int[] xoffs;
            Graphics2D g2 = (Graphics2D)g;
            Stroke stroke0 = g2.getStroke();
            g2.setStroke(strokeKit.getRound());
            int noff = this.xoffs_.length;
            Dimension size = MultiPointShape.getApproxGraphicsSize(g2);
            int maxcoord = Math.max(size.width, size.height);
            boolean clipped = false;
            for (int ioff = 0; ioff < noff && !clipped; ++ioff) {
                int xoff = this.xoffs_[ioff];
                int yoff = this.yoffs_[ioff];
                clipped = clipped || xoff < -maxcoord || xoff > maxcoord || yoff < -maxcoord || yoff > maxcoord;
            }
            if (clipped) {
                xoffs = new int[noff];
                yoffs = new int[noff];
                for (int ioff = 0; ioff < noff; ++ioff) {
                    xoffs[ioff] = Math.max(-maxcoord, Math.min(maxcoord, xoffs[ioff]));
                    yoffs[ioff] = Math.max(-maxcoord, Math.min(maxcoord, yoffs[ioff]));
                }
            } else {
                xoffs = this.xoffs_;
                yoffs = this.yoffs_;
            }
            if (noff == 2) {
                g.drawLine(xoffs[0], yoffs[0], xoffs[1], yoffs[1]);
            } else {
                if (noff != 4 || yoffs.length != 4 || !(g instanceof Graphics2D)) {
                    return;
                }
                if (yoffs[0] == 0 && yoffs[1] == 0 && xoffs[2] == 0 && xoffs[3] == 0) {
                    int xlo = Math.min(xoffs[0], xoffs[1]);
                    int xhi = Math.max(xoffs[0], xoffs[1]);
                    int ylo = Math.min(yoffs[2], yoffs[3]);
                    int yhi = Math.max(yoffs[2], yoffs[3]);
                    int width = xhi - xlo;
                    int height = yhi - ylo;
                    if (width > 0 || height > 0) {
                        this.paintOblong(g, xlo, ylo, width, height);
                    }
                } else {
                    int[] yo;
                    int[] xo;
                    double[] m2;
                    double[] m3;
                    AffineTransform trans;
                    double height;
                    double dx1 = xoffs[1] - xoffs[0];
                    double dy1 = yoffs[1] - yoffs[0];
                    double dx2 = xoffs[3] - xoffs[2];
                    double dy2 = yoffs[3] - yoffs[2];
                    double width = Math.sqrt(dx1 * dx1 + dy1 * dy1);
                    double[] m1 = new double[]{width, 0.0, 0.0, 0.0, height = Math.sqrt(dx2 * dx2 + dy2 * dy2), 0.0, 1.0, 1.0, 1.0};
                    if (Matrices.det(m1) != 0.0 && (trans = new AffineTransform((m3 = Matrices.mmMult(m2 = new double[]{(xo = xoffs)[1] + xo[2], xo[0] + xo[3], xo[0] + xo[2], (yo = yoffs)[1] + yo[2], yo[0] + yo[3], yo[0] + yo[2], 1.0, 1.0, 1.0}, Matrices.invert(m1)))[0], m3[3], m3[1], m3[4], m3[2], m3[5])).getDeterminant() != 0.0) {
                        AffineTransform oldTrans = g2.getTransform();
                        g2.transform(trans);
                        this.paintOblong(g2, 0, 0, (int)Math.round(width), (int)Math.round(height));
                        g2.setTransform(oldTrans);
                    }
                }
            }
            if (this.withLines_) {
                CappedLine.drawCappedLine(g, xoffs, yoffs, true, null, true, strokeKit);
            }
            g2.setStroke(stroke0);
        }

        @Override
        public Rectangle getPixelBounds() {
            int xmin = 0;
            int xmax = 0;
            int ymin = 0;
            int ymax = 0;
            int rmax = 0;
            int np = this.xoffs_.length;
            for (int ip = 0; ip < np; ++ip) {
                int xoff = this.xoffs_[ip];
                int yoff = this.yoffs_[ip];
                if (xoff == 0 && yoff == 0) continue;
                if (xoff == 0) {
                    ymin = Math.min(ymin, yoff);
                    ymax = Math.max(ymax, yoff);
                    continue;
                }
                if (yoff == 0) {
                    xmin = Math.min(xmin, xoff);
                    xmax = Math.max(xmax, xoff);
                    continue;
                }
                rmax = Math.max(rmax, Math.abs(xoff) + Math.abs(yoff));
            }
            if (rmax > 0) {
                xmin = Math.min(xmin, -rmax);
                xmax = Math.max(xmax, rmax);
                ymin = Math.min(ymin, -rmax);
                ymax = Math.max(ymax, rmax);
            }
            return new Rectangle(xmin, ymin, xmax - xmin + 1, ymax - ymin + 1);
        }

        abstract void paintOblong(Graphics var1, int var2, int var3, int var4, int var5);
    }

    private static class ArrowCapper
    implements Capper {
        private final int capsize_;
        private final int[] xs_;
        private final int[] ys_;

        ArrowCapper(int capsize) {
            this.capsize_ = capsize;
            this.xs_ = new int[3];
            this.ys_ = new int[3];
        }

        @Override
        public void drawCapX(Graphics g, int xoff) {
            int xstart;
            int sign = xoff > 0 ? 1 : -1;
            int size = Math.min(this.capsize_, sign * xoff);
            this.xs_[0] = xstart = xoff - sign * size;
            this.ys_[0] = -size;
            this.xs_[1] = xoff;
            this.ys_[1] = 0;
            this.xs_[2] = xstart;
            this.ys_[2] = size;
            g.drawPolyline(this.xs_, this.ys_, 3);
        }

        @Override
        public void drawCapY(Graphics g, int yoff) {
            int sign = yoff > 0 ? 1 : -1;
            int size = Math.min(this.capsize_, sign * yoff);
            int ystart = yoff - sign * size;
            this.xs_[0] = -size;
            this.ys_[0] = ystart;
            this.xs_[1] = 0;
            this.ys_[1] = yoff;
            this.xs_[2] = size;
            this.ys_[2] = ystart;
            g.drawPolyline(this.xs_, this.ys_, 3);
        }

        @Override
        public void drawCap(PixelDrawing drawing, int xoff, int yoff) {
            if (xoff == 0) {
                int sign = yoff > 0 ? 1 : -1;
                int size = Math.min(this.capsize_, sign * yoff);
                int ystart = yoff - sign * size;
                drawing.drawLine(0, yoff, -size, ystart);
                drawing.drawLine(0, yoff, size, ystart);
            } else if (yoff == 0) {
                int sign = xoff > 0 ? 1 : -1;
                int size = Math.min(this.capsize_, sign * xoff);
                int xstart = xoff - sign * size;
                drawing.drawLine(xoff, 0, xstart, -size);
                drawing.drawLine(xoff, 0, xstart, size);
            } else {
                double r1 = Math.sqrt(xoff * xoff + yoff * yoff);
                double size = Math.min((double)this.capsize_, r1);
                double capfact = size / r1;
                int ax = xoff + (int)Math.round(capfact * (double)(-xoff + yoff));
                int ay = yoff + (int)Math.round(capfact * (double)(-xoff - yoff));
                int bx = xoff + (int)Math.round(capfact * (double)(-xoff - yoff));
                int by = yoff + (int)Math.round(capfact * (double)(xoff - yoff));
                drawing.drawLine(xoff, yoff, ax, ay);
                drawing.drawLine(xoff, yoff, bx, by);
            }
        }

        @Override
        public void extendBounds(Rectangle bounds, int xoff, int yoff) {
            int cs = (int)Math.ceil(1.5 * (double)this.capsize_);
            bounds.add(xoff + cs, yoff);
            bounds.add(xoff - cs, yoff);
            bounds.add(xoff, yoff + cs);
            bounds.add(xoff, yoff - cs);
        }
    }

    private static class BarCapper
    implements Capper {
        private final int capsize_;

        public BarCapper(int capsize) {
            this.capsize_ = capsize;
        }

        @Override
        public void drawCapX(Graphics g, int xoff) {
            g.drawLine(xoff, -this.capsize_, xoff, this.capsize_);
        }

        @Override
        public void drawCapY(Graphics g, int yoff) {
            g.drawLine(-this.capsize_, yoff, this.capsize_, yoff);
        }

        @Override
        public void drawCap(PixelDrawing drawing, int xoff, int yoff) {
            if (xoff == 0) {
                drawing.drawLine(-this.capsize_, yoff, this.capsize_, yoff);
            } else if (yoff == 0) {
                drawing.drawLine(xoff, -this.capsize_, xoff, this.capsize_);
            } else {
                int x0 = xoff;
                int y0 = yoff;
                double r1 = Math.sqrt(xoff * xoff + yoff * yoff);
                double capfact = (double)this.capsize_ / r1;
                int x1 = (int)Math.round(-capfact * (double)yoff);
                int y1 = (int)Math.round(capfact * (double)xoff);
                drawing.drawLine(x0 - x1, y0 - y1, x0 + x1, y0 + y1);
            }
        }

        @Override
        public void extendBounds(Rectangle bounds, int xoff, int yoff) {
            int cs = this.capsize_ + 1;
            if (xoff == 0) {
                bounds.add(-cs, yoff);
                bounds.add(cs, yoff);
            } else if (yoff == 0) {
                bounds.add(xoff, -cs);
                bounds.add(xoff, cs);
            } else {
                bounds.add(xoff - cs, yoff - cs);
                bounds.add(xoff - cs, yoff + cs);
                bounds.add(xoff + cs, yoff - cs);
                bounds.add(xoff + cs, yoff + cs);
            }
        }
    }

    @FunctionalInterface
    private static interface CapperFactory {
        public Capper getCapper(int var1);
    }

    private static interface Capper {
        public void drawCapX(Graphics var1, int var2);

        public void drawCapY(Graphics var1, int var2);

        public void drawCap(PixelDrawing var1, int var2, int var3);

        public void extendBounds(Rectangle var1, int var2, int var3);
    }

    private static class MultiPlaneShape
    extends ThickShape {
        private final Oblong shape2d_;

        MultiPlaneShape(Oblong shape2d) {
            super(shape2d.getName(), 3, shape2d.canThick());
            this.shape2d_ = shape2d;
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return ndim == 3 || ndim < 3 && this.shape2d_.supportsDimensionality(ndim);
        }

        @Override
        boolean isPadIcon() {
            return true;
        }

        @Override
        public LineScribe createBasicScribe() {
            LineScribe scribe2d = this.shape2d_.createBasicScribe();
            return new LineScribe(this, (xoffs, yoffs) -> {
                Iterable<int[][]> offsets = MultiPlaneShape.get2dOffsets(xoffs, yoffs);
                final ArrayList<LineGlyph> subGlyphs = new ArrayList<LineGlyph>();
                for (int[][] offs : MultiPlaneShape.get2dOffsets(xoffs, yoffs)) {
                    subGlyphs.add(scribe2d.createGlyph(offs[0], offs[1]));
                }
                return new LineGlyph(){

                    @Override
                    public Rectangle getPixelBounds() {
                        Rectangle bounds = new Rectangle(0, 0, 0, 0);
                        for (LineGlyph subgl : subGlyphs) {
                            bounds.add(subgl.getPixelBounds());
                        }
                        return bounds;
                    }

                    @Override
                    public void drawShape(PixelDrawing drawing) {
                        for (LineGlyph subgl : subGlyphs) {
                            subgl.drawShape(drawing);
                        }
                    }

                    @Override
                    public void paintGlyph(Graphics g, StrokeKit strokeKit) {
                        for (LineGlyph subgl : subGlyphs) {
                            subgl.paintGlyph(g, strokeKit);
                        }
                    }
                };
            });
        }

        private static Iterable<int[][]> get2dOffsets(final int[] xoffs, final int[] yoffs) {
            int ndim = xoffs.length / 2;
            if (ndim < 3) {
                return Collections.singletonList(new int[][]{xoffs, yoffs});
            }
            final int[] activeDims = new int[ndim];
            int iActiveDim = 0;
            for (int idim = 0; idim < ndim; ++idim) {
                int i2 = idim * 2;
                if (xoffs[i2 + 0] == 0 && yoffs[i2 + 0] == 0 && xoffs[i2 + 1] == 0 && yoffs[i2 + 1] == 0) continue;
                activeDims[iActiveDim++] = idim;
            }
            final int nActiveDim = iActiveDim;
            if (nActiveDim == 0) {
                return Collections.emptyList();
            }
            if (nActiveDim == 1) {
                int[][] offPairs = new int[2][2];
                int i2 = activeDims[0] * 2;
                offPairs[0][0] = xoffs[i2 + 0];
                offPairs[1][0] = yoffs[i2 + 0];
                offPairs[0][1] = xoffs[i2 + 1];
                offPairs[1][1] = yoffs[i2 + 1];
                return Collections.singletonList(offPairs);
            }
            assert (nActiveDim >= 2);
            return () -> new Iterator<int[][]>(){
                boolean done;
                int iActive = 0;
                int jActive = 1;

                @Override
                public int[][] next() {
                    if (this.done) {
                        throw new NoSuchElementException();
                    }
                    int i2 = activeDims[this.iActive] * 2;
                    int j2 = activeDims[this.jActive] * 2;
                    if (++this.iActive >= this.jActive) {
                        this.iActive = 0;
                        if (++this.jActive >= nActiveDim) {
                            this.done = true;
                        }
                    }
                    int[][] offPairs = new int[2][4];
                    offPairs[0][0] = xoffs[i2 + 0];
                    offPairs[1][0] = yoffs[i2 + 0];
                    offPairs[0][1] = xoffs[i2 + 1];
                    offPairs[1][1] = yoffs[i2 + 1];
                    offPairs[0][2] = xoffs[j2 + 0];
                    offPairs[1][2] = yoffs[j2 + 0];
                    offPairs[0][3] = xoffs[j2 + 1];
                    offPairs[1][3] = yoffs[j2 + 1];
                    return offPairs;
                }

                @Override
                public boolean hasNext() {
                    return !this.done;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
    }

    private static class OpenCuboid
    extends ThickShape {
        OpenCuboid(String name) {
            super(name, 3, true);
        }

        @Override
        boolean isPadIcon() {
            return true;
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return ndim == 3;
        }

        @Override
        public LineScribe createBasicScribe() {
            return new LineScribe(this, (xoffs, yoffs) -> new LineGlyph((int[])xoffs, (int[])yoffs){
                final /* synthetic */ int[] val$xoffs;
                final /* synthetic */ int[] val$yoffs;
                {
                    this.val$xoffs = nArray;
                    this.val$yoffs = nArray2;
                }

                @Override
                public Rectangle getPixelBounds() {
                    LineBounder bounder = new LineBounder();
                    this.doLines(bounder);
                    int width = bounder.xhi_ - bounder.xlo_;
                    int height = bounder.yhi_ - bounder.ylo_;
                    if (width > 0 || height > 0) {
                        ++width;
                        ++height;
                    }
                    return new Rectangle(bounder.xlo_, bounder.ylo_, width, height);
                }

                @Override
                public void drawShape(PixelDrawing drawing) {
                    this.doLines((x1, y1, x2, y2) -> drawing.drawLine(x1, y1, x2, y2));
                }

                @Override
                public void paintGlyph(Graphics g, StrokeKit strokeKit) {
                    Graphics2D g2 = (Graphics2D)g;
                    Stroke stroke0 = g2.getStroke();
                    g2.setStroke(strokeKit.getRound());
                    this.doLines((x1, y1, x2, y2) -> g.drawLine(x1, y1, x2, y2));
                    g2.setStroke(stroke0);
                }

                void doLines(LineConsumer liner) {
                    OpenCuboid.doCuboidLines(this.val$xoffs, this.val$yoffs, liner);
                }
            });
        }

        private static void doCuboidLines(int[] xoffs, int[] yoffs, LineConsumer liner) {
            int ndim = xoffs.length / 2;
            if (ndim == 1) {
                liner.line(xoffs[0], yoffs[0], xoffs[1], yoffs[1]);
            } else if (ndim == 2) {
                int x00 = xoffs[0] + xoffs[2];
                int x01 = xoffs[0] + xoffs[3];
                int x11 = xoffs[1] + xoffs[3];
                int x10 = xoffs[1] + xoffs[2];
                int y00 = yoffs[0] + yoffs[2];
                int y01 = yoffs[0] + yoffs[3];
                int y11 = yoffs[1] + yoffs[3];
                int y10 = yoffs[1] + yoffs[2];
                liner.line(x00, y00, x01, y01);
                liner.line(x01, y01, x11, y11);
                liner.line(x11, y11, x10, y10);
                liner.line(x10, y10, x00, y00);
            } else if (ndim == 3) {
                int x000 = xoffs[0] + xoffs[2] + xoffs[4];
                int x001 = xoffs[0] + xoffs[2] + xoffs[5];
                int x010 = xoffs[0] + xoffs[3] + xoffs[4];
                int x011 = xoffs[0] + xoffs[3] + xoffs[5];
                int x100 = xoffs[1] + xoffs[2] + xoffs[4];
                int x101 = xoffs[1] + xoffs[2] + xoffs[5];
                int x110 = xoffs[1] + xoffs[3] + xoffs[4];
                int x111 = xoffs[1] + xoffs[3] + xoffs[5];
                int y000 = yoffs[0] + yoffs[2] + yoffs[4];
                int y001 = yoffs[0] + yoffs[2] + yoffs[5];
                int y010 = yoffs[0] + yoffs[3] + yoffs[4];
                int y011 = yoffs[0] + yoffs[3] + yoffs[5];
                int y100 = yoffs[1] + yoffs[2] + yoffs[4];
                int y101 = yoffs[1] + yoffs[2] + yoffs[5];
                int y110 = yoffs[1] + yoffs[3] + yoffs[4];
                int y111 = yoffs[1] + yoffs[3] + yoffs[5];
                liner.line(x000, y000, x001, y001);
                liner.line(x000, y000, x010, y010);
                liner.line(x000, y000, x100, y100);
                liner.line(x001, y001, x011, y011);
                liner.line(x001, y001, x101, y101);
                liner.line(x010, y010, x011, y011);
                liner.line(x010, y010, x110, y110);
                liner.line(x100, y100, x101, y101);
                liner.line(x100, y100, x110, y110);
                liner.line(x011, y011, x111, y111);
                liner.line(x101, y101, x111, y111);
                liner.line(x110, y110, x111, y111);
            }
        }

        private static class LineBounder
        implements LineConsumer {
            int xlo_ = Integer.MAX_VALUE;
            int ylo_ = Integer.MAX_VALUE;
            int xhi_ = Integer.MIN_VALUE;
            int yhi_ = Integer.MIN_VALUE;

            private LineBounder() {
            }

            @Override
            public void line(int x1, int y1, int x2, int y2) {
                this.xlo_ = Math.min(this.xlo_, Math.min(x1, x2));
                this.ylo_ = Math.min(this.ylo_, Math.min(y1, y2));
                this.xhi_ = Math.max(this.xhi_, Math.max(x1, x2));
                this.yhi_ = Math.max(this.yhi_, Math.max(y1, y2));
            }
        }

        @FunctionalInterface
        private static interface LineConsumer {
            public void line(int var1, int var2, int var3, int var4);
        }
    }

    private static class FilledRectangle
    extends Oblong {
        public FilledRectangle(String name) {
            super(name, false, false);
        }

        @Override
        public LineScribe createBasicScribe() {
            return new LineScribe(this, (xoffs, yoffs) -> new OblongGlyph((int[])xoffs, (int[])yoffs, false, (int[])xoffs, (int[])yoffs){
                final /* synthetic */ int[] val$xoffs;
                final /* synthetic */ int[] val$yoffs;
                {
                    this.val$xoffs = nArray;
                    this.val$yoffs = nArray2;
                    super(xoffs, yoffs, withLines);
                }

                @Override
                void paintOblong(Graphics g, int x, int y, int width, int height) {
                    g.fillRect(x, y, width, height);
                }

                @Override
                public void drawShape(PixelDrawing drawing) {
                    if (this.val$xoffs.length != 4 || this.val$yoffs.length != 4) {
                        return;
                    }
                    if (this.val$yoffs[0] == 0 && this.val$yoffs[1] == 0 && this.val$xoffs[2] == 0 && this.val$xoffs[3] == 0) {
                        int xlo = Math.min(this.val$xoffs[0], this.val$xoffs[1]);
                        int xhi = Math.max(this.val$xoffs[0], this.val$xoffs[1]);
                        int ylo = Math.min(this.val$yoffs[2], this.val$yoffs[3]);
                        int yhi = Math.max(this.val$yoffs[2], this.val$yoffs[3]);
                        int width = xhi - xlo;
                        int height = yhi - ylo;
                        drawing.fillRect(xlo, ylo, width, height);
                    } else {
                        int[] xof = new int[]{this.val$xoffs[0] + this.val$xoffs[2], this.val$xoffs[1] + this.val$xoffs[2], this.val$xoffs[1] + this.val$xoffs[3], this.val$xoffs[0] + this.val$xoffs[3]};
                        int[] yof = new int[]{this.val$yoffs[0] + this.val$yoffs[2], this.val$yoffs[1] + this.val$yoffs[2], this.val$yoffs[1] + this.val$yoffs[3], this.val$yoffs[0] + this.val$yoffs[3]};
                        drawing.fillPolygon(xof, yof, 4);
                    }
                }
            });
        }
    }

    private static class OpenRectangle
    extends Oblong {
        private final boolean withLines_;

        public OpenRectangle(String name, boolean withLines) {
            super(name, withLines, true);
            this.withLines_ = withLines;
        }

        @Override
        public LineScribe createBasicScribe() {
            return new LineScribe(this, (xoffs, yoffs) -> new OblongGlyph((int[])xoffs, (int[])yoffs, this.withLines_, (int[])xoffs, (int[])yoffs){
                final /* synthetic */ int[] val$xoffs;
                final /* synthetic */ int[] val$yoffs;
                {
                    this.val$xoffs = nArray;
                    this.val$yoffs = nArray2;
                    super(xoffs, yoffs, withLines);
                }

                @Override
                void paintOblong(Graphics g, int x, int y, int width, int height) {
                    g.drawRect(x, y, width, height);
                }

                @Override
                public void drawShape(PixelDrawing drawing) {
                    if (this.val$xoffs.length != 4 || this.val$yoffs.length != 4) {
                        return;
                    }
                    int xa = this.val$xoffs[0] + this.val$xoffs[2];
                    int xb = this.val$xoffs[0] + this.val$xoffs[3];
                    int xc = this.val$xoffs[1] + this.val$xoffs[3];
                    int xd = this.val$xoffs[1] + this.val$xoffs[2];
                    int ya = this.val$yoffs[0] + this.val$yoffs[2];
                    int yb = this.val$yoffs[0] + this.val$yoffs[3];
                    int yc = this.val$yoffs[1] + this.val$yoffs[3];
                    int yd = this.val$yoffs[1] + this.val$yoffs[2];
                    drawing.drawLine(xa, ya, xb, yb);
                    drawing.drawLine(xb, yb, xc, yc);
                    drawing.drawLine(xc, yc, xd, yd);
                    drawing.drawLine(xd, yd, xa, ya);
                    if (this.withLines_) {
                        for (int i = 0; i < 4; ++i) {
                            drawing.drawLine(0, 0, this.val$xoffs[i], this.val$yoffs[i]);
                        }
                    }
                }
            });
        }
    }

    private static class FilledEllipse
    extends Oblong {
        public FilledEllipse(String name) {
            super(name, false, false);
        }

        @Override
        public LineScribe createBasicScribe() {
            return new LineScribe(this, (xoffs, yoffs) -> new OblongGlyph((int[])xoffs, (int[])yoffs, false, (int[])xoffs, (int[])yoffs){
                final /* synthetic */ int[] val$xoffs;
                final /* synthetic */ int[] val$yoffs;
                {
                    this.val$xoffs = nArray;
                    this.val$yoffs = nArray2;
                    super(xoffs, yoffs, withLines);
                }

                @Override
                void paintOblong(Graphics g, int x, int y, int width, int height) {
                    g.fillOval(x, y, width, height);
                }

                @Override
                public void drawShape(PixelDrawing drawing) {
                    if (this.val$xoffs.length != 4 || this.val$yoffs.length != 4) {
                        return;
                    }
                    if (this.val$yoffs[0] == 0 && this.val$yoffs[1] == 0 && this.val$xoffs[2] == 0 && this.val$xoffs[3] == 0) {
                        int xlo = Math.min(this.val$xoffs[0], this.val$xoffs[1]);
                        int xhi = Math.max(this.val$xoffs[0], this.val$xoffs[1]);
                        int ylo = Math.min(this.val$yoffs[2], this.val$yoffs[3]);
                        int yhi = Math.max(this.val$yoffs[2], this.val$yoffs[3]);
                        int width = xhi - xlo;
                        int height = yhi - ylo;
                        drawing.fillOval(xlo, ylo, width, height);
                    } else {
                        int ax = (this.val$xoffs[1] - this.val$xoffs[0]) / 2;
                        int ay = (this.val$yoffs[1] - this.val$yoffs[0]) / 2;
                        int bx = (this.val$xoffs[3] - this.val$xoffs[2]) / 2;
                        int by = (this.val$yoffs[3] - this.val$yoffs[2]) / 2;
                        int x0 = Math.round((float)(this.val$xoffs[0] + this.val$xoffs[1] + this.val$xoffs[2] + this.val$xoffs[3]) / 2.0f);
                        int y0 = Math.round((float)(this.val$yoffs[0] + this.val$yoffs[1] + this.val$yoffs[2] + this.val$yoffs[3]) / 2.0f);
                        drawing.fillEllipse(x0, y0, ax, ay, bx, by);
                    }
                }
            });
        }
    }

    private static class OpenEllipse
    extends Oblong {
        private final boolean withLines_;

        public OpenEllipse(String name, boolean withLines) {
            super(name, withLines, true);
            this.withLines_ = withLines;
        }

        @Override
        public LineScribe createBasicScribe() {
            return new LineScribe(this, (xoffs, yoffs) -> new OblongGlyph((int[])xoffs, (int[])yoffs, this.withLines_, (int[])xoffs, (int[])yoffs){
                final /* synthetic */ int[] val$xoffs;
                final /* synthetic */ int[] val$yoffs;
                {
                    this.val$xoffs = nArray;
                    this.val$yoffs = nArray2;
                    super(xoffs, yoffs, withLines);
                }

                @Override
                void paintOblong(Graphics g, int x, int y, int width, int height) {
                    g.drawOval(x, y, width, height);
                }

                @Override
                public void drawShape(PixelDrawing drawing) {
                    if (this.val$xoffs.length != 4 || this.val$yoffs.length != 4) {
                        return;
                    }
                    if (this.val$yoffs[0] == 0 && this.val$yoffs[1] == 0 && this.val$xoffs[2] == 0 && this.val$xoffs[3] == 0) {
                        int xlo = Math.min(this.val$xoffs[0], this.val$xoffs[1]);
                        int xhi = Math.max(this.val$xoffs[0], this.val$xoffs[1]);
                        int ylo = Math.min(this.val$yoffs[2], this.val$yoffs[3]);
                        int yhi = Math.max(this.val$yoffs[2], this.val$yoffs[3]);
                        int width = xhi - xlo;
                        int height = yhi - ylo;
                        drawing.drawOval(xlo, ylo, width, height);
                    } else {
                        int ax = (this.val$xoffs[1] - this.val$xoffs[0]) / 2;
                        int ay = (this.val$yoffs[1] - this.val$yoffs[0]) / 2;
                        int bx = (this.val$xoffs[3] - this.val$xoffs[2]) / 2;
                        int by = (this.val$yoffs[3] - this.val$yoffs[2]) / 2;
                        int x0 = Math.round((float)(this.val$xoffs[0] + this.val$xoffs[1] + this.val$xoffs[2] + this.val$xoffs[3]) / 2.0f);
                        int y0 = Math.round((float)(this.val$yoffs[0] + this.val$yoffs[1] + this.val$yoffs[2] + this.val$yoffs[3]) / 2.0f);
                        drawing.drawEllipse(x0, y0, ax, ay, bx, by);
                    }
                    if (this.withLines_) {
                        for (int i = 0; i < 4; ++i) {
                            drawing.drawLine(0, 0, this.val$xoffs[i], this.val$yoffs[i]);
                        }
                    }
                }
            });
        }
    }

    private static abstract class Oblong
    extends ThickShape {
        private final boolean withLines_;

        Oblong(String name, boolean withLines, boolean canThick) {
            super(name, 2, withLines || canThick);
            this.withLines_ = withLines;
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return ndim == 2;
        }
    }

    private static class Triangle
    extends ThickShape {
        private final boolean isFill_;

        public Triangle(String name, boolean isFill) {
            super(name, 2, !isFill);
            this.isFill_ = isFill;
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return ndim == 2;
        }

        @Override
        public LineScribe createBasicScribe() {
            return new LineScribe(this, (xoffs, yoffs) -> new LineGlyph((int[])xoffs, (int[])yoffs){
                final Polygon triangle;
                final /* synthetic */ int[] val$xoffs;
                final /* synthetic */ int[] val$yoffs;
                {
                    this.val$xoffs = nArray;
                    this.val$yoffs = nArray2;
                    this.triangle = Triangle.getTriangle(this.val$xoffs, this.val$yoffs);
                }

                @Override
                public Rectangle getPixelBounds() {
                    return this.triangle.getBounds();
                }

                @Override
                public void drawShape(PixelDrawing drawing) {
                    int[] xs = this.triangle.xpoints;
                    int[] ys = this.triangle.ypoints;
                    if (isFill_) {
                        drawing.fillPolygon(xs, ys, 3);
                    } else {
                        drawing.drawLine(xs[1], ys[1], xs[2], ys[2]);
                        drawing.drawLine(xs[2], ys[2], xs[0], ys[0]);
                        drawing.drawLine(xs[0], ys[0], xs[1], ys[1]);
                    }
                }

                @Override
                public void paintGlyph(Graphics g, StrokeKit strokeKit) {
                    Polygon tri;
                    Dimension size = MultiPointShape.getApproxGraphicsSize((Graphics2D)g);
                    int dmax = Math.max(size.width, size.height);
                    boolean ok = true;
                    for (int ip = 0; ip < 4 && ok; ++ip) {
                        ok = ok && Math.abs(this.val$xoffs[ip]) < dmax && Math.abs(this.val$yoffs[ip]) < dmax;
                    }
                    if (ok) {
                        tri = this.triangle;
                    } else {
                        int[] xoffs1 = (int[])this.val$xoffs.clone();
                        int[] yoffs1 = (int[])this.val$yoffs.clone();
                        for (int ip = 0; ip < 4; ++ip) {
                            xoffs1[ip] = Math.min(dmax, Math.max(-dmax, this.val$xoffs[ip]));
                            yoffs1[ip] = Math.min(dmax, Math.max(-dmax, this.val$yoffs[ip]));
                        }
                        tri = Triangle.getTriangle(xoffs1, yoffs1);
                    }
                    if (isFill_) {
                        g.fillPolygon(tri);
                    } else {
                        Graphics2D g2 = (Graphics2D)g;
                        Stroke stroke0 = g2.getStroke();
                        g2.setStroke(strokeKit.getRound());
                        g.drawPolygon(tri);
                        g2.setStroke(stroke0);
                    }
                }
            });
        }

        private static Polygon getTriangle(int[] xoffs, int[] yoffs) {
            int[] xs = new int[3];
            int[] ys = new int[3];
            xs[0] = xoffs[1];
            ys[0] = yoffs[1];
            xs[1] = xoffs[0] + xoffs[2];
            ys[1] = yoffs[0] + yoffs[2];
            xs[2] = xoffs[0] + xoffs[3];
            ys[2] = yoffs[0] + yoffs[3];
            return new Polygon(xs, ys, 3);
        }
    }

    private static class Dart
    extends MultiPointShape {
        private final boolean isFill_;
        private final int basepix_;

        public Dart(String name, boolean isFill, int basepix) {
            super(name, 2, !isFill);
            this.isFill_ = isFill;
            this.basepix_ = basepix;
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return ndim > 0;
        }

        @Override
        public MultiPointScribe createScribe(int nthick) {
            int basepix = this.basepix_ + (this.canThick() ? nthick * 2 : 0);
            LineScribe scribe = this.createBasicScribe(basepix);
            return this.canThick() && nthick > 0 ? new ThickScribe(scribe, nthick) : scribe;
        }

        private LineScribe createBasicScribe(int basepix) {
            int[] vys = new int[]{basepix, 0, -basepix};
            return new LineScribe(this, (xoffs, yoffs) -> new LineGlyph((int[])xoffs, (int[])yoffs, basepix, vys){
                int np;
                final /* synthetic */ int[] val$xoffs;
                final /* synthetic */ int[] val$yoffs;
                final /* synthetic */ int val$basepix;
                final /* synthetic */ int[] val$vys;
                {
                    this.val$xoffs = nArray;
                    this.val$yoffs = nArray2;
                    this.val$basepix = n;
                    this.val$vys = nArray3;
                    this.np = this.val$xoffs.length;
                }

                @Override
                public Rectangle getPixelBounds() {
                    Rectangle box = new Rectangle();
                    for (int ip = 0; ip < this.np; ++ip) {
                        int xoff = this.val$xoffs[ip];
                        int yoff = this.val$yoffs[ip];
                        if (xoff == 0 && yoff == 0) continue;
                        box.add(xoff, yoff);
                        Point bp = this.getBaseVertex(this.val$basepix, xoff, yoff);
                        box.add(bp.x, bp.y);
                        box.add(-bp.x, -bp.y);
                        ++box.width;
                        ++box.height;
                    }
                    return box;
                }

                @Override
                public void drawShape(PixelDrawing drawing) {
                    for (int ip = 0; ip < this.np; ++ip) {
                        int xoff = this.val$xoffs[ip];
                        int yoff = this.val$yoffs[ip];
                        if (xoff == 0 && yoff == 0) continue;
                        Point bp = this.getBaseVertex(this.val$basepix, xoff, yoff);
                        int x1 = xoff;
                        int y1 = yoff;
                        int x2 = bp.x;
                        int y2 = bp.y;
                        int x3 = -bp.x;
                        int y3 = -bp.y;
                        if (isFill_) {
                            drawing.fillPolygon(new int[]{x1, x2, x3}, new int[]{y1, y2, y3}, 3);
                            continue;
                        }
                        drawing.drawLine(x1, y1, x2, y2);
                        drawing.drawLine(x2, y2, x3, y3);
                        drawing.drawLine(x3, y3, x1, y1);
                    }
                }

                @Override
                public void paintGlyph(Graphics g, StrokeKit strokeKit) {
                    Rectangle clip = g.getClipBounds();
                    Graphics2D g2 = (Graphics2D)g;
                    Stroke stroke0 = g2.getStroke();
                    g2.setStroke(strokeKit.getRound());
                    Dimension size = MultiPointShape.getApproxGraphicsSize(g2);
                    double dmax = Math.max(size.width, size.height);
                    int np = this.val$xoffs.length;
                    for (int ip = 0; ip < np; ++ip) {
                        double dx = this.val$xoffs[ip];
                        double dy = this.val$yoffs[ip];
                        if (dx == 0.0 && dy == 0.0) continue;
                        double dleng = Math.min(Math.hypot(dx, dy), dmax);
                        AffineTransform trans0 = g2.getTransform();
                        g2.rotate(Math.atan2(dy, dx));
                        int[] xs = new int[]{0, (int)Math.round(dleng), 0};
                        if (isFill_) {
                            g2.fillPolygon(xs, this.val$vys, 3);
                        } else {
                            g2.drawPolygon(xs, this.val$vys, 3);
                        }
                        g2.setTransform(trans0);
                    }
                    g2.setStroke(stroke0);
                }
            });
        }

        private Point getBaseVertex(int basepix, int xoff, int yoff) {
            double dx = xoff;
            double dy = yoff;
            double dscale = 1.0 / Math.hypot(dx, dy);
            return new Point(-((int)Math.round((double)basepix * dy * dscale)), (int)Math.round((double)basepix * dx * dscale));
        }
    }

    private static class CappedLine
    extends MultiPointShape {
        private final boolean hasLine_;
        private final CapperFactory capperFact_;

        CappedLine(String name, boolean hasLine, CapperFactory capperFact) {
            super(name, 2, true);
            this.hasLine_ = hasLine;
            this.capperFact_ = capperFact;
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return true;
        }

        @Override
        public MultiPointScribe createScribe(int nthick) {
            Capper capper = this.capperFact_ == null ? null : this.capperFact_.getCapper(nthick);
            LineScribe scribe = this.createBasicScribe(capper);
            return nthick > 0 ? new ThickScribe(scribe, nthick) : scribe;
        }

        private LineScribe createBasicScribe(Capper capper) {
            return new LineScribe(this, (xoffs, yoffs) -> new LineGlyph((int[])xoffs, (int[])yoffs, capper){
                final /* synthetic */ int[] val$xoffs;
                final /* synthetic */ int[] val$yoffs;
                final /* synthetic */ Capper val$capper;
                {
                    this.val$xoffs = nArray;
                    this.val$yoffs = nArray2;
                    this.val$capper = capper;
                }

                @Override
                public Rectangle getPixelBounds() {
                    int np = this.val$xoffs.length;
                    boolean empty = true;
                    Rectangle box = new Rectangle();
                    for (int ip = 0; ip < np; ++ip) {
                        int xoff = this.val$xoffs[ip];
                        int yoff = this.val$yoffs[ip];
                        if (xoff == 0 && yoff == 0) continue;
                        empty = false;
                        box.add(xoff, yoff);
                        if (this.val$capper == null) continue;
                        this.val$capper.extendBounds(box, xoff, yoff);
                    }
                    if (!empty) {
                        ++box.width;
                        ++box.height;
                    }
                    return box;
                }

                @Override
                public void paintGlyph(Graphics g, StrokeKit strokeKit) {
                    CappedLine.drawCappedLine(g, this.val$xoffs, this.val$yoffs, hasLine_, this.val$capper, false, strokeKit);
                }

                @Override
                public void drawShape(PixelDrawing drawing) {
                    int np = this.val$xoffs.length;
                    for (int ip = 0; ip < np; ++ip) {
                        int xoff = this.val$xoffs[ip];
                        int yoff = this.val$yoffs[ip];
                        if (xoff == 0 && yoff == 0) continue;
                        if (hasLine_) {
                            drawing.drawLine(0, 0, xoff, yoff);
                        }
                        if (this.val$capper == null) continue;
                        this.val$capper.drawCap(drawing, xoff, yoff);
                    }
                }
            });
        }

        private static void drawCappedLine(Graphics g, int[] xoffs, int[] yoffs, boolean hasLine, Capper capper, boolean willCover, StrokeKit strokeKit) {
            Graphics2D g2 = (Graphics2D)g;
            Stroke oldStroke = g2.getStroke();
            g2.setStroke(capper != null || willCover ? strokeKit.getButt() : strokeKit.getRound());
            Dimension size = MultiPointShape.getApproxGraphicsSize(g2);
            int xmax = size.width;
            int ymax = size.height;
            int np = xoffs.length;
            for (int ip = 0; ip < np; ++ip) {
                boolean clipped;
                int xoff = xoffs[ip];
                int yoff = yoffs[ip];
                if (xoff == 0 && yoff == 0) continue;
                boolean xlo = xoff < -xmax;
                boolean xhi = xoff > xmax;
                boolean ylo = yoff < -ymax;
                boolean yhi = yoff > ymax;
                boolean bl = clipped = xlo || xhi || ylo || yhi;
                if (clipped) {
                    if (xlo && yoff == 0) {
                        xoff = -xmax;
                    } else if (xhi && yoff == 0) {
                        xoff = xmax;
                    } else if (ylo && xoff == 0) {
                        yoff = -ymax;
                    } else if (yhi && xoff == 0) {
                        yoff = ymax;
                    } else {
                        double s2 = (double)(xmax * xmax + ymax * ymax) / (double)(xoff * xoff + yoff * yoff);
                        double shrink = Math.sqrt(s2);
                        xoff = (int)Math.ceil(shrink * (double)xoff);
                        yoff = (int)Math.ceil(shrink * (double)yoff);
                    }
                }
                if (hasLine) {
                    g.drawLine(0, 0, xoff, yoff);
                }
                if (capper == null || clipped) continue;
                g2.setStroke(strokeKit.getRound());
                if (xoff == 0) {
                    capper.drawCapY(g2, yoff);
                    continue;
                }
                if (yoff == 0) {
                    capper.drawCapX(g2, xoff);
                    continue;
                }
                AffineTransform oldTransform = g2.getTransform();
                g2.rotate(Math.atan2(yoff, xoff));
                double l2 = xoff * xoff + yoff * yoff;
                int leng = (int)Math.round(Math.sqrt(l2));
                capper.drawCapX(g2, leng);
                g2.setTransform(oldTransform);
            }
            g2.setStroke(oldStroke);
        }
    }

    private static class Blank
    extends MultiPointShape {
        private final MultiPointScribe scribe_;

        Blank(String name) {
            super(name, 1, false);
            final Glyph glyph = new Glyph(){

                @Override
                public Pixer createPixer(Rectangle clip) {
                    return null;
                }

                @Override
                public void paintGlyph(Graphics g) {
                }
            };
            this.scribe_ = new MultiPointScribe(){

                @Override
                public Glyph createGlyph(int[] xoffs, int[] yoffs) {
                    return glyph;
                }
            };
        }

        @Override
        public boolean supportsDimensionality(int ndim) {
            return true;
        }

        @Override
        public MultiPointScribe createScribe(int nthick) {
            return this.scribe_;
        }
    }

    private static class ThickScribe
    implements MultiPointScribe {
        private final LineScribe baseScribe_;
        private final int nthick_;
        private final PixerFactory kernel_;
        private final StrokeKit strokeKit_;

        ThickScribe(LineScribe baseScribe, int nthick) {
            this(baseScribe, nthick, LineGlyph.createThickKernel(nthick), LineGlyph.createThickStrokeKit(nthick));
        }

        ThickScribe(LineScribe baseScribe, int nthick, PixerFactory kernel, StrokeKit strokeKit) {
            this.baseScribe_ = baseScribe;
            this.nthick_ = nthick;
            this.kernel_ = kernel;
            this.strokeKit_ = strokeKit;
        }

        @Override
        public Glyph createGlyph(int[] xoffs, int[] yoffs) {
            return this.baseScribe_.createGlyph(xoffs, yoffs).toThicker(this.kernel_, this.strokeKit_);
        }

        public int hashCode() {
            int code = 92342;
            code = 23 * code + this.baseScribe_.hashCode();
            code = 23 * code + this.nthick_;
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof ThickScribe) {
                ThickScribe other = (ThickScribe)o;
                return this.baseScribe_.equals(other.baseScribe_) && this.nthick_ == other.nthick_;
            }
            return false;
        }
    }

    private static class LineScribe
    implements MultiPointScribe {
        private final MultiPointShape shape_;
        private final BiFunction<int[], int[], LineGlyph> createGlyph_;

        LineScribe(MultiPointShape shape, BiFunction<int[], int[], LineGlyph> createGlyph) {
            this.shape_ = shape;
            this.createGlyph_ = createGlyph;
        }

        @Override
        public LineGlyph createGlyph(int[] xoffs, int[] yoffs) {
            return this.createGlyph_.apply(xoffs, yoffs);
        }

        public int hashCode() {
            return this.shape_.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof LineScribe) {
                LineScribe other = (LineScribe)o;
                return this.shape_.equals(other.shape_);
            }
            return false;
        }
    }

    private static class MultiPointIcon
    implements Icon {
        private final int width_;
        private final int height_;
        private final Glyph glyph_;
        private final int xoff_;
        private final int yoff_;

        public MultiPointIcon(MultiPointShape shape, int ndim) {
            this(shape.createScribe(0), MultiPointIcon.fillModeArray(ndim, ErrorMode.SYMMETRIC), 40, 16, 5, 1);
        }

        public MultiPointIcon(MultiPointScribe scribe, ErrorMode[] modes, int width, int height, int xpad, int ypad) {
            ErrorMode zmode;
            ErrorMode ymode;
            ErrorMode xmode;
            this.width_ = width;
            this.height_ = height;
            int w2 = width / 2 - xpad;
            int h2 = height / 2 - ypad;
            int ndim = modes.length;
            ArrayList<Point> offList = new ArrayList<Point>(ndim);
            if (ndim > 0 && !ErrorMode.NONE.equals(xmode = modes[0])) {
                float xlo = (float)xmode.getExampleLower();
                float xhi = (float)xmode.getExampleUpper();
                offList.add(new Point(Math.round(-xlo * (float)w2), 0));
                offList.add(new Point(Math.round(xhi * (float)w2), 0));
            }
            if (ndim > 1 && !ErrorMode.NONE.equals(ymode = modes[1])) {
                float ylo = (float)ymode.getExampleLower();
                float yhi = (float)ymode.getExampleUpper();
                offList.add(new Point(0, Math.round(ylo * (float)h2)));
                offList.add(new Point(0, Math.round(-yhi * (float)h2)));
            }
            if (ndim > 2 && !ErrorMode.NONE.equals(zmode = modes[2])) {
                float zlo = (float)zmode.getExampleLower();
                float zhi = (float)zmode.getExampleUpper();
                float theta = (float)Math.toRadians(40.0);
                float slant = 0.8f;
                float c = (float)Math.cos(theta) * slant;
                float s = (float)Math.sin(theta) * slant;
                offList.add(new Point(Math.round(-c * zlo * (float)w2), Math.round(s * zlo * (float)h2)));
                offList.add(new Point(Math.round(c * zhi * (float)w2), Math.round(-s * zhi * (float)h2)));
            }
            int np = offList.size();
            int[] xoffs = new int[np];
            int[] yoffs = new int[np];
            for (int ip = 0; ip < np; ++ip) {
                Point point = (Point)offList.get(ip);
                xoffs[ip] = point.x;
                yoffs[ip] = point.y;
            }
            this.glyph_ = scribe.createGlyph(xoffs, yoffs);
            this.xoff_ = width / 2;
            this.yoff_ = height / 2;
        }

        @Override
        public int getIconWidth() {
            return this.width_;
        }

        @Override
        public int getIconHeight() {
            return this.height_;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2 = (Graphics2D)g;
            Object aaHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.translate(x + this.xoff_, y + this.yoff_);
            this.glyph_.paintGlyph(g2);
            g2.translate(-(x + this.xoff_), -(y + this.yoff_));
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, aaHint);
        }

        private static ErrorMode[] fillModeArray(int leng, ErrorMode mode) {
            Object[] modes = new ErrorMode[leng];
            Arrays.fill(modes, mode);
            return modes;
        }
    }

    private static abstract class ThickShape
    extends MultiPointShape {
        protected ThickShape(String name, int iconDim, boolean canThick) {
            super(name, iconDim, canThick);
        }

        abstract LineScribe createBasicScribe();

        @Override
        public MultiPointScribe createScribe(int nthick) {
            LineScribe scribe = this.createBasicScribe();
            return this.canThick() && nthick > 0 ? new ThickScribe(scribe, nthick) : scribe;
        }
    }
}

