/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Point;
import java.awt.Rectangle;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.layer.PixelDrawing;
import uk.ac.starlink.ttools.plot2.layer.PixerFactory;
import uk.ac.starlink.util.IntList;

public class Pixers {
    public static final Pixer EMPTY = new Pixer(){

        @Override
        public boolean next() {
            return false;
        }

        @Override
        public int getX() {
            throw new IllegalStateException();
        }

        @Override
        public int getY() {
            throw new IllegalStateException();
        }
    };

    private Pixers() {
    }

    public static Pixer createArrayPixer(final int[] xs, final int[] ys, final int np) {
        return new Pixer(){
            int ip = -1;

            @Override
            public boolean next() {
                return ++this.ip < np;
            }

            @Override
            public int getX() {
                return xs[this.ip];
            }

            @Override
            public int getY() {
                return ys[this.ip];
            }
        };
    }

    public static Pixer createPointsPixer(final Point[] points) {
        final int np = points.length;
        return new Pixer(){
            int ip = -1;

            @Override
            public boolean next() {
                return ++this.ip < np;
            }

            @Override
            public int getX() {
                return points[this.ip].x;
            }

            @Override
            public int getY() {
                return points[this.ip].y;
            }
        };
    }

    public static PixerFactory copy(PixerFactory base) {
        final int xmin = base.getMinX();
        final int xmax = base.getMaxX();
        final int ymin = base.getMinY();
        final int ymax = base.getMaxY();
        final int npix = base.getPixelCount();
        final int[] xs = new int[npix];
        final int[] ys = new int[npix];
        int ip = 0;
        Pixer pixer = base.createPixer();
        while (pixer.next()) {
            xs[ip] = pixer.getX();
            ys[ip] = pixer.getY();
            ++ip;
        }
        assert (ip == npix);
        return new PixerFactory(){

            @Override
            public int getMinX() {
                return xmin;
            }

            @Override
            public int getMaxX() {
                return xmax;
            }

            @Override
            public int getMinY() {
                return ymin;
            }

            @Override
            public int getMaxY() {
                return ymax;
            }

            @Override
            public int getPixelCount() {
                return npix;
            }

            @Override
            public Pixer createPixer() {
                return Pixers.createArrayPixer(xs, ys, npix);
            }
        };
    }

    public static PixerFactory createPixerCopier(Pixer pixer) {
        IntList xlist = new IntList();
        IntList ylist = new IntList();
        int ip = 0;
        int xmin = Integer.MAX_VALUE;
        int xmax = Integer.MIN_VALUE;
        int ymin = Integer.MAX_VALUE;
        int ymax = Integer.MIN_VALUE;
        while (pixer.next()) {
            int x = pixer.getX();
            int y = pixer.getY();
            xlist.add(x);
            ylist.add(y);
            xmin = Math.min(xmin, x);
            xmax = Math.max(xmax, x);
            ymin = Math.min(ymin, y);
            ymax = Math.max(ymax, y);
            ++ip;
        }
        final int[] xs = xlist.toIntArray();
        final int[] ys = ylist.toIntArray();
        final int np = ip;
        final int xmin0 = xmin;
        final int xmax0 = xmax;
        final int ymin0 = ymin;
        final int ymax0 = ymax;
        return new PixerFactory(){

            @Override
            public Pixer createPixer() {
                return Pixers.createArrayPixer(xs, ys, np);
            }

            @Override
            public int getPixelCount() {
                return np;
            }

            @Override
            public int getMinX() {
                return xmin0;
            }

            @Override
            public int getMaxX() {
                return xmax0;
            }

            @Override
            public int getMinY() {
                return ymin0;
            }

            @Override
            public int getMaxY() {
                return ymax0;
            }
        };
    }

    public static Pixer translate(final Pixer base, final int tx, final int ty) {
        return new Pixer(){

            @Override
            public boolean next() {
                return base.next();
            }

            @Override
            public int getX() {
                return base.getX() + tx;
            }

            @Override
            public int getY() {
                return base.getY() + ty;
            }
        };
    }

    public static Pixer clip(Pixer base, Rectangle clip) {
        return new ClipPixer(base, clip.x, clip.x + clip.width - 1, clip.y, clip.y + clip.height - 1);
    }

    public static Pixer createClippedPixer(PixerFactory pfact, Rectangle clip) {
        int ymaxBase;
        int xmaxBase;
        int xminClip = clip.x;
        int xmaxClip = clip.x + clip.width - 1;
        int xminBase = pfact.getMinX();
        int xcmp = Pixers.compare(xminClip, xmaxClip, xminBase, xmaxBase = pfact.getMaxX());
        if (xcmp == 0) {
            return null;
        }
        int yminClip = clip.y;
        int ymaxClip = clip.y + clip.height - 1;
        int yminBase = pfact.getMinY();
        int ycmp = Pixers.compare(yminClip, ymaxClip, yminBase, ymaxBase = pfact.getMaxY());
        if (ycmp == 0) {
            return null;
        }
        if (xcmp == 1 && ycmp == 1) {
            return pfact.createPixer();
        }
        int xmin = Math.max(xminClip, xminBase);
        int xmax = Math.min(xmaxClip, xmaxBase);
        int ymin = Math.max(yminClip, yminBase);
        int ymax = Math.min(ymaxClip, ymaxBase);
        return new ClipPixer(pfact.createPixer(), xmin, xmax, ymin, ymax);
    }

    public static Pixer clip(Pixer base, Rectangle clip, int xminBase, int xmaxBase, int yminBase, int ymaxBase) {
        if (base == null) {
            return null;
        }
        int xminClip = clip.x;
        int xmaxClip = clip.x + clip.width - 1;
        int yminClip = clip.y;
        int ymaxClip = clip.y + clip.height - 1;
        int xcmp = Pixers.compare(xminClip, xmaxClip, xminBase, xmaxBase);
        if (xcmp == 0) {
            return null;
        }
        int ycmp = Pixers.compare(yminClip, ymaxClip, yminBase, ymaxBase);
        if (ycmp == 0) {
            return null;
        }
        if (xcmp == 1 && ycmp == 1) {
            return base;
        }
        int xmin = Math.max(xminClip, xminBase);
        int xmax = Math.min(xmaxClip, xmaxBase);
        int ymin = Math.max(yminClip, yminBase);
        int ymax = Math.min(ymaxClip, ymaxBase);
        return new ClipPixer(base, xmin, xmax, ymin, ymax);
    }

    public static PixelDrawing convolve(PixerFactory shape, PixerFactory kernel, Rectangle clip) {
        int xlo = Math.max(shape.getMinX() + kernel.getMinX(), clip.x);
        int ylo = Math.max(shape.getMinY() + kernel.getMinY(), clip.y);
        int xhi = Math.min(shape.getMaxX() + kernel.getMaxX(), clip.x + clip.width - 1);
        int yhi = Math.min(shape.getMaxY() + kernel.getMaxY(), clip.y + clip.height - 1);
        PixelDrawing drawing = new PixelDrawing(xlo, ylo, xhi - xlo + 1, yhi - ylo + 1);
        Pixer spixer = shape.createPixer();
        while (spixer.next()) {
            int sx = spixer.getX();
            int sy = spixer.getY();
            Pixer kpixer = kernel.createPixer();
            while (kpixer.next()) {
                int kx = kpixer.getX();
                int ky = kpixer.getY();
                drawing.addPixel(sx + kx, sy + ky);
            }
        }
        return drawing;
    }

    private static int compare(int minOuter, int maxOuter, int minInner, int maxInner) {
        if (minInner > maxOuter || maxInner < minOuter) {
            return 0;
        }
        if (minInner >= minOuter && maxInner <= maxOuter) {
            return 1;
        }
        return -1;
    }

    private static class ClipPixer
    implements Pixer {
        private final Pixer base_;
        private final int xmin_;
        private final int xmax_;
        private final int ymin_;
        private final int ymax_;

        ClipPixer(Pixer base, int xmin, int xmax, int ymin, int ymax) {
            this.xmin_ = xmin;
            this.xmax_ = xmax;
            this.ymin_ = ymin;
            this.ymax_ = ymax;
            this.base_ = base;
        }

        @Override
        public boolean next() {
            while (this.base_.next()) {
                if (!ClipPixer.contains(this.xmin_, this.xmax_, this.base_.getX()) || !ClipPixer.contains(this.ymin_, this.ymax_, this.base_.getY())) continue;
                return true;
            }
            return false;
        }

        @Override
        public int getX() {
            return this.base_.getX();
        }

        @Override
        public int getY() {
            return this.base_.getY();
        }

        private static boolean contains(int min, int max, int value) {
            return value >= min && value <= max;
        }
    }
}

