/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.util.Arrays;
import uk.ac.starlink.ttools.plot2.Equality;
import uk.ac.starlink.ttools.plot2.layer.ArrayBinList;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.util.DoubleList;

@Equality
public abstract class QuantileCombiner
extends Combiner {
    private final Quantiler quantiler_;

    public QuantileCombiner(String name, String description, Quantiler quantiler) {
        super(name, description, Combiner.Type.INTENSIVE, true);
        this.quantiler_ = quantiler;
    }

    @Override
    public ArrayBinList createArrayBinList(int size) {
        return new QuantileBinList(size);
    }

    @Override
    public Combiner.Container createContainer() {
        return new QuantileContainer();
    }

    public int hashCode() {
        int code = 23234232;
        code = 23 * code + this.quantiler_.hashCode();
        return code;
    }

    public boolean equals(Object o) {
        if (o instanceof QuantileCombiner) {
            QuantileCombiner other = (QuantileCombiner)o;
            return this.quantiler_.equals(other.quantiler_);
        }
        return false;
    }

    private double calculateQuantile(DoubleList dlist) {
        double[] values = dlist.toDoubleArray();
        Arrays.sort(values);
        return this.quantiler_.calculateValue(values);
    }

    @Equality
    public static interface Quantiler {
        public double calculateValue(double[] var1);
    }

    private class QuantileContainer
    implements Combiner.Container {
        final DoubleList dlist_ = new DoubleList();

        QuantileContainer() {
        }

        @Override
        public void submit(double datum) {
            this.dlist_.add(datum);
        }

        @Override
        public void add(Combiner.Container other) {
            DoubleList dlist1 = ((QuantileContainer)other).dlist_;
            if (dlist1 != null) {
                this.dlist_.addAll(dlist1);
            }
        }

        @Override
        public double getCombinedValue() {
            return QuantileCombiner.this.calculateQuantile(this.dlist_);
        }
    }

    private class QuantileBinList
    extends ArrayBinList {
        final DoubleList[] dlists_;

        QuantileBinList(int size) {
            super(size, QuantileCombiner.this);
            this.dlists_ = new DoubleList[size];
        }

        @Override
        public void submitToBinInt(int index, double value) {
            DoubleList dlist = this.dlists_[index];
            if (dlist == null) {
                this.dlists_[index] = new DoubleList(new double[]{value});
            } else {
                dlist.add(value);
            }
        }

        @Override
        public double getBinResultInt(int index) {
            DoubleList dlist = this.dlists_[index];
            return dlist == null ? Double.NaN : QuantileCombiner.this.calculateQuantile(dlist);
        }

        @Override
        public void copyBin(int index, Combiner.Container bin) {
            QuantileContainer container = (QuantileContainer)bin;
            this.dlists_[index] = container.dlist_;
        }

        @Override
        public void addBin(int index, ArrayBinList other) {
            DoubleList dlist1 = ((QuantileBinList)other).dlists_[index];
            if (dlist1 != null) {
                if (this.dlists_[index] == null) {
                    this.dlists_[index] = new DoubleList(dlist1.size());
                }
                this.dlists_[index].addAll(dlist1);
            }
        }
    }
}

