/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.InputMeta;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.geom.GPoint3D;
import uk.ac.starlink.ttools.plot2.layer.BasicXYShape;
import uk.ac.starlink.ttools.plot2.layer.FloatingCoordAuxReader;
import uk.ac.starlink.ttools.plot2.layer.Outliner;
import uk.ac.starlink.ttools.plot2.layer.PixOutliner;
import uk.ac.starlink.ttools.plot2.layer.ShapeForm;
import uk.ac.starlink.ttools.plot2.layer.ShapePainter;
import uk.ac.starlink.ttools.plot2.layer.ShapeStyle;
import uk.ac.starlink.ttools.plot2.layer.ShortPair;
import uk.ac.starlink.ttools.plot2.layer.XYShape;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;

public class SizeXyForm
implements ShapeForm {
    private static final FloatingCoord XSIZE_COORD = SizeXyForm.createSizeCoord(false);
    private static final FloatingCoord YSIZE_COORD = SizeXyForm.createSizeCoord(true);
    private static final ConfigKey<Integer> THICK_KEY = SizeXyForm.createThicknessKey();
    private static final AuxScale XSIZE_SCALE = new AuxScale("globalsizex");
    private static final AuxScale YSIZE_SCALE = new AuxScale("globalsizey");
    private static final SizeXyForm instance_ = new SizeXyForm();

    private SizeXyForm() {
    }

    @Override
    public int getBasicPositionCount() {
        return 1;
    }

    @Override
    public String getFormName() {
        return "SizeXY";
    }

    @Override
    public Icon getFormIcon() {
        return ResourceIcon.FORM_SIZEXY;
    }

    @Override
    public String getFormDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots a shaped marker with variable", "horizontal and vertical extents at each position.", "The X and Y dimensions are determined by two additional", "input data values.", "</p>", "<p>The actual size of the markers depends on the setting of the", "<code>" + StyleKeys.AUTOSCALE_PIX.getMeta().getShortName() + "</code>", "parameter.", "If autoscaling is off, the basic dimensions of each marker", "are given by the input data values in units of pixels.", "If autoscaling is on, the data values are gathered", "for all the currently visible points, and scaling factors", "are applied so that the largest ones will be a sensible size", "(a few tens of pixels).", "This autoscaling happens independently for", "the X and Y directions.", "The basic sizes can be further adjusted with the", "<code>" + StyleKeys.SCALE_PIX.getMeta().getShortName() + "</code>", "factor.", "</p>", "<p>Currently data values of zero always correspond to", "marker dimension of zero,", "negative data values are not represented,", "and the mapping is linear.", "An absolute maximum of", Integer.toString(100), "pixels is also imposed on marker sizes.", "Other options may be introduced in future.", "</p>", "<p>Note: for marker sizes that correspond to data values", "in data coordinates,", "you may find Error plotting more appropriate.", "</p>"});
    }

    @Override
    public Coord[] getExtraCoords() {
        return new Coord[]{XSIZE_COORD, YSIZE_COORD};
    }

    @Override
    public int getExtraPositionCount() {
        return 0;
    }

    @Override
    public DataGeom adjustGeom(DataGeom geom, DataSpec dataSpec, ShapeStyle style) {
        return geom;
    }

    @Override
    public ConfigKey<?>[] getConfigKeys() {
        return new ConfigKey[]{StyleKeys.XYSHAPE, THICK_KEY, StyleKeys.SCALE_PIX, StyleKeys.AUTOSCALE_PIX};
    }

    @Override
    public Outliner createOutliner(ConfigMap config) {
        AuxScale yAutoscale;
        AuxScale xAutoscale;
        BasicXYShape bshape = config.get(StyleKeys.XYSHAPE);
        int nthick = config.get(THICK_KEY);
        BasicXYShape shape = nthick > 0 ? bshape.toThicker(nthick) : bshape;
        boolean isAutoscale = config.get(StyleKeys.AUTOSCALE_PIX);
        double scale = config.get(StyleKeys.SCALE_PIX) * (double)(isAutoscale ? 20 : 1);
        boolean isGlobal = true;
        if (isAutoscale) {
            xAutoscale = isGlobal ? XSIZE_SCALE : new AuxScale("xsize1");
            yAutoscale = isGlobal ? YSIZE_SCALE : new AuxScale("ysize1");
        } else {
            xAutoscale = null;
            yAutoscale = null;
        }
        return new SizeXyOutliner(shape, scale, xAutoscale, yAutoscale, 100);
    }

    public static SizeXyForm getInstance() {
        return instance_;
    }

    private static int getSizeCoordIndex(DataGeom geom, boolean isY) {
        return geom.getPosCoords().length + (isY ? 1 : 0);
    }

    private static FloatingCoord createSizeCoord(boolean isY) {
        InputMeta meta = new InputMeta((isY ? "y" : "x") + "size", (isY ? "Y" : "X") + " Size");
        meta.setShortDescription("Marker " + (isY ? "vertical" : "horizontal") + " size (pixels or auto)");
        meta.setXmlDescription(new String[]{"<p>", isY ? "Vertical" : "Horizontal", "extent of each marker.", "Units are pixels unless auto-scaling is in effect,", "in which case units are arbitrary.", "</p>"});
        return FloatingCoord.createCoord(meta, false);
    }

    private static ConfigKey<Integer> createThicknessKey() {
        ConfigMeta meta = new ConfigMeta("thick", "Thickness");
        meta.setShortDescription("Line thickness for open shapes");
        meta.setXmlDescription(new String[]{"<p>Controls the line thickness used when drawing shapes.", "Zero, the default value, means a 1-pixel-wide line is used.", "Larger values make drawn lines thicker,", "but note changing this value will not affect all shapes,", "for instance filled rectangles contain no line drawings.", "</p>"});
        return StyleKeys.createPaintThicknessKey(meta, 3);
    }

    public static class SizeXyOutliner
    extends PixOutliner {
        private final XYShape shape_;
        private final AuxScale xAutoscale_;
        private final AuxScale yAutoscale_;
        private final short sizeLimit_;
        private final double scale_;
        private final Icon icon_;
        private final Map<ShortPair, Glyph> glyphMap_;

        public SizeXyOutliner(XYShape shape, double scale, AuxScale xAutoscale, AuxScale yAutoscale, short sizeLimit) {
            this.shape_ = shape;
            this.scale_ = scale;
            this.xAutoscale_ = xAutoscale;
            this.yAutoscale_ = yAutoscale;
            this.sizeLimit_ = sizeLimit;
            this.icon_ = XYShape.createIcon(shape, 14, 10, false);
            this.glyphMap_ = null;
        }

        @Override
        public Icon getLegendIcon() {
            return this.icon_;
        }

        @Override
        public Map<AuxScale, AuxReader> getAuxRangers(DataGeom geom) {
            HashMap<AuxScale, AuxReader> map = new HashMap<AuxScale, AuxReader>();
            Scaling scaling = null;
            if (this.xAutoscale_ != null) {
                int icx = SizeXyForm.getSizeCoordIndex(geom, false);
                FloatingCoordAuxReader xReader = new FloatingCoordAuxReader(XSIZE_COORD, icx, geom, true, scaling);
                map.put(this.xAutoscale_, xReader);
            }
            if (this.yAutoscale_ != null) {
                int icy = SizeXyForm.getSizeCoordIndex(geom, true);
                FloatingCoordAuxReader yReader = new FloatingCoordAuxReader(YSIZE_COORD, icy, geom, true, scaling);
                map.put(this.yAutoscale_, yReader);
            }
            return map;
        }

        @Override
        public boolean canPaint(DataSpec dataSpec) {
            return true;
        }

        @Override
        public ShapePainter create2DPainter(final Surface surface, final DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, final PaperType2D paperType) {
            final double[] dpos = new double[surface.getDataDimCount()];
            final Point2D.Double gpos = new Point2D.Double();
            final int icxSize = SizeXyForm.getSizeCoordIndex(geom, false);
            final int icySize = SizeXyForm.getSizeCoordIndex(geom, true);
            final double xscale = this.scale_ * SizeXyOutliner.getBaseScale(surface, auxSpans, this.xAutoscale_);
            final double yscale = this.scale_ * SizeXyOutliner.getBaseScale(surface, auxSpans, this.yAutoscale_);
            Rectangle bounds = surface.getPlotBounds();
            final short xmax = SizeXyOutliner.strunc(bounds.width * 2);
            final short ymax = SizeXyOutliner.strunc(bounds.height * 2);
            return new ShapePainter(){

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    if (geom.readDataPos(tuple, 0, dpos) && surface.dataToGraphics(dpos, true, gpos)) {
                        double xsize = XSIZE_COORD.readDoubleCoord(tuple, icxSize);
                        double ysize = YSIZE_COORD.readDoubleCoord(tuple, icySize);
                        if (PlotUtil.isFinite(xsize) && PlotUtil.isFinite(ysize)) {
                            short ixsize = SizeXyOutliner.sround(xsize * xscale, xmax);
                            short iysize = SizeXyOutliner.sround(ysize * yscale, ymax);
                            Glyph glyph = this.getGlyph(ixsize, iysize);
                            paperType.placeGlyph(paper, gpos.x, gpos.y, glyph, color);
                        }
                    }
                }
            };
        }

        @Override
        public ShapePainter create3DPainter(final CubeSurface surface, final DataGeom geom, DataSpec dataSpec, Map<AuxScale, Span> auxSpans, final PaperType3D paperType) {
            final double[] dpos = new double[surface.getDataDimCount()];
            final GPoint3D gpos = new GPoint3D();
            final int icxSize = SizeXyForm.getSizeCoordIndex(geom, false);
            final int icySize = SizeXyForm.getSizeCoordIndex(geom, true);
            final double xscale = this.scale_ * SizeXyOutliner.getBaseScale(surface, auxSpans, this.xAutoscale_);
            final double yscale = this.scale_ * SizeXyOutliner.getBaseScale(surface, auxSpans, this.yAutoscale_);
            Rectangle bounds = surface.getPlotBounds();
            final short xmax = SizeXyOutliner.strunc(bounds.width * 2);
            final short ymax = SizeXyOutliner.strunc(bounds.height * 2);
            return new ShapePainter(){

                @Override
                public void paintPoint(Tuple tuple, Color color, Paper paper) {
                    if (geom.readDataPos(tuple, 0, dpos) && surface.dataToGraphicZ(dpos, true, gpos)) {
                        double xsize = XSIZE_COORD.readDoubleCoord(tuple, icxSize);
                        double ysize = YSIZE_COORD.readDoubleCoord(tuple, icySize);
                        if (PlotUtil.isFinite(xsize) && PlotUtil.isFinite(ysize)) {
                            short ixsize = SizeXyOutliner.sround(xsize * xscale, xmax);
                            short iysize = SizeXyOutliner.sround(ysize * yscale, ymax);
                            Glyph glyph = this.getGlyph(ixsize, iysize);
                            paperType.placeGlyph(paper, gpos.x, gpos.y, gpos.z, glyph, color);
                        }
                    }
                }
            };
        }

        public boolean equals(Object o) {
            if (o instanceof SizeXyOutliner) {
                SizeXyOutliner other = (SizeXyOutliner)o;
                return this.shape_.equals(other.shape_) && PlotUtil.equals(this.xAutoscale_, other.xAutoscale_) && PlotUtil.equals(this.yAutoscale_, other.yAutoscale_) && this.scale_ == other.scale_ && this.sizeLimit_ == other.sizeLimit_;
            }
            return false;
        }

        public int hashCode() {
            int code = 77641;
            code = 23 * code + this.shape_.hashCode();
            code = 23 * code + PlotUtil.hashCode(this.xAutoscale_);
            code = 23 * code + PlotUtil.hashCode(this.yAutoscale_);
            code = 23 * code + Float.floatToIntBits((float)this.scale_);
            code = 23 * code + this.sizeLimit_;
            return code;
        }

        private Glyph getGlyph(short xsize, short ysize) {
            if (xsize > this.sizeLimit_) {
                xsize = this.sizeLimit_;
            }
            if (ysize > this.sizeLimit_) {
                ysize = this.sizeLimit_;
            }
            if (this.glyphMap_ != null) {
                ShortPair size = new ShortPair(xsize, ysize);
                Glyph glyph = this.glyphMap_.get(size);
                if (glyph == null) {
                    glyph = this.shape_.getGlyph(xsize, ysize);
                    this.glyphMap_.put(size, glyph);
                }
                return glyph;
            }
            return this.shape_.getGlyph(xsize, ysize);
        }

        private static double getBaseScale(Surface surface, Map<AuxScale, Span> spanMap, AuxScale autoscale) {
            if (autoscale != null) {
                Span span = spanMap.get(autoscale);
                double[] bounds = span.getFiniteBounds(true);
                return 1.0 / bounds[1];
            }
            return 1.0;
        }

        private static short strunc(int value) {
            return (short)Math.min(value, Short.MAX_VALUE);
        }

        private static short sround(double value, short max) {
            if (value < 0.0) {
                return 0;
            }
            if (value >= (double)max) {
                return max;
            }
            return (short)(value + 0.5);
        }
    }
}

