/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.table.AbstractStarTable;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.HealpixTableInfo;
import uk.ac.starlink.table.IteratorRowSequence;
import uk.ac.starlink.table.RowSequence;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.ttools.func.Tilings;
import uk.ac.starlink.ttools.gui.ResourceIcon;
import uk.ac.starlink.ttools.plot.Matrices;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot.Shaders;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxReader;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Plotter;
import uk.ac.starlink.ttools.plot2.Ranger;
import uk.ac.starlink.ttools.plot2.ReportKey;
import uk.ac.starlink.ttools.plot2.ReportMap;
import uk.ac.starlink.ttools.plot2.ReportMeta;
import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.Scaling;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Subrange;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.ConfigMeta;
import uk.ac.starlink.ttools.plot2.config.IntegerConfigKey;
import uk.ac.starlink.ttools.plot2.config.OptionConfigKey;
import uk.ac.starlink.ttools.plot2.config.PerUnitConfigKey;
import uk.ac.starlink.ttools.plot2.config.RampKeySet;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.CoordGroup;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.FloatingCoord;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.Rotation;
import uk.ac.starlink.ttools.plot2.geom.SkyDataGeom;
import uk.ac.starlink.ttools.plot2.geom.SkySurface;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.BinListCollector;
import uk.ac.starlink.ttools.plot2.layer.BinResultColumnData;
import uk.ac.starlink.ttools.plot2.layer.Combiner;
import uk.ac.starlink.ttools.plot2.layer.Gridder;
import uk.ac.starlink.ttools.plot2.layer.HealpixSys;
import uk.ac.starlink.ttools.plot2.layer.SkyPixer;
import uk.ac.starlink.ttools.plot2.layer.SkyTileRenderer;
import uk.ac.starlink.ttools.plot2.layer.SolidAngleUnit;
import uk.ac.starlink.ttools.plot2.layer.Unit;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;

public class SkyDensityPlotter
implements Plotter<SkyDenseStyle> {
    private final boolean transparent_;
    private final CoordGroup coordGrp_;
    private final FloatingCoord weightCoord_;
    private final boolean reportAuxKeys_;
    private static final FloatingCoord WEIGHT_COORD = FloatingCoord.WEIGHT_COORD;
    public static final ReportKey<Double> TILESIZE_REPKEY = ReportKey.createDoubleKey(new ReportMeta("tile_sqdeg", "Tile size/sq.deg"), true);
    private static final ReportKey<Integer> ABSLEVEL_REPKEY = ReportKey.createIntegerKey(new ReportMeta("abs_level", "HEALPix Level"), true);
    private static final ReportKey<Integer> RELLEVEL_REPKEY = ReportKey.createIntegerKey(new ReportMeta("rel_level", "Relative HEALPix Level"), false);
    private static final ReportKey<StarTable> HPXTABLE_REPKEY = ReportKey.createTableKey(new ReportMeta("hpx_map", "HEALPix Map"), true);
    private static final AuxScale SCALE = AuxScale.COLOR;
    private static final RampKeySet RAMP_KEYS = StyleKeys.AUX_RAMP;
    private static final ConfigKey<Integer> LEVEL_KEY = IntegerConfigKey.createSpinnerPairKey(new ConfigMeta("level", "HEALPix Level").setStringUsage("<-rel-level|+abs-level>").setShortDescription("HEALPix level, negative for relative").setXmlDescription(new String[]{"<p>Determines the HEALPix level of pixels which are averaged", "over to calculate density.", "</p>", "<p>If the supplied value is a non-negative integer,", "it gives the absolute level to use;", "at level 0 there are 12 pixels on the sky, and", "the count multiplies by 4 for each increment.", "</p>", "<p>If the value is negative, it represents a relative level;", "it is approximately the (negative) number of screen pixels", "along one side of a HEALPix sky pixel.", "In this case the actual HEALPix level will depend on", "the current zoom.", "</p>"}), -3, 29, -8, "Abs", "Rel", ABSLEVEL_REPKEY, RELLEVEL_REPKEY);
    public static final ConfigKey<Double> TRANSPARENCY_KEY = StyleKeys.TRANSPARENCY;
    public static final ConfigKey<Combiner> COMBINER_KEY;
    public static final PerUnitConfigKey<SolidAngleUnit> ANGLE_KEY;
    private static final ReportKey<Combiner.Type> CTYPE_REPKEY;

    public SkyDensityPlotter(boolean transparent, boolean hasWeight) {
        Coord[] coordArray;
        this.transparent_ = transparent;
        FloatingCoord floatingCoord = this.weightCoord_ = hasWeight ? FloatingCoord.WEIGHT_COORD : null;
        if (this.weightCoord_ == null) {
            coordArray = new Coord[]{};
        } else {
            Coord[] coordArray2 = new Coord[1];
            coordArray = coordArray2;
            coordArray2[0] = this.weightCoord_;
        }
        Coord[] extraCoords = coordArray;
        this.coordGrp_ = CoordGroup.createCoordGroup(1, extraCoords);
        this.reportAuxKeys_ = false;
    }

    @Override
    public String getPlotterName() {
        return "SkyDensity";
    }

    @Override
    public Icon getPlotterIcon() {
        return ResourceIcon.FORM_SKYDENSITY;
    }

    @Override
    public CoordGroup getCoordGroup() {
        return this.coordGrp_;
    }

    @Override
    public boolean hasReports() {
        return true;
    }

    @Override
    public String getPlotterDescription() {
        StringBuffer sbuf = new StringBuffer().append("<p>Plots a density map on the sky.\n").append("The grid on which the values are drawn uses\n").append("the HEALPix tesselation,\n").append("with a configurable resolution.\n").append("You can optionally use a weighting for the points,\n").append("and you can configure how the points are combined\n").append("to produce the output pixel values.\n").append("</p>\n");
        sbuf.append("<p>");
        if (this.reportAuxKeys_) {
            sbuf.append("There are additional options to adjust\n").append("the way data values are mapped to colours.\n");
        } else {
            sbuf.append("The way that data values are mapped\n").append("to colours is usually controlled by options\n").append("at the level of the plot itself,\n").append("rather than by per-layer configuration.\n");
        }
        sbuf.append("</p>\n");
        return sbuf.toString();
    }

    @Override
    public ConfigKey<?>[] getStyleKeys() {
        ArrayList keyList = new ArrayList();
        keyList.add(LEVEL_KEY);
        if (this.weightCoord_ != null) {
            keyList.add(COMBINER_KEY);
            keyList.add(ANGLE_KEY);
        }
        if (this.reportAuxKeys_) {
            keyList.addAll(Arrays.asList(RAMP_KEYS.getKeys()));
        }
        if (this.transparent_) {
            keyList.add(TRANSPARENCY_KEY);
        }
        return keyList.toArray(new ConfigKey[0]);
    }

    @Override
    public SkyDenseStyle createStyle(ConfigMap config) {
        RampKeySet.Ramp ramp = RAMP_KEYS.createValue(config);
        int level = config.get(LEVEL_KEY);
        Scaling scaling = ramp.getScaling();
        Subrange dataclip = ramp.getDataClip();
        float scaleAlpha = 1.0f - config.get(TRANSPARENCY_KEY).floatValue();
        Shader shader = Shaders.fade(ramp.getShader(), scaleAlpha);
        Combiner combiner = this.weightCoord_ == null ? Combiner.COUNT : config.get(COMBINER_KEY);
        SolidAngleUnit unit = config.get(ANGLE_KEY);
        return new SkyDenseStyle(level, scaling, dataclip, shader, combiner, unit);
    }

    @Override
    public Object getRangeStyleKey(SkyDenseStyle style) {
        return null;
    }

    @Override
    public PlotLayer createLayer(DataGeom geom, DataSpec dataSpec, SkyDenseStyle style) {
        return new SkyDensityLayer((SkyDataGeom)geom, dataSpec, style);
    }

    public static int getPixelLevel(SkySurface surface) {
        Point p = surface.getSkyCenter();
        double[] p1 = surface.graphicsToData(new Point(p.x - 1, p.y - 1), null);
        double[] p2 = surface.graphicsToData(new Point(p.x + 1, p.y + 1), null);
        double pixTheta = SkyDensityPlotter.vectorSeparation(p1, p2) / Math.sqrt(8.0);
        return Tilings.healpixK(Math.toDegrees(pixTheta));
    }

    public static double vectorSeparation(double[] p1, double[] p2) {
        double modCross = Matrices.mod(Matrices.cross(p1, p2));
        double dot = Matrices.dot(p1, p2);
        return modCross == 0.0 && dot == 0.0 ? 0.0 : Math.atan2(modCross, dot);
    }

    static {
        ConfigMeta angleMeta = new ConfigMeta("perunit", "Per Unit");
        ConfigMeta combineMeta = new ConfigMeta("combine", "Combine");
        angleMeta.setShortDescription("Solid angle unit for densities");
        angleMeta.setXmlDescription(new String[]{"<p>Defines the unit of sky area used for scaling density-like", "combinations", "(e.g. <code>" + combineMeta.getShortName() + "</code>=<code>" + Combiner.DENSITY + "</code> or", "<code>" + Combiner.WEIGHTED_DENSITY + "</code>).", "If the Combination mode is calculating values per unit area,", "this configures the area scale in question.", "For non-density-like combination modes", "(e.g. <code>" + combineMeta.getShortName() + "</code>=<code>" + Combiner.SUM + "</code> or ", "<code>" + Combiner.MEAN + "</code>)", "it has no effect.", "</p>"});
        combineMeta.setShortDescription("Value combination mode");
        combineMeta.setXmlDescription(new String[]{"<p>Defines how values contributing to the same density map bin", "are combined together to produce the value assigned to that bin,", "and hence its colour.", "The combined values are the weights, but if the", "<code>" + WEIGHT_COORD.getInput().getMeta().getShortName() + "</code>", "is left blank, a weighting of unity is assumed.", "</p>", "<p>For density-like values", "(<code>" + Combiner.DENSITY + "</code>,", "<code>" + Combiner.WEIGHTED_DENSITY + "</code>)", "the scaling is additionally influenced by the", "<code>" + angleMeta.getShortName() + "</code> parameter.", "</p>"});
        ANGLE_KEY = new PerUnitConfigKey(angleMeta, SolidAngleUnit.class, (Unit[])SolidAngleUnit.getKnownUnits(), (Unit)SolidAngleUnit.DEGREE2);
        COMBINER_KEY = new OptionConfigKey<Combiner>(combineMeta, Combiner.class, Combiner.getKnownCombiners(), Combiner.WEIGHTED_DENSITY){

            @Override
            public String getXmlDescription(Combiner combiner) {
                return combiner.getDescription();
            }
        }.setOptionUsage().addOptionsXml();
        CTYPE_REPKEY = ANGLE_KEY.getCombinerTypeReportKey();
    }

    private static class SkyDensityPlan {
        final int level_;
        final Combiner combiner_;
        final BinList.Result binResult_;
        final DataSpec dataSpec_;
        final SkyDataGeom geom_;
        int pixelLevel_;

        SkyDensityPlan(int level, Combiner combiner, BinList.Result binResult, DataSpec dataSpec, SkyDataGeom geom) {
            this.level_ = level;
            this.combiner_ = combiner;
            this.binResult_ = binResult;
            this.dataSpec_ = dataSpec;
            this.geom_ = geom;
            this.pixelLevel_ = Integer.MIN_VALUE;
        }

        public boolean matches(int level, Combiner combiner, DataSpec dataSpec, SkyDataGeom geom) {
            return this.level_ == level && this.combiner_.equals(combiner) && this.dataSpec_.equals(dataSpec) && this.geom_.equals(geom);
        }

        public void extendVisibleRange(Ranger ranger, SkySurface surface, double binFactor) {
            Rectangle bounds = surface.getPlotBounds();
            int nx = bounds.width;
            int ny = bounds.height;
            Gridder gridder = new Gridder(nx, ny);
            int npix = gridder.getLength();
            Point2D.Double point = new Point2D.Double();
            double x0 = (double)bounds.x + 0.5;
            double y0 = (double)bounds.y + 0.5;
            SkyPixer skyPixer = new SkyPixer(this.level_);
            for (int ip = 0; ip < npix; ++ip) {
                point.x = x0 + (double)gridder.getX(ip);
                point.y = y0 + (double)gridder.getY(ip);
                double[] dpos = surface.graphicsToData(point, null);
                if (dpos == null) continue;
                double dval = binFactor * this.binResult_.getBinValue(skyPixer.getIndex(dpos));
                ranger.submitDatum(dval);
            }
        }
    }

    private static class BinRowIterator
    implements Iterator<Object[]> {
        private final Iterator<Long> indexIt_;
        private final ColumnData dataCol_;
        private final boolean isLong_;

        BinRowIterator(Iterator<Long> indexIt, ColumnData dataCol, boolean isLong) {
            this.indexIt_ = indexIt;
            this.dataCol_ = dataCol;
            this.isLong_ = isLong;
        }

        @Override
        public Object[] next() {
            Object dataObj;
            Long index = this.indexIt_.next();
            long ix = index;
            Number ixObj = this.isLong_ ? (Number)index : (Number)((int)ix);
            try {
                dataObj = this.dataCol_.readValue(ix);
            }
            catch (IOException e) {
                throw new IteratorRowSequence.PackagedIOException(e);
            }
            return new Object[]{ixObj, dataObj};
        }

        @Override
        public boolean hasNext() {
            return this.indexIt_.hasNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SkyDensityLayer
    extends AbstractPlotLayer {
        private final SkyDenseStyle dstyle_;
        private final SkyDataGeom geom_;
        private final int icWeight_;

        SkyDensityLayer(SkyDataGeom geom, DataSpec dataSpec, SkyDenseStyle style) {
            super(SkyDensityPlotter.this, geom, dataSpec, style, style.isOpaque() ? LayerOpt.OPAQUE : LayerOpt.NO_SPECIAL);
            this.dstyle_ = style;
            this.geom_ = geom;
            int n = this.icWeight_ = SkyDensityPlotter.this.weightCoord_ == null ? -1 : SkyDensityPlotter.this.coordGrp_.getExtraCoordIndex(0, geom);
            assert (SkyDensityPlotter.this.weightCoord_ == null || SkyDensityPlotter.this.weightCoord_ == dataSpec.getCoord(this.icWeight_));
        }

        @Override
        public Drawing createDrawing(Surface surface, Map<AuxScale, Span> auxSpans, PaperType paperType) {
            SkySurface ssurf = (SkySurface)surface;
            return new SkyDensityDrawing(ssurf, this.createTileRenderer(ssurf), auxSpans.get(SCALE), paperType);
        }

        @Override
        public Map<AuxScale, AuxReader> getAuxRangers() {
            HashMap<AuxScale, AuxReader> map = new HashMap<AuxScale, AuxReader>();
            map.put(SCALE, new AuxReader(){

                @Override
                public int getCoordIndex() {
                    return SkyDensityLayer.this.icWeight_;
                }

                @Override
                public ValueInfo getAxisInfo(DataSpec dataSpec) {
                    return SkyDensityLayer.this.getCombinedInfo(dataSpec);
                }

                @Override
                public Scaling getScaling() {
                    return SkyDensityLayer.this.dstyle_.scaling_;
                }

                @Override
                public void adjustAuxRange(Surface surface, DataSpec dataSpec, DataStore dataStore, Object[] knownPlans, Ranger ranger) {
                    SkySurface ssurf = (SkySurface)surface;
                    int level = SkyDensityLayer.this.getLevel(ssurf);
                    SkyDensityPlan splan = SkyDensityLayer.this.getSkyPlan(knownPlans, level, dataSpec);
                    if (splan != null) {
                        splan.extendVisibleRange(ranger, ssurf, SkyDensityLayer.this.getBinFactor(level));
                    } else {
                        BinList.Result binResult = SkyDensityLayer.this.readBins(ssurf, dataSpec, dataStore).getResult();
                        SkyDensityLayer.this.createTileRenderer(ssurf).extendAuxRange(ranger, binResult);
                    }
                }
            });
            return map;
        }

        private SkyTileRenderer createTileRenderer(SkySurface surface) {
            int level = this.getLevel(surface);
            return SkyTileRenderer.createRenderer(surface, Rotation.IDENTITY, level, this.getBinFactor(level));
        }

        private int getLevel(SkySurface surface) {
            int pixLevel = SkyDensityPlotter.getPixelLevel(surface);
            return this.dstyle_.level_ >= 0 ? Math.min(this.dstyle_.level_, pixLevel) : Math.max(0, pixLevel + this.dstyle_.level_);
        }

        private double getBinFactor(int level) {
            double binExtent = Tilings.healpixSqdeg(level) / this.dstyle_.unit_.getExtentInSquareDegrees();
            Combiner.Type ctype = this.dstyle_.combiner_.getType();
            return ctype.getBinFactor(binExtent);
        }

        private BinList readBins(SkySurface surface, DataSpec dataSpec, DataStore dataStore) {
            final int level = this.getLevel(surface);
            long npix = new SkyPixer(level).getPixelCount();
            Combiner combiner = this.dstyle_.combiner_;
            final int icPos = SkyDensityPlotter.this.coordGrp_.getPosCoordIndex(0, this.geom_);
            final boolean isUnweighted = this.icWeight_ < 0 || dataSpec.isCoordBlank(this.icWeight_);
            BinListCollector collector = new BinListCollector(combiner, npix){

                public void accumulate(TupleSequence tseq, BinList binList) {
                    SkyPixer skyPixer = new SkyPixer(level);
                    double[] v3 = new double[3];
                    if (isUnweighted) {
                        while (tseq.next()) {
                            if (!SkyDensityLayer.this.geom_.readDataPos(tseq, icPos, v3)) continue;
                            long ihpx = skyPixer.getIndex(v3);
                            binList.submitToBin(ihpx, 1.0);
                        }
                    } else {
                        while (tseq.next()) {
                            double w;
                            if (!SkyDensityLayer.this.geom_.readDataPos(tseq, icPos, v3) || Double.isNaN(w = SkyDensityPlotter.this.weightCoord_.readDoubleCoord(tseq, SkyDensityLayer.this.icWeight_))) continue;
                            long ihpx = skyPixer.getIndex(v3);
                            binList.submitToBin(ihpx, w);
                        }
                    }
                }
            };
            return PlotUtil.tupleCollect(collector, dataSpec, dataStore);
        }

        private SkyDensityPlan getSkyPlan(Object[] knownPlans, int level, DataSpec dataSpec) {
            Combiner combiner = this.dstyle_.combiner_;
            for (Object plan : knownPlans) {
                SkyDensityPlan skyPlan;
                if (!(plan instanceof SkyDensityPlan) || !(skyPlan = (SkyDensityPlan)plan).matches(level, combiner, dataSpec, this.geom_)) continue;
                return skyPlan;
            }
            return null;
        }

        private ValueInfo getCombinedInfo(DataSpec dataSpec) {
            ValueInfo[] winfos;
            Object weightInfo = this.icWeight_ < 0 || dataSpec.isCoordBlank(this.icWeight_) ? new DefaultValueInfo("1", Double.class, "Weight unspecified, taken as unity") : ((winfos = dataSpec.getUserCoordInfos(this.icWeight_)) != null && winfos.length == 1 ? winfos[0] : new DefaultValueInfo("Weight", Double.class));
            return this.dstyle_.combiner_.createCombinedInfo((ValueInfo)weightInfo, this.dstyle_.unit_);
        }

        private StarTable createExportTable(SkyDensityPlan splan) {
            int level = splan.level_;
            final BinList.Result binResult = splan.binResult_;
            SkyPixer pixer = new SkyPixer(level);
            boolean isNested = pixer.isNested();
            HealpixTableInfo.HpxCoordSys csys = HealpixSys.fromGeom(this.geom_.getViewSystem());
            DataSpec dataSpec = splan.dataSpec_;
            long nsky = pixer.getPixelCount();
            final long ndata = binResult.getBinCount();
            final BinResultColumnData<?> dataCol = BinResultColumnData.createInstance(this.getCombinedInfo(dataSpec), binResult, this.getBinFactor(level));
            if ((double)ndata * 1.0 / (double)nsky > 0.5 && nsky <= Integer.MAX_VALUE) {
                int nrow = (int)nsky;
                assert ((long)nrow == nsky);
                ColumnStarTable table = ColumnStarTable.makeTableWithRows((long)nrow);
                table.addColumn(dataCol);
                HealpixTableInfo hpxInfo = new HealpixTableInfo(level, isNested, null, csys);
                table.getParameters().addAll(Arrays.asList(hpxInfo.toParams()));
                return table;
            }
            String indexDescrip = "HEALPix index, level " + level + ", " + (isNested ? "Nested" : "Ring") + " scheme";
            final boolean isLong = nsky > Integer.MAX_VALUE;
            ColumnInfo indexInfo = new ColumnInfo("hpx" + level, isLong ? Long.class : Integer.class, indexDescrip);
            final ColumnInfo[] infos = new ColumnInfo[]{indexInfo, dataCol.getColumnInfo()};
            AbstractStarTable table = new AbstractStarTable(){

                public ColumnInfo getColumnInfo(int icol) {
                    return infos[icol];
                }

                public int getColumnCount() {
                    return infos.length;
                }

                public long getRowCount() {
                    return ndata;
                }

                public RowSequence getRowSequence() {
                    BinRowIterator rowIt = new BinRowIterator(binResult.indexIterator(), dataCol, isLong);
                    return new IteratorRowSequence((Iterator)rowIt);
                }
            };
            HealpixTableInfo hpxInfo = new HealpixTableInfo(level, isNested, indexInfo.getName(), csys);
            table.getParameters().addAll(Arrays.asList(hpxInfo.toParams()));
            return table;
        }

        private class SkyDensityDrawing
        implements Drawing {
            private final SkySurface surface_;
            private final SkyTileRenderer renderer_;
            private final Span auxSpan_;
            private final PaperType paperType_;
            private final int level_;
            private final int pixelLevel_;

            SkyDensityDrawing(SkySurface surface, SkyTileRenderer renderer, Span auxSpan, PaperType paperType) {
                this.surface_ = surface;
                this.renderer_ = renderer;
                this.auxSpan_ = auxSpan;
                this.paperType_ = paperType;
                this.level_ = SkyDensityLayer.this.getLevel(surface);
                this.pixelLevel_ = SkyDensityPlotter.getPixelLevel(surface);
            }

            @Override
            public Object calculatePlan(Object[] knownPlans, DataStore dataStore) {
                SkyDensityPlan plan = this.calculateBasicPlan(knownPlans, dataStore);
                plan.pixelLevel_ = this.pixelLevel_;
                return plan;
            }

            private SkyDensityPlan calculateBasicPlan(Object[] knownPlans, DataStore dataStore) {
                DataSpec dataSpec = SkyDensityLayer.this.getDataSpec();
                Combiner combiner = SkyDensityLayer.this.dstyle_.combiner_;
                SkyDensityPlan knownPlan = SkyDensityLayer.this.getSkyPlan(knownPlans, this.level_, dataSpec);
                if (knownPlan != null) {
                    return knownPlan;
                }
                BinList.Result binResult = SkyDensityLayer.this.readBins(this.surface_, dataSpec, dataStore).getResult().compact();
                return new SkyDensityPlan(this.level_, combiner, binResult, dataSpec, SkyDensityLayer.this.geom_);
            }

            @Override
            public void paintData(Object plan, Paper paper, DataStore dataStore) {
                final BinList.Result binResult = ((SkyDensityPlan)plan).binResult_;
                final Scaler scaler = this.auxSpan_.createScaler(SkyDensityLayer.this.dstyle_.scaling_, SkyDensityLayer.this.dstyle_.dataclip_);
                final Shader shader = SkyDensityLayer.this.dstyle_.shader_;
                this.paperType_.placeDecal(paper, new Decal(){

                    @Override
                    public void paintDecal(Graphics g) {
                        SkyDensityDrawing.this.renderer_.renderBins(g, binResult, shader, scaler);
                    }

                    @Override
                    public boolean isOpaque() {
                        return SkyDensityLayer.this.dstyle_.isOpaque();
                    }
                });
            }

            @Override
            public ReportMap getReport(Object plan) {
                ReportMap map = new ReportMap();
                if (plan instanceof SkyDensityPlan) {
                    SkyDensityPlan splan = (SkyDensityPlan)plan;
                    int absLevel = splan.level_;
                    int relLevel = absLevel - splan.pixelLevel_;
                    double tileSize = Tilings.healpixSqdeg(absLevel);
                    map.put(ABSLEVEL_REPKEY, absLevel);
                    map.put(RELLEVEL_REPKEY, relLevel);
                    map.put(TILESIZE_REPKEY, tileSize);
                    map.put(HPXTABLE_REPKEY, SkyDensityLayer.this.createExportTable(splan));
                    map.put(CTYPE_REPKEY, splan.combiner_.getType());
                }
                return map;
            }
        }
    }

    public static class SkyDenseStyle
    implements Style {
        private final int level_;
        private final Scaling scaling_;
        private final Subrange dataclip_;
        private final Shader shader_;
        private final Combiner combiner_;
        private final SolidAngleUnit unit_;

        public SkyDenseStyle(int level, Scaling scaling, Subrange dataclip, Shader shader, Combiner combiner, SolidAngleUnit unit) {
            this.level_ = level;
            this.scaling_ = scaling;
            this.dataclip_ = dataclip;
            this.shader_ = shader;
            this.combiner_ = combiner;
            this.unit_ = unit;
        }

        boolean isOpaque() {
            return !Shaders.isTransparent(this.shader_);
        }

        @Override
        public Icon getLegendIcon() {
            return Shaders.createShaderIcon(this.shader_, null, true, 16, 8, 2, 2);
        }

        public int hashCode() {
            int code = 23443;
            code = 23 * code + this.level_;
            code = 23 * code + this.scaling_.hashCode();
            code = 23 * code + this.dataclip_.hashCode();
            code = 23 * code + this.shader_.hashCode();
            code = 23 * code + this.combiner_.hashCode();
            code = 23 * code + this.unit_.hashCode();
            return code;
        }

        public boolean equals(Object o) {
            if (o instanceof SkyDenseStyle) {
                SkyDenseStyle other = (SkyDenseStyle)o;
                return this.level_ == other.level_ && this.scaling_.equals(other.scaling_) && this.dataclip_.equals(other.dataclip_) && this.shader_.equals(other.shader_) && this.combiner_.equals(other.combiner_) && this.unit_.equals(other.unit_);
            }
            return false;
        }
    }
}

