/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.IndexColorModel;
import java.util.logging.Logger;
import uk.ac.starlink.ttools.plot.Shader;
import uk.ac.starlink.ttools.plot2.Ranger;
import uk.ac.starlink.ttools.plot2.Scaler;
import uk.ac.starlink.ttools.plot2.geom.Rotation;
import uk.ac.starlink.ttools.plot2.geom.SkySurface;
import uk.ac.starlink.ttools.plot2.layer.BinList;
import uk.ac.starlink.ttools.plot2.layer.Gridder;
import uk.ac.starlink.ttools.plot2.layer.PixelImage;
import uk.ac.starlink.ttools.plot2.layer.SkyPixer;
import uk.ac.starlink.ttools.plot2.layer.SkySurfaceTiler;

public abstract class SkyTileRenderer {
    private static final int MIN_PAINT_PIXELS = 24;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.plot2.layer");

    public abstract void extendAuxRange(Ranger var1, BinList.Result var2);

    public abstract void renderBins(Graphics var1, BinList.Result var2, Shader var3, Scaler var4);

    public static SkyTileRenderer createRenderer(SkySurface surface, Rotation rotation, int viewLevel, double binFactor) {
        String reason;
        boolean isPaint;
        boolean boundsVisible;
        boolean bl = boundsVisible = !surface.getSkyShape().contains(surface.getPlotBounds());
        if (boundsVisible) {
            isPaint = false;
            reason = "sky bounds are visible";
        } else {
            double srPerTile = Math.PI * 4 / (double)(12L << 2 * viewLevel);
            double srPerPixel = surface.pixelAreaSteradians();
            int pixelsPerTile = (int)(srPerTile / srPerPixel);
            if (pixelsPerTile >= 24) {
                isPaint = true;
                reason = "pixels per tile " + pixelsPerTile + ">=" + 24;
            } else {
                isPaint = false;
                reason = "pixels per tile " + pixelsPerTile + "<" + 24;
            }
        }
        String msg = new StringBuffer().append("Rendering mode: ").append(isPaint ? "paint" : "resample").append(" (").append(reason).append(")").toString();
        logger_.info(msg);
        return isPaint ? new PaintTileRenderer(surface, viewLevel, rotation, binFactor) : new ResampleTileRenderer(surface, viewLevel, rotation, binFactor);
    }

    public static void paintBins(Graphics g, BinList.Result binResult, double binFactor, SkySurface surface, SkyPixer skyPixer, Shader shader, Scaler scaler) {
        Rectangle bounds = surface.getPlotBounds();
        IndexColorModel colorModel = PixelImage.createColorModel(shader, true);
        int ncolor = colorModel.getMapSize() - 1;
        int nx = bounds.width;
        int ny = bounds.height;
        Gridder gridder = new Gridder(nx, ny);
        int npix = gridder.getLength();
        int[] pixels = new int[npix];
        Point2D.Double point = new Point2D.Double();
        double x0 = (double)bounds.x + 0.5;
        double y0 = (double)bounds.y + 0.5;
        for (int ip = 0; ip < npix; ++ip) {
            double dval;
            point.x = x0 + (double)gridder.getX(ip);
            point.y = y0 + (double)gridder.getY(ip);
            double[] dpos = surface.graphicsToData(point, null);
            if (dpos == null || Double.isNaN(dval = binResult.getBinValue(skyPixer.getIndex(dpos)))) continue;
            pixels[ip] = Math.min(1 + (int)(scaler.scaleValue(binFactor * dval) * (double)ncolor), ncolor - 1);
        }
        new PixelImage(bounds.getSize(), pixels, colorModel).paintPixels(g, bounds.getLocation());
    }

    private static class PaintTileRenderer
    extends SkyTileRenderer {
        private final SkySurfaceTiler tiler_;
        private final double binFactor_;

        PaintTileRenderer(SkySurface surface, int viewLevel, Rotation rotation, double binFactor) {
            this.tiler_ = new SkySurfaceTiler(surface, rotation, viewLevel);
            this.binFactor_ = binFactor;
        }

        @Override
        public void extendAuxRange(Ranger ranger, BinList.Result binResult) {
            for (Long hpxObj : this.tiler_.visiblePixels()) {
                long hpx = hpxObj;
                double value = binResult.getBinValue(hpx);
                if (Double.isNaN(value)) continue;
                ranger.submitDatum(this.binFactor_ * value);
            }
        }

        @Override
        public void renderBins(Graphics g, BinList.Result binResult, Shader shader, Scaler scaler) {
            Color color0 = g.getColor();
            float[] rgba = new float[4];
            for (Long hpxObj : this.tiler_.visiblePixels()) {
                Polygon shape;
                long hpx = hpxObj;
                double value = binResult.getBinValue(hpx);
                if (Double.isNaN(value) || (shape = this.tiler_.getTileShape(hpx)) == null) continue;
                rgba[0] = 0.5f;
                rgba[1] = 0.5f;
                rgba[2] = 0.5f;
                rgba[3] = 1.0f;
                float sval = (float)scaler.scaleValue(this.binFactor_ * value);
                shader.adjustRgba(rgba, sval);
                g.setColor(new Color(rgba[0], rgba[1], rgba[2], rgba[3]));
                g.fillPolygon(shape);
            }
            g.setColor(color0);
        }
    }

    private static class ResampleTileRenderer
    extends SkyTileRenderer {
        private final SkySurface surface_;
        private final SkyPixer skyPixer_;
        private final double binFactor_;

        ResampleTileRenderer(SkySurface surface, int viewLevel, Rotation rotation, double binFactor) {
            this.surface_ = surface;
            final Rotation unrotation = rotation.invert();
            this.binFactor_ = binFactor;
            this.skyPixer_ = new SkyPixer(viewLevel){

                @Override
                public long getIndex(double[] v3) {
                    unrotation.rotate(v3);
                    return super.getIndex(v3);
                }
            };
        }

        @Override
        public void extendAuxRange(Ranger ranger, BinList.Result binResult) {
            Rectangle bounds = this.surface_.getPlotBounds();
            Gridder gridder = new Gridder(bounds.width, bounds.height);
            int npix = gridder.getLength();
            Point2D.Double point = new Point2D.Double();
            double x0 = (double)bounds.x + 0.5;
            double y0 = (double)bounds.y + 0.5;
            long hpix0 = -1L;
            for (int ip = 0; ip < npix; ++ip) {
                long hpix;
                point.x = x0 + (double)gridder.getX(ip);
                point.y = y0 + (double)gridder.getY(ip);
                double[] dpos = this.surface_.graphicsToData(point, null);
                if (dpos == null || (hpix = this.skyPixer_.getIndex(dpos)) == hpix0) continue;
                hpix0 = hpix;
                ranger.submitDatum(this.binFactor_ * binResult.getBinValue(hpix));
            }
        }

        @Override
        public void renderBins(Graphics g, BinList.Result binResult, Shader shader, Scaler scaler) {
            ResampleTileRenderer.paintBins(g, binResult, this.binFactor_, this.surface_, this.skyPixer_, shader, scaler);
        }
    }
}

