/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.util.Map;
import java.util.function.BiConsumer;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot.Style;
import uk.ac.starlink.ttools.plot2.AuxScale;
import uk.ac.starlink.ttools.plot2.DataGeom;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.Glyph;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Span;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.config.ConfigKey;
import uk.ac.starlink.ttools.plot2.config.ConfigMap;
import uk.ac.starlink.ttools.plot2.config.StyleKeys;
import uk.ac.starlink.ttools.plot2.data.Coord;
import uk.ac.starlink.ttools.plot2.data.DataSpec;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.data.Tuple;
import uk.ac.starlink.ttools.plot2.data.TupleSequence;
import uk.ac.starlink.ttools.plot2.geom.CubeSurface;
import uk.ac.starlink.ttools.plot2.geom.GPoint3D;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotLayer;
import uk.ac.starlink.ttools.plot2.layer.AbstractPlotter;
import uk.ac.starlink.ttools.plot2.layer.Pixers;
import uk.ac.starlink.ttools.plot2.layer.UnplannedDrawing;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.ttools.plot2.paper.PaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType3D;
import uk.ac.starlink.ttools.plot2.task.SimpleLayerType;

public class SpotPlotter
extends AbstractPlotter<SpotStyle> {
    public SpotPlotter() {
        super("Spot", SpotPlotter.createSpotIcon(Color.RED), 1, new Coord[0]);
    }

    @Override
    public String getPlotterDescription() {
        return PlotUtil.concatLines(new String[]{"<p>Plots a fixed sized marker at each data point.", "This is a minimal plotter implementation,", "intended as an implementation example.", "More capable plotters exist which do the same thing.", "</p>"});
    }

    @Override
    public ConfigKey<?>[] getStyleKeys() {
        return new ConfigKey[]{StyleKeys.COLOR};
    }

    @Override
    public SpotStyle createStyle(ConfigMap config) {
        return new SpotStyle(config.get(StyleKeys.COLOR));
    }

    @Override
    public PlotLayer createLayer(final DataGeom geom, final DataSpec dataSpec, final SpotStyle style) {
        LayerOpt opt = new LayerOpt(style.getColor(), true);
        return new AbstractPlotLayer(this, geom, dataSpec, style, opt){

            @Override
            public Drawing createDrawing(final Surface surface, Map<AuxScale, Span> auxSpans, PaperType paperType) {
                if (paperType instanceof PaperType2D) {
                    final PaperType2D ptype = (PaperType2D)paperType;
                    return new UnplannedDrawing(){

                        @Override
                        protected void paintData(Paper paper, DataStore dataStore) {
                            SpotPlotter.this.paintSpots2D(style, surface, geom, dataSpec, dataStore, ptype, paper);
                        }
                    };
                }
                if (paperType instanceof PaperType3D) {
                    final PaperType3D ptype = (PaperType3D)paperType;
                    final CubeSurface surf = (CubeSurface)surface;
                    return new UnplannedDrawing(){

                        @Override
                        protected void paintData(Paper paper, DataStore dataStore) {
                            SpotPlotter.this.paintSpots3D(style, surf, geom, dataSpec, dataStore, ptype, paper);
                        }
                    };
                }
                throw new IllegalArgumentException("paper type");
            }
        };
    }

    private void paintSpots2D(SpotStyle style, Surface surface, DataGeom geom, DataSpec dataSpec, DataStore dataStore, PaperType2D paperType, Paper paper) {
        Glyph spotGlyph = SpotPlotter.createSpotGlyph();
        Color spotColor = style.color_;
        int icPos = this.getCoordGroup().getPosCoordIndex(0, geom);
        BiConsumer<TupleSequence, Paper> tuplePainter = (tseq, p) -> {
            double[] dpos = new double[surface.getDataDimCount()];
            Point2D.Double gp = new Point2D.Double();
            while (tseq.next()) {
                if (!geom.readDataPos((Tuple)tseq, icPos, dpos) || !surface.dataToGraphics(dpos, true, gp)) continue;
                paperType.placeGlyph((Paper)p, gp.x, gp.y, spotGlyph, spotColor);
            }
        };
        dataStore.getTupleRunner().paintData(tuplePainter, paper, dataSpec, dataStore);
    }

    private void paintSpots3D(SpotStyle style, CubeSurface surface, DataGeom geom, DataSpec dataSpec, DataStore dataStore, PaperType3D paperType, Paper paper) {
        Glyph spotGlyph = SpotPlotter.createSpotGlyph();
        Color spotColor = style.getColor();
        int icPos = this.getCoordGroup().getPosCoordIndex(0, geom);
        BiConsumer<TupleSequence, Paper> tuplePainter = (tseq, p) -> {
            double[] dpos = new double[surface.getDataDimCount()];
            GPoint3D gp = new GPoint3D();
            while (tseq.next()) {
                if (!geom.readDataPos((Tuple)tseq, icPos, dpos) || !surface.dataToGraphicZ(dpos, true, gp)) continue;
                paperType.placeGlyph((Paper)p, gp.x, gp.y, gp.z, spotGlyph, spotColor);
            }
        };
        dataStore.getTupleRunner().paintData(tuplePainter, paper, dataSpec, dataStore);
    }

    private static void paintSpotShape(Graphics g, int x, int y) {
        g.fillRect(x - 2, y - 2, 4, 4);
    }

    private static Icon createSpotIcon(final Color color) {
        return new Icon(){

            @Override
            public int getIconWidth() {
                return 4;
            }

            @Override
            public int getIconHeight() {
                return 4;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                Color color0 = g.getColor();
                g.setColor(color);
                SpotPlotter.paintSpotShape(g, x, y);
            }
        };
    }

    private static Glyph createSpotGlyph() {
        int np = 9;
        final int[] xs = new int[9];
        final int[] ys = new int[9];
        int ip = 0;
        for (int ix = -1; ix < 2; ++ix) {
            int iy = -1;
            while (iy < 2) {
                xs[ip] = ix;
                ys[ip] = iy++;
                ++ip;
            }
        }
        return new Glyph(){

            @Override
            public void paintGlyph(Graphics g) {
                g.fillRect(-1, -1, 3, 3);
            }

            @Override
            public Pixer createPixer(Rectangle clip) {
                return Pixers.clip(Pixers.createArrayPixer(xs, ys, 9), clip);
            }
        };
    }

    public static class SpotLayerType
    extends SimpleLayerType {
        public SpotLayerType() {
            super(new SpotPlotter());
        }
    }

    public static class SpotStyle
    implements Style {
        final Color color_;

        SpotStyle(Color color) {
            this.color_ = color;
        }

        public Color getColor() {
            return this.color_;
        }

        @Override
        public Icon getLegendIcon() {
            return SpotPlotter.createSpotIcon(this.color_);
        }

        public boolean equals(Object o) {
            return o instanceof SpotStyle && this.color_.equals(((SpotStyle)o).color_);
        }

        public int hashCode() {
            return this.color_.hashCode();
        }
    }
}

