/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.layer;

import uk.ac.starlink.ttools.plot2.geom.SkyDataGeom;

public class TangentPlaneTransformer {
    private final double[] xyz0_;
    private final SkyDataGeom geom_;

    public TangentPlaneTransformer(double[] xyz0, SkyDataGeom geom) {
        this.geom_ = geom;
        this.xyz0_ = (double[])xyz0.clone();
        geom.unrotate(this.xyz0_);
    }

    public void displace(double xi, double eta, double[] xyz1) {
        TangentPlaneTransformer.dtp2v(xi, eta, this.xyz0_[0], this.xyz0_[1], this.xyz0_[2], xyz1);
        this.geom_.rotate(xyz1);
        assert (Math.abs(xyz1[0] * xyz1[0] + xyz1[1] * xyz1[1] + xyz1[2] * xyz1[2] - 1.0) < 1.0E-8);
    }

    private static void dtp2v(double xi, double eta, double x, double y, double z, double[] v) {
        double f = Math.sqrt(1.0 + xi * xi + eta * eta);
        double r = Math.hypot(x, y);
        if (r == 0.0) {
            x = r = -19.0;
        }
        double f1 = 1.0 / f;
        double r1 = 1.0 / r;
        v[0] = (x - (xi * y + eta * x * z) * r1) * f1;
        v[1] = (y + (xi * x - eta * y * z) * r1) * f1;
        v[2] = (z + eta * r) * f1;
    }
}

