/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.paper;

import java.util.Arrays;

public abstract class Compositor {
    private static final float FF1 = 0.003921569f;
    public static final Compositor SATURATION = new SaturationCompositor(){

        @Override
        public float scaleAlpha(float alpha) {
            return alpha;
        }
    };

    public abstract float scaleAlpha(float var1);

    public abstract Buffer createBuffer(int var1);

    public static float byteToFloat(int i) {
        return (float)(i & 0xFF) * 0.003921569f;
    }

    public static int floatToByte(float f) {
        return Math.round(255.0f * f) & 0xFF;
    }

    public static int srcOverOpaque(int sRgba, int dRgb) {
        if (dRgb == 0) {
            return sRgba;
        }
        int sAlphaByte = sRgba >> 24;
        if (sAlphaByte == 0) {
            return dRgb;
        }
        float sAlpha = Compositor.byteToFloat(sAlphaByte);
        float dAlpha = 1.0f - sAlpha;
        float sR = Compositor.byteToFloat(sRgba >> 16);
        float sG = Compositor.byteToFloat(sRgba >> 8);
        float sB = Compositor.byteToFloat(sRgba);
        float dR = Compositor.byteToFloat(dRgb >> 16);
        float dG = Compositor.byteToFloat(dRgb >> 8);
        float dB = Compositor.byteToFloat(dRgb);
        return Compositor.floatToByte(sR * sAlpha + dR * dAlpha) << 16 | Compositor.floatToByte(sG * sAlpha + dG * dAlpha) << 8 | Compositor.floatToByte(sB * sAlpha + dB * dAlpha) | 0xFF000000;
    }

    private static class SaturationBuffer
    implements Buffer {
        private final Compositor compositor_;
        private final float[] buf_;

        SaturationBuffer(Compositor compositor, int count) {
            this.compositor_ = compositor;
            this.buf_ = new float[count * 4];
        }

        @Override
        public void clear() {
            Arrays.fill(this.buf_, 0.0f);
        }

        @Override
        public boolean addSample(int index, int rgba) {
            float alpha = Compositor.byteToFloat(rgba >> 24);
            return this.addSample(index, rgba, alpha);
        }

        @Override
        public boolean addSample(int index, int rgb, float alpha) {
            float r = Compositor.byteToFloat(rgb >> 16);
            float g = Compositor.byteToFloat(rgb >> 8);
            float b = Compositor.byteToFloat(rgb);
            return this.addSample(index, r, g, b, alpha);
        }

        @Override
        public boolean addSample(int index, float r, float g, float b, float alpha) {
            int ix = index * 4;
            float ta = this.buf_[ix];
            float remain = 1.0f - ta;
            float weight = Math.min(remain, alpha);
            if (weight > 0.0f) {
                this.buf_[ix++] = ta += weight;
                int n = ix++;
                this.buf_[n] = this.buf_[n] + weight * r;
                int n2 = ix++;
                this.buf_[n2] = this.buf_[n2] + weight * g;
                int n3 = ix;
                this.buf_[n3] = this.buf_[n3] + weight * b;
            }
            return ta >= 1.0f;
        }

        @Override
        public int toRgbInt(int index) {
            float fa;
            int ix = index * 4;
            if ((fa = this.buf_[ix++]) == 0.0f) {
                return 0;
            }
            float fr = this.buf_[ix++];
            float fg = this.buf_[ix++];
            float fb = this.buf_[ix];
            if (fa < 1.0f) {
                float a1 = 1.0f / fa;
                fr *= a1;
                fg *= a1;
                fb *= a1;
            } else assert (fa == 1.0f);
            return Compositor.floatToByte(this.compositor_.scaleAlpha(fa)) << 24 | Compositor.floatToByte(fr) << 16 | Compositor.floatToByte(fg) << 8 | Compositor.floatToByte(fb);
        }
    }

    private static abstract class SaturationCompositor
    extends Compositor {
        private SaturationCompositor() {
        }

        @Override
        public Buffer createBuffer(int count) {
            return new SaturationBuffer(this, count);
        }
    }

    public static class BoostCompositor
    extends Compositor {
        private final float boost_;
        private final float boost1_;

        public BoostCompositor(float boost) {
            this.boost_ = boost;
            this.boost1_ = 1.0f - boost;
            if (!(boost >= 0.0f) || !(boost <= 1.0f)) {
                throw new IllegalArgumentException("Boost out of range 0..1");
            }
        }

        @Override
        public Buffer createBuffer(int count) {
            return new SaturationBuffer(this, count);
        }

        @Override
        public float scaleAlpha(float alpha) {
            return this.boost_ + this.boost1_ * alpha;
        }

        public float getBoost() {
            return this.boost_;
        }
    }

    public static interface Buffer {
        public void clear();

        public boolean addSample(int var1, float var2, float var3, float var4, float var5);

        public boolean addSample(int var1, int var2, float var3);

        public boolean addSample(int var1, int var2);

        public int toRgbInt(int var1);
    }
}

