/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.paper;

import java.awt.Color;
import java.util.HashSet;
import uk.ac.starlink.ttools.plot2.LayerOpt;
import uk.ac.starlink.ttools.plot2.PlotLayer;
import uk.ac.starlink.ttools.plot2.paper.CompositePaperType2D;
import uk.ac.starlink.ttools.plot2.paper.Compositor;
import uk.ac.starlink.ttools.plot2.paper.MonoPaperType;
import uk.ac.starlink.ttools.plot2.paper.OverPaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaintPaperType2D;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.ttools.plot2.paper.PixelStackPaperType3D;
import uk.ac.starlink.ttools.plot2.paper.SortedPaperType3D;
import uk.ac.starlink.ttools.plot2.paper.ZBufferPaperType3D;

public abstract class PaperTypeSelector {
    public static PaperTypeSelector SELECTOR_2D = PaperTypeSelector.createSelector2D();
    public static PaperTypeSelector SELECTOR_3D = PaperTypeSelector.createSelector3D();

    public abstract PaperType getVectorPaperType(LayerOpt[] var1);

    public abstract PaperType getPixelPaperType(LayerOpt[] var1, Compositor var2);

    private static PaperTypeSelector createSelector2D() {
        PaintPaperType2D vectorType = PaintPaperType2D.createPaperType(true);
        OverPaperType2D pixelOpaqueType = new OverPaperType2D();
        return new BasicSelector(vectorType, pixelOpaqueType){

            @Override
            PaperType createGeneralPixelPaperType(Compositor compos) {
                return new CompositePaperType2D(compos);
            }
        };
    }

    private static PaperTypeSelector createSelector3D() {
        return new BasicSelector(new SortedPaperType3D(), new ZBufferPaperType3D()){

            @Override
            PaperType createGeneralPixelPaperType(Compositor compos) {
                return new PixelStackPaperType3D(compos, 1.0E-4f);
            }
        };
    }

    public static PaperTypeSelector createSingleSelector(final PaperType ptype) {
        return new PaperTypeSelector(){

            @Override
            public PaperType getVectorPaperType(LayerOpt[] opts) {
                return ptype;
            }

            @Override
            public PaperType getPixelPaperType(LayerOpt[] opts, Compositor compositor) {
                return ptype;
            }
        };
    }

    public static LayerOpt[] getOpts(PlotLayer[] layers) {
        int nl = layers.length;
        LayerOpt[] opts = new LayerOpt[nl];
        for (int il = 0; il < nl; ++il) {
            opts[il] = layers[il].getOpt();
        }
        return opts;
    }

    private static Color getMonochromeColor(LayerOpt[] opts) {
        HashSet<Integer> rgbSet = new HashSet<Integer>();
        for (int il = 0; il < opts.length; ++il) {
            Color color = opts[il].getSingleColor();
            if (color == null) {
                return null;
            }
            rgbSet.add(color.getRGB() & 0xFFFFFF);
        }
        return rgbSet.size() == 1 ? new Color((Integer)rgbSet.iterator().next()) : null;
    }

    private static boolean isOpaque(LayerOpt[] opts) {
        for (int il = 0; il < opts.length; ++il) {
            if (opts[il].isOpaque()) continue;
            return false;
        }
        return true;
    }

    private static abstract class BasicSelector
    extends PaperTypeSelector {
        private final PaperType vector_;
        private final PaperType pixelOpaque_;

        BasicSelector(PaperType vector, PaperType pixelOpaque) {
            this.vector_ = vector;
            this.pixelOpaque_ = pixelOpaque;
        }

        @Override
        public PaperType getVectorPaperType(LayerOpt[] opts) {
            return this.vector_;
        }

        @Override
        public PaperType getPixelPaperType(LayerOpt[] opts, Compositor compos) {
            if (PaperTypeSelector.isOpaque(opts)) {
                return this.pixelOpaque_;
            }
            Color color = PaperTypeSelector.getMonochromeColor(opts);
            if (color != null) {
                return new MonoPaperType(color, compos);
            }
            return this.createGeneralPixelPaperType(compos);
        }

        abstract PaperType createGeneralPixelPaperType(Compositor var1);
    }
}

