/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ttools.plot2.paper;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.logging.Logger;
import javax.swing.Icon;
import uk.ac.starlink.ttools.plot2.Decal;
import uk.ac.starlink.ttools.plot2.Drawing;
import uk.ac.starlink.ttools.plot2.Pixer;
import uk.ac.starlink.ttools.plot2.PlotUtil;
import uk.ac.starlink.ttools.plot2.Surface;
import uk.ac.starlink.ttools.plot2.data.DataStore;
import uk.ac.starlink.ttools.plot2.paper.Paper;
import uk.ac.starlink.ttools.plot2.paper.PaperType;
import uk.ac.starlink.ttools.plot2.paper.RgbImage;

public abstract class RgbPaperType
implements PaperType {
    private final String name_;
    private final boolean upLayer_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.ttools.paper");

    protected RgbPaperType(String name, boolean upLayer) {
        this.name_ = name;
        this.upLayer_ = upLayer;
    }

    @Override
    public boolean isBitmap() {
        return true;
    }

    @Override
    public void placeDecal(Paper paper, Decal decal) {
        ((RgbPaper)paper).placeDecal(decal);
    }

    @Override
    public Icon createDataIcon(Surface surface, Drawing[] drawings, Object[] plans, DataStore dataStore, boolean requireCached) {
        final Rectangle bounds = surface.getPlotBounds();
        final RgbPaper paper = this.createPaper(bounds);
        surface.paintBackground(paper.graphics_);
        int nlayer = drawings.length;
        for (int il = 0; il < nlayer; ++il) {
            int jl = this.upLayer_ ? il : nlayer - 1 - il;
            drawings[jl].paintData(plans[jl], paper, dataStore);
        }
        long startFlush = System.currentTimeMillis();
        paper.flush();
        PlotUtil.logTimeFromStart(logger_, "Flush", startFlush);
        return new Icon(){

            @Override
            public int getIconWidth() {
                return bounds.x + bounds.width;
            }

            @Override
            public int getIconHeight() {
                return bounds.y + bounds.height;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
                g.drawImage(paper.getRgbImage().getImage(), x, y, null);
            }
        };
    }

    public String toString() {
        return this.name_;
    }

    protected abstract RgbPaper createPaper(Rectangle var1);

    protected static abstract class RgbPaper
    implements Paper {
        private final PaperType paperType_;
        private final Rectangle bounds_;
        private final int xpix_;
        private final int ypix_;
        private final RgbImage rgbImage_;
        private final Graphics graphics_;

        public RgbPaper(PaperType paperType, Rectangle bounds) {
            this.paperType_ = paperType;
            this.bounds_ = new Rectangle(bounds);
            this.xpix_ = bounds.width;
            this.ypix_ = bounds.height;
            this.rgbImage_ = RgbImage.createRgbImage(bounds.width, bounds.height, false);
            this.graphics_ = this.rgbImage_.getImage().createGraphics();
            this.graphics_.setColor(Color.BLACK);
            this.graphics_.translate(-bounds.x, -bounds.y);
        }

        @Override
        public PaperType getPaperType() {
            return this.paperType_;
        }

        public RgbImage getRgbImage() {
            return this.rgbImage_;
        }

        public Rectangle getBounds() {
            return this.bounds_;
        }

        public void placeDecal(Decal decal) {
            decal.paintDecal(this.graphics_);
        }

        protected int getPixelIndex(int xoff, int yoff, Pixer pixer) {
            int x = xoff + pixer.getX();
            int y = yoff + pixer.getY();
            assert (x >= 0 && x < this.xpix_ && y >= 0 && y < this.ypix_) : pixer;
            return x + this.xpix_ * y;
        }

        public abstract void flush();
    }
}

